
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.EndpointIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.IndustryClassificationCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.LogoReferenceIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.MarkAttentionIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.MarkCareIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.WebsiteURIType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for PartyType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="PartyType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MarkCareIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MarkAttentionIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}WebsiteURI" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}LogoReferenceID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}EndpointID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}IndustryClassificationCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PartyIdentification" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PartyName" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Language" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PostalAddress" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PhysicalLocation" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PartyTaxScheme" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PartyLegalEntity" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Contact" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Person" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AgentParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ServiceProviderParty" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PowerOfAttorney" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PartyAuthorization" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}FinancialAccount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AdditionalWebSite" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}SocialMediaProfile" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PartyType", propOrder = {
    "ublExtensions",
    "markCareIndicator",
    "markAttentionIndicator",
    "websiteURI",
    "logoReferenceID",
    "endpointID",
    "industryClassificationCode",
    "partyIdentification",
    "partyName",
    "language",
    "postalAddress",
    "physicalLocation",
    "partyTaxScheme",
    "partyLegalEntity",
    "contact",
    "person",
    "agentParty",
    "serviceProviderParty",
    "powerOfAttorney",
    "partyAuthorization",
    "financialAccount",
    "additionalWebSite",
    "socialMediaProfile"
})
@CodingStyleguideUnaware
public class PartyType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "MarkCareIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MarkCareIndicatorType markCareIndicator;
    @XmlElement(name = "MarkAttentionIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MarkAttentionIndicatorType markAttentionIndicator;
    @XmlElement(name = "WebsiteURI", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private WebsiteURIType websiteURI;
    @XmlElement(name = "LogoReferenceID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private LogoReferenceIDType logoReferenceID;
    @XmlElement(name = "EndpointID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private EndpointIDType endpointID;
    @XmlElement(name = "IndustryClassificationCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IndustryClassificationCodeType industryClassificationCode;
    @XmlElement(name = "PartyIdentification")
    private List<PartyIdentificationType> partyIdentification;
    @XmlElement(name = "PartyName")
    private List<PartyNameType> partyName;
    @XmlElement(name = "Language")
    private LanguageType language;
    @XmlElement(name = "PostalAddress")
    private AddressType postalAddress;
    @XmlElement(name = "PhysicalLocation")
    private LocationType physicalLocation;
    @XmlElement(name = "PartyTaxScheme")
    private List<PartyTaxSchemeType> partyTaxScheme;
    @XmlElement(name = "PartyLegalEntity")
    private List<PartyLegalEntityType> partyLegalEntity;
    @XmlElement(name = "Contact")
    private ContactType contact;
    @XmlElement(name = "Person")
    private List<PersonType> person;
    @XmlElement(name = "AgentParty")
    private PartyType agentParty;
    @XmlElement(name = "ServiceProviderParty")
    private List<ServiceProviderPartyType> serviceProviderParty;
    @XmlElement(name = "PowerOfAttorney")
    private List<PowerOfAttorneyType> powerOfAttorney;
    @XmlElement(name = "PartyAuthorization")
    private List<AuthorizationType> partyAuthorization;
    @XmlElement(name = "FinancialAccount")
    private FinancialAccountType financialAccount;
    @XmlElement(name = "AdditionalWebSite")
    private List<WebSiteType> additionalWebSite;
    @XmlElement(name = "SocialMediaProfile")
    private List<SocialMediaProfileType> socialMediaProfile;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public PartyType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the markCareIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link MarkCareIndicatorType }
     *     
     */
    @Nullable
    public MarkCareIndicatorType getMarkCareIndicator() {
        return markCareIndicator;
    }

    /**
     * Sets the value of the markCareIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link MarkCareIndicatorType }
     *     
     */
    public void setMarkCareIndicator(
        @Nullable
        MarkCareIndicatorType value) {
        this.markCareIndicator = value;
    }

    /**
     * Gets the value of the markAttentionIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link MarkAttentionIndicatorType }
     *     
     */
    @Nullable
    public MarkAttentionIndicatorType getMarkAttentionIndicator() {
        return markAttentionIndicator;
    }

    /**
     * Sets the value of the markAttentionIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link MarkAttentionIndicatorType }
     *     
     */
    public void setMarkAttentionIndicator(
        @Nullable
        MarkAttentionIndicatorType value) {
        this.markAttentionIndicator = value;
    }

    /**
     * Gets the value of the websiteURI property.
     * 
     * @return
     *     possible object is
     *     {@link WebsiteURIType }
     *     
     */
    @Nullable
    public WebsiteURIType getWebsiteURI() {
        return websiteURI;
    }

    /**
     * Sets the value of the websiteURI property.
     * 
     * @param value
     *     allowed object is
     *     {@link WebsiteURIType }
     *     
     */
    public void setWebsiteURI(
        @Nullable
        WebsiteURIType value) {
        this.websiteURI = value;
    }

    /**
     * Gets the value of the logoReferenceID property.
     * 
     * @return
     *     possible object is
     *     {@link LogoReferenceIDType }
     *     
     */
    @Nullable
    public LogoReferenceIDType getLogoReferenceID() {
        return logoReferenceID;
    }

    /**
     * Sets the value of the logoReferenceID property.
     * 
     * @param value
     *     allowed object is
     *     {@link LogoReferenceIDType }
     *     
     */
    public void setLogoReferenceID(
        @Nullable
        LogoReferenceIDType value) {
        this.logoReferenceID = value;
    }

    /**
     * Gets the value of the endpointID property.
     * 
     * @return
     *     possible object is
     *     {@link EndpointIDType }
     *     
     */
    @Nullable
    public EndpointIDType getEndpointID() {
        return endpointID;
    }

    /**
     * Sets the value of the endpointID property.
     * 
     * @param value
     *     allowed object is
     *     {@link EndpointIDType }
     *     
     */
    public void setEndpointID(
        @Nullable
        EndpointIDType value) {
        this.endpointID = value;
    }

    /**
     * Gets the value of the industryClassificationCode property.
     * 
     * @return
     *     possible object is
     *     {@link IndustryClassificationCodeType }
     *     
     */
    @Nullable
    public IndustryClassificationCodeType getIndustryClassificationCode() {
        return industryClassificationCode;
    }

    /**
     * Sets the value of the industryClassificationCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link IndustryClassificationCodeType }
     *     
     */
    public void setIndustryClassificationCode(
        @Nullable
        IndustryClassificationCodeType value) {
        this.industryClassificationCode = value;
    }

    /**
     * Gets the value of the partyIdentification property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the partyIdentification property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPartyIdentification().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PartyIdentificationType }
     * </p>
     * 
     * 
     * @return
     *     The value of the partyIdentification property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PartyIdentificationType> getPartyIdentification() {
        if (partyIdentification == null) {
            partyIdentification = new ArrayList<>();
        }
        return this.partyIdentification;
    }

    /**
     * Gets the value of the partyName property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the partyName property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPartyName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PartyNameType }
     * </p>
     * 
     * 
     * @return
     *     The value of the partyName property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PartyNameType> getPartyName() {
        if (partyName == null) {
            partyName = new ArrayList<>();
        }
        return this.partyName;
    }

    /**
     * Gets the value of the language property.
     * 
     * @return
     *     possible object is
     *     {@link LanguageType }
     *     
     */
    @Nullable
    public LanguageType getLanguage() {
        return language;
    }

    /**
     * Sets the value of the language property.
     * 
     * @param value
     *     allowed object is
     *     {@link LanguageType }
     *     
     */
    public void setLanguage(
        @Nullable
        LanguageType value) {
        this.language = value;
    }

    /**
     * Gets the value of the postalAddress property.
     * 
     * @return
     *     possible object is
     *     {@link AddressType }
     *     
     */
    @Nullable
    public AddressType getPostalAddress() {
        return postalAddress;
    }

    /**
     * Sets the value of the postalAddress property.
     * 
     * @param value
     *     allowed object is
     *     {@link AddressType }
     *     
     */
    public void setPostalAddress(
        @Nullable
        AddressType value) {
        this.postalAddress = value;
    }

    /**
     * Gets the value of the physicalLocation property.
     * 
     * @return
     *     possible object is
     *     {@link LocationType }
     *     
     */
    @Nullable
    public LocationType getPhysicalLocation() {
        return physicalLocation;
    }

    /**
     * Sets the value of the physicalLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationType }
     *     
     */
    public void setPhysicalLocation(
        @Nullable
        LocationType value) {
        this.physicalLocation = value;
    }

    /**
     * Gets the value of the partyTaxScheme property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the partyTaxScheme property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPartyTaxScheme().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PartyTaxSchemeType }
     * </p>
     * 
     * 
     * @return
     *     The value of the partyTaxScheme property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PartyTaxSchemeType> getPartyTaxScheme() {
        if (partyTaxScheme == null) {
            partyTaxScheme = new ArrayList<>();
        }
        return this.partyTaxScheme;
    }

    /**
     * Gets the value of the partyLegalEntity property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the partyLegalEntity property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPartyLegalEntity().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PartyLegalEntityType }
     * </p>
     * 
     * 
     * @return
     *     The value of the partyLegalEntity property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PartyLegalEntityType> getPartyLegalEntity() {
        if (partyLegalEntity == null) {
            partyLegalEntity = new ArrayList<>();
        }
        return this.partyLegalEntity;
    }

    /**
     * Gets the value of the contact property.
     * 
     * @return
     *     possible object is
     *     {@link ContactType }
     *     
     */
    @Nullable
    public ContactType getContact() {
        return contact;
    }

    /**
     * Sets the value of the contact property.
     * 
     * @param value
     *     allowed object is
     *     {@link ContactType }
     *     
     */
    public void setContact(
        @Nullable
        ContactType value) {
        this.contact = value;
    }

    /**
     * Gets the value of the person property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the person property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPerson().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PersonType }
     * </p>
     * 
     * 
     * @return
     *     The value of the person property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PersonType> getPerson() {
        if (person == null) {
            person = new ArrayList<>();
        }
        return this.person;
    }

    /**
     * Gets the value of the agentParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getAgentParty() {
        return agentParty;
    }

    /**
     * Sets the value of the agentParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setAgentParty(
        @Nullable
        PartyType value) {
        this.agentParty = value;
    }

    /**
     * Gets the value of the serviceProviderParty property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the serviceProviderParty property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getServiceProviderParty().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ServiceProviderPartyType }
     * </p>
     * 
     * 
     * @return
     *     The value of the serviceProviderParty property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ServiceProviderPartyType> getServiceProviderParty() {
        if (serviceProviderParty == null) {
            serviceProviderParty = new ArrayList<>();
        }
        return this.serviceProviderParty;
    }

    /**
     * Gets the value of the powerOfAttorney property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the powerOfAttorney property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPowerOfAttorney().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PowerOfAttorneyType }
     * </p>
     * 
     * 
     * @return
     *     The value of the powerOfAttorney property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PowerOfAttorneyType> getPowerOfAttorney() {
        if (powerOfAttorney == null) {
            powerOfAttorney = new ArrayList<>();
        }
        return this.powerOfAttorney;
    }

    /**
     * Gets the value of the partyAuthorization property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the partyAuthorization property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPartyAuthorization().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AuthorizationType }
     * </p>
     * 
     * 
     * @return
     *     The value of the partyAuthorization property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AuthorizationType> getPartyAuthorization() {
        if (partyAuthorization == null) {
            partyAuthorization = new ArrayList<>();
        }
        return this.partyAuthorization;
    }

    /**
     * Gets the value of the financialAccount property.
     * 
     * @return
     *     possible object is
     *     {@link FinancialAccountType }
     *     
     */
    @Nullable
    public FinancialAccountType getFinancialAccount() {
        return financialAccount;
    }

    /**
     * Sets the value of the financialAccount property.
     * 
     * @param value
     *     allowed object is
     *     {@link FinancialAccountType }
     *     
     */
    public void setFinancialAccount(
        @Nullable
        FinancialAccountType value) {
        this.financialAccount = value;
    }

    /**
     * Gets the value of the additionalWebSite property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the additionalWebSite property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAdditionalWebSite().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link WebSiteType }
     * </p>
     * 
     * 
     * @return
     *     The value of the additionalWebSite property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<WebSiteType> getAdditionalWebSite() {
        if (additionalWebSite == null) {
            additionalWebSite = new ArrayList<>();
        }
        return this.additionalWebSite;
    }

    /**
     * Gets the value of the socialMediaProfile property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the socialMediaProfile property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getSocialMediaProfile().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SocialMediaProfileType }
     * </p>
     * 
     * 
     * @return
     *     The value of the socialMediaProfile property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<SocialMediaProfileType> getSocialMediaProfile() {
        if (socialMediaProfile == null) {
            socialMediaProfile = new ArrayList<>();
        }
        return this.socialMediaProfile;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final PartyType rhs = ((PartyType) o);
        if (!EqualsHelper.equalsCollection(additionalWebSite, rhs.additionalWebSite)) {
            return false;
        }
        if (!EqualsHelper.equals(agentParty, rhs.agentParty)) {
            return false;
        }
        if (!EqualsHelper.equals(contact, rhs.contact)) {
            return false;
        }
        if (!EqualsHelper.equals(endpointID, rhs.endpointID)) {
            return false;
        }
        if (!EqualsHelper.equals(financialAccount, rhs.financialAccount)) {
            return false;
        }
        if (!EqualsHelper.equals(industryClassificationCode, rhs.industryClassificationCode)) {
            return false;
        }
        if (!EqualsHelper.equals(language, rhs.language)) {
            return false;
        }
        if (!EqualsHelper.equals(logoReferenceID, rhs.logoReferenceID)) {
            return false;
        }
        if (!EqualsHelper.equals(markAttentionIndicator, rhs.markAttentionIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(markCareIndicator, rhs.markCareIndicator)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(partyAuthorization, rhs.partyAuthorization)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(partyIdentification, rhs.partyIdentification)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(partyLegalEntity, rhs.partyLegalEntity)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(partyName, rhs.partyName)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(partyTaxScheme, rhs.partyTaxScheme)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(person, rhs.person)) {
            return false;
        }
        if (!EqualsHelper.equals(physicalLocation, rhs.physicalLocation)) {
            return false;
        }
        if (!EqualsHelper.equals(postalAddress, rhs.postalAddress)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(powerOfAttorney, rhs.powerOfAttorney)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(serviceProviderParty, rhs.serviceProviderParty)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(socialMediaProfile, rhs.socialMediaProfile)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equals(websiteURI, rhs.websiteURI)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(additionalWebSite).append(agentParty).append(contact).append(endpointID).append(financialAccount).append(industryClassificationCode).append(language).append(logoReferenceID).append(markAttentionIndicator).append(markCareIndicator).append(partyAuthorization).append(partyIdentification).append(partyLegalEntity).append(partyName).append(partyTaxScheme).append(person).append(physicalLocation).append(postalAddress).append(powerOfAttorney).append(serviceProviderParty).append(socialMediaProfile).append(ublExtensions).append(websiteURI).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("additionalWebSite", additionalWebSite).append("agentParty", agentParty).append("contact", contact).append("endpointID", endpointID).append("financialAccount", financialAccount).append("industryClassificationCode", industryClassificationCode).append("language", language).append("logoReferenceID", logoReferenceID).append("markAttentionIndicator", markAttentionIndicator).append("markCareIndicator", markCareIndicator).append("partyAuthorization", partyAuthorization).append("partyIdentification", partyIdentification).append("partyLegalEntity", partyLegalEntity).append("partyName", partyName).append("partyTaxScheme", partyTaxScheme).append("person", person).append("physicalLocation", physicalLocation).append("postalAddress", postalAddress).append("powerOfAttorney", powerOfAttorney).append("serviceProviderParty", serviceProviderParty).append("socialMediaProfile", socialMediaProfile).append("ublExtensions", ublExtensions).append("websiteURI", websiteURI).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPartyIdentification(
        @Nullable
        final List<PartyIdentificationType> aList) {
        partyIdentification = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPartyName(
        @Nullable
        final List<PartyNameType> aList) {
        partyName = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPartyTaxScheme(
        @Nullable
        final List<PartyTaxSchemeType> aList) {
        partyTaxScheme = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPartyLegalEntity(
        @Nullable
        final List<PartyLegalEntityType> aList) {
        partyLegalEntity = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPerson(
        @Nullable
        final List<PersonType> aList) {
        person = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setServiceProviderParty(
        @Nullable
        final List<ServiceProviderPartyType> aList) {
        serviceProviderParty = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPowerOfAttorney(
        @Nullable
        final List<PowerOfAttorneyType> aList) {
        powerOfAttorney = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPartyAuthorization(
        @Nullable
        final List<AuthorizationType> aList) {
        partyAuthorization = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAdditionalWebSite(
        @Nullable
        final List<WebSiteType> aList) {
        additionalWebSite = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSocialMediaProfile(
        @Nullable
        final List<SocialMediaProfileType> aList) {
        socialMediaProfile = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPartyIdentificationEntries() {
        return (!getPartyIdentification().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPartyIdentificationEntries() {
        return getPartyIdentification().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPartyIdentificationCount() {
        return getPartyIdentification().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PartyIdentificationType getPartyIdentificationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPartyIdentification().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPartyIdentification(
        @Nonnull
        final PartyIdentificationType elem) {
        getPartyIdentification().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPartyNameEntries() {
        return (!getPartyName().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPartyNameEntries() {
        return getPartyName().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPartyNameCount() {
        return getPartyName().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PartyNameType getPartyNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPartyName().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPartyName(
        @Nonnull
        final PartyNameType elem) {
        getPartyName().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPartyTaxSchemeEntries() {
        return (!getPartyTaxScheme().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPartyTaxSchemeEntries() {
        return getPartyTaxScheme().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPartyTaxSchemeCount() {
        return getPartyTaxScheme().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PartyTaxSchemeType getPartyTaxSchemeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPartyTaxScheme().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPartyTaxScheme(
        @Nonnull
        final PartyTaxSchemeType elem) {
        getPartyTaxScheme().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPartyLegalEntityEntries() {
        return (!getPartyLegalEntity().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPartyLegalEntityEntries() {
        return getPartyLegalEntity().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPartyLegalEntityCount() {
        return getPartyLegalEntity().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PartyLegalEntityType getPartyLegalEntityAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPartyLegalEntity().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPartyLegalEntity(
        @Nonnull
        final PartyLegalEntityType elem) {
        getPartyLegalEntity().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPersonEntries() {
        return (!getPerson().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPersonEntries() {
        return getPerson().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPersonCount() {
        return getPerson().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PersonType getPersonAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPerson().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPerson(
        @Nonnull
        final PersonType elem) {
        getPerson().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasServiceProviderPartyEntries() {
        return (!getServiceProviderParty().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoServiceProviderPartyEntries() {
        return getServiceProviderParty().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getServiceProviderPartyCount() {
        return getServiceProviderParty().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ServiceProviderPartyType getServiceProviderPartyAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getServiceProviderParty().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addServiceProviderParty(
        @Nonnull
        final ServiceProviderPartyType elem) {
        getServiceProviderParty().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPowerOfAttorneyEntries() {
        return (!getPowerOfAttorney().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPowerOfAttorneyEntries() {
        return getPowerOfAttorney().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPowerOfAttorneyCount() {
        return getPowerOfAttorney().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PowerOfAttorneyType getPowerOfAttorneyAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPowerOfAttorney().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPowerOfAttorney(
        @Nonnull
        final PowerOfAttorneyType elem) {
        getPowerOfAttorney().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPartyAuthorizationEntries() {
        return (!getPartyAuthorization().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPartyAuthorizationEntries() {
        return getPartyAuthorization().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPartyAuthorizationCount() {
        return getPartyAuthorization().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AuthorizationType getPartyAuthorizationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPartyAuthorization().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPartyAuthorization(
        @Nonnull
        final AuthorizationType elem) {
        getPartyAuthorization().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAdditionalWebSiteEntries() {
        return (!getAdditionalWebSite().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAdditionalWebSiteEntries() {
        return getAdditionalWebSite().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAdditionalWebSiteCount() {
        return getAdditionalWebSite().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public WebSiteType getAdditionalWebSiteAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAdditionalWebSite().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAdditionalWebSite(
        @Nonnull
        final WebSiteType elem) {
        getAdditionalWebSite().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSocialMediaProfileEntries() {
        return (!getSocialMediaProfile().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSocialMediaProfileEntries() {
        return getSocialMediaProfile().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSocialMediaProfileCount() {
        return getSocialMediaProfile().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public SocialMediaProfileType getSocialMediaProfileAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSocialMediaProfile().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSocialMediaProfile(
        @Nonnull
        final SocialMediaProfileType elem) {
        getSocialMediaProfile().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        PartyType ret) {
        if (additionalWebSite == null) {
            ret.additionalWebSite = null;
        } else {
            List<WebSiteType> retAdditionalWebSite = new ArrayList<>();
            for (WebSiteType aItem: getAdditionalWebSite()) {
                retAdditionalWebSite.add(((aItem == null)?null:aItem.clone()));
            }
            ret.additionalWebSite = retAdditionalWebSite;
        }
        ret.agentParty = ((agentParty == null)?null:agentParty.clone());
        ret.contact = ((contact == null)?null:contact.clone());
        ret.endpointID = ((endpointID == null)?null:endpointID.clone());
        ret.financialAccount = ((financialAccount == null)?null:financialAccount.clone());
        ret.industryClassificationCode = ((industryClassificationCode == null)?null:industryClassificationCode.clone());
        ret.language = ((language == null)?null:language.clone());
        ret.logoReferenceID = ((logoReferenceID == null)?null:logoReferenceID.clone());
        ret.markAttentionIndicator = ((markAttentionIndicator == null)?null:markAttentionIndicator.clone());
        ret.markCareIndicator = ((markCareIndicator == null)?null:markCareIndicator.clone());
        if (partyAuthorization == null) {
            ret.partyAuthorization = null;
        } else {
            List<AuthorizationType> retPartyAuthorization = new ArrayList<>();
            for (AuthorizationType aItem: getPartyAuthorization()) {
                retPartyAuthorization.add(((aItem == null)?null:aItem.clone()));
            }
            ret.partyAuthorization = retPartyAuthorization;
        }
        if (partyIdentification == null) {
            ret.partyIdentification = null;
        } else {
            List<PartyIdentificationType> retPartyIdentification = new ArrayList<>();
            for (PartyIdentificationType aItem: getPartyIdentification()) {
                retPartyIdentification.add(((aItem == null)?null:aItem.clone()));
            }
            ret.partyIdentification = retPartyIdentification;
        }
        if (partyLegalEntity == null) {
            ret.partyLegalEntity = null;
        } else {
            List<PartyLegalEntityType> retPartyLegalEntity = new ArrayList<>();
            for (PartyLegalEntityType aItem: getPartyLegalEntity()) {
                retPartyLegalEntity.add(((aItem == null)?null:aItem.clone()));
            }
            ret.partyLegalEntity = retPartyLegalEntity;
        }
        if (partyName == null) {
            ret.partyName = null;
        } else {
            List<PartyNameType> retPartyName = new ArrayList<>();
            for (PartyNameType aItem: getPartyName()) {
                retPartyName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.partyName = retPartyName;
        }
        if (partyTaxScheme == null) {
            ret.partyTaxScheme = null;
        } else {
            List<PartyTaxSchemeType> retPartyTaxScheme = new ArrayList<>();
            for (PartyTaxSchemeType aItem: getPartyTaxScheme()) {
                retPartyTaxScheme.add(((aItem == null)?null:aItem.clone()));
            }
            ret.partyTaxScheme = retPartyTaxScheme;
        }
        if (person == null) {
            ret.person = null;
        } else {
            List<PersonType> retPerson = new ArrayList<>();
            for (PersonType aItem: getPerson()) {
                retPerson.add(((aItem == null)?null:aItem.clone()));
            }
            ret.person = retPerson;
        }
        ret.physicalLocation = ((physicalLocation == null)?null:physicalLocation.clone());
        ret.postalAddress = ((postalAddress == null)?null:postalAddress.clone());
        if (powerOfAttorney == null) {
            ret.powerOfAttorney = null;
        } else {
            List<PowerOfAttorneyType> retPowerOfAttorney = new ArrayList<>();
            for (PowerOfAttorneyType aItem: getPowerOfAttorney()) {
                retPowerOfAttorney.add(((aItem == null)?null:aItem.clone()));
            }
            ret.powerOfAttorney = retPowerOfAttorney;
        }
        if (serviceProviderParty == null) {
            ret.serviceProviderParty = null;
        } else {
            List<ServiceProviderPartyType> retServiceProviderParty = new ArrayList<>();
            for (ServiceProviderPartyType aItem: getServiceProviderParty()) {
                retServiceProviderParty.add(((aItem == null)?null:aItem.clone()));
            }
            ret.serviceProviderParty = retServiceProviderParty;
        }
        if (socialMediaProfile == null) {
            ret.socialMediaProfile = null;
        } else {
            List<SocialMediaProfileType> retSocialMediaProfile = new ArrayList<>();
            for (SocialMediaProfileType aItem: getSocialMediaProfile()) {
                retSocialMediaProfile.add(((aItem == null)?null:aItem.clone()));
            }
            ret.socialMediaProfile = retSocialMediaProfile;
        }
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        ret.websiteURI = ((websiteURI == null)?null:websiteURI.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public PartyType clone() {
        PartyType ret = new PartyType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type MarkCareIndicatorType and never <code>null</code>
     */
    @Nonnull
    public MarkCareIndicatorType setMarkCareIndicator(final boolean valueParam) {
        MarkCareIndicatorType aObj = getMarkCareIndicator();
        if (aObj == null) {
            aObj = new MarkCareIndicatorType(valueParam);
            setMarkCareIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type MarkAttentionIndicatorType and never <code>null</code>
     */
    @Nonnull
    public MarkAttentionIndicatorType setMarkAttentionIndicator(final boolean valueParam) {
        MarkAttentionIndicatorType aObj = getMarkAttentionIndicator();
        if (aObj == null) {
            aObj = new MarkAttentionIndicatorType(valueParam);
            setMarkAttentionIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type WebsiteURIType and never <code>null</code>
     */
    @Nonnull
    public WebsiteURIType setWebsiteURI(
        @Nullable
        final String valueParam) {
        WebsiteURIType aObj = getWebsiteURI();
        if (aObj == null) {
            aObj = new WebsiteURIType(valueParam);
            setWebsiteURI(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LogoReferenceIDType and never <code>null</code>
     */
    @Nonnull
    public LogoReferenceIDType setLogoReferenceID(
        @Nullable
        final String valueParam) {
        LogoReferenceIDType aObj = getLogoReferenceID();
        if (aObj == null) {
            aObj = new LogoReferenceIDType(valueParam);
            setLogoReferenceID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EndpointIDType and never <code>null</code>
     */
    @Nonnull
    public EndpointIDType setEndpointID(
        @Nullable
        final String valueParam) {
        EndpointIDType aObj = getEndpointID();
        if (aObj == null) {
            aObj = new EndpointIDType(valueParam);
            setEndpointID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IndustryClassificationCodeType and never <code>null</code>
     */
    @Nonnull
    public IndustryClassificationCodeType setIndustryClassificationCode(
        @Nullable
        final String valueParam) {
        IndustryClassificationCodeType aObj = getIndustryClassificationCode();
        if (aObj == null) {
            aObj = new IndustryClassificationCodeType(valueParam);
            setIndustryClassificationCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained MarkCareIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained MarkCareIndicatorType object or the passed nullValue
     */
    public boolean isMarkCareIndicatorValue(final boolean nullValue) {
        MarkCareIndicatorType aObj = getMarkCareIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained MarkAttentionIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained MarkAttentionIndicatorType object or the passed nullValue
     */
    public boolean isMarkAttentionIndicatorValue(final boolean nullValue) {
        MarkAttentionIndicatorType aObj = getMarkAttentionIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained WebsiteURIType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained WebsiteURIType object or <code>null</code>
     */
    @Nullable
    public String getWebsiteURIValue() {
        WebsiteURIType aObj = getWebsiteURI();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained LogoReferenceIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LogoReferenceIDType object or <code>null</code>
     */
    @Nullable
    public String getLogoReferenceIDValue() {
        LogoReferenceIDType aObj = getLogoReferenceID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained EndpointIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EndpointIDType object or <code>null</code>
     */
    @Nullable
    public String getEndpointIDValue() {
        EndpointIDType aObj = getEndpointID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IndustryClassificationCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IndustryClassificationCodeType object or <code>null</code>
     */
    @Nullable
    public String getIndustryClassificationCodeValue() {
        IndustryClassificationCodeType aObj = getIndustryClassificationCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
