
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.datetime.XMLOffsetTime;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.AuthorizationIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.CashChangeAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.InstructionIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.MerchantIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PaidAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PaidCashAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PaidDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PaidTimeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PaymentTerminalIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ReceivedDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TransactionIDType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for PaymentType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="PaymentType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PaidAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PaidCashAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CashChangeAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ReceivedDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PaidDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PaidTime" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}InstructionID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MerchantID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}AuthorizationID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TransactionID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PaymentTerminalID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ExchangeRate" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PaymentType", propOrder = {
    "ublExtensions",
    "id",
    "paidAmount",
    "paidCashAmount",
    "cashChangeAmount",
    "receivedDate",
    "paidDate",
    "paidTime",
    "instructionID",
    "merchantID",
    "authorizationID",
    "transactionID",
    "paymentTerminalID",
    "exchangeRate"
})
@CodingStyleguideUnaware
public class PaymentType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "PaidAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PaidAmountType paidAmount;
    @XmlElement(name = "PaidCashAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PaidCashAmountType paidCashAmount;
    @XmlElement(name = "CashChangeAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CashChangeAmountType cashChangeAmount;
    @XmlElement(name = "ReceivedDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ReceivedDateType receivedDate;
    @XmlElement(name = "PaidDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PaidDateType paidDate;
    @XmlElement(name = "PaidTime", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PaidTimeType paidTime;
    @XmlElement(name = "InstructionID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private InstructionIDType instructionID;
    @XmlElement(name = "MerchantID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MerchantIDType merchantID;
    @XmlElement(name = "AuthorizationID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private AuthorizationIDType authorizationID;
    @XmlElement(name = "TransactionID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TransactionIDType transactionID;
    @XmlElement(name = "PaymentTerminalID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PaymentTerminalIDType paymentTerminalID;
    @XmlElement(name = "ExchangeRate")
    private ExchangeRateType exchangeRate;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public PaymentType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the paidAmount property.
     * 
     * @return
     *     possible object is
     *     {@link PaidAmountType }
     *     
     */
    @Nullable
    public PaidAmountType getPaidAmount() {
        return paidAmount;
    }

    /**
     * Sets the value of the paidAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link PaidAmountType }
     *     
     */
    public void setPaidAmount(
        @Nullable
        PaidAmountType value) {
        this.paidAmount = value;
    }

    /**
     * Gets the value of the paidCashAmount property.
     * 
     * @return
     *     possible object is
     *     {@link PaidCashAmountType }
     *     
     */
    @Nullable
    public PaidCashAmountType getPaidCashAmount() {
        return paidCashAmount;
    }

    /**
     * Sets the value of the paidCashAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link PaidCashAmountType }
     *     
     */
    public void setPaidCashAmount(
        @Nullable
        PaidCashAmountType value) {
        this.paidCashAmount = value;
    }

    /**
     * Gets the value of the cashChangeAmount property.
     * 
     * @return
     *     possible object is
     *     {@link CashChangeAmountType }
     *     
     */
    @Nullable
    public CashChangeAmountType getCashChangeAmount() {
        return cashChangeAmount;
    }

    /**
     * Sets the value of the cashChangeAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link CashChangeAmountType }
     *     
     */
    public void setCashChangeAmount(
        @Nullable
        CashChangeAmountType value) {
        this.cashChangeAmount = value;
    }

    /**
     * Gets the value of the receivedDate property.
     * 
     * @return
     *     possible object is
     *     {@link ReceivedDateType }
     *     
     */
    @Nullable
    public ReceivedDateType getReceivedDate() {
        return receivedDate;
    }

    /**
     * Sets the value of the receivedDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReceivedDateType }
     *     
     */
    public void setReceivedDate(
        @Nullable
        ReceivedDateType value) {
        this.receivedDate = value;
    }

    /**
     * Gets the value of the paidDate property.
     * 
     * @return
     *     possible object is
     *     {@link PaidDateType }
     *     
     */
    @Nullable
    public PaidDateType getPaidDate() {
        return paidDate;
    }

    /**
     * Sets the value of the paidDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link PaidDateType }
     *     
     */
    public void setPaidDate(
        @Nullable
        PaidDateType value) {
        this.paidDate = value;
    }

    /**
     * Gets the value of the paidTime property.
     * 
     * @return
     *     possible object is
     *     {@link PaidTimeType }
     *     
     */
    @Nullable
    public PaidTimeType getPaidTime() {
        return paidTime;
    }

    /**
     * Sets the value of the paidTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link PaidTimeType }
     *     
     */
    public void setPaidTime(
        @Nullable
        PaidTimeType value) {
        this.paidTime = value;
    }

    /**
     * Gets the value of the instructionID property.
     * 
     * @return
     *     possible object is
     *     {@link InstructionIDType }
     *     
     */
    @Nullable
    public InstructionIDType getInstructionID() {
        return instructionID;
    }

    /**
     * Sets the value of the instructionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link InstructionIDType }
     *     
     */
    public void setInstructionID(
        @Nullable
        InstructionIDType value) {
        this.instructionID = value;
    }

    /**
     * Gets the value of the merchantID property.
     * 
     * @return
     *     possible object is
     *     {@link MerchantIDType }
     *     
     */
    @Nullable
    public MerchantIDType getMerchantID() {
        return merchantID;
    }

    /**
     * Sets the value of the merchantID property.
     * 
     * @param value
     *     allowed object is
     *     {@link MerchantIDType }
     *     
     */
    public void setMerchantID(
        @Nullable
        MerchantIDType value) {
        this.merchantID = value;
    }

    /**
     * Gets the value of the authorizationID property.
     * 
     * @return
     *     possible object is
     *     {@link AuthorizationIDType }
     *     
     */
    @Nullable
    public AuthorizationIDType getAuthorizationID() {
        return authorizationID;
    }

    /**
     * Sets the value of the authorizationID property.
     * 
     * @param value
     *     allowed object is
     *     {@link AuthorizationIDType }
     *     
     */
    public void setAuthorizationID(
        @Nullable
        AuthorizationIDType value) {
        this.authorizationID = value;
    }

    /**
     * Gets the value of the transactionID property.
     * 
     * @return
     *     possible object is
     *     {@link TransactionIDType }
     *     
     */
    @Nullable
    public TransactionIDType getTransactionID() {
        return transactionID;
    }

    /**
     * Sets the value of the transactionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransactionIDType }
     *     
     */
    public void setTransactionID(
        @Nullable
        TransactionIDType value) {
        this.transactionID = value;
    }

    /**
     * Gets the value of the paymentTerminalID property.
     * 
     * @return
     *     possible object is
     *     {@link PaymentTerminalIDType }
     *     
     */
    @Nullable
    public PaymentTerminalIDType getPaymentTerminalID() {
        return paymentTerminalID;
    }

    /**
     * Sets the value of the paymentTerminalID property.
     * 
     * @param value
     *     allowed object is
     *     {@link PaymentTerminalIDType }
     *     
     */
    public void setPaymentTerminalID(
        @Nullable
        PaymentTerminalIDType value) {
        this.paymentTerminalID = value;
    }

    /**
     * Gets the value of the exchangeRate property.
     * 
     * @return
     *     possible object is
     *     {@link ExchangeRateType }
     *     
     */
    @Nullable
    public ExchangeRateType getExchangeRate() {
        return exchangeRate;
    }

    /**
     * Sets the value of the exchangeRate property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExchangeRateType }
     *     
     */
    public void setExchangeRate(
        @Nullable
        ExchangeRateType value) {
        this.exchangeRate = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final PaymentType rhs = ((PaymentType) o);
        if (!EqualsHelper.equals(authorizationID, rhs.authorizationID)) {
            return false;
        }
        if (!EqualsHelper.equals(cashChangeAmount, rhs.cashChangeAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(exchangeRate, rhs.exchangeRate)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(instructionID, rhs.instructionID)) {
            return false;
        }
        if (!EqualsHelper.equals(merchantID, rhs.merchantID)) {
            return false;
        }
        if (!EqualsHelper.equals(paidAmount, rhs.paidAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(paidCashAmount, rhs.paidCashAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(paidDate, rhs.paidDate)) {
            return false;
        }
        if (!EqualsHelper.equals(paidTime, rhs.paidTime)) {
            return false;
        }
        if (!EqualsHelper.equals(paymentTerminalID, rhs.paymentTerminalID)) {
            return false;
        }
        if (!EqualsHelper.equals(receivedDate, rhs.receivedDate)) {
            return false;
        }
        if (!EqualsHelper.equals(transactionID, rhs.transactionID)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(authorizationID).append(cashChangeAmount).append(exchangeRate).append(id).append(instructionID).append(merchantID).append(paidAmount).append(paidCashAmount).append(paidDate).append(paidTime).append(paymentTerminalID).append(receivedDate).append(transactionID).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("authorizationID", authorizationID).append("cashChangeAmount", cashChangeAmount).append("exchangeRate", exchangeRate).append("id", id).append("instructionID", instructionID).append("merchantID", merchantID).append("paidAmount", paidAmount).append("paidCashAmount", paidCashAmount).append("paidDate", paidDate).append("paidTime", paidTime).append("paymentTerminalID", paymentTerminalID).append("receivedDate", receivedDate).append("transactionID", transactionID).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        PaymentType ret) {
        ret.authorizationID = ((authorizationID == null)?null:authorizationID.clone());
        ret.cashChangeAmount = ((cashChangeAmount == null)?null:cashChangeAmount.clone());
        ret.exchangeRate = ((exchangeRate == null)?null:exchangeRate.clone());
        ret.id = ((id == null)?null:id.clone());
        ret.instructionID = ((instructionID == null)?null:instructionID.clone());
        ret.merchantID = ((merchantID == null)?null:merchantID.clone());
        ret.paidAmount = ((paidAmount == null)?null:paidAmount.clone());
        ret.paidCashAmount = ((paidCashAmount == null)?null:paidCashAmount.clone());
        ret.paidDate = ((paidDate == null)?null:paidDate.clone());
        ret.paidTime = ((paidTime == null)?null:paidTime.clone());
        ret.paymentTerminalID = ((paymentTerminalID == null)?null:paymentTerminalID.clone());
        ret.receivedDate = ((receivedDate == null)?null:receivedDate.clone());
        ret.transactionID = ((transactionID == null)?null:transactionID.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public PaymentType clone() {
        PaymentType ret = new PaymentType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PaidAmountType and never <code>null</code>
     */
    @Nonnull
    public PaidAmountType setPaidAmount(
        @Nullable
        final BigDecimal valueParam) {
        PaidAmountType aObj = getPaidAmount();
        if (aObj == null) {
            aObj = new PaidAmountType(valueParam);
            setPaidAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PaidCashAmountType and never <code>null</code>
     */
    @Nonnull
    public PaidCashAmountType setPaidCashAmount(
        @Nullable
        final BigDecimal valueParam) {
        PaidCashAmountType aObj = getPaidCashAmount();
        if (aObj == null) {
            aObj = new PaidCashAmountType(valueParam);
            setPaidCashAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CashChangeAmountType and never <code>null</code>
     */
    @Nonnull
    public CashChangeAmountType setCashChangeAmount(
        @Nullable
        final BigDecimal valueParam) {
        CashChangeAmountType aObj = getCashChangeAmount();
        if (aObj == null) {
            aObj = new CashChangeAmountType(valueParam);
            setCashChangeAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ReceivedDateType and never <code>null</code>
     */
    @Nonnull
    public ReceivedDateType setReceivedDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        ReceivedDateType aObj = getReceivedDate();
        if (aObj == null) {
            aObj = new ReceivedDateType(valueParam);
            setReceivedDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ReceivedDateType and never <code>null</code>
     */
    @Nonnull
    public ReceivedDateType setReceivedDate(
        @Nullable
        final LocalDate valueParam) {
        ReceivedDateType aObj = getReceivedDate();
        if (aObj == null) {
            aObj = new ReceivedDateType(valueParam);
            setReceivedDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PaidDateType and never <code>null</code>
     */
    @Nonnull
    public PaidDateType setPaidDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        PaidDateType aObj = getPaidDate();
        if (aObj == null) {
            aObj = new PaidDateType(valueParam);
            setPaidDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PaidDateType and never <code>null</code>
     */
    @Nonnull
    public PaidDateType setPaidDate(
        @Nullable
        final LocalDate valueParam) {
        PaidDateType aObj = getPaidDate();
        if (aObj == null) {
            aObj = new PaidDateType(valueParam);
            setPaidDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PaidTimeType and never <code>null</code>
     */
    @Nonnull
    public PaidTimeType setPaidTime(
        @Nullable
        final XMLOffsetTime valueParam) {
        PaidTimeType aObj = getPaidTime();
        if (aObj == null) {
            aObj = new PaidTimeType(valueParam);
            setPaidTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PaidTimeType and never <code>null</code>
     */
    @Nonnull
    public PaidTimeType setPaidTime(
        @Nullable
        final LocalTime valueParam) {
        PaidTimeType aObj = getPaidTime();
        if (aObj == null) {
            aObj = new PaidTimeType(valueParam);
            setPaidTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type InstructionIDType and never <code>null</code>
     */
    @Nonnull
    public InstructionIDType setInstructionID(
        @Nullable
        final String valueParam) {
        InstructionIDType aObj = getInstructionID();
        if (aObj == null) {
            aObj = new InstructionIDType(valueParam);
            setInstructionID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MerchantIDType and never <code>null</code>
     */
    @Nonnull
    public MerchantIDType setMerchantID(
        @Nullable
        final String valueParam) {
        MerchantIDType aObj = getMerchantID();
        if (aObj == null) {
            aObj = new MerchantIDType(valueParam);
            setMerchantID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AuthorizationIDType and never <code>null</code>
     */
    @Nonnull
    public AuthorizationIDType setAuthorizationID(
        @Nullable
        final String valueParam) {
        AuthorizationIDType aObj = getAuthorizationID();
        if (aObj == null) {
            aObj = new AuthorizationIDType(valueParam);
            setAuthorizationID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TransactionIDType and never <code>null</code>
     */
    @Nonnull
    public TransactionIDType setTransactionID(
        @Nullable
        final String valueParam) {
        TransactionIDType aObj = getTransactionID();
        if (aObj == null) {
            aObj = new TransactionIDType(valueParam);
            setTransactionID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PaymentTerminalIDType and never <code>null</code>
     */
    @Nonnull
    public PaymentTerminalIDType setPaymentTerminalID(
        @Nullable
        final String valueParam) {
        PaymentTerminalIDType aObj = getPaymentTerminalID();
        if (aObj == null) {
            aObj = new PaymentTerminalIDType(valueParam);
            setPaymentTerminalID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PaidAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PaidAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getPaidAmountValue() {
        PaidAmountType aObj = getPaidAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PaidCashAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PaidCashAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getPaidCashAmountValue() {
        PaidCashAmountType aObj = getPaidCashAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CashChangeAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CashChangeAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getCashChangeAmountValue() {
        CashChangeAmountType aObj = getCashChangeAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ReceivedDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ReceivedDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getReceivedDateValue() {
        ReceivedDateType aObj = getReceivedDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ReceivedDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ReceivedDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getReceivedDateValueLocal() {
        ReceivedDateType aObj = getReceivedDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained PaidDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PaidDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getPaidDateValue() {
        PaidDateType aObj = getPaidDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PaidDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PaidDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getPaidDateValueLocal() {
        PaidDateType aObj = getPaidDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained PaidTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PaidTimeType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetTime getPaidTimeValue() {
        PaidTimeType aObj = getPaidTime();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PaidTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PaidTimeType object or <code>null</code>
     */
    @Nullable
    public LocalTime getPaidTimeValueLocal() {
        PaidTimeType aObj = getPaidTime();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained InstructionIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained InstructionIDType object or <code>null</code>
     */
    @Nullable
    public String getInstructionIDValue() {
        InstructionIDType aObj = getInstructionID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MerchantIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MerchantIDType object or <code>null</code>
     */
    @Nullable
    public String getMerchantIDValue() {
        MerchantIDType aObj = getMerchantID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained AuthorizationIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AuthorizationIDType object or <code>null</code>
     */
    @Nullable
    public String getAuthorizationIDValue() {
        AuthorizationIDType aObj = getAuthorizationID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TransactionIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TransactionIDType object or <code>null</code>
     */
    @Nullable
    public String getTransactionIDValue() {
        TransactionIDType aObj = getTransactionID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PaymentTerminalIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PaymentTerminalIDType object or <code>null</code>
     */
    @Nullable
    public String getPaymentTerminalIDValue() {
        PaymentTerminalIDType aObj = getPaymentTerminalID();
        return (aObj == null)?null:aObj.getValue();
    }

}
