
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.BuriedAtSeaIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.DiedIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.EvacuatedIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.GivenTreatmentDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.JoinedShipDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.NatureOfIllnessDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.NoteType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.OnsetDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ReportedToMedicalOfficerIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.StillIllIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.StillOnBoardIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for PersonnelHealthIncidentType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="PersonnelHealthIncidentType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}JoinedShipDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}NatureOfIllnessDescription" maxOccurs="unbounded"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}OnsetDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ReportedToMedicalOfficerIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}GivenTreatmentDescription" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}StillIllIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}DiedIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}StillOnBoardIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}EvacuatedIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}BuriedAtSeaIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Note" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Person" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PersonnelHealthIncidentType", propOrder = {
    "ublExtensions",
    "id",
    "joinedShipDate",
    "natureOfIllnessDescription",
    "onsetDate",
    "reportedToMedicalOfficerIndicator",
    "givenTreatmentDescription",
    "stillIllIndicator",
    "diedIndicator",
    "stillOnBoardIndicator",
    "evacuatedIndicator",
    "buriedAtSeaIndicator",
    "note",
    "person"
})
@CodingStyleguideUnaware
public class PersonnelHealthIncidentType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private IDType id;
    @XmlElement(name = "JoinedShipDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private JoinedShipDateType joinedShipDate;
    @XmlElement(name = "NatureOfIllnessDescription", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private List<NatureOfIllnessDescriptionType> natureOfIllnessDescription;
    @XmlElement(name = "OnsetDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private OnsetDateType onsetDate;
    @XmlElement(name = "ReportedToMedicalOfficerIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ReportedToMedicalOfficerIndicatorType reportedToMedicalOfficerIndicator;
    @XmlElement(name = "GivenTreatmentDescription", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<GivenTreatmentDescriptionType> givenTreatmentDescription;
    @XmlElement(name = "StillIllIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private StillIllIndicatorType stillIllIndicator;
    @XmlElement(name = "DiedIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private DiedIndicatorType diedIndicator;
    @XmlElement(name = "StillOnBoardIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private StillOnBoardIndicatorType stillOnBoardIndicator;
    @XmlElement(name = "EvacuatedIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private EvacuatedIndicatorType evacuatedIndicator;
    @XmlElement(name = "BuriedAtSeaIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private BuriedAtSeaIndicatorType buriedAtSeaIndicator;
    @XmlElement(name = "Note", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<NoteType> note;
    @XmlElement(name = "Person")
    private PersonType person;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public PersonnelHealthIncidentType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the joinedShipDate property.
     * 
     * @return
     *     possible object is
     *     {@link JoinedShipDateType }
     *     
     */
    @Nullable
    public JoinedShipDateType getJoinedShipDate() {
        return joinedShipDate;
    }

    /**
     * Sets the value of the joinedShipDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link JoinedShipDateType }
     *     
     */
    public void setJoinedShipDate(
        @Nullable
        JoinedShipDateType value) {
        this.joinedShipDate = value;
    }

    /**
     * Gets the value of the natureOfIllnessDescription property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the natureOfIllnessDescription property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getNatureOfIllnessDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NatureOfIllnessDescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the natureOfIllnessDescription property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NatureOfIllnessDescriptionType> getNatureOfIllnessDescription() {
        if (natureOfIllnessDescription == null) {
            natureOfIllnessDescription = new ArrayList<>();
        }
        return this.natureOfIllnessDescription;
    }

    /**
     * Gets the value of the onsetDate property.
     * 
     * @return
     *     possible object is
     *     {@link OnsetDateType }
     *     
     */
    @Nullable
    public OnsetDateType getOnsetDate() {
        return onsetDate;
    }

    /**
     * Sets the value of the onsetDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link OnsetDateType }
     *     
     */
    public void setOnsetDate(
        @Nullable
        OnsetDateType value) {
        this.onsetDate = value;
    }

    /**
     * Gets the value of the reportedToMedicalOfficerIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link ReportedToMedicalOfficerIndicatorType }
     *     
     */
    @Nullable
    public ReportedToMedicalOfficerIndicatorType getReportedToMedicalOfficerIndicator() {
        return reportedToMedicalOfficerIndicator;
    }

    /**
     * Sets the value of the reportedToMedicalOfficerIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReportedToMedicalOfficerIndicatorType }
     *     
     */
    public void setReportedToMedicalOfficerIndicator(
        @Nullable
        ReportedToMedicalOfficerIndicatorType value) {
        this.reportedToMedicalOfficerIndicator = value;
    }

    /**
     * Gets the value of the givenTreatmentDescription property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the givenTreatmentDescription property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getGivenTreatmentDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link GivenTreatmentDescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the givenTreatmentDescription property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<GivenTreatmentDescriptionType> getGivenTreatmentDescription() {
        if (givenTreatmentDescription == null) {
            givenTreatmentDescription = new ArrayList<>();
        }
        return this.givenTreatmentDescription;
    }

    /**
     * Gets the value of the stillIllIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link StillIllIndicatorType }
     *     
     */
    @Nullable
    public StillIllIndicatorType getStillIllIndicator() {
        return stillIllIndicator;
    }

    /**
     * Sets the value of the stillIllIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link StillIllIndicatorType }
     *     
     */
    public void setStillIllIndicator(
        @Nullable
        StillIllIndicatorType value) {
        this.stillIllIndicator = value;
    }

    /**
     * Gets the value of the diedIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link DiedIndicatorType }
     *     
     */
    @Nullable
    public DiedIndicatorType getDiedIndicator() {
        return diedIndicator;
    }

    /**
     * Sets the value of the diedIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link DiedIndicatorType }
     *     
     */
    public void setDiedIndicator(
        @Nullable
        DiedIndicatorType value) {
        this.diedIndicator = value;
    }

    /**
     * Gets the value of the stillOnBoardIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link StillOnBoardIndicatorType }
     *     
     */
    @Nullable
    public StillOnBoardIndicatorType getStillOnBoardIndicator() {
        return stillOnBoardIndicator;
    }

    /**
     * Sets the value of the stillOnBoardIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link StillOnBoardIndicatorType }
     *     
     */
    public void setStillOnBoardIndicator(
        @Nullable
        StillOnBoardIndicatorType value) {
        this.stillOnBoardIndicator = value;
    }

    /**
     * Gets the value of the evacuatedIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link EvacuatedIndicatorType }
     *     
     */
    @Nullable
    public EvacuatedIndicatorType getEvacuatedIndicator() {
        return evacuatedIndicator;
    }

    /**
     * Sets the value of the evacuatedIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link EvacuatedIndicatorType }
     *     
     */
    public void setEvacuatedIndicator(
        @Nullable
        EvacuatedIndicatorType value) {
        this.evacuatedIndicator = value;
    }

    /**
     * Gets the value of the buriedAtSeaIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link BuriedAtSeaIndicatorType }
     *     
     */
    @Nullable
    public BuriedAtSeaIndicatorType getBuriedAtSeaIndicator() {
        return buriedAtSeaIndicator;
    }

    /**
     * Sets the value of the buriedAtSeaIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link BuriedAtSeaIndicatorType }
     *     
     */
    public void setBuriedAtSeaIndicator(
        @Nullable
        BuriedAtSeaIndicatorType value) {
        this.buriedAtSeaIndicator = value;
    }

    /**
     * Gets the value of the note property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the note property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getNote().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NoteType }
     * </p>
     * 
     * 
     * @return
     *     The value of the note property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NoteType> getNote() {
        if (note == null) {
            note = new ArrayList<>();
        }
        return this.note;
    }

    /**
     * Gets the value of the person property.
     * 
     * @return
     *     possible object is
     *     {@link PersonType }
     *     
     */
    @Nullable
    public PersonType getPerson() {
        return person;
    }

    /**
     * Sets the value of the person property.
     * 
     * @param value
     *     allowed object is
     *     {@link PersonType }
     *     
     */
    public void setPerson(
        @Nullable
        PersonType value) {
        this.person = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final PersonnelHealthIncidentType rhs = ((PersonnelHealthIncidentType) o);
        if (!EqualsHelper.equals(buriedAtSeaIndicator, rhs.buriedAtSeaIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(diedIndicator, rhs.diedIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(evacuatedIndicator, rhs.evacuatedIndicator)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(givenTreatmentDescription, rhs.givenTreatmentDescription)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(joinedShipDate, rhs.joinedShipDate)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(natureOfIllnessDescription, rhs.natureOfIllnessDescription)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(note, rhs.note)) {
            return false;
        }
        if (!EqualsHelper.equals(onsetDate, rhs.onsetDate)) {
            return false;
        }
        if (!EqualsHelper.equals(person, rhs.person)) {
            return false;
        }
        if (!EqualsHelper.equals(reportedToMedicalOfficerIndicator, rhs.reportedToMedicalOfficerIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(stillIllIndicator, rhs.stillIllIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(stillOnBoardIndicator, rhs.stillOnBoardIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(buriedAtSeaIndicator).append(diedIndicator).append(evacuatedIndicator).append(givenTreatmentDescription).append(id).append(joinedShipDate).append(natureOfIllnessDescription).append(note).append(onsetDate).append(person).append(reportedToMedicalOfficerIndicator).append(stillIllIndicator).append(stillOnBoardIndicator).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("buriedAtSeaIndicator", buriedAtSeaIndicator).append("diedIndicator", diedIndicator).append("evacuatedIndicator", evacuatedIndicator).append("givenTreatmentDescription", givenTreatmentDescription).append("id", id).append("joinedShipDate", joinedShipDate).append("natureOfIllnessDescription", natureOfIllnessDescription).append("note", note).append("onsetDate", onsetDate).append("person", person).append("reportedToMedicalOfficerIndicator", reportedToMedicalOfficerIndicator).append("stillIllIndicator", stillIllIndicator).append("stillOnBoardIndicator", stillOnBoardIndicator).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setNatureOfIllnessDescription(
        @Nullable
        final List<NatureOfIllnessDescriptionType> aList) {
        natureOfIllnessDescription = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setGivenTreatmentDescription(
        @Nullable
        final List<GivenTreatmentDescriptionType> aList) {
        givenTreatmentDescription = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setNote(
        @Nullable
        final List<NoteType> aList) {
        note = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasNatureOfIllnessDescriptionEntries() {
        return (!getNatureOfIllnessDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoNatureOfIllnessDescriptionEntries() {
        return getNatureOfIllnessDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getNatureOfIllnessDescriptionCount() {
        return getNatureOfIllnessDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NatureOfIllnessDescriptionType getNatureOfIllnessDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getNatureOfIllnessDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addNatureOfIllnessDescription(
        @Nonnull
        final NatureOfIllnessDescriptionType elem) {
        getNatureOfIllnessDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasGivenTreatmentDescriptionEntries() {
        return (!getGivenTreatmentDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoGivenTreatmentDescriptionEntries() {
        return getGivenTreatmentDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getGivenTreatmentDescriptionCount() {
        return getGivenTreatmentDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public GivenTreatmentDescriptionType getGivenTreatmentDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getGivenTreatmentDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addGivenTreatmentDescription(
        @Nonnull
        final GivenTreatmentDescriptionType elem) {
        getGivenTreatmentDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoteEntries() {
        return (!getNote().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoNoteEntries() {
        return getNote().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getNoteCount() {
        return getNote().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NoteType getNoteAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getNote().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addNote(
        @Nonnull
        final NoteType elem) {
        getNote().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        PersonnelHealthIncidentType ret) {
        ret.buriedAtSeaIndicator = ((buriedAtSeaIndicator == null)?null:buriedAtSeaIndicator.clone());
        ret.diedIndicator = ((diedIndicator == null)?null:diedIndicator.clone());
        ret.evacuatedIndicator = ((evacuatedIndicator == null)?null:evacuatedIndicator.clone());
        if (givenTreatmentDescription == null) {
            ret.givenTreatmentDescription = null;
        } else {
            List<GivenTreatmentDescriptionType> retGivenTreatmentDescription = new ArrayList<>();
            for (GivenTreatmentDescriptionType aItem: getGivenTreatmentDescription()) {
                retGivenTreatmentDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.givenTreatmentDescription = retGivenTreatmentDescription;
        }
        ret.id = ((id == null)?null:id.clone());
        ret.joinedShipDate = ((joinedShipDate == null)?null:joinedShipDate.clone());
        if (natureOfIllnessDescription == null) {
            ret.natureOfIllnessDescription = null;
        } else {
            List<NatureOfIllnessDescriptionType> retNatureOfIllnessDescription = new ArrayList<>();
            for (NatureOfIllnessDescriptionType aItem: getNatureOfIllnessDescription()) {
                retNatureOfIllnessDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.natureOfIllnessDescription = retNatureOfIllnessDescription;
        }
        if (note == null) {
            ret.note = null;
        } else {
            List<NoteType> retNote = new ArrayList<>();
            for (NoteType aItem: getNote()) {
                retNote.add(((aItem == null)?null:aItem.clone()));
            }
            ret.note = retNote;
        }
        ret.onsetDate = ((onsetDate == null)?null:onsetDate.clone());
        ret.person = ((person == null)?null:person.clone());
        ret.reportedToMedicalOfficerIndicator = ((reportedToMedicalOfficerIndicator == null)?null:reportedToMedicalOfficerIndicator.clone());
        ret.stillIllIndicator = ((stillIllIndicator == null)?null:stillIllIndicator.clone());
        ret.stillOnBoardIndicator = ((stillOnBoardIndicator == null)?null:stillOnBoardIndicator.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public PersonnelHealthIncidentType clone() {
        PersonnelHealthIncidentType ret = new PersonnelHealthIncidentType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type JoinedShipDateType and never <code>null</code>
     */
    @Nonnull
    public JoinedShipDateType setJoinedShipDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        JoinedShipDateType aObj = getJoinedShipDate();
        if (aObj == null) {
            aObj = new JoinedShipDateType(valueParam);
            setJoinedShipDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type JoinedShipDateType and never <code>null</code>
     */
    @Nonnull
    public JoinedShipDateType setJoinedShipDate(
        @Nullable
        final LocalDate valueParam) {
        JoinedShipDateType aObj = getJoinedShipDate();
        if (aObj == null) {
            aObj = new JoinedShipDateType(valueParam);
            setJoinedShipDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type OnsetDateType and never <code>null</code>
     */
    @Nonnull
    public OnsetDateType setOnsetDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        OnsetDateType aObj = getOnsetDate();
        if (aObj == null) {
            aObj = new OnsetDateType(valueParam);
            setOnsetDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type OnsetDateType and never <code>null</code>
     */
    @Nonnull
    public OnsetDateType setOnsetDate(
        @Nullable
        final LocalDate valueParam) {
        OnsetDateType aObj = getOnsetDate();
        if (aObj == null) {
            aObj = new OnsetDateType(valueParam);
            setOnsetDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type ReportedToMedicalOfficerIndicatorType and never <code>null</code>
     */
    @Nonnull
    public ReportedToMedicalOfficerIndicatorType setReportedToMedicalOfficerIndicator(final boolean valueParam) {
        ReportedToMedicalOfficerIndicatorType aObj = getReportedToMedicalOfficerIndicator();
        if (aObj == null) {
            aObj = new ReportedToMedicalOfficerIndicatorType(valueParam);
            setReportedToMedicalOfficerIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type StillIllIndicatorType and never <code>null</code>
     */
    @Nonnull
    public StillIllIndicatorType setStillIllIndicator(final boolean valueParam) {
        StillIllIndicatorType aObj = getStillIllIndicator();
        if (aObj == null) {
            aObj = new StillIllIndicatorType(valueParam);
            setStillIllIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type DiedIndicatorType and never <code>null</code>
     */
    @Nonnull
    public DiedIndicatorType setDiedIndicator(final boolean valueParam) {
        DiedIndicatorType aObj = getDiedIndicator();
        if (aObj == null) {
            aObj = new DiedIndicatorType(valueParam);
            setDiedIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type StillOnBoardIndicatorType and never <code>null</code>
     */
    @Nonnull
    public StillOnBoardIndicatorType setStillOnBoardIndicator(final boolean valueParam) {
        StillOnBoardIndicatorType aObj = getStillOnBoardIndicator();
        if (aObj == null) {
            aObj = new StillOnBoardIndicatorType(valueParam);
            setStillOnBoardIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type EvacuatedIndicatorType and never <code>null</code>
     */
    @Nonnull
    public EvacuatedIndicatorType setEvacuatedIndicator(final boolean valueParam) {
        EvacuatedIndicatorType aObj = getEvacuatedIndicator();
        if (aObj == null) {
            aObj = new EvacuatedIndicatorType(valueParam);
            setEvacuatedIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type BuriedAtSeaIndicatorType and never <code>null</code>
     */
    @Nonnull
    public BuriedAtSeaIndicatorType setBuriedAtSeaIndicator(final boolean valueParam) {
        BuriedAtSeaIndicatorType aObj = getBuriedAtSeaIndicator();
        if (aObj == null) {
            aObj = new BuriedAtSeaIndicatorType(valueParam);
            setBuriedAtSeaIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained JoinedShipDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained JoinedShipDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getJoinedShipDateValue() {
        JoinedShipDateType aObj = getJoinedShipDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained JoinedShipDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained JoinedShipDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getJoinedShipDateValueLocal() {
        JoinedShipDateType aObj = getJoinedShipDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained OnsetDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained OnsetDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getOnsetDateValue() {
        OnsetDateType aObj = getOnsetDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained OnsetDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained OnsetDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getOnsetDateValueLocal() {
        OnsetDateType aObj = getOnsetDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained ReportedToMedicalOfficerIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained ReportedToMedicalOfficerIndicatorType object or the passed nullValue
     */
    public boolean isReportedToMedicalOfficerIndicatorValue(final boolean nullValue) {
        ReportedToMedicalOfficerIndicatorType aObj = getReportedToMedicalOfficerIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained StillIllIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained StillIllIndicatorType object or the passed nullValue
     */
    public boolean isStillIllIndicatorValue(final boolean nullValue) {
        StillIllIndicatorType aObj = getStillIllIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained DiedIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained DiedIndicatorType object or the passed nullValue
     */
    public boolean isDiedIndicatorValue(final boolean nullValue) {
        DiedIndicatorType aObj = getDiedIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained StillOnBoardIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained StillOnBoardIndicatorType object or the passed nullValue
     */
    public boolean isStillOnBoardIndicatorValue(final boolean nullValue) {
        StillOnBoardIndicatorType aObj = getStillOnBoardIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained EvacuatedIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained EvacuatedIndicatorType object or the passed nullValue
     */
    public boolean isEvacuatedIndicatorValue(final boolean nullValue) {
        EvacuatedIndicatorType aObj = getEvacuatedIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained BuriedAtSeaIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained BuriedAtSeaIndicatorType object or the passed nullValue
     */
    public boolean isBuriedAtSeaIndicatorValue(final boolean nullValue) {
        BuriedAtSeaIndicatorType aObj = getBuriedAtSeaIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

}
