
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.CargoAndBallastTankConditionDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ExpectedAnchorageIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PlannedInspectionsDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PlannedOperationsDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PlannedWorksDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PositionInPortIDType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for PortCallType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="PortCallType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PlannedOperationsDescription" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PlannedWorksDescription" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PlannedInspectionsDescription" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ExpectedAnchorageIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PositionInPortID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CargoAndBallastTankConditionDescription" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ShipRequirement" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PrimaryPortCallPurpose" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AdditionalPortCallPurpose" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}RequestedArrivalEvent" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PortCallType", propOrder = {
    "ublExtensions",
    "id",
    "plannedOperationsDescription",
    "plannedWorksDescription",
    "plannedInspectionsDescription",
    "expectedAnchorageIndicator",
    "positionInPortID",
    "cargoAndBallastTankConditionDescription",
    "shipRequirement",
    "primaryPortCallPurpose",
    "additionalPortCallPurpose",
    "requestedArrivalEvent"
})
@CodingStyleguideUnaware
public class PortCallType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "PlannedOperationsDescription", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<PlannedOperationsDescriptionType> plannedOperationsDescription;
    @XmlElement(name = "PlannedWorksDescription", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<PlannedWorksDescriptionType> plannedWorksDescription;
    @XmlElement(name = "PlannedInspectionsDescription", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<PlannedInspectionsDescriptionType> plannedInspectionsDescription;
    @XmlElement(name = "ExpectedAnchorageIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ExpectedAnchorageIndicatorType expectedAnchorageIndicator;
    @XmlElement(name = "PositionInPortID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PositionInPortIDType positionInPortID;
    @XmlElement(name = "CargoAndBallastTankConditionDescription", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<CargoAndBallastTankConditionDescriptionType> cargoAndBallastTankConditionDescription;
    @XmlElement(name = "ShipRequirement")
    private List<ShipRequirementType> shipRequirement;
    @XmlElement(name = "PrimaryPortCallPurpose")
    private PortCallPurposeType primaryPortCallPurpose;
    @XmlElement(name = "AdditionalPortCallPurpose")
    private List<PortCallPurposeType> additionalPortCallPurpose;
    @XmlElement(name = "RequestedArrivalEvent")
    private EventType requestedArrivalEvent;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public PortCallType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the plannedOperationsDescription property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the plannedOperationsDescription property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPlannedOperationsDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PlannedOperationsDescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the plannedOperationsDescription property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PlannedOperationsDescriptionType> getPlannedOperationsDescription() {
        if (plannedOperationsDescription == null) {
            plannedOperationsDescription = new ArrayList<>();
        }
        return this.plannedOperationsDescription;
    }

    /**
     * Gets the value of the plannedWorksDescription property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the plannedWorksDescription property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPlannedWorksDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PlannedWorksDescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the plannedWorksDescription property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PlannedWorksDescriptionType> getPlannedWorksDescription() {
        if (plannedWorksDescription == null) {
            plannedWorksDescription = new ArrayList<>();
        }
        return this.plannedWorksDescription;
    }

    /**
     * Gets the value of the plannedInspectionsDescription property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the plannedInspectionsDescription property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPlannedInspectionsDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PlannedInspectionsDescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the plannedInspectionsDescription property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PlannedInspectionsDescriptionType> getPlannedInspectionsDescription() {
        if (plannedInspectionsDescription == null) {
            plannedInspectionsDescription = new ArrayList<>();
        }
        return this.plannedInspectionsDescription;
    }

    /**
     * Gets the value of the expectedAnchorageIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link ExpectedAnchorageIndicatorType }
     *     
     */
    @Nullable
    public ExpectedAnchorageIndicatorType getExpectedAnchorageIndicator() {
        return expectedAnchorageIndicator;
    }

    /**
     * Sets the value of the expectedAnchorageIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link ExpectedAnchorageIndicatorType }
     *     
     */
    public void setExpectedAnchorageIndicator(
        @Nullable
        ExpectedAnchorageIndicatorType value) {
        this.expectedAnchorageIndicator = value;
    }

    /**
     * Gets the value of the positionInPortID property.
     * 
     * @return
     *     possible object is
     *     {@link PositionInPortIDType }
     *     
     */
    @Nullable
    public PositionInPortIDType getPositionInPortID() {
        return positionInPortID;
    }

    /**
     * Sets the value of the positionInPortID property.
     * 
     * @param value
     *     allowed object is
     *     {@link PositionInPortIDType }
     *     
     */
    public void setPositionInPortID(
        @Nullable
        PositionInPortIDType value) {
        this.positionInPortID = value;
    }

    /**
     * Gets the value of the cargoAndBallastTankConditionDescription property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the cargoAndBallastTankConditionDescription property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getCargoAndBallastTankConditionDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CargoAndBallastTankConditionDescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the cargoAndBallastTankConditionDescription property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CargoAndBallastTankConditionDescriptionType> getCargoAndBallastTankConditionDescription() {
        if (cargoAndBallastTankConditionDescription == null) {
            cargoAndBallastTankConditionDescription = new ArrayList<>();
        }
        return this.cargoAndBallastTankConditionDescription;
    }

    /**
     * Gets the value of the shipRequirement property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the shipRequirement property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getShipRequirement().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ShipRequirementType }
     * </p>
     * 
     * 
     * @return
     *     The value of the shipRequirement property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ShipRequirementType> getShipRequirement() {
        if (shipRequirement == null) {
            shipRequirement = new ArrayList<>();
        }
        return this.shipRequirement;
    }

    /**
     * Gets the value of the primaryPortCallPurpose property.
     * 
     * @return
     *     possible object is
     *     {@link PortCallPurposeType }
     *     
     */
    @Nullable
    public PortCallPurposeType getPrimaryPortCallPurpose() {
        return primaryPortCallPurpose;
    }

    /**
     * Sets the value of the primaryPortCallPurpose property.
     * 
     * @param value
     *     allowed object is
     *     {@link PortCallPurposeType }
     *     
     */
    public void setPrimaryPortCallPurpose(
        @Nullable
        PortCallPurposeType value) {
        this.primaryPortCallPurpose = value;
    }

    /**
     * Gets the value of the additionalPortCallPurpose property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the additionalPortCallPurpose property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAdditionalPortCallPurpose().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PortCallPurposeType }
     * </p>
     * 
     * 
     * @return
     *     The value of the additionalPortCallPurpose property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PortCallPurposeType> getAdditionalPortCallPurpose() {
        if (additionalPortCallPurpose == null) {
            additionalPortCallPurpose = new ArrayList<>();
        }
        return this.additionalPortCallPurpose;
    }

    /**
     * Gets the value of the requestedArrivalEvent property.
     * 
     * @return
     *     possible object is
     *     {@link EventType }
     *     
     */
    @Nullable
    public EventType getRequestedArrivalEvent() {
        return requestedArrivalEvent;
    }

    /**
     * Sets the value of the requestedArrivalEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link EventType }
     *     
     */
    public void setRequestedArrivalEvent(
        @Nullable
        EventType value) {
        this.requestedArrivalEvent = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final PortCallType rhs = ((PortCallType) o);
        if (!EqualsHelper.equalsCollection(additionalPortCallPurpose, rhs.additionalPortCallPurpose)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(cargoAndBallastTankConditionDescription, rhs.cargoAndBallastTankConditionDescription)) {
            return false;
        }
        if (!EqualsHelper.equals(expectedAnchorageIndicator, rhs.expectedAnchorageIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(plannedInspectionsDescription, rhs.plannedInspectionsDescription)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(plannedOperationsDescription, rhs.plannedOperationsDescription)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(plannedWorksDescription, rhs.plannedWorksDescription)) {
            return false;
        }
        if (!EqualsHelper.equals(positionInPortID, rhs.positionInPortID)) {
            return false;
        }
        if (!EqualsHelper.equals(primaryPortCallPurpose, rhs.primaryPortCallPurpose)) {
            return false;
        }
        if (!EqualsHelper.equals(requestedArrivalEvent, rhs.requestedArrivalEvent)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(shipRequirement, rhs.shipRequirement)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(additionalPortCallPurpose).append(cargoAndBallastTankConditionDescription).append(expectedAnchorageIndicator).append(id).append(plannedInspectionsDescription).append(plannedOperationsDescription).append(plannedWorksDescription).append(positionInPortID).append(primaryPortCallPurpose).append(requestedArrivalEvent).append(shipRequirement).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("additionalPortCallPurpose", additionalPortCallPurpose).append("cargoAndBallastTankConditionDescription", cargoAndBallastTankConditionDescription).append("expectedAnchorageIndicator", expectedAnchorageIndicator).append("id", id).append("plannedInspectionsDescription", plannedInspectionsDescription).append("plannedOperationsDescription", plannedOperationsDescription).append("plannedWorksDescription", plannedWorksDescription).append("positionInPortID", positionInPortID).append("primaryPortCallPurpose", primaryPortCallPurpose).append("requestedArrivalEvent", requestedArrivalEvent).append("shipRequirement", shipRequirement).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPlannedOperationsDescription(
        @Nullable
        final List<PlannedOperationsDescriptionType> aList) {
        plannedOperationsDescription = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPlannedWorksDescription(
        @Nullable
        final List<PlannedWorksDescriptionType> aList) {
        plannedWorksDescription = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPlannedInspectionsDescription(
        @Nullable
        final List<PlannedInspectionsDescriptionType> aList) {
        plannedInspectionsDescription = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCargoAndBallastTankConditionDescription(
        @Nullable
        final List<CargoAndBallastTankConditionDescriptionType> aList) {
        cargoAndBallastTankConditionDescription = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setShipRequirement(
        @Nullable
        final List<ShipRequirementType> aList) {
        shipRequirement = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAdditionalPortCallPurpose(
        @Nullable
        final List<PortCallPurposeType> aList) {
        additionalPortCallPurpose = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPlannedOperationsDescriptionEntries() {
        return (!getPlannedOperationsDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPlannedOperationsDescriptionEntries() {
        return getPlannedOperationsDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPlannedOperationsDescriptionCount() {
        return getPlannedOperationsDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PlannedOperationsDescriptionType getPlannedOperationsDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPlannedOperationsDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPlannedOperationsDescription(
        @Nonnull
        final PlannedOperationsDescriptionType elem) {
        getPlannedOperationsDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPlannedWorksDescriptionEntries() {
        return (!getPlannedWorksDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPlannedWorksDescriptionEntries() {
        return getPlannedWorksDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPlannedWorksDescriptionCount() {
        return getPlannedWorksDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PlannedWorksDescriptionType getPlannedWorksDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPlannedWorksDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPlannedWorksDescription(
        @Nonnull
        final PlannedWorksDescriptionType elem) {
        getPlannedWorksDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPlannedInspectionsDescriptionEntries() {
        return (!getPlannedInspectionsDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPlannedInspectionsDescriptionEntries() {
        return getPlannedInspectionsDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPlannedInspectionsDescriptionCount() {
        return getPlannedInspectionsDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PlannedInspectionsDescriptionType getPlannedInspectionsDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPlannedInspectionsDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPlannedInspectionsDescription(
        @Nonnull
        final PlannedInspectionsDescriptionType elem) {
        getPlannedInspectionsDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCargoAndBallastTankConditionDescriptionEntries() {
        return (!getCargoAndBallastTankConditionDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCargoAndBallastTankConditionDescriptionEntries() {
        return getCargoAndBallastTankConditionDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCargoAndBallastTankConditionDescriptionCount() {
        return getCargoAndBallastTankConditionDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CargoAndBallastTankConditionDescriptionType getCargoAndBallastTankConditionDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCargoAndBallastTankConditionDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCargoAndBallastTankConditionDescription(
        @Nonnull
        final CargoAndBallastTankConditionDescriptionType elem) {
        getCargoAndBallastTankConditionDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasShipRequirementEntries() {
        return (!getShipRequirement().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoShipRequirementEntries() {
        return getShipRequirement().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getShipRequirementCount() {
        return getShipRequirement().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ShipRequirementType getShipRequirementAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getShipRequirement().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addShipRequirement(
        @Nonnull
        final ShipRequirementType elem) {
        getShipRequirement().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAdditionalPortCallPurposeEntries() {
        return (!getAdditionalPortCallPurpose().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAdditionalPortCallPurposeEntries() {
        return getAdditionalPortCallPurpose().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAdditionalPortCallPurposeCount() {
        return getAdditionalPortCallPurpose().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PortCallPurposeType getAdditionalPortCallPurposeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAdditionalPortCallPurpose().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAdditionalPortCallPurpose(
        @Nonnull
        final PortCallPurposeType elem) {
        getAdditionalPortCallPurpose().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        PortCallType ret) {
        if (additionalPortCallPurpose == null) {
            ret.additionalPortCallPurpose = null;
        } else {
            List<PortCallPurposeType> retAdditionalPortCallPurpose = new ArrayList<>();
            for (PortCallPurposeType aItem: getAdditionalPortCallPurpose()) {
                retAdditionalPortCallPurpose.add(((aItem == null)?null:aItem.clone()));
            }
            ret.additionalPortCallPurpose = retAdditionalPortCallPurpose;
        }
        if (cargoAndBallastTankConditionDescription == null) {
            ret.cargoAndBallastTankConditionDescription = null;
        } else {
            List<CargoAndBallastTankConditionDescriptionType> retCargoAndBallastTankConditionDescription = new ArrayList<>();
            for (CargoAndBallastTankConditionDescriptionType aItem: getCargoAndBallastTankConditionDescription()) {
                retCargoAndBallastTankConditionDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.cargoAndBallastTankConditionDescription = retCargoAndBallastTankConditionDescription;
        }
        ret.expectedAnchorageIndicator = ((expectedAnchorageIndicator == null)?null:expectedAnchorageIndicator.clone());
        ret.id = ((id == null)?null:id.clone());
        if (plannedInspectionsDescription == null) {
            ret.plannedInspectionsDescription = null;
        } else {
            List<PlannedInspectionsDescriptionType> retPlannedInspectionsDescription = new ArrayList<>();
            for (PlannedInspectionsDescriptionType aItem: getPlannedInspectionsDescription()) {
                retPlannedInspectionsDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.plannedInspectionsDescription = retPlannedInspectionsDescription;
        }
        if (plannedOperationsDescription == null) {
            ret.plannedOperationsDescription = null;
        } else {
            List<PlannedOperationsDescriptionType> retPlannedOperationsDescription = new ArrayList<>();
            for (PlannedOperationsDescriptionType aItem: getPlannedOperationsDescription()) {
                retPlannedOperationsDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.plannedOperationsDescription = retPlannedOperationsDescription;
        }
        if (plannedWorksDescription == null) {
            ret.plannedWorksDescription = null;
        } else {
            List<PlannedWorksDescriptionType> retPlannedWorksDescription = new ArrayList<>();
            for (PlannedWorksDescriptionType aItem: getPlannedWorksDescription()) {
                retPlannedWorksDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.plannedWorksDescription = retPlannedWorksDescription;
        }
        ret.positionInPortID = ((positionInPortID == null)?null:positionInPortID.clone());
        ret.primaryPortCallPurpose = ((primaryPortCallPurpose == null)?null:primaryPortCallPurpose.clone());
        ret.requestedArrivalEvent = ((requestedArrivalEvent == null)?null:requestedArrivalEvent.clone());
        if (shipRequirement == null) {
            ret.shipRequirement = null;
        } else {
            List<ShipRequirementType> retShipRequirement = new ArrayList<>();
            for (ShipRequirementType aItem: getShipRequirement()) {
                retShipRequirement.add(((aItem == null)?null:aItem.clone()));
            }
            ret.shipRequirement = retShipRequirement;
        }
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public PortCallType clone() {
        PortCallType ret = new PortCallType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type ExpectedAnchorageIndicatorType and never <code>null</code>
     */
    @Nonnull
    public ExpectedAnchorageIndicatorType setExpectedAnchorageIndicator(final boolean valueParam) {
        ExpectedAnchorageIndicatorType aObj = getExpectedAnchorageIndicator();
        if (aObj == null) {
            aObj = new ExpectedAnchorageIndicatorType(valueParam);
            setExpectedAnchorageIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PositionInPortIDType and never <code>null</code>
     */
    @Nonnull
    public PositionInPortIDType setPositionInPortID(
        @Nullable
        final String valueParam) {
        PositionInPortIDType aObj = getPositionInPortID();
        if (aObj == null) {
            aObj = new PositionInPortIDType(valueParam);
            setPositionInPortID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ExpectedAnchorageIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained ExpectedAnchorageIndicatorType object or the passed nullValue
     */
    public boolean isExpectedAnchorageIndicatorValue(final boolean nullValue) {
        ExpectedAnchorageIndicatorType aObj = getExpectedAnchorageIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained PositionInPortIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PositionInPortIDType object or <code>null</code>
     */
    @Nullable
    public String getPositionInPortIDValue() {
        PositionInPortIDType aObj = getPositionInPortID();
        return (aObj == null)?null:aObj.getValue();
    }

}
