
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.datetime.XMLOffsetTime;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.IssueDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.IssueTimeType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for PowerOfAttorneyType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="PowerOfAttorneyType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}IssueDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}IssueTime" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Description" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}NotaryParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AgentParty"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}WitnessParty" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}MandateDocumentReference" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PowerOfAttorneyType", propOrder = {
    "ublExtensions",
    "id",
    "issueDate",
    "issueTime",
    "description",
    "notaryParty",
    "agentParty",
    "witnessParty",
    "mandateDocumentReference"
})
@CodingStyleguideUnaware
public class PowerOfAttorneyType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "IssueDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IssueDateType issueDate;
    @XmlElement(name = "IssueTime", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IssueTimeType issueTime;
    @XmlElement(name = "Description", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<DescriptionType> description;
    @XmlElement(name = "NotaryParty")
    private PartyType notaryParty;
    @XmlElement(name = "AgentParty", required = true)
    private PartyType agentParty;
    @XmlElement(name = "WitnessParty")
    private List<PartyType> witnessParty;
    @XmlElement(name = "MandateDocumentReference")
    private List<DocumentReferenceType> mandateDocumentReference;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public PowerOfAttorneyType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the issueDate property.
     * 
     * @return
     *     possible object is
     *     {@link IssueDateType }
     *     
     */
    @Nullable
    public IssueDateType getIssueDate() {
        return issueDate;
    }

    /**
     * Sets the value of the issueDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link IssueDateType }
     *     
     */
    public void setIssueDate(
        @Nullable
        IssueDateType value) {
        this.issueDate = value;
    }

    /**
     * Gets the value of the issueTime property.
     * 
     * @return
     *     possible object is
     *     {@link IssueTimeType }
     *     
     */
    @Nullable
    public IssueTimeType getIssueTime() {
        return issueTime;
    }

    /**
     * Sets the value of the issueTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link IssueTimeType }
     *     
     */
    public void setIssueTime(
        @Nullable
        IssueTimeType value) {
        this.issueTime = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the description property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the description property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DescriptionType> getDescription() {
        if (description == null) {
            description = new ArrayList<>();
        }
        return this.description;
    }

    /**
     * Gets the value of the notaryParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getNotaryParty() {
        return notaryParty;
    }

    /**
     * Sets the value of the notaryParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setNotaryParty(
        @Nullable
        PartyType value) {
        this.notaryParty = value;
    }

    /**
     * Gets the value of the agentParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getAgentParty() {
        return agentParty;
    }

    /**
     * Sets the value of the agentParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setAgentParty(
        @Nullable
        PartyType value) {
        this.agentParty = value;
    }

    /**
     * Gets the value of the witnessParty property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the witnessParty property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getWitnessParty().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PartyType }
     * </p>
     * 
     * 
     * @return
     *     The value of the witnessParty property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PartyType> getWitnessParty() {
        if (witnessParty == null) {
            witnessParty = new ArrayList<>();
        }
        return this.witnessParty;
    }

    /**
     * Gets the value of the mandateDocumentReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the mandateDocumentReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getMandateDocumentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the mandateDocumentReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentReferenceType> getMandateDocumentReference() {
        if (mandateDocumentReference == null) {
            mandateDocumentReference = new ArrayList<>();
        }
        return this.mandateDocumentReference;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final PowerOfAttorneyType rhs = ((PowerOfAttorneyType) o);
        if (!EqualsHelper.equals(agentParty, rhs.agentParty)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(issueDate, rhs.issueDate)) {
            return false;
        }
        if (!EqualsHelper.equals(issueTime, rhs.issueTime)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(mandateDocumentReference, rhs.mandateDocumentReference)) {
            return false;
        }
        if (!EqualsHelper.equals(notaryParty, rhs.notaryParty)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(witnessParty, rhs.witnessParty)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(agentParty).append(description).append(id).append(issueDate).append(issueTime).append(mandateDocumentReference).append(notaryParty).append(ublExtensions).append(witnessParty).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("agentParty", agentParty).append("description", description).append("id", id).append("issueDate", issueDate).append("issueTime", issueTime).append("mandateDocumentReference", mandateDocumentReference).append("notaryParty", notaryParty).append("ublExtensions", ublExtensions).append("witnessParty", witnessParty).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<DescriptionType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setWitnessParty(
        @Nullable
        final List<PartyType> aList) {
        witnessParty = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setMandateDocumentReference(
        @Nullable
        final List<DocumentReferenceType> aList) {
        mandateDocumentReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DescriptionType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final DescriptionType elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasWitnessPartyEntries() {
        return (!getWitnessParty().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoWitnessPartyEntries() {
        return getWitnessParty().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getWitnessPartyCount() {
        return getWitnessParty().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PartyType getWitnessPartyAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getWitnessParty().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addWitnessParty(
        @Nonnull
        final PartyType elem) {
        getWitnessParty().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasMandateDocumentReferenceEntries() {
        return (!getMandateDocumentReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoMandateDocumentReferenceEntries() {
        return getMandateDocumentReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getMandateDocumentReferenceCount() {
        return getMandateDocumentReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentReferenceType getMandateDocumentReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getMandateDocumentReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addMandateDocumentReference(
        @Nonnull
        final DocumentReferenceType elem) {
        getMandateDocumentReference().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        PowerOfAttorneyType ret) {
        ret.agentParty = ((agentParty == null)?null:agentParty.clone());
        if (description == null) {
            ret.description = null;
        } else {
            List<DescriptionType> retDescription = new ArrayList<>();
            for (DescriptionType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        ret.id = ((id == null)?null:id.clone());
        ret.issueDate = ((issueDate == null)?null:issueDate.clone());
        ret.issueTime = ((issueTime == null)?null:issueTime.clone());
        if (mandateDocumentReference == null) {
            ret.mandateDocumentReference = null;
        } else {
            List<DocumentReferenceType> retMandateDocumentReference = new ArrayList<>();
            for (DocumentReferenceType aItem: getMandateDocumentReference()) {
                retMandateDocumentReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.mandateDocumentReference = retMandateDocumentReference;
        }
        ret.notaryParty = ((notaryParty == null)?null:notaryParty.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        if (witnessParty == null) {
            ret.witnessParty = null;
        } else {
            List<PartyType> retWitnessParty = new ArrayList<>();
            for (PartyType aItem: getWitnessParty()) {
                retWitnessParty.add(((aItem == null)?null:aItem.clone()));
            }
            ret.witnessParty = retWitnessParty;
        }
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public PowerOfAttorneyType clone() {
        PowerOfAttorneyType ret = new PowerOfAttorneyType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IssueDateType and never <code>null</code>
     */
    @Nonnull
    public IssueDateType setIssueDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        IssueDateType aObj = getIssueDate();
        if (aObj == null) {
            aObj = new IssueDateType(valueParam);
            setIssueDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IssueDateType and never <code>null</code>
     */
    @Nonnull
    public IssueDateType setIssueDate(
        @Nullable
        final LocalDate valueParam) {
        IssueDateType aObj = getIssueDate();
        if (aObj == null) {
            aObj = new IssueDateType(valueParam);
            setIssueDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IssueTimeType and never <code>null</code>
     */
    @Nonnull
    public IssueTimeType setIssueTime(
        @Nullable
        final XMLOffsetTime valueParam) {
        IssueTimeType aObj = getIssueTime();
        if (aObj == null) {
            aObj = new IssueTimeType(valueParam);
            setIssueTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IssueTimeType and never <code>null</code>
     */
    @Nonnull
    public IssueTimeType setIssueTime(
        @Nullable
        final LocalTime valueParam) {
        IssueTimeType aObj = getIssueTime();
        if (aObj == null) {
            aObj = new IssueTimeType(valueParam);
            setIssueTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IssueDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IssueDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getIssueDateValue() {
        IssueDateType aObj = getIssueDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IssueDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IssueDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getIssueDateValueLocal() {
        IssueDateType aObj = getIssueDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained IssueTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IssueTimeType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetTime getIssueTimeValue() {
        IssueTimeType aObj = getIssueTime();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IssueTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IssueTimeType object or <code>null</code>
     */
    @Nullable
    public LocalTime getIssueTimeValueLocal() {
        IssueTimeType aObj = getIssueTime();
        return (aObj == null)?null:aObj.getValueLocal();
    }

}
