
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.FirstShipmentAvailibilityDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.LatestProposalAcceptanceDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PromotionalEventTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.SubmissionDateType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for PromotionalEventType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="PromotionalEventType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PromotionalEventTypeCode"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}SubmissionDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}FirstShipmentAvailibilityDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}LatestProposalAcceptanceDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PromotionalSpecification" maxOccurs="unbounded"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PromotionalEventType", propOrder = {
    "ublExtensions",
    "promotionalEventTypeCode",
    "submissionDate",
    "firstShipmentAvailibilityDate",
    "latestProposalAcceptanceDate",
    "promotionalSpecification"
})
@CodingStyleguideUnaware
public class PromotionalEventType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "PromotionalEventTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private PromotionalEventTypeCodeType promotionalEventTypeCode;
    @XmlElement(name = "SubmissionDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private SubmissionDateType submissionDate;
    @XmlElement(name = "FirstShipmentAvailibilityDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private FirstShipmentAvailibilityDateType firstShipmentAvailibilityDate;
    @XmlElement(name = "LatestProposalAcceptanceDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private LatestProposalAcceptanceDateType latestProposalAcceptanceDate;
    @XmlElement(name = "PromotionalSpecification", required = true)
    private List<PromotionalSpecificationType> promotionalSpecification;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public PromotionalEventType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the promotionalEventTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link PromotionalEventTypeCodeType }
     *     
     */
    @Nullable
    public PromotionalEventTypeCodeType getPromotionalEventTypeCode() {
        return promotionalEventTypeCode;
    }

    /**
     * Sets the value of the promotionalEventTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link PromotionalEventTypeCodeType }
     *     
     */
    public void setPromotionalEventTypeCode(
        @Nullable
        PromotionalEventTypeCodeType value) {
        this.promotionalEventTypeCode = value;
    }

    /**
     * Gets the value of the submissionDate property.
     * 
     * @return
     *     possible object is
     *     {@link SubmissionDateType }
     *     
     */
    @Nullable
    public SubmissionDateType getSubmissionDate() {
        return submissionDate;
    }

    /**
     * Sets the value of the submissionDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link SubmissionDateType }
     *     
     */
    public void setSubmissionDate(
        @Nullable
        SubmissionDateType value) {
        this.submissionDate = value;
    }

    /**
     * Gets the value of the firstShipmentAvailibilityDate property.
     * 
     * @return
     *     possible object is
     *     {@link FirstShipmentAvailibilityDateType }
     *     
     */
    @Nullable
    public FirstShipmentAvailibilityDateType getFirstShipmentAvailibilityDate() {
        return firstShipmentAvailibilityDate;
    }

    /**
     * Sets the value of the firstShipmentAvailibilityDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link FirstShipmentAvailibilityDateType }
     *     
     */
    public void setFirstShipmentAvailibilityDate(
        @Nullable
        FirstShipmentAvailibilityDateType value) {
        this.firstShipmentAvailibilityDate = value;
    }

    /**
     * Gets the value of the latestProposalAcceptanceDate property.
     * 
     * @return
     *     possible object is
     *     {@link LatestProposalAcceptanceDateType }
     *     
     */
    @Nullable
    public LatestProposalAcceptanceDateType getLatestProposalAcceptanceDate() {
        return latestProposalAcceptanceDate;
    }

    /**
     * Sets the value of the latestProposalAcceptanceDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link LatestProposalAcceptanceDateType }
     *     
     */
    public void setLatestProposalAcceptanceDate(
        @Nullable
        LatestProposalAcceptanceDateType value) {
        this.latestProposalAcceptanceDate = value;
    }

    /**
     * Gets the value of the promotionalSpecification property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the promotionalSpecification property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPromotionalSpecification().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PromotionalSpecificationType }
     * </p>
     * 
     * 
     * @return
     *     The value of the promotionalSpecification property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PromotionalSpecificationType> getPromotionalSpecification() {
        if (promotionalSpecification == null) {
            promotionalSpecification = new ArrayList<>();
        }
        return this.promotionalSpecification;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final PromotionalEventType rhs = ((PromotionalEventType) o);
        if (!EqualsHelper.equals(firstShipmentAvailibilityDate, rhs.firstShipmentAvailibilityDate)) {
            return false;
        }
        if (!EqualsHelper.equals(latestProposalAcceptanceDate, rhs.latestProposalAcceptanceDate)) {
            return false;
        }
        if (!EqualsHelper.equals(promotionalEventTypeCode, rhs.promotionalEventTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(promotionalSpecification, rhs.promotionalSpecification)) {
            return false;
        }
        if (!EqualsHelper.equals(submissionDate, rhs.submissionDate)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(firstShipmentAvailibilityDate).append(latestProposalAcceptanceDate).append(promotionalEventTypeCode).append(promotionalSpecification).append(submissionDate).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("firstShipmentAvailibilityDate", firstShipmentAvailibilityDate).append("latestProposalAcceptanceDate", latestProposalAcceptanceDate).append("promotionalEventTypeCode", promotionalEventTypeCode).append("promotionalSpecification", promotionalSpecification).append("submissionDate", submissionDate).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPromotionalSpecification(
        @Nullable
        final List<PromotionalSpecificationType> aList) {
        promotionalSpecification = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPromotionalSpecificationEntries() {
        return (!getPromotionalSpecification().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPromotionalSpecificationEntries() {
        return getPromotionalSpecification().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPromotionalSpecificationCount() {
        return getPromotionalSpecification().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PromotionalSpecificationType getPromotionalSpecificationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPromotionalSpecification().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPromotionalSpecification(
        @Nonnull
        final PromotionalSpecificationType elem) {
        getPromotionalSpecification().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        PromotionalEventType ret) {
        ret.firstShipmentAvailibilityDate = ((firstShipmentAvailibilityDate == null)?null:firstShipmentAvailibilityDate.clone());
        ret.latestProposalAcceptanceDate = ((latestProposalAcceptanceDate == null)?null:latestProposalAcceptanceDate.clone());
        ret.promotionalEventTypeCode = ((promotionalEventTypeCode == null)?null:promotionalEventTypeCode.clone());
        if (promotionalSpecification == null) {
            ret.promotionalSpecification = null;
        } else {
            List<PromotionalSpecificationType> retPromotionalSpecification = new ArrayList<>();
            for (PromotionalSpecificationType aItem: getPromotionalSpecification()) {
                retPromotionalSpecification.add(((aItem == null)?null:aItem.clone()));
            }
            ret.promotionalSpecification = retPromotionalSpecification;
        }
        ret.submissionDate = ((submissionDate == null)?null:submissionDate.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public PromotionalEventType clone() {
        PromotionalEventType ret = new PromotionalEventType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PromotionalEventTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public PromotionalEventTypeCodeType setPromotionalEventTypeCode(
        @Nullable
        final String valueParam) {
        PromotionalEventTypeCodeType aObj = getPromotionalEventTypeCode();
        if (aObj == null) {
            aObj = new PromotionalEventTypeCodeType(valueParam);
            setPromotionalEventTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SubmissionDateType and never <code>null</code>
     */
    @Nonnull
    public SubmissionDateType setSubmissionDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        SubmissionDateType aObj = getSubmissionDate();
        if (aObj == null) {
            aObj = new SubmissionDateType(valueParam);
            setSubmissionDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SubmissionDateType and never <code>null</code>
     */
    @Nonnull
    public SubmissionDateType setSubmissionDate(
        @Nullable
        final LocalDate valueParam) {
        SubmissionDateType aObj = getSubmissionDate();
        if (aObj == null) {
            aObj = new SubmissionDateType(valueParam);
            setSubmissionDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type FirstShipmentAvailibilityDateType and never <code>null</code>
     */
    @Nonnull
    public FirstShipmentAvailibilityDateType setFirstShipmentAvailibilityDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        FirstShipmentAvailibilityDateType aObj = getFirstShipmentAvailibilityDate();
        if (aObj == null) {
            aObj = new FirstShipmentAvailibilityDateType(valueParam);
            setFirstShipmentAvailibilityDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type FirstShipmentAvailibilityDateType and never <code>null</code>
     */
    @Nonnull
    public FirstShipmentAvailibilityDateType setFirstShipmentAvailibilityDate(
        @Nullable
        final LocalDate valueParam) {
        FirstShipmentAvailibilityDateType aObj = getFirstShipmentAvailibilityDate();
        if (aObj == null) {
            aObj = new FirstShipmentAvailibilityDateType(valueParam);
            setFirstShipmentAvailibilityDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LatestProposalAcceptanceDateType and never <code>null</code>
     */
    @Nonnull
    public LatestProposalAcceptanceDateType setLatestProposalAcceptanceDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        LatestProposalAcceptanceDateType aObj = getLatestProposalAcceptanceDate();
        if (aObj == null) {
            aObj = new LatestProposalAcceptanceDateType(valueParam);
            setLatestProposalAcceptanceDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LatestProposalAcceptanceDateType and never <code>null</code>
     */
    @Nonnull
    public LatestProposalAcceptanceDateType setLatestProposalAcceptanceDate(
        @Nullable
        final LocalDate valueParam) {
        LatestProposalAcceptanceDateType aObj = getLatestProposalAcceptanceDate();
        if (aObj == null) {
            aObj = new LatestProposalAcceptanceDateType(valueParam);
            setLatestProposalAcceptanceDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained PromotionalEventTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PromotionalEventTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getPromotionalEventTypeCodeValue() {
        PromotionalEventTypeCodeType aObj = getPromotionalEventTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained SubmissionDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SubmissionDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getSubmissionDateValue() {
        SubmissionDateType aObj = getSubmissionDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained SubmissionDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SubmissionDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getSubmissionDateValueLocal() {
        SubmissionDateType aObj = getSubmissionDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained FirstShipmentAvailibilityDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained FirstShipmentAvailibilityDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getFirstShipmentAvailibilityDateValue() {
        FirstShipmentAvailibilityDateType aObj = getFirstShipmentAvailibilityDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained FirstShipmentAvailibilityDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained FirstShipmentAvailibilityDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getFirstShipmentAvailibilityDateValueLocal() {
        FirstShipmentAvailibilityDateType aObj = getFirstShipmentAvailibilityDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained LatestProposalAcceptanceDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LatestProposalAcceptanceDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getLatestProposalAcceptanceDateValue() {
        LatestProposalAcceptanceDateType aObj = getLatestProposalAcceptanceDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained LatestProposalAcceptanceDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LatestProposalAcceptanceDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getLatestProposalAcceptanceDateValueLocal() {
        LatestProposalAcceptanceDateType aObj = getLatestProposalAcceptanceDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

}
