
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.datetime.XMLOffsetTime;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.NoteType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.OversupplyQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.QuantityDiscrepancyCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ReceivedDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ReceivedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ReceivedTimeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.RejectActionCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.RejectReasonCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.RejectReasonType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.RejectedQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ShortQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ShortageActionCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TimingComplaintCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TimingComplaintType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.UUIDType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for ReceiptLineType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ReceiptLineType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}UUID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Note" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ReceivedQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ShortQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ShortageActionCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RejectedQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RejectReasonCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RejectReason" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RejectActionCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}QuantityDiscrepancyCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}OversupplyQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ReceivedDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ReceivedTime" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TimingComplaintCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TimingComplaint" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}OrderLineReference" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}DespatchLineReference" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}DocumentReference" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Item" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Shipment" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ReceiptLineType", propOrder = {
    "ublExtensions",
    "id",
    "uuid",
    "note",
    "receivedQuantity",
    "shortQuantity",
    "shortageActionCode",
    "rejectedQuantity",
    "rejectReasonCode",
    "rejectReason",
    "rejectActionCode",
    "quantityDiscrepancyCode",
    "oversupplyQuantity",
    "receivedDate",
    "receivedTime",
    "timingComplaintCode",
    "timingComplaint",
    "orderLineReference",
    "despatchLineReference",
    "documentReference",
    "item",
    "shipment"
})
@CodingStyleguideUnaware
public class ReceiptLineType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private IDType id;
    @XmlElement(name = "UUID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private UUIDType uuid;
    @XmlElement(name = "Note", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<NoteType> note;
    @XmlElement(name = "ReceivedQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ReceivedQuantityType receivedQuantity;
    @XmlElement(name = "ShortQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ShortQuantityType shortQuantity;
    @XmlElement(name = "ShortageActionCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ShortageActionCodeType shortageActionCode;
    @XmlElement(name = "RejectedQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private RejectedQuantityType rejectedQuantity;
    @XmlElement(name = "RejectReasonCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private RejectReasonCodeType rejectReasonCode;
    @XmlElement(name = "RejectReason", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<RejectReasonType> rejectReason;
    @XmlElement(name = "RejectActionCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private RejectActionCodeType rejectActionCode;
    @XmlElement(name = "QuantityDiscrepancyCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private QuantityDiscrepancyCodeType quantityDiscrepancyCode;
    @XmlElement(name = "OversupplyQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private OversupplyQuantityType oversupplyQuantity;
    @XmlElement(name = "ReceivedDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ReceivedDateType receivedDate;
    @XmlElement(name = "ReceivedTime", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ReceivedTimeType receivedTime;
    @XmlElement(name = "TimingComplaintCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TimingComplaintCodeType timingComplaintCode;
    @XmlElement(name = "TimingComplaint", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TimingComplaintType timingComplaint;
    @XmlElement(name = "OrderLineReference")
    private OrderLineReferenceType orderLineReference;
    @XmlElement(name = "DespatchLineReference")
    private List<LineReferenceType> despatchLineReference;
    @XmlElement(name = "DocumentReference")
    private List<DocumentReferenceType> documentReference;
    @XmlElement(name = "Item")
    private List<ItemType> item;
    @XmlElement(name = "Shipment")
    private List<ShipmentType> shipment;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public ReceiptLineType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the uuid property.
     * 
     * @return
     *     possible object is
     *     {@link UUIDType }
     *     
     */
    @Nullable
    public UUIDType getUUID() {
        return uuid;
    }

    /**
     * Sets the value of the uuid property.
     * 
     * @param value
     *     allowed object is
     *     {@link UUIDType }
     *     
     */
    public void setUUID(
        @Nullable
        UUIDType value) {
        this.uuid = value;
    }

    /**
     * Gets the value of the note property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the note property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getNote().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NoteType }
     * </p>
     * 
     * 
     * @return
     *     The value of the note property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NoteType> getNote() {
        if (note == null) {
            note = new ArrayList<>();
        }
        return this.note;
    }

    /**
     * Gets the value of the receivedQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link ReceivedQuantityType }
     *     
     */
    @Nullable
    public ReceivedQuantityType getReceivedQuantity() {
        return receivedQuantity;
    }

    /**
     * Sets the value of the receivedQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReceivedQuantityType }
     *     
     */
    public void setReceivedQuantity(
        @Nullable
        ReceivedQuantityType value) {
        this.receivedQuantity = value;
    }

    /**
     * Gets the value of the shortQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link ShortQuantityType }
     *     
     */
    @Nullable
    public ShortQuantityType getShortQuantity() {
        return shortQuantity;
    }

    /**
     * Sets the value of the shortQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link ShortQuantityType }
     *     
     */
    public void setShortQuantity(
        @Nullable
        ShortQuantityType value) {
        this.shortQuantity = value;
    }

    /**
     * Gets the value of the shortageActionCode property.
     * 
     * @return
     *     possible object is
     *     {@link ShortageActionCodeType }
     *     
     */
    @Nullable
    public ShortageActionCodeType getShortageActionCode() {
        return shortageActionCode;
    }

    /**
     * Sets the value of the shortageActionCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ShortageActionCodeType }
     *     
     */
    public void setShortageActionCode(
        @Nullable
        ShortageActionCodeType value) {
        this.shortageActionCode = value;
    }

    /**
     * Gets the value of the rejectedQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link RejectedQuantityType }
     *     
     */
    @Nullable
    public RejectedQuantityType getRejectedQuantity() {
        return rejectedQuantity;
    }

    /**
     * Sets the value of the rejectedQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link RejectedQuantityType }
     *     
     */
    public void setRejectedQuantity(
        @Nullable
        RejectedQuantityType value) {
        this.rejectedQuantity = value;
    }

    /**
     * Gets the value of the rejectReasonCode property.
     * 
     * @return
     *     possible object is
     *     {@link RejectReasonCodeType }
     *     
     */
    @Nullable
    public RejectReasonCodeType getRejectReasonCode() {
        return rejectReasonCode;
    }

    /**
     * Sets the value of the rejectReasonCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link RejectReasonCodeType }
     *     
     */
    public void setRejectReasonCode(
        @Nullable
        RejectReasonCodeType value) {
        this.rejectReasonCode = value;
    }

    /**
     * Gets the value of the rejectReason property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the rejectReason property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getRejectReason().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link RejectReasonType }
     * </p>
     * 
     * 
     * @return
     *     The value of the rejectReason property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<RejectReasonType> getRejectReason() {
        if (rejectReason == null) {
            rejectReason = new ArrayList<>();
        }
        return this.rejectReason;
    }

    /**
     * Gets the value of the rejectActionCode property.
     * 
     * @return
     *     possible object is
     *     {@link RejectActionCodeType }
     *     
     */
    @Nullable
    public RejectActionCodeType getRejectActionCode() {
        return rejectActionCode;
    }

    /**
     * Sets the value of the rejectActionCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link RejectActionCodeType }
     *     
     */
    public void setRejectActionCode(
        @Nullable
        RejectActionCodeType value) {
        this.rejectActionCode = value;
    }

    /**
     * Gets the value of the quantityDiscrepancyCode property.
     * 
     * @return
     *     possible object is
     *     {@link QuantityDiscrepancyCodeType }
     *     
     */
    @Nullable
    public QuantityDiscrepancyCodeType getQuantityDiscrepancyCode() {
        return quantityDiscrepancyCode;
    }

    /**
     * Sets the value of the quantityDiscrepancyCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link QuantityDiscrepancyCodeType }
     *     
     */
    public void setQuantityDiscrepancyCode(
        @Nullable
        QuantityDiscrepancyCodeType value) {
        this.quantityDiscrepancyCode = value;
    }

    /**
     * Gets the value of the oversupplyQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link OversupplyQuantityType }
     *     
     */
    @Nullable
    public OversupplyQuantityType getOversupplyQuantity() {
        return oversupplyQuantity;
    }

    /**
     * Sets the value of the oversupplyQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link OversupplyQuantityType }
     *     
     */
    public void setOversupplyQuantity(
        @Nullable
        OversupplyQuantityType value) {
        this.oversupplyQuantity = value;
    }

    /**
     * Gets the value of the receivedDate property.
     * 
     * @return
     *     possible object is
     *     {@link ReceivedDateType }
     *     
     */
    @Nullable
    public ReceivedDateType getReceivedDate() {
        return receivedDate;
    }

    /**
     * Sets the value of the receivedDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReceivedDateType }
     *     
     */
    public void setReceivedDate(
        @Nullable
        ReceivedDateType value) {
        this.receivedDate = value;
    }

    /**
     * Gets the value of the receivedTime property.
     * 
     * @return
     *     possible object is
     *     {@link ReceivedTimeType }
     *     
     */
    @Nullable
    public ReceivedTimeType getReceivedTime() {
        return receivedTime;
    }

    /**
     * Sets the value of the receivedTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReceivedTimeType }
     *     
     */
    public void setReceivedTime(
        @Nullable
        ReceivedTimeType value) {
        this.receivedTime = value;
    }

    /**
     * Gets the value of the timingComplaintCode property.
     * 
     * @return
     *     possible object is
     *     {@link TimingComplaintCodeType }
     *     
     */
    @Nullable
    public TimingComplaintCodeType getTimingComplaintCode() {
        return timingComplaintCode;
    }

    /**
     * Sets the value of the timingComplaintCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TimingComplaintCodeType }
     *     
     */
    public void setTimingComplaintCode(
        @Nullable
        TimingComplaintCodeType value) {
        this.timingComplaintCode = value;
    }

    /**
     * Gets the value of the timingComplaint property.
     * 
     * @return
     *     possible object is
     *     {@link TimingComplaintType }
     *     
     */
    @Nullable
    public TimingComplaintType getTimingComplaint() {
        return timingComplaint;
    }

    /**
     * Sets the value of the timingComplaint property.
     * 
     * @param value
     *     allowed object is
     *     {@link TimingComplaintType }
     *     
     */
    public void setTimingComplaint(
        @Nullable
        TimingComplaintType value) {
        this.timingComplaint = value;
    }

    /**
     * Gets the value of the orderLineReference property.
     * 
     * @return
     *     possible object is
     *     {@link OrderLineReferenceType }
     *     
     */
    @Nullable
    public OrderLineReferenceType getOrderLineReference() {
        return orderLineReference;
    }

    /**
     * Sets the value of the orderLineReference property.
     * 
     * @param value
     *     allowed object is
     *     {@link OrderLineReferenceType }
     *     
     */
    public void setOrderLineReference(
        @Nullable
        OrderLineReferenceType value) {
        this.orderLineReference = value;
    }

    /**
     * Gets the value of the despatchLineReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the despatchLineReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDespatchLineReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LineReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the despatchLineReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LineReferenceType> getDespatchLineReference() {
        if (despatchLineReference == null) {
            despatchLineReference = new ArrayList<>();
        }
        return this.despatchLineReference;
    }

    /**
     * Gets the value of the documentReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the documentReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDocumentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the documentReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentReferenceType> getDocumentReference() {
        if (documentReference == null) {
            documentReference = new ArrayList<>();
        }
        return this.documentReference;
    }

    /**
     * Gets the value of the item property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the item property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getItem().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ItemType }
     * </p>
     * 
     * 
     * @return
     *     The value of the item property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ItemType> getItem() {
        if (item == null) {
            item = new ArrayList<>();
        }
        return this.item;
    }

    /**
     * Gets the value of the shipment property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the shipment property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getShipment().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ShipmentType }
     * </p>
     * 
     * 
     * @return
     *     The value of the shipment property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ShipmentType> getShipment() {
        if (shipment == null) {
            shipment = new ArrayList<>();
        }
        return this.shipment;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ReceiptLineType rhs = ((ReceiptLineType) o);
        if (!EqualsHelper.equalsCollection(despatchLineReference, rhs.despatchLineReference)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(documentReference, rhs.documentReference)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(item, rhs.item)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(note, rhs.note)) {
            return false;
        }
        if (!EqualsHelper.equals(orderLineReference, rhs.orderLineReference)) {
            return false;
        }
        if (!EqualsHelper.equals(oversupplyQuantity, rhs.oversupplyQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(quantityDiscrepancyCode, rhs.quantityDiscrepancyCode)) {
            return false;
        }
        if (!EqualsHelper.equals(receivedDate, rhs.receivedDate)) {
            return false;
        }
        if (!EqualsHelper.equals(receivedQuantity, rhs.receivedQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(receivedTime, rhs.receivedTime)) {
            return false;
        }
        if (!EqualsHelper.equals(rejectActionCode, rhs.rejectActionCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(rejectReason, rhs.rejectReason)) {
            return false;
        }
        if (!EqualsHelper.equals(rejectReasonCode, rhs.rejectReasonCode)) {
            return false;
        }
        if (!EqualsHelper.equals(rejectedQuantity, rhs.rejectedQuantity)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(shipment, rhs.shipment)) {
            return false;
        }
        if (!EqualsHelper.equals(shortQuantity, rhs.shortQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(shortageActionCode, rhs.shortageActionCode)) {
            return false;
        }
        if (!EqualsHelper.equals(timingComplaint, rhs.timingComplaint)) {
            return false;
        }
        if (!EqualsHelper.equals(timingComplaintCode, rhs.timingComplaintCode)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equals(uuid, rhs.uuid)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(despatchLineReference).append(documentReference).append(id).append(item).append(note).append(orderLineReference).append(oversupplyQuantity).append(quantityDiscrepancyCode).append(receivedDate).append(receivedQuantity).append(receivedTime).append(rejectActionCode).append(rejectReason).append(rejectReasonCode).append(rejectedQuantity).append(shipment).append(shortQuantity).append(shortageActionCode).append(timingComplaint).append(timingComplaintCode).append(ublExtensions).append(uuid).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("despatchLineReference", despatchLineReference).append("documentReference", documentReference).append("id", id).append("item", item).append("note", note).append("orderLineReference", orderLineReference).append("oversupplyQuantity", oversupplyQuantity).append("quantityDiscrepancyCode", quantityDiscrepancyCode).append("receivedDate", receivedDate).append("receivedQuantity", receivedQuantity).append("receivedTime", receivedTime).append("rejectActionCode", rejectActionCode).append("rejectReason", rejectReason).append("rejectReasonCode", rejectReasonCode).append("rejectedQuantity", rejectedQuantity).append("shipment", shipment).append("shortQuantity", shortQuantity).append("shortageActionCode", shortageActionCode).append("timingComplaint", timingComplaint).append("timingComplaintCode", timingComplaintCode).append("ublExtensions", ublExtensions).append("uuid", uuid).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setNote(
        @Nullable
        final List<NoteType> aList) {
        note = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setRejectReason(
        @Nullable
        final List<RejectReasonType> aList) {
        rejectReason = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDespatchLineReference(
        @Nullable
        final List<LineReferenceType> aList) {
        despatchLineReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDocumentReference(
        @Nullable
        final List<DocumentReferenceType> aList) {
        documentReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setItem(
        @Nullable
        final List<ItemType> aList) {
        item = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setShipment(
        @Nullable
        final List<ShipmentType> aList) {
        shipment = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoteEntries() {
        return (!getNote().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoNoteEntries() {
        return getNote().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getNoteCount() {
        return getNote().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NoteType getNoteAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getNote().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addNote(
        @Nonnull
        final NoteType elem) {
        getNote().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasRejectReasonEntries() {
        return (!getRejectReason().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoRejectReasonEntries() {
        return getRejectReason().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getRejectReasonCount() {
        return getRejectReason().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public RejectReasonType getRejectReasonAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getRejectReason().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addRejectReason(
        @Nonnull
        final RejectReasonType elem) {
        getRejectReason().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDespatchLineReferenceEntries() {
        return (!getDespatchLineReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDespatchLineReferenceEntries() {
        return getDespatchLineReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDespatchLineReferenceCount() {
        return getDespatchLineReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LineReferenceType getDespatchLineReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDespatchLineReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDespatchLineReference(
        @Nonnull
        final LineReferenceType elem) {
        getDespatchLineReference().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDocumentReferenceEntries() {
        return (!getDocumentReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDocumentReferenceEntries() {
        return getDocumentReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDocumentReferenceCount() {
        return getDocumentReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentReferenceType getDocumentReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDocumentReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDocumentReference(
        @Nonnull
        final DocumentReferenceType elem) {
        getDocumentReference().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasItemEntries() {
        return (!getItem().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoItemEntries() {
        return getItem().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getItemCount() {
        return getItem().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ItemType getItemAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getItem().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addItem(
        @Nonnull
        final ItemType elem) {
        getItem().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasShipmentEntries() {
        return (!getShipment().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoShipmentEntries() {
        return getShipment().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getShipmentCount() {
        return getShipment().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ShipmentType getShipmentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getShipment().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addShipment(
        @Nonnull
        final ShipmentType elem) {
        getShipment().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ReceiptLineType ret) {
        if (despatchLineReference == null) {
            ret.despatchLineReference = null;
        } else {
            List<LineReferenceType> retDespatchLineReference = new ArrayList<>();
            for (LineReferenceType aItem: getDespatchLineReference()) {
                retDespatchLineReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.despatchLineReference = retDespatchLineReference;
        }
        if (documentReference == null) {
            ret.documentReference = null;
        } else {
            List<DocumentReferenceType> retDocumentReference = new ArrayList<>();
            for (DocumentReferenceType aItem: getDocumentReference()) {
                retDocumentReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.documentReference = retDocumentReference;
        }
        ret.id = ((id == null)?null:id.clone());
        if (item == null) {
            ret.item = null;
        } else {
            List<ItemType> retItem = new ArrayList<>();
            for (ItemType aItem: getItem()) {
                retItem.add(((aItem == null)?null:aItem.clone()));
            }
            ret.item = retItem;
        }
        if (note == null) {
            ret.note = null;
        } else {
            List<NoteType> retNote = new ArrayList<>();
            for (NoteType aItem: getNote()) {
                retNote.add(((aItem == null)?null:aItem.clone()));
            }
            ret.note = retNote;
        }
        ret.orderLineReference = ((orderLineReference == null)?null:orderLineReference.clone());
        ret.oversupplyQuantity = ((oversupplyQuantity == null)?null:oversupplyQuantity.clone());
        ret.quantityDiscrepancyCode = ((quantityDiscrepancyCode == null)?null:quantityDiscrepancyCode.clone());
        ret.receivedDate = ((receivedDate == null)?null:receivedDate.clone());
        ret.receivedQuantity = ((receivedQuantity == null)?null:receivedQuantity.clone());
        ret.receivedTime = ((receivedTime == null)?null:receivedTime.clone());
        ret.rejectActionCode = ((rejectActionCode == null)?null:rejectActionCode.clone());
        if (rejectReason == null) {
            ret.rejectReason = null;
        } else {
            List<RejectReasonType> retRejectReason = new ArrayList<>();
            for (RejectReasonType aItem: getRejectReason()) {
                retRejectReason.add(((aItem == null)?null:aItem.clone()));
            }
            ret.rejectReason = retRejectReason;
        }
        ret.rejectReasonCode = ((rejectReasonCode == null)?null:rejectReasonCode.clone());
        ret.rejectedQuantity = ((rejectedQuantity == null)?null:rejectedQuantity.clone());
        if (shipment == null) {
            ret.shipment = null;
        } else {
            List<ShipmentType> retShipment = new ArrayList<>();
            for (ShipmentType aItem: getShipment()) {
                retShipment.add(((aItem == null)?null:aItem.clone()));
            }
            ret.shipment = retShipment;
        }
        ret.shortQuantity = ((shortQuantity == null)?null:shortQuantity.clone());
        ret.shortageActionCode = ((shortageActionCode == null)?null:shortageActionCode.clone());
        ret.timingComplaint = ((timingComplaint == null)?null:timingComplaint.clone());
        ret.timingComplaintCode = ((timingComplaintCode == null)?null:timingComplaintCode.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        ret.uuid = ((uuid == null)?null:uuid.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ReceiptLineType clone() {
        ReceiptLineType ret = new ReceiptLineType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type UUIDType and never <code>null</code>
     */
    @Nonnull
    public UUIDType setUUID(
        @Nullable
        final String valueParam) {
        UUIDType aObj = getUUID();
        if (aObj == null) {
            aObj = new UUIDType(valueParam);
            setUUID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ReceivedQuantityType and never <code>null</code>
     */
    @Nonnull
    public ReceivedQuantityType setReceivedQuantity(
        @Nullable
        final BigDecimal valueParam) {
        ReceivedQuantityType aObj = getReceivedQuantity();
        if (aObj == null) {
            aObj = new ReceivedQuantityType(valueParam);
            setReceivedQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ShortQuantityType and never <code>null</code>
     */
    @Nonnull
    public ShortQuantityType setShortQuantity(
        @Nullable
        final BigDecimal valueParam) {
        ShortQuantityType aObj = getShortQuantity();
        if (aObj == null) {
            aObj = new ShortQuantityType(valueParam);
            setShortQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ShortageActionCodeType and never <code>null</code>
     */
    @Nonnull
    public ShortageActionCodeType setShortageActionCode(
        @Nullable
        final String valueParam) {
        ShortageActionCodeType aObj = getShortageActionCode();
        if (aObj == null) {
            aObj = new ShortageActionCodeType(valueParam);
            setShortageActionCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RejectedQuantityType and never <code>null</code>
     */
    @Nonnull
    public RejectedQuantityType setRejectedQuantity(
        @Nullable
        final BigDecimal valueParam) {
        RejectedQuantityType aObj = getRejectedQuantity();
        if (aObj == null) {
            aObj = new RejectedQuantityType(valueParam);
            setRejectedQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RejectReasonCodeType and never <code>null</code>
     */
    @Nonnull
    public RejectReasonCodeType setRejectReasonCode(
        @Nullable
        final String valueParam) {
        RejectReasonCodeType aObj = getRejectReasonCode();
        if (aObj == null) {
            aObj = new RejectReasonCodeType(valueParam);
            setRejectReasonCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RejectActionCodeType and never <code>null</code>
     */
    @Nonnull
    public RejectActionCodeType setRejectActionCode(
        @Nullable
        final String valueParam) {
        RejectActionCodeType aObj = getRejectActionCode();
        if (aObj == null) {
            aObj = new RejectActionCodeType(valueParam);
            setRejectActionCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type QuantityDiscrepancyCodeType and never <code>null</code>
     */
    @Nonnull
    public QuantityDiscrepancyCodeType setQuantityDiscrepancyCode(
        @Nullable
        final String valueParam) {
        QuantityDiscrepancyCodeType aObj = getQuantityDiscrepancyCode();
        if (aObj == null) {
            aObj = new QuantityDiscrepancyCodeType(valueParam);
            setQuantityDiscrepancyCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type OversupplyQuantityType and never <code>null</code>
     */
    @Nonnull
    public OversupplyQuantityType setOversupplyQuantity(
        @Nullable
        final BigDecimal valueParam) {
        OversupplyQuantityType aObj = getOversupplyQuantity();
        if (aObj == null) {
            aObj = new OversupplyQuantityType(valueParam);
            setOversupplyQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ReceivedDateType and never <code>null</code>
     */
    @Nonnull
    public ReceivedDateType setReceivedDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        ReceivedDateType aObj = getReceivedDate();
        if (aObj == null) {
            aObj = new ReceivedDateType(valueParam);
            setReceivedDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ReceivedDateType and never <code>null</code>
     */
    @Nonnull
    public ReceivedDateType setReceivedDate(
        @Nullable
        final LocalDate valueParam) {
        ReceivedDateType aObj = getReceivedDate();
        if (aObj == null) {
            aObj = new ReceivedDateType(valueParam);
            setReceivedDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ReceivedTimeType and never <code>null</code>
     */
    @Nonnull
    public ReceivedTimeType setReceivedTime(
        @Nullable
        final XMLOffsetTime valueParam) {
        ReceivedTimeType aObj = getReceivedTime();
        if (aObj == null) {
            aObj = new ReceivedTimeType(valueParam);
            setReceivedTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ReceivedTimeType and never <code>null</code>
     */
    @Nonnull
    public ReceivedTimeType setReceivedTime(
        @Nullable
        final LocalTime valueParam) {
        ReceivedTimeType aObj = getReceivedTime();
        if (aObj == null) {
            aObj = new ReceivedTimeType(valueParam);
            setReceivedTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TimingComplaintCodeType and never <code>null</code>
     */
    @Nonnull
    public TimingComplaintCodeType setTimingComplaintCode(
        @Nullable
        final String valueParam) {
        TimingComplaintCodeType aObj = getTimingComplaintCode();
        if (aObj == null) {
            aObj = new TimingComplaintCodeType(valueParam);
            setTimingComplaintCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TimingComplaintType and never <code>null</code>
     */
    @Nonnull
    public TimingComplaintType setTimingComplaint(
        @Nullable
        final String valueParam) {
        TimingComplaintType aObj = getTimingComplaint();
        if (aObj == null) {
            aObj = new TimingComplaintType(valueParam);
            setTimingComplaint(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained UUIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained UUIDType object or <code>null</code>
     */
    @Nullable
    public String getUUIDValue() {
        UUIDType aObj = getUUID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ReceivedQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ReceivedQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getReceivedQuantityValue() {
        ReceivedQuantityType aObj = getReceivedQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ShortQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ShortQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getShortQuantityValue() {
        ShortQuantityType aObj = getShortQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ShortageActionCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ShortageActionCodeType object or <code>null</code>
     */
    @Nullable
    public String getShortageActionCodeValue() {
        ShortageActionCodeType aObj = getShortageActionCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained RejectedQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RejectedQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getRejectedQuantityValue() {
        RejectedQuantityType aObj = getRejectedQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained RejectReasonCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RejectReasonCodeType object or <code>null</code>
     */
    @Nullable
    public String getRejectReasonCodeValue() {
        RejectReasonCodeType aObj = getRejectReasonCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained RejectActionCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RejectActionCodeType object or <code>null</code>
     */
    @Nullable
    public String getRejectActionCodeValue() {
        RejectActionCodeType aObj = getRejectActionCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained QuantityDiscrepancyCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained QuantityDiscrepancyCodeType object or <code>null</code>
     */
    @Nullable
    public String getQuantityDiscrepancyCodeValue() {
        QuantityDiscrepancyCodeType aObj = getQuantityDiscrepancyCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained OversupplyQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained OversupplyQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getOversupplyQuantityValue() {
        OversupplyQuantityType aObj = getOversupplyQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ReceivedDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ReceivedDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getReceivedDateValue() {
        ReceivedDateType aObj = getReceivedDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ReceivedDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ReceivedDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getReceivedDateValueLocal() {
        ReceivedDateType aObj = getReceivedDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained ReceivedTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ReceivedTimeType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetTime getReceivedTimeValue() {
        ReceivedTimeType aObj = getReceivedTime();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ReceivedTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ReceivedTimeType object or <code>null</code>
     */
    @Nullable
    public LocalTime getReceivedTimeValueLocal() {
        ReceivedTimeType aObj = getReceivedTime();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained TimingComplaintCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TimingComplaintCodeType object or <code>null</code>
     */
    @Nullable
    public String getTimingComplaintCodeValue() {
        TimingComplaintCodeType aObj = getTimingComplaintCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TimingComplaintType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TimingComplaintType object or <code>null</code>
     */
    @Nullable
    public String getTimingComplaintValue() {
        TimingComplaintType aObj = getTimingComplaint();
        return (aObj == null)?null:aObj.getValue();
    }

}
