
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.AverageSubsequentContractAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.EstimatedOverallContractAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.EstimatedOverallFrameworkContractsAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.MaximumAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.MinimumAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.MonetaryScopeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TaxIncludedIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TotalAmountType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for RequestedTenderTotalType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="RequestedTenderTotalType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}EstimatedOverallContractAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}EstimatedOverallFrameworkContractsAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TotalAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TaxIncludedIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MinimumAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MaximumAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MonetaryScope" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}AverageSubsequentContractAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ApplicableTaxCategory" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "RequestedTenderTotalType", propOrder = {
    "ublExtensions",
    "estimatedOverallContractAmount",
    "estimatedOverallFrameworkContractsAmount",
    "totalAmount",
    "taxIncludedIndicator",
    "minimumAmount",
    "maximumAmount",
    "monetaryScope",
    "averageSubsequentContractAmount",
    "applicableTaxCategory"
})
@CodingStyleguideUnaware
public class RequestedTenderTotalType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "EstimatedOverallContractAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private EstimatedOverallContractAmountType estimatedOverallContractAmount;
    @XmlElement(name = "EstimatedOverallFrameworkContractsAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private EstimatedOverallFrameworkContractsAmountType estimatedOverallFrameworkContractsAmount;
    @XmlElement(name = "TotalAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TotalAmountType totalAmount;
    @XmlElement(name = "TaxIncludedIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TaxIncludedIndicatorType taxIncludedIndicator;
    @XmlElement(name = "MinimumAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MinimumAmountType minimumAmount;
    @XmlElement(name = "MaximumAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MaximumAmountType maximumAmount;
    @XmlElement(name = "MonetaryScope", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<MonetaryScopeType> monetaryScope;
    @XmlElement(name = "AverageSubsequentContractAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private AverageSubsequentContractAmountType averageSubsequentContractAmount;
    @XmlElement(name = "ApplicableTaxCategory")
    private List<TaxCategoryType> applicableTaxCategory;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public RequestedTenderTotalType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the estimatedOverallContractAmount property.
     * 
     * @return
     *     possible object is
     *     {@link EstimatedOverallContractAmountType }
     *     
     */
    @Nullable
    public EstimatedOverallContractAmountType getEstimatedOverallContractAmount() {
        return estimatedOverallContractAmount;
    }

    /**
     * Sets the value of the estimatedOverallContractAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link EstimatedOverallContractAmountType }
     *     
     */
    public void setEstimatedOverallContractAmount(
        @Nullable
        EstimatedOverallContractAmountType value) {
        this.estimatedOverallContractAmount = value;
    }

    /**
     * Gets the value of the estimatedOverallFrameworkContractsAmount property.
     * 
     * @return
     *     possible object is
     *     {@link EstimatedOverallFrameworkContractsAmountType }
     *     
     */
    @Nullable
    public EstimatedOverallFrameworkContractsAmountType getEstimatedOverallFrameworkContractsAmount() {
        return estimatedOverallFrameworkContractsAmount;
    }

    /**
     * Sets the value of the estimatedOverallFrameworkContractsAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link EstimatedOverallFrameworkContractsAmountType }
     *     
     */
    public void setEstimatedOverallFrameworkContractsAmount(
        @Nullable
        EstimatedOverallFrameworkContractsAmountType value) {
        this.estimatedOverallFrameworkContractsAmount = value;
    }

    /**
     * Gets the value of the totalAmount property.
     * 
     * @return
     *     possible object is
     *     {@link TotalAmountType }
     *     
     */
    @Nullable
    public TotalAmountType getTotalAmount() {
        return totalAmount;
    }

    /**
     * Sets the value of the totalAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link TotalAmountType }
     *     
     */
    public void setTotalAmount(
        @Nullable
        TotalAmountType value) {
        this.totalAmount = value;
    }

    /**
     * Gets the value of the taxIncludedIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link TaxIncludedIndicatorType }
     *     
     */
    @Nullable
    public TaxIncludedIndicatorType getTaxIncludedIndicator() {
        return taxIncludedIndicator;
    }

    /**
     * Sets the value of the taxIncludedIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link TaxIncludedIndicatorType }
     *     
     */
    public void setTaxIncludedIndicator(
        @Nullable
        TaxIncludedIndicatorType value) {
        this.taxIncludedIndicator = value;
    }

    /**
     * Gets the value of the minimumAmount property.
     * 
     * @return
     *     possible object is
     *     {@link MinimumAmountType }
     *     
     */
    @Nullable
    public MinimumAmountType getMinimumAmount() {
        return minimumAmount;
    }

    /**
     * Sets the value of the minimumAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link MinimumAmountType }
     *     
     */
    public void setMinimumAmount(
        @Nullable
        MinimumAmountType value) {
        this.minimumAmount = value;
    }

    /**
     * Gets the value of the maximumAmount property.
     * 
     * @return
     *     possible object is
     *     {@link MaximumAmountType }
     *     
     */
    @Nullable
    public MaximumAmountType getMaximumAmount() {
        return maximumAmount;
    }

    /**
     * Sets the value of the maximumAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link MaximumAmountType }
     *     
     */
    public void setMaximumAmount(
        @Nullable
        MaximumAmountType value) {
        this.maximumAmount = value;
    }

    /**
     * Gets the value of the monetaryScope property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the monetaryScope property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getMonetaryScope().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link MonetaryScopeType }
     * </p>
     * 
     * 
     * @return
     *     The value of the monetaryScope property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<MonetaryScopeType> getMonetaryScope() {
        if (monetaryScope == null) {
            monetaryScope = new ArrayList<>();
        }
        return this.monetaryScope;
    }

    /**
     * Gets the value of the averageSubsequentContractAmount property.
     * 
     * @return
     *     possible object is
     *     {@link AverageSubsequentContractAmountType }
     *     
     */
    @Nullable
    public AverageSubsequentContractAmountType getAverageSubsequentContractAmount() {
        return averageSubsequentContractAmount;
    }

    /**
     * Sets the value of the averageSubsequentContractAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link AverageSubsequentContractAmountType }
     *     
     */
    public void setAverageSubsequentContractAmount(
        @Nullable
        AverageSubsequentContractAmountType value) {
        this.averageSubsequentContractAmount = value;
    }

    /**
     * Gets the value of the applicableTaxCategory property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the applicableTaxCategory property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getApplicableTaxCategory().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TaxCategoryType }
     * </p>
     * 
     * 
     * @return
     *     The value of the applicableTaxCategory property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TaxCategoryType> getApplicableTaxCategory() {
        if (applicableTaxCategory == null) {
            applicableTaxCategory = new ArrayList<>();
        }
        return this.applicableTaxCategory;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final RequestedTenderTotalType rhs = ((RequestedTenderTotalType) o);
        if (!EqualsHelper.equalsCollection(applicableTaxCategory, rhs.applicableTaxCategory)) {
            return false;
        }
        if (!EqualsHelper.equals(averageSubsequentContractAmount, rhs.averageSubsequentContractAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(estimatedOverallContractAmount, rhs.estimatedOverallContractAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(estimatedOverallFrameworkContractsAmount, rhs.estimatedOverallFrameworkContractsAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(maximumAmount, rhs.maximumAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(minimumAmount, rhs.minimumAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(monetaryScope, rhs.monetaryScope)) {
            return false;
        }
        if (!EqualsHelper.equals(taxIncludedIndicator, rhs.taxIncludedIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(totalAmount, rhs.totalAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(applicableTaxCategory).append(averageSubsequentContractAmount).append(estimatedOverallContractAmount).append(estimatedOverallFrameworkContractsAmount).append(maximumAmount).append(minimumAmount).append(monetaryScope).append(taxIncludedIndicator).append(totalAmount).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("applicableTaxCategory", applicableTaxCategory).append("averageSubsequentContractAmount", averageSubsequentContractAmount).append("estimatedOverallContractAmount", estimatedOverallContractAmount).append("estimatedOverallFrameworkContractsAmount", estimatedOverallFrameworkContractsAmount).append("maximumAmount", maximumAmount).append("minimumAmount", minimumAmount).append("monetaryScope", monetaryScope).append("taxIncludedIndicator", taxIncludedIndicator).append("totalAmount", totalAmount).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setMonetaryScope(
        @Nullable
        final List<MonetaryScopeType> aList) {
        monetaryScope = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setApplicableTaxCategory(
        @Nullable
        final List<TaxCategoryType> aList) {
        applicableTaxCategory = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasMonetaryScopeEntries() {
        return (!getMonetaryScope().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoMonetaryScopeEntries() {
        return getMonetaryScope().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getMonetaryScopeCount() {
        return getMonetaryScope().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public MonetaryScopeType getMonetaryScopeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getMonetaryScope().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addMonetaryScope(
        @Nonnull
        final MonetaryScopeType elem) {
        getMonetaryScope().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasApplicableTaxCategoryEntries() {
        return (!getApplicableTaxCategory().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoApplicableTaxCategoryEntries() {
        return getApplicableTaxCategory().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getApplicableTaxCategoryCount() {
        return getApplicableTaxCategory().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TaxCategoryType getApplicableTaxCategoryAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getApplicableTaxCategory().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addApplicableTaxCategory(
        @Nonnull
        final TaxCategoryType elem) {
        getApplicableTaxCategory().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        RequestedTenderTotalType ret) {
        if (applicableTaxCategory == null) {
            ret.applicableTaxCategory = null;
        } else {
            List<TaxCategoryType> retApplicableTaxCategory = new ArrayList<>();
            for (TaxCategoryType aItem: getApplicableTaxCategory()) {
                retApplicableTaxCategory.add(((aItem == null)?null:aItem.clone()));
            }
            ret.applicableTaxCategory = retApplicableTaxCategory;
        }
        ret.averageSubsequentContractAmount = ((averageSubsequentContractAmount == null)?null:averageSubsequentContractAmount.clone());
        ret.estimatedOverallContractAmount = ((estimatedOverallContractAmount == null)?null:estimatedOverallContractAmount.clone());
        ret.estimatedOverallFrameworkContractsAmount = ((estimatedOverallFrameworkContractsAmount == null)?null:estimatedOverallFrameworkContractsAmount.clone());
        ret.maximumAmount = ((maximumAmount == null)?null:maximumAmount.clone());
        ret.minimumAmount = ((minimumAmount == null)?null:minimumAmount.clone());
        if (monetaryScope == null) {
            ret.monetaryScope = null;
        } else {
            List<MonetaryScopeType> retMonetaryScope = new ArrayList<>();
            for (MonetaryScopeType aItem: getMonetaryScope()) {
                retMonetaryScope.add(((aItem == null)?null:aItem.clone()));
            }
            ret.monetaryScope = retMonetaryScope;
        }
        ret.taxIncludedIndicator = ((taxIncludedIndicator == null)?null:taxIncludedIndicator.clone());
        ret.totalAmount = ((totalAmount == null)?null:totalAmount.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public RequestedTenderTotalType clone() {
        RequestedTenderTotalType ret = new RequestedTenderTotalType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EstimatedOverallContractAmountType and never <code>null</code>
     */
    @Nonnull
    public EstimatedOverallContractAmountType setEstimatedOverallContractAmount(
        @Nullable
        final BigDecimal valueParam) {
        EstimatedOverallContractAmountType aObj = getEstimatedOverallContractAmount();
        if (aObj == null) {
            aObj = new EstimatedOverallContractAmountType(valueParam);
            setEstimatedOverallContractAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EstimatedOverallFrameworkContractsAmountType and never <code>null</code>
     */
    @Nonnull
    public EstimatedOverallFrameworkContractsAmountType setEstimatedOverallFrameworkContractsAmount(
        @Nullable
        final BigDecimal valueParam) {
        EstimatedOverallFrameworkContractsAmountType aObj = getEstimatedOverallFrameworkContractsAmount();
        if (aObj == null) {
            aObj = new EstimatedOverallFrameworkContractsAmountType(valueParam);
            setEstimatedOverallFrameworkContractsAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TotalAmountType and never <code>null</code>
     */
    @Nonnull
    public TotalAmountType setTotalAmount(
        @Nullable
        final BigDecimal valueParam) {
        TotalAmountType aObj = getTotalAmount();
        if (aObj == null) {
            aObj = new TotalAmountType(valueParam);
            setTotalAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type TaxIncludedIndicatorType and never <code>null</code>
     */
    @Nonnull
    public TaxIncludedIndicatorType setTaxIncludedIndicator(final boolean valueParam) {
        TaxIncludedIndicatorType aObj = getTaxIncludedIndicator();
        if (aObj == null) {
            aObj = new TaxIncludedIndicatorType(valueParam);
            setTaxIncludedIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MinimumAmountType and never <code>null</code>
     */
    @Nonnull
    public MinimumAmountType setMinimumAmount(
        @Nullable
        final BigDecimal valueParam) {
        MinimumAmountType aObj = getMinimumAmount();
        if (aObj == null) {
            aObj = new MinimumAmountType(valueParam);
            setMinimumAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MaximumAmountType and never <code>null</code>
     */
    @Nonnull
    public MaximumAmountType setMaximumAmount(
        @Nullable
        final BigDecimal valueParam) {
        MaximumAmountType aObj = getMaximumAmount();
        if (aObj == null) {
            aObj = new MaximumAmountType(valueParam);
            setMaximumAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AverageSubsequentContractAmountType and never <code>null</code>
     */
    @Nonnull
    public AverageSubsequentContractAmountType setAverageSubsequentContractAmount(
        @Nullable
        final BigDecimal valueParam) {
        AverageSubsequentContractAmountType aObj = getAverageSubsequentContractAmount();
        if (aObj == null) {
            aObj = new AverageSubsequentContractAmountType(valueParam);
            setAverageSubsequentContractAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained EstimatedOverallContractAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EstimatedOverallContractAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getEstimatedOverallContractAmountValue() {
        EstimatedOverallContractAmountType aObj = getEstimatedOverallContractAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained EstimatedOverallFrameworkContractsAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EstimatedOverallFrameworkContractsAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getEstimatedOverallFrameworkContractsAmountValue() {
        EstimatedOverallFrameworkContractsAmountType aObj = getEstimatedOverallFrameworkContractsAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TotalAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TotalAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getTotalAmountValue() {
        TotalAmountType aObj = getTotalAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TaxIncludedIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained TaxIncludedIndicatorType object or the passed nullValue
     */
    public boolean isTaxIncludedIndicatorValue(final boolean nullValue) {
        TaxIncludedIndicatorType aObj = getTaxIncludedIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained MinimumAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MinimumAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getMinimumAmountValue() {
        MinimumAmountType aObj = getMinimumAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MaximumAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MaximumAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getMaximumAmountValue() {
        MaximumAmountType aObj = getMaximumAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained AverageSubsequentContractAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AverageSubsequentContractAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getAverageSubsequentContractAmountValue() {
        AverageSubsequentContractAmountType aObj = getAverageSubsequentContractAmount();
        return (aObj == null)?null:aObj.getValue();
    }

}
