
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.time.LocalDate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ApplicationDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.SanitaryMeasureTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for SanitaryMeasureType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SanitaryMeasureType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}SanitaryMeasureTypeCode"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ApplicationDate" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SanitaryMeasureType", propOrder = {
    "ublExtensions",
    "sanitaryMeasureTypeCode",
    "applicationDate"
})
@CodingStyleguideUnaware
public class SanitaryMeasureType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "SanitaryMeasureTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private SanitaryMeasureTypeCodeType sanitaryMeasureTypeCode;
    @XmlElement(name = "ApplicationDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ApplicationDateType applicationDate;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public SanitaryMeasureType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the sanitaryMeasureTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link SanitaryMeasureTypeCodeType }
     *     
     */
    @Nullable
    public SanitaryMeasureTypeCodeType getSanitaryMeasureTypeCode() {
        return sanitaryMeasureTypeCode;
    }

    /**
     * Sets the value of the sanitaryMeasureTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link SanitaryMeasureTypeCodeType }
     *     
     */
    public void setSanitaryMeasureTypeCode(
        @Nullable
        SanitaryMeasureTypeCodeType value) {
        this.sanitaryMeasureTypeCode = value;
    }

    /**
     * Gets the value of the applicationDate property.
     * 
     * @return
     *     possible object is
     *     {@link ApplicationDateType }
     *     
     */
    @Nullable
    public ApplicationDateType getApplicationDate() {
        return applicationDate;
    }

    /**
     * Sets the value of the applicationDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link ApplicationDateType }
     *     
     */
    public void setApplicationDate(
        @Nullable
        ApplicationDateType value) {
        this.applicationDate = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final SanitaryMeasureType rhs = ((SanitaryMeasureType) o);
        if (!EqualsHelper.equals(applicationDate, rhs.applicationDate)) {
            return false;
        }
        if (!EqualsHelper.equals(sanitaryMeasureTypeCode, rhs.sanitaryMeasureTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(applicationDate).append(sanitaryMeasureTypeCode).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("applicationDate", applicationDate).append("sanitaryMeasureTypeCode", sanitaryMeasureTypeCode).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        SanitaryMeasureType ret) {
        ret.applicationDate = ((applicationDate == null)?null:applicationDate.clone());
        ret.sanitaryMeasureTypeCode = ((sanitaryMeasureTypeCode == null)?null:sanitaryMeasureTypeCode.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public SanitaryMeasureType clone() {
        SanitaryMeasureType ret = new SanitaryMeasureType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SanitaryMeasureTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public SanitaryMeasureTypeCodeType setSanitaryMeasureTypeCode(
        @Nullable
        final String valueParam) {
        SanitaryMeasureTypeCodeType aObj = getSanitaryMeasureTypeCode();
        if (aObj == null) {
            aObj = new SanitaryMeasureTypeCodeType(valueParam);
            setSanitaryMeasureTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ApplicationDateType and never <code>null</code>
     */
    @Nonnull
    public ApplicationDateType setApplicationDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        ApplicationDateType aObj = getApplicationDate();
        if (aObj == null) {
            aObj = new ApplicationDateType(valueParam);
            setApplicationDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ApplicationDateType and never <code>null</code>
     */
    @Nonnull
    public ApplicationDateType setApplicationDate(
        @Nullable
        final LocalDate valueParam) {
        ApplicationDateType aObj = getApplicationDate();
        if (aObj == null) {
            aObj = new ApplicationDateType(valueParam);
            setApplicationDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained SanitaryMeasureTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SanitaryMeasureTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getSanitaryMeasureTypeCodeValue() {
        SanitaryMeasureTypeCodeType aObj = getSanitaryMeasureTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ApplicationDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ApplicationDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getApplicationDateValue() {
        ApplicationDateType aObj = getApplicationDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ApplicationDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ApplicationDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getApplicationDateValueLocal() {
        ApplicationDateType aObj = getApplicationDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

}
