
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.AvailabilityTimePercentType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.FridayAvailabilityIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.MaximumDataLossDurationMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.MaximumIncidentNotificationDurationMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.MeanTimeToRecoverDurationMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.MinimumDownTimeScheduleDurationMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.MinimumResponseTimeDurationMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.MondayAvailabilityIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.SaturdayAvailabilityIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ServiceTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ServiceTypeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.SundayAvailabilityIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ThursdayAvailabilityIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TuesdayAvailabilityIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.WednesdayAvailabilityIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for ServiceLevelAgreementType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ServiceLevelAgreementType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ServiceTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ServiceType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}AvailabilityTimePercent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MondayAvailabilityIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TuesdayAvailabilityIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}WednesdayAvailabilityIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ThursdayAvailabilityIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}FridayAvailabilityIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}SaturdayAvailabilityIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}SundayAvailabilityIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MinimumResponseTimeDurationMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MinimumDownTimeScheduleDurationMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MaximumIncidentNotificationDurationMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MaximumDataLossDurationMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MeanTimeToRecoverDurationMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ServiceAvailabilityPeriod" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ServiceMaintenancePeriod" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ServiceLevelAgreementType", propOrder = {
    "ublExtensions",
    "id",
    "serviceTypeCode",
    "serviceType",
    "availabilityTimePercent",
    "mondayAvailabilityIndicator",
    "tuesdayAvailabilityIndicator",
    "wednesdayAvailabilityIndicator",
    "thursdayAvailabilityIndicator",
    "fridayAvailabilityIndicator",
    "saturdayAvailabilityIndicator",
    "sundayAvailabilityIndicator",
    "minimumResponseTimeDurationMeasure",
    "minimumDownTimeScheduleDurationMeasure",
    "maximumIncidentNotificationDurationMeasure",
    "maximumDataLossDurationMeasure",
    "meanTimeToRecoverDurationMeasure",
    "serviceAvailabilityPeriod",
    "serviceMaintenancePeriod"
})
@CodingStyleguideUnaware
public class ServiceLevelAgreementType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "ServiceTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ServiceTypeCodeType serviceTypeCode;
    @XmlElement(name = "ServiceType", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<ServiceTypeType> serviceType;
    @XmlElement(name = "AvailabilityTimePercent", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private AvailabilityTimePercentType availabilityTimePercent;
    @XmlElement(name = "MondayAvailabilityIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MondayAvailabilityIndicatorType mondayAvailabilityIndicator;
    @XmlElement(name = "TuesdayAvailabilityIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TuesdayAvailabilityIndicatorType tuesdayAvailabilityIndicator;
    @XmlElement(name = "WednesdayAvailabilityIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private WednesdayAvailabilityIndicatorType wednesdayAvailabilityIndicator;
    @XmlElement(name = "ThursdayAvailabilityIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ThursdayAvailabilityIndicatorType thursdayAvailabilityIndicator;
    @XmlElement(name = "FridayAvailabilityIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private FridayAvailabilityIndicatorType fridayAvailabilityIndicator;
    @XmlElement(name = "SaturdayAvailabilityIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private SaturdayAvailabilityIndicatorType saturdayAvailabilityIndicator;
    @XmlElement(name = "SundayAvailabilityIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private SundayAvailabilityIndicatorType sundayAvailabilityIndicator;
    @XmlElement(name = "MinimumResponseTimeDurationMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MinimumResponseTimeDurationMeasureType minimumResponseTimeDurationMeasure;
    @XmlElement(name = "MinimumDownTimeScheduleDurationMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MinimumDownTimeScheduleDurationMeasureType minimumDownTimeScheduleDurationMeasure;
    @XmlElement(name = "MaximumIncidentNotificationDurationMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MaximumIncidentNotificationDurationMeasureType maximumIncidentNotificationDurationMeasure;
    @XmlElement(name = "MaximumDataLossDurationMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MaximumDataLossDurationMeasureType maximumDataLossDurationMeasure;
    @XmlElement(name = "MeanTimeToRecoverDurationMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MeanTimeToRecoverDurationMeasureType meanTimeToRecoverDurationMeasure;
    @XmlElement(name = "ServiceAvailabilityPeriod")
    private List<PeriodType> serviceAvailabilityPeriod;
    @XmlElement(name = "ServiceMaintenancePeriod")
    private List<PeriodType> serviceMaintenancePeriod;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public ServiceLevelAgreementType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the serviceTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link ServiceTypeCodeType }
     *     
     */
    @Nullable
    public ServiceTypeCodeType getServiceTypeCode() {
        return serviceTypeCode;
    }

    /**
     * Sets the value of the serviceTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ServiceTypeCodeType }
     *     
     */
    public void setServiceTypeCode(
        @Nullable
        ServiceTypeCodeType value) {
        this.serviceTypeCode = value;
    }

    /**
     * Gets the value of the serviceType property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the serviceType property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getServiceType().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ServiceTypeType }
     * </p>
     * 
     * 
     * @return
     *     The value of the serviceType property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ServiceTypeType> getServiceType() {
        if (serviceType == null) {
            serviceType = new ArrayList<>();
        }
        return this.serviceType;
    }

    /**
     * Gets the value of the availabilityTimePercent property.
     * 
     * @return
     *     possible object is
     *     {@link AvailabilityTimePercentType }
     *     
     */
    @Nullable
    public AvailabilityTimePercentType getAvailabilityTimePercent() {
        return availabilityTimePercent;
    }

    /**
     * Sets the value of the availabilityTimePercent property.
     * 
     * @param value
     *     allowed object is
     *     {@link AvailabilityTimePercentType }
     *     
     */
    public void setAvailabilityTimePercent(
        @Nullable
        AvailabilityTimePercentType value) {
        this.availabilityTimePercent = value;
    }

    /**
     * Gets the value of the mondayAvailabilityIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link MondayAvailabilityIndicatorType }
     *     
     */
    @Nullable
    public MondayAvailabilityIndicatorType getMondayAvailabilityIndicator() {
        return mondayAvailabilityIndicator;
    }

    /**
     * Sets the value of the mondayAvailabilityIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link MondayAvailabilityIndicatorType }
     *     
     */
    public void setMondayAvailabilityIndicator(
        @Nullable
        MondayAvailabilityIndicatorType value) {
        this.mondayAvailabilityIndicator = value;
    }

    /**
     * Gets the value of the tuesdayAvailabilityIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link TuesdayAvailabilityIndicatorType }
     *     
     */
    @Nullable
    public TuesdayAvailabilityIndicatorType getTuesdayAvailabilityIndicator() {
        return tuesdayAvailabilityIndicator;
    }

    /**
     * Sets the value of the tuesdayAvailabilityIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link TuesdayAvailabilityIndicatorType }
     *     
     */
    public void setTuesdayAvailabilityIndicator(
        @Nullable
        TuesdayAvailabilityIndicatorType value) {
        this.tuesdayAvailabilityIndicator = value;
    }

    /**
     * Gets the value of the wednesdayAvailabilityIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link WednesdayAvailabilityIndicatorType }
     *     
     */
    @Nullable
    public WednesdayAvailabilityIndicatorType getWednesdayAvailabilityIndicator() {
        return wednesdayAvailabilityIndicator;
    }

    /**
     * Sets the value of the wednesdayAvailabilityIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link WednesdayAvailabilityIndicatorType }
     *     
     */
    public void setWednesdayAvailabilityIndicator(
        @Nullable
        WednesdayAvailabilityIndicatorType value) {
        this.wednesdayAvailabilityIndicator = value;
    }

    /**
     * Gets the value of the thursdayAvailabilityIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link ThursdayAvailabilityIndicatorType }
     *     
     */
    @Nullable
    public ThursdayAvailabilityIndicatorType getThursdayAvailabilityIndicator() {
        return thursdayAvailabilityIndicator;
    }

    /**
     * Sets the value of the thursdayAvailabilityIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link ThursdayAvailabilityIndicatorType }
     *     
     */
    public void setThursdayAvailabilityIndicator(
        @Nullable
        ThursdayAvailabilityIndicatorType value) {
        this.thursdayAvailabilityIndicator = value;
    }

    /**
     * Gets the value of the fridayAvailabilityIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link FridayAvailabilityIndicatorType }
     *     
     */
    @Nullable
    public FridayAvailabilityIndicatorType getFridayAvailabilityIndicator() {
        return fridayAvailabilityIndicator;
    }

    /**
     * Sets the value of the fridayAvailabilityIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link FridayAvailabilityIndicatorType }
     *     
     */
    public void setFridayAvailabilityIndicator(
        @Nullable
        FridayAvailabilityIndicatorType value) {
        this.fridayAvailabilityIndicator = value;
    }

    /**
     * Gets the value of the saturdayAvailabilityIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link SaturdayAvailabilityIndicatorType }
     *     
     */
    @Nullable
    public SaturdayAvailabilityIndicatorType getSaturdayAvailabilityIndicator() {
        return saturdayAvailabilityIndicator;
    }

    /**
     * Sets the value of the saturdayAvailabilityIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link SaturdayAvailabilityIndicatorType }
     *     
     */
    public void setSaturdayAvailabilityIndicator(
        @Nullable
        SaturdayAvailabilityIndicatorType value) {
        this.saturdayAvailabilityIndicator = value;
    }

    /**
     * Gets the value of the sundayAvailabilityIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link SundayAvailabilityIndicatorType }
     *     
     */
    @Nullable
    public SundayAvailabilityIndicatorType getSundayAvailabilityIndicator() {
        return sundayAvailabilityIndicator;
    }

    /**
     * Sets the value of the sundayAvailabilityIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link SundayAvailabilityIndicatorType }
     *     
     */
    public void setSundayAvailabilityIndicator(
        @Nullable
        SundayAvailabilityIndicatorType value) {
        this.sundayAvailabilityIndicator = value;
    }

    /**
     * Gets the value of the minimumResponseTimeDurationMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link MinimumResponseTimeDurationMeasureType }
     *     
     */
    @Nullable
    public MinimumResponseTimeDurationMeasureType getMinimumResponseTimeDurationMeasure() {
        return minimumResponseTimeDurationMeasure;
    }

    /**
     * Sets the value of the minimumResponseTimeDurationMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link MinimumResponseTimeDurationMeasureType }
     *     
     */
    public void setMinimumResponseTimeDurationMeasure(
        @Nullable
        MinimumResponseTimeDurationMeasureType value) {
        this.minimumResponseTimeDurationMeasure = value;
    }

    /**
     * Gets the value of the minimumDownTimeScheduleDurationMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link MinimumDownTimeScheduleDurationMeasureType }
     *     
     */
    @Nullable
    public MinimumDownTimeScheduleDurationMeasureType getMinimumDownTimeScheduleDurationMeasure() {
        return minimumDownTimeScheduleDurationMeasure;
    }

    /**
     * Sets the value of the minimumDownTimeScheduleDurationMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link MinimumDownTimeScheduleDurationMeasureType }
     *     
     */
    public void setMinimumDownTimeScheduleDurationMeasure(
        @Nullable
        MinimumDownTimeScheduleDurationMeasureType value) {
        this.minimumDownTimeScheduleDurationMeasure = value;
    }

    /**
     * Gets the value of the maximumIncidentNotificationDurationMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link MaximumIncidentNotificationDurationMeasureType }
     *     
     */
    @Nullable
    public MaximumIncidentNotificationDurationMeasureType getMaximumIncidentNotificationDurationMeasure() {
        return maximumIncidentNotificationDurationMeasure;
    }

    /**
     * Sets the value of the maximumIncidentNotificationDurationMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link MaximumIncidentNotificationDurationMeasureType }
     *     
     */
    public void setMaximumIncidentNotificationDurationMeasure(
        @Nullable
        MaximumIncidentNotificationDurationMeasureType value) {
        this.maximumIncidentNotificationDurationMeasure = value;
    }

    /**
     * Gets the value of the maximumDataLossDurationMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link MaximumDataLossDurationMeasureType }
     *     
     */
    @Nullable
    public MaximumDataLossDurationMeasureType getMaximumDataLossDurationMeasure() {
        return maximumDataLossDurationMeasure;
    }

    /**
     * Sets the value of the maximumDataLossDurationMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link MaximumDataLossDurationMeasureType }
     *     
     */
    public void setMaximumDataLossDurationMeasure(
        @Nullable
        MaximumDataLossDurationMeasureType value) {
        this.maximumDataLossDurationMeasure = value;
    }

    /**
     * Gets the value of the meanTimeToRecoverDurationMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link MeanTimeToRecoverDurationMeasureType }
     *     
     */
    @Nullable
    public MeanTimeToRecoverDurationMeasureType getMeanTimeToRecoverDurationMeasure() {
        return meanTimeToRecoverDurationMeasure;
    }

    /**
     * Sets the value of the meanTimeToRecoverDurationMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link MeanTimeToRecoverDurationMeasureType }
     *     
     */
    public void setMeanTimeToRecoverDurationMeasure(
        @Nullable
        MeanTimeToRecoverDurationMeasureType value) {
        this.meanTimeToRecoverDurationMeasure = value;
    }

    /**
     * Gets the value of the serviceAvailabilityPeriod property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the serviceAvailabilityPeriod property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getServiceAvailabilityPeriod().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PeriodType }
     * </p>
     * 
     * 
     * @return
     *     The value of the serviceAvailabilityPeriod property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PeriodType> getServiceAvailabilityPeriod() {
        if (serviceAvailabilityPeriod == null) {
            serviceAvailabilityPeriod = new ArrayList<>();
        }
        return this.serviceAvailabilityPeriod;
    }

    /**
     * Gets the value of the serviceMaintenancePeriod property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the serviceMaintenancePeriod property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getServiceMaintenancePeriod().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PeriodType }
     * </p>
     * 
     * 
     * @return
     *     The value of the serviceMaintenancePeriod property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PeriodType> getServiceMaintenancePeriod() {
        if (serviceMaintenancePeriod == null) {
            serviceMaintenancePeriod = new ArrayList<>();
        }
        return this.serviceMaintenancePeriod;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ServiceLevelAgreementType rhs = ((ServiceLevelAgreementType) o);
        if (!EqualsHelper.equals(availabilityTimePercent, rhs.availabilityTimePercent)) {
            return false;
        }
        if (!EqualsHelper.equals(fridayAvailabilityIndicator, rhs.fridayAvailabilityIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(maximumDataLossDurationMeasure, rhs.maximumDataLossDurationMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(maximumIncidentNotificationDurationMeasure, rhs.maximumIncidentNotificationDurationMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(meanTimeToRecoverDurationMeasure, rhs.meanTimeToRecoverDurationMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(minimumDownTimeScheduleDurationMeasure, rhs.minimumDownTimeScheduleDurationMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(minimumResponseTimeDurationMeasure, rhs.minimumResponseTimeDurationMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(mondayAvailabilityIndicator, rhs.mondayAvailabilityIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(saturdayAvailabilityIndicator, rhs.saturdayAvailabilityIndicator)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(serviceAvailabilityPeriod, rhs.serviceAvailabilityPeriod)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(serviceMaintenancePeriod, rhs.serviceMaintenancePeriod)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(serviceType, rhs.serviceType)) {
            return false;
        }
        if (!EqualsHelper.equals(serviceTypeCode, rhs.serviceTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(sundayAvailabilityIndicator, rhs.sundayAvailabilityIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(thursdayAvailabilityIndicator, rhs.thursdayAvailabilityIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(tuesdayAvailabilityIndicator, rhs.tuesdayAvailabilityIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equals(wednesdayAvailabilityIndicator, rhs.wednesdayAvailabilityIndicator)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(availabilityTimePercent).append(fridayAvailabilityIndicator).append(id).append(maximumDataLossDurationMeasure).append(maximumIncidentNotificationDurationMeasure).append(meanTimeToRecoverDurationMeasure).append(minimumDownTimeScheduleDurationMeasure).append(minimumResponseTimeDurationMeasure).append(mondayAvailabilityIndicator).append(saturdayAvailabilityIndicator).append(serviceAvailabilityPeriod).append(serviceMaintenancePeriod).append(serviceType).append(serviceTypeCode).append(sundayAvailabilityIndicator).append(thursdayAvailabilityIndicator).append(tuesdayAvailabilityIndicator).append(ublExtensions).append(wednesdayAvailabilityIndicator).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("availabilityTimePercent", availabilityTimePercent).append("fridayAvailabilityIndicator", fridayAvailabilityIndicator).append("id", id).append("maximumDataLossDurationMeasure", maximumDataLossDurationMeasure).append("maximumIncidentNotificationDurationMeasure", maximumIncidentNotificationDurationMeasure).append("meanTimeToRecoverDurationMeasure", meanTimeToRecoverDurationMeasure).append("minimumDownTimeScheduleDurationMeasure", minimumDownTimeScheduleDurationMeasure).append("minimumResponseTimeDurationMeasure", minimumResponseTimeDurationMeasure).append("mondayAvailabilityIndicator", mondayAvailabilityIndicator).append("saturdayAvailabilityIndicator", saturdayAvailabilityIndicator).append("serviceAvailabilityPeriod", serviceAvailabilityPeriod).append("serviceMaintenancePeriod", serviceMaintenancePeriod).append("serviceType", serviceType).append("serviceTypeCode", serviceTypeCode).append("sundayAvailabilityIndicator", sundayAvailabilityIndicator).append("thursdayAvailabilityIndicator", thursdayAvailabilityIndicator).append("tuesdayAvailabilityIndicator", tuesdayAvailabilityIndicator).append("ublExtensions", ublExtensions).append("wednesdayAvailabilityIndicator", wednesdayAvailabilityIndicator).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setServiceType(
        @Nullable
        final List<ServiceTypeType> aList) {
        serviceType = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setServiceAvailabilityPeriod(
        @Nullable
        final List<PeriodType> aList) {
        serviceAvailabilityPeriod = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setServiceMaintenancePeriod(
        @Nullable
        final List<PeriodType> aList) {
        serviceMaintenancePeriod = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasServiceTypeEntries() {
        return (!getServiceType().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoServiceTypeEntries() {
        return getServiceType().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getServiceTypeCount() {
        return getServiceType().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ServiceTypeType getServiceTypeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getServiceType().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addServiceType(
        @Nonnull
        final ServiceTypeType elem) {
        getServiceType().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasServiceAvailabilityPeriodEntries() {
        return (!getServiceAvailabilityPeriod().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoServiceAvailabilityPeriodEntries() {
        return getServiceAvailabilityPeriod().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getServiceAvailabilityPeriodCount() {
        return getServiceAvailabilityPeriod().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PeriodType getServiceAvailabilityPeriodAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getServiceAvailabilityPeriod().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addServiceAvailabilityPeriod(
        @Nonnull
        final PeriodType elem) {
        getServiceAvailabilityPeriod().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasServiceMaintenancePeriodEntries() {
        return (!getServiceMaintenancePeriod().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoServiceMaintenancePeriodEntries() {
        return getServiceMaintenancePeriod().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getServiceMaintenancePeriodCount() {
        return getServiceMaintenancePeriod().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PeriodType getServiceMaintenancePeriodAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getServiceMaintenancePeriod().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addServiceMaintenancePeriod(
        @Nonnull
        final PeriodType elem) {
        getServiceMaintenancePeriod().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ServiceLevelAgreementType ret) {
        ret.availabilityTimePercent = ((availabilityTimePercent == null)?null:availabilityTimePercent.clone());
        ret.fridayAvailabilityIndicator = ((fridayAvailabilityIndicator == null)?null:fridayAvailabilityIndicator.clone());
        ret.id = ((id == null)?null:id.clone());
        ret.maximumDataLossDurationMeasure = ((maximumDataLossDurationMeasure == null)?null:maximumDataLossDurationMeasure.clone());
        ret.maximumIncidentNotificationDurationMeasure = ((maximumIncidentNotificationDurationMeasure == null)?null:maximumIncidentNotificationDurationMeasure.clone());
        ret.meanTimeToRecoverDurationMeasure = ((meanTimeToRecoverDurationMeasure == null)?null:meanTimeToRecoverDurationMeasure.clone());
        ret.minimumDownTimeScheduleDurationMeasure = ((minimumDownTimeScheduleDurationMeasure == null)?null:minimumDownTimeScheduleDurationMeasure.clone());
        ret.minimumResponseTimeDurationMeasure = ((minimumResponseTimeDurationMeasure == null)?null:minimumResponseTimeDurationMeasure.clone());
        ret.mondayAvailabilityIndicator = ((mondayAvailabilityIndicator == null)?null:mondayAvailabilityIndicator.clone());
        ret.saturdayAvailabilityIndicator = ((saturdayAvailabilityIndicator == null)?null:saturdayAvailabilityIndicator.clone());
        if (serviceAvailabilityPeriod == null) {
            ret.serviceAvailabilityPeriod = null;
        } else {
            List<PeriodType> retServiceAvailabilityPeriod = new ArrayList<>();
            for (PeriodType aItem: getServiceAvailabilityPeriod()) {
                retServiceAvailabilityPeriod.add(((aItem == null)?null:aItem.clone()));
            }
            ret.serviceAvailabilityPeriod = retServiceAvailabilityPeriod;
        }
        if (serviceMaintenancePeriod == null) {
            ret.serviceMaintenancePeriod = null;
        } else {
            List<PeriodType> retServiceMaintenancePeriod = new ArrayList<>();
            for (PeriodType aItem: getServiceMaintenancePeriod()) {
                retServiceMaintenancePeriod.add(((aItem == null)?null:aItem.clone()));
            }
            ret.serviceMaintenancePeriod = retServiceMaintenancePeriod;
        }
        if (serviceType == null) {
            ret.serviceType = null;
        } else {
            List<ServiceTypeType> retServiceType = new ArrayList<>();
            for (ServiceTypeType aItem: getServiceType()) {
                retServiceType.add(((aItem == null)?null:aItem.clone()));
            }
            ret.serviceType = retServiceType;
        }
        ret.serviceTypeCode = ((serviceTypeCode == null)?null:serviceTypeCode.clone());
        ret.sundayAvailabilityIndicator = ((sundayAvailabilityIndicator == null)?null:sundayAvailabilityIndicator.clone());
        ret.thursdayAvailabilityIndicator = ((thursdayAvailabilityIndicator == null)?null:thursdayAvailabilityIndicator.clone());
        ret.tuesdayAvailabilityIndicator = ((tuesdayAvailabilityIndicator == null)?null:tuesdayAvailabilityIndicator.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        ret.wednesdayAvailabilityIndicator = ((wednesdayAvailabilityIndicator == null)?null:wednesdayAvailabilityIndicator.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ServiceLevelAgreementType clone() {
        ServiceLevelAgreementType ret = new ServiceLevelAgreementType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ServiceTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public ServiceTypeCodeType setServiceTypeCode(
        @Nullable
        final String valueParam) {
        ServiceTypeCodeType aObj = getServiceTypeCode();
        if (aObj == null) {
            aObj = new ServiceTypeCodeType(valueParam);
            setServiceTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AvailabilityTimePercentType and never <code>null</code>
     */
    @Nonnull
    public AvailabilityTimePercentType setAvailabilityTimePercent(
        @Nullable
        final BigDecimal valueParam) {
        AvailabilityTimePercentType aObj = getAvailabilityTimePercent();
        if (aObj == null) {
            aObj = new AvailabilityTimePercentType(valueParam);
            setAvailabilityTimePercent(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type MondayAvailabilityIndicatorType and never <code>null</code>
     */
    @Nonnull
    public MondayAvailabilityIndicatorType setMondayAvailabilityIndicator(final boolean valueParam) {
        MondayAvailabilityIndicatorType aObj = getMondayAvailabilityIndicator();
        if (aObj == null) {
            aObj = new MondayAvailabilityIndicatorType(valueParam);
            setMondayAvailabilityIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type TuesdayAvailabilityIndicatorType and never <code>null</code>
     */
    @Nonnull
    public TuesdayAvailabilityIndicatorType setTuesdayAvailabilityIndicator(final boolean valueParam) {
        TuesdayAvailabilityIndicatorType aObj = getTuesdayAvailabilityIndicator();
        if (aObj == null) {
            aObj = new TuesdayAvailabilityIndicatorType(valueParam);
            setTuesdayAvailabilityIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type WednesdayAvailabilityIndicatorType and never <code>null</code>
     */
    @Nonnull
    public WednesdayAvailabilityIndicatorType setWednesdayAvailabilityIndicator(final boolean valueParam) {
        WednesdayAvailabilityIndicatorType aObj = getWednesdayAvailabilityIndicator();
        if (aObj == null) {
            aObj = new WednesdayAvailabilityIndicatorType(valueParam);
            setWednesdayAvailabilityIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type ThursdayAvailabilityIndicatorType and never <code>null</code>
     */
    @Nonnull
    public ThursdayAvailabilityIndicatorType setThursdayAvailabilityIndicator(final boolean valueParam) {
        ThursdayAvailabilityIndicatorType aObj = getThursdayAvailabilityIndicator();
        if (aObj == null) {
            aObj = new ThursdayAvailabilityIndicatorType(valueParam);
            setThursdayAvailabilityIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type FridayAvailabilityIndicatorType and never <code>null</code>
     */
    @Nonnull
    public FridayAvailabilityIndicatorType setFridayAvailabilityIndicator(final boolean valueParam) {
        FridayAvailabilityIndicatorType aObj = getFridayAvailabilityIndicator();
        if (aObj == null) {
            aObj = new FridayAvailabilityIndicatorType(valueParam);
            setFridayAvailabilityIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type SaturdayAvailabilityIndicatorType and never <code>null</code>
     */
    @Nonnull
    public SaturdayAvailabilityIndicatorType setSaturdayAvailabilityIndicator(final boolean valueParam) {
        SaturdayAvailabilityIndicatorType aObj = getSaturdayAvailabilityIndicator();
        if (aObj == null) {
            aObj = new SaturdayAvailabilityIndicatorType(valueParam);
            setSaturdayAvailabilityIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type SundayAvailabilityIndicatorType and never <code>null</code>
     */
    @Nonnull
    public SundayAvailabilityIndicatorType setSundayAvailabilityIndicator(final boolean valueParam) {
        SundayAvailabilityIndicatorType aObj = getSundayAvailabilityIndicator();
        if (aObj == null) {
            aObj = new SundayAvailabilityIndicatorType(valueParam);
            setSundayAvailabilityIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MinimumResponseTimeDurationMeasureType and never <code>null</code>
     */
    @Nonnull
    public MinimumResponseTimeDurationMeasureType setMinimumResponseTimeDurationMeasure(
        @Nullable
        final BigDecimal valueParam) {
        MinimumResponseTimeDurationMeasureType aObj = getMinimumResponseTimeDurationMeasure();
        if (aObj == null) {
            aObj = new MinimumResponseTimeDurationMeasureType(valueParam);
            setMinimumResponseTimeDurationMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MinimumDownTimeScheduleDurationMeasureType and never <code>null</code>
     */
    @Nonnull
    public MinimumDownTimeScheduleDurationMeasureType setMinimumDownTimeScheduleDurationMeasure(
        @Nullable
        final BigDecimal valueParam) {
        MinimumDownTimeScheduleDurationMeasureType aObj = getMinimumDownTimeScheduleDurationMeasure();
        if (aObj == null) {
            aObj = new MinimumDownTimeScheduleDurationMeasureType(valueParam);
            setMinimumDownTimeScheduleDurationMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MaximumIncidentNotificationDurationMeasureType and never <code>null</code>
     */
    @Nonnull
    public MaximumIncidentNotificationDurationMeasureType setMaximumIncidentNotificationDurationMeasure(
        @Nullable
        final BigDecimal valueParam) {
        MaximumIncidentNotificationDurationMeasureType aObj = getMaximumIncidentNotificationDurationMeasure();
        if (aObj == null) {
            aObj = new MaximumIncidentNotificationDurationMeasureType(valueParam);
            setMaximumIncidentNotificationDurationMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MaximumDataLossDurationMeasureType and never <code>null</code>
     */
    @Nonnull
    public MaximumDataLossDurationMeasureType setMaximumDataLossDurationMeasure(
        @Nullable
        final BigDecimal valueParam) {
        MaximumDataLossDurationMeasureType aObj = getMaximumDataLossDurationMeasure();
        if (aObj == null) {
            aObj = new MaximumDataLossDurationMeasureType(valueParam);
            setMaximumDataLossDurationMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MeanTimeToRecoverDurationMeasureType and never <code>null</code>
     */
    @Nonnull
    public MeanTimeToRecoverDurationMeasureType setMeanTimeToRecoverDurationMeasure(
        @Nullable
        final BigDecimal valueParam) {
        MeanTimeToRecoverDurationMeasureType aObj = getMeanTimeToRecoverDurationMeasure();
        if (aObj == null) {
            aObj = new MeanTimeToRecoverDurationMeasureType(valueParam);
            setMeanTimeToRecoverDurationMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ServiceTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ServiceTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getServiceTypeCodeValue() {
        ServiceTypeCodeType aObj = getServiceTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained AvailabilityTimePercentType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AvailabilityTimePercentType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getAvailabilityTimePercentValue() {
        AvailabilityTimePercentType aObj = getAvailabilityTimePercent();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MondayAvailabilityIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained MondayAvailabilityIndicatorType object or the passed nullValue
     */
    public boolean isMondayAvailabilityIndicatorValue(final boolean nullValue) {
        MondayAvailabilityIndicatorType aObj = getMondayAvailabilityIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained TuesdayAvailabilityIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained TuesdayAvailabilityIndicatorType object or the passed nullValue
     */
    public boolean isTuesdayAvailabilityIndicatorValue(final boolean nullValue) {
        TuesdayAvailabilityIndicatorType aObj = getTuesdayAvailabilityIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained WednesdayAvailabilityIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained WednesdayAvailabilityIndicatorType object or the passed nullValue
     */
    public boolean isWednesdayAvailabilityIndicatorValue(final boolean nullValue) {
        WednesdayAvailabilityIndicatorType aObj = getWednesdayAvailabilityIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained ThursdayAvailabilityIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained ThursdayAvailabilityIndicatorType object or the passed nullValue
     */
    public boolean isThursdayAvailabilityIndicatorValue(final boolean nullValue) {
        ThursdayAvailabilityIndicatorType aObj = getThursdayAvailabilityIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained FridayAvailabilityIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained FridayAvailabilityIndicatorType object or the passed nullValue
     */
    public boolean isFridayAvailabilityIndicatorValue(final boolean nullValue) {
        FridayAvailabilityIndicatorType aObj = getFridayAvailabilityIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained SaturdayAvailabilityIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained SaturdayAvailabilityIndicatorType object or the passed nullValue
     */
    public boolean isSaturdayAvailabilityIndicatorValue(final boolean nullValue) {
        SaturdayAvailabilityIndicatorType aObj = getSaturdayAvailabilityIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained SundayAvailabilityIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained SundayAvailabilityIndicatorType object or the passed nullValue
     */
    public boolean isSundayAvailabilityIndicatorValue(final boolean nullValue) {
        SundayAvailabilityIndicatorType aObj = getSundayAvailabilityIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained MinimumResponseTimeDurationMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MinimumResponseTimeDurationMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getMinimumResponseTimeDurationMeasureValue() {
        MinimumResponseTimeDurationMeasureType aObj = getMinimumResponseTimeDurationMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MinimumDownTimeScheduleDurationMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MinimumDownTimeScheduleDurationMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getMinimumDownTimeScheduleDurationMeasureValue() {
        MinimumDownTimeScheduleDurationMeasureType aObj = getMinimumDownTimeScheduleDurationMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MaximumIncidentNotificationDurationMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MaximumIncidentNotificationDurationMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getMaximumIncidentNotificationDurationMeasureValue() {
        MaximumIncidentNotificationDurationMeasureType aObj = getMaximumIncidentNotificationDurationMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MaximumDataLossDurationMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MaximumDataLossDurationMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getMaximumDataLossDurationMeasureValue() {
        MaximumDataLossDurationMeasureType aObj = getMaximumDataLossDurationMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MeanTimeToRecoverDurationMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MeanTimeToRecoverDurationMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getMeanTimeToRecoverDurationMeasureValue() {
        MeanTimeToRecoverDurationMeasureType aObj = getMeanTimeToRecoverDurationMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

}
