
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.datetime.XMLOffsetTime;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.CabotageIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.CrewQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.DemurrageInstructionsType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.EstimatedDeliveryDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.EstimatedDeliveryTimeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.HazardousRiskIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.InstructionsType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.LoadingSequenceIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.OnCarriageIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PassengerQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PreCarriageIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.RequiredDeliveryDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.RequiredDeliveryTimeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ShipmentStageTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ShipmentStageTypeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.SuccessiveSequenceIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TransitDirectionCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TransportMeansTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TransportModeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for ShipmentStageType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="ShipmentStageType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ShipmentStageTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ShipmentStageType" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TransportModeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TransportMeansTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TransitDirectionCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PreCarriageIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}OnCarriageIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CabotageIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}HazardousRiskIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}EstimatedDeliveryDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}EstimatedDeliveryTime" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RequiredDeliveryDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RequiredDeliveryTime" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}LoadingSequenceID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}SuccessiveSequenceID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Instructions" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}DemurrageInstructions" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CrewQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PassengerQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TransitPeriod" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}CarrierParty" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TransportMeans" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}LoadingPortLocation" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}UnloadingPortLocation" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TransshipPortLocation" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}LoadingTransportEvent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ExaminationTransportEvent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AvailabilityTransportEvent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ExportationTransportEvent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}DischargeTransportEvent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}WarehousingTransportEvent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TakeoverTransportEvent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}OptionalTakeoverTransportEvent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}DropoffTransportEvent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ActualPickupTransportEvent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}DeliveryTransportEvent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ReceiptTransportEvent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}StorageTransportEvent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AcceptanceTransportEvent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TerminalOperatorParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}CustomsAgentParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}EstimatedTransitPeriod" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}FreightAllowanceCharge" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}FreightChargeLocation" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}DetentionTransportEvent" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}RequestedDepartureTransportEvent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}RequestedArrivalTransportEvent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}RequestedWaypointTransportEvent" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PlannedDepartureTransportEvent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PlannedArrivalTransportEvent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PlannedWaypointTransportEvent" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ActualDepartureTransportEvent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ActualWaypointTransportEvent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ActualArrivalTransportEvent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TransportEvent" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}EstimatedDepartureTransportEvent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}EstimatedArrivalTransportEvent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PassengerPerson" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}DriverPerson" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ReportingPerson" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}CrewMemberPerson" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}SecurityOfficerPerson" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}MasterPerson" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ShipsSurgeonPerson" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}DestinationPortCall" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ShipStoreArticle" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}CrewPersonEffect" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}MaritimeWaste" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}BallastWaterSummary" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ISPSRequirements" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}MaritimeHealthDeclaration" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}FuelConsumption" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ShipmentStageType", propOrder = {
    "ublExtensions",
    "id",
    "shipmentStageTypeCode",
    "shipmentStageType",
    "transportModeCode",
    "transportMeansTypeCode",
    "transitDirectionCode",
    "preCarriageIndicator",
    "onCarriageIndicator",
    "cabotageIndicator",
    "hazardousRiskIndicator",
    "estimatedDeliveryDate",
    "estimatedDeliveryTime",
    "requiredDeliveryDate",
    "requiredDeliveryTime",
    "loadingSequenceID",
    "successiveSequenceID",
    "instructions",
    "demurrageInstructions",
    "crewQuantity",
    "passengerQuantity",
    "transitPeriod",
    "carrierParty",
    "transportMeans",
    "loadingPortLocation",
    "unloadingPortLocation",
    "transshipPortLocation",
    "loadingTransportEvent",
    "examinationTransportEvent",
    "availabilityTransportEvent",
    "exportationTransportEvent",
    "dischargeTransportEvent",
    "warehousingTransportEvent",
    "takeoverTransportEvent",
    "optionalTakeoverTransportEvent",
    "dropoffTransportEvent",
    "actualPickupTransportEvent",
    "deliveryTransportEvent",
    "receiptTransportEvent",
    "storageTransportEvent",
    "acceptanceTransportEvent",
    "terminalOperatorParty",
    "customsAgentParty",
    "estimatedTransitPeriod",
    "freightAllowanceCharge",
    "freightChargeLocation",
    "detentionTransportEvent",
    "requestedDepartureTransportEvent",
    "requestedArrivalTransportEvent",
    "requestedWaypointTransportEvent",
    "plannedDepartureTransportEvent",
    "plannedArrivalTransportEvent",
    "plannedWaypointTransportEvent",
    "actualDepartureTransportEvent",
    "actualWaypointTransportEvent",
    "actualArrivalTransportEvent",
    "transportEvent",
    "estimatedDepartureTransportEvent",
    "estimatedArrivalTransportEvent",
    "passengerPerson",
    "driverPerson",
    "reportingPerson",
    "crewMemberPerson",
    "securityOfficerPerson",
    "masterPerson",
    "shipsSurgeonPerson",
    "destinationPortCall",
    "shipStoreArticle",
    "crewPersonEffect",
    "maritimeWaste",
    "ballastWaterSummary",
    "ispsRequirements",
    "maritimeHealthDeclaration",
    "fuelConsumption"
})
@CodingStyleguideUnaware
public class ShipmentStageType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "ShipmentStageTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ShipmentStageTypeCodeType shipmentStageTypeCode;
    @XmlElement(name = "ShipmentStageType", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<ShipmentStageTypeType> shipmentStageType;
    @XmlElement(name = "TransportModeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TransportModeCodeType transportModeCode;
    @XmlElement(name = "TransportMeansTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TransportMeansTypeCodeType transportMeansTypeCode;
    @XmlElement(name = "TransitDirectionCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TransitDirectionCodeType transitDirectionCode;
    @XmlElement(name = "PreCarriageIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PreCarriageIndicatorType preCarriageIndicator;
    @XmlElement(name = "OnCarriageIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private OnCarriageIndicatorType onCarriageIndicator;
    @XmlElement(name = "CabotageIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CabotageIndicatorType cabotageIndicator;
    @XmlElement(name = "HazardousRiskIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private HazardousRiskIndicatorType hazardousRiskIndicator;
    @XmlElement(name = "EstimatedDeliveryDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private EstimatedDeliveryDateType estimatedDeliveryDate;
    @XmlElement(name = "EstimatedDeliveryTime", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private EstimatedDeliveryTimeType estimatedDeliveryTime;
    @XmlElement(name = "RequiredDeliveryDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private RequiredDeliveryDateType requiredDeliveryDate;
    @XmlElement(name = "RequiredDeliveryTime", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private RequiredDeliveryTimeType requiredDeliveryTime;
    @XmlElement(name = "LoadingSequenceID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private LoadingSequenceIDType loadingSequenceID;
    @XmlElement(name = "SuccessiveSequenceID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private SuccessiveSequenceIDType successiveSequenceID;
    @XmlElement(name = "Instructions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<InstructionsType> instructions;
    @XmlElement(name = "DemurrageInstructions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<DemurrageInstructionsType> demurrageInstructions;
    @XmlElement(name = "CrewQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CrewQuantityType crewQuantity;
    @XmlElement(name = "PassengerQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PassengerQuantityType passengerQuantity;
    @XmlElement(name = "TransitPeriod")
    private PeriodType transitPeriod;
    @XmlElement(name = "CarrierParty")
    private List<PartyType> carrierParty;
    @XmlElement(name = "TransportMeans")
    private TransportMeansType transportMeans;
    @XmlElement(name = "LoadingPortLocation")
    private LocationType loadingPortLocation;
    @XmlElement(name = "UnloadingPortLocation")
    private LocationType unloadingPortLocation;
    @XmlElement(name = "TransshipPortLocation")
    private LocationType transshipPortLocation;
    @XmlElement(name = "LoadingTransportEvent")
    private TransportEventType loadingTransportEvent;
    @XmlElement(name = "ExaminationTransportEvent")
    private TransportEventType examinationTransportEvent;
    @XmlElement(name = "AvailabilityTransportEvent")
    private TransportEventType availabilityTransportEvent;
    @XmlElement(name = "ExportationTransportEvent")
    private TransportEventType exportationTransportEvent;
    @XmlElement(name = "DischargeTransportEvent")
    private TransportEventType dischargeTransportEvent;
    @XmlElement(name = "WarehousingTransportEvent")
    private TransportEventType warehousingTransportEvent;
    @XmlElement(name = "TakeoverTransportEvent")
    private TransportEventType takeoverTransportEvent;
    @XmlElement(name = "OptionalTakeoverTransportEvent")
    private TransportEventType optionalTakeoverTransportEvent;
    @XmlElement(name = "DropoffTransportEvent")
    private TransportEventType dropoffTransportEvent;
    @XmlElement(name = "ActualPickupTransportEvent")
    private TransportEventType actualPickupTransportEvent;
    @XmlElement(name = "DeliveryTransportEvent")
    private TransportEventType deliveryTransportEvent;
    @XmlElement(name = "ReceiptTransportEvent")
    private TransportEventType receiptTransportEvent;
    @XmlElement(name = "StorageTransportEvent")
    private TransportEventType storageTransportEvent;
    @XmlElement(name = "AcceptanceTransportEvent")
    private TransportEventType acceptanceTransportEvent;
    @XmlElement(name = "TerminalOperatorParty")
    private PartyType terminalOperatorParty;
    @XmlElement(name = "CustomsAgentParty")
    private PartyType customsAgentParty;
    @XmlElement(name = "EstimatedTransitPeriod")
    private PeriodType estimatedTransitPeriod;
    @XmlElement(name = "FreightAllowanceCharge")
    private List<AllowanceChargeType> freightAllowanceCharge;
    @XmlElement(name = "FreightChargeLocation")
    private LocationType freightChargeLocation;
    @XmlElement(name = "DetentionTransportEvent")
    private List<TransportEventType> detentionTransportEvent;
    @XmlElement(name = "RequestedDepartureTransportEvent")
    private TransportEventType requestedDepartureTransportEvent;
    @XmlElement(name = "RequestedArrivalTransportEvent")
    private TransportEventType requestedArrivalTransportEvent;
    @XmlElement(name = "RequestedWaypointTransportEvent")
    private List<TransportEventType> requestedWaypointTransportEvent;
    @XmlElement(name = "PlannedDepartureTransportEvent")
    private TransportEventType plannedDepartureTransportEvent;
    @XmlElement(name = "PlannedArrivalTransportEvent")
    private TransportEventType plannedArrivalTransportEvent;
    @XmlElement(name = "PlannedWaypointTransportEvent")
    private List<TransportEventType> plannedWaypointTransportEvent;
    @XmlElement(name = "ActualDepartureTransportEvent")
    private TransportEventType actualDepartureTransportEvent;
    @XmlElement(name = "ActualWaypointTransportEvent")
    private TransportEventType actualWaypointTransportEvent;
    @XmlElement(name = "ActualArrivalTransportEvent")
    private TransportEventType actualArrivalTransportEvent;
    @XmlElement(name = "TransportEvent")
    private List<TransportEventType> transportEvent;
    @XmlElement(name = "EstimatedDepartureTransportEvent")
    private TransportEventType estimatedDepartureTransportEvent;
    @XmlElement(name = "EstimatedArrivalTransportEvent")
    private TransportEventType estimatedArrivalTransportEvent;
    @XmlElement(name = "PassengerPerson")
    private List<PersonType> passengerPerson;
    @XmlElement(name = "DriverPerson")
    private List<PersonType> driverPerson;
    @XmlElement(name = "ReportingPerson")
    private PersonType reportingPerson;
    @XmlElement(name = "CrewMemberPerson")
    private List<PersonType> crewMemberPerson;
    @XmlElement(name = "SecurityOfficerPerson")
    private PersonType securityOfficerPerson;
    @XmlElement(name = "MasterPerson")
    private PersonType masterPerson;
    @XmlElement(name = "ShipsSurgeonPerson")
    private PersonType shipsSurgeonPerson;
    @XmlElement(name = "DestinationPortCall")
    private PortCallType destinationPortCall;
    @XmlElement(name = "ShipStoreArticle")
    private List<ShipStoreArticleType> shipStoreArticle;
    @XmlElement(name = "CrewPersonEffect")
    private List<CrewPersonEffectType> crewPersonEffect;
    @XmlElement(name = "MaritimeWaste")
    private List<MaritimeWasteType> maritimeWaste;
    @XmlElement(name = "BallastWaterSummary")
    private BallastWaterSummaryType ballastWaterSummary;
    @XmlElement(name = "ISPSRequirements")
    private ISPSRequirementsType ispsRequirements;
    @XmlElement(name = "MaritimeHealthDeclaration")
    private MaritimeHealthDeclarationType maritimeHealthDeclaration;
    @XmlElement(name = "FuelConsumption")
    private List<FuelConsumptionType> fuelConsumption;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public ShipmentStageType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the shipmentStageTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link ShipmentStageTypeCodeType }
     *     
     */
    @Nullable
    public ShipmentStageTypeCodeType getShipmentStageTypeCode() {
        return shipmentStageTypeCode;
    }

    /**
     * Sets the value of the shipmentStageTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ShipmentStageTypeCodeType }
     *     
     */
    public void setShipmentStageTypeCode(
        @Nullable
        ShipmentStageTypeCodeType value) {
        this.shipmentStageTypeCode = value;
    }

    /**
     * Gets the value of the shipmentStageType property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the shipmentStageType property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getShipmentStageType().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ShipmentStageTypeType }
     * </p>
     * 
     * 
     * @return
     *     The value of the shipmentStageType property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ShipmentStageTypeType> getShipmentStageType() {
        if (shipmentStageType == null) {
            shipmentStageType = new ArrayList<>();
        }
        return this.shipmentStageType;
    }

    /**
     * Gets the value of the transportModeCode property.
     * 
     * @return
     *     possible object is
     *     {@link TransportModeCodeType }
     *     
     */
    @Nullable
    public TransportModeCodeType getTransportModeCode() {
        return transportModeCode;
    }

    /**
     * Sets the value of the transportModeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportModeCodeType }
     *     
     */
    public void setTransportModeCode(
        @Nullable
        TransportModeCodeType value) {
        this.transportModeCode = value;
    }

    /**
     * Gets the value of the transportMeansTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link TransportMeansTypeCodeType }
     *     
     */
    @Nullable
    public TransportMeansTypeCodeType getTransportMeansTypeCode() {
        return transportMeansTypeCode;
    }

    /**
     * Sets the value of the transportMeansTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportMeansTypeCodeType }
     *     
     */
    public void setTransportMeansTypeCode(
        @Nullable
        TransportMeansTypeCodeType value) {
        this.transportMeansTypeCode = value;
    }

    /**
     * Gets the value of the transitDirectionCode property.
     * 
     * @return
     *     possible object is
     *     {@link TransitDirectionCodeType }
     *     
     */
    @Nullable
    public TransitDirectionCodeType getTransitDirectionCode() {
        return transitDirectionCode;
    }

    /**
     * Sets the value of the transitDirectionCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransitDirectionCodeType }
     *     
     */
    public void setTransitDirectionCode(
        @Nullable
        TransitDirectionCodeType value) {
        this.transitDirectionCode = value;
    }

    /**
     * Gets the value of the preCarriageIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link PreCarriageIndicatorType }
     *     
     */
    @Nullable
    public PreCarriageIndicatorType getPreCarriageIndicator() {
        return preCarriageIndicator;
    }

    /**
     * Sets the value of the preCarriageIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link PreCarriageIndicatorType }
     *     
     */
    public void setPreCarriageIndicator(
        @Nullable
        PreCarriageIndicatorType value) {
        this.preCarriageIndicator = value;
    }

    /**
     * Gets the value of the onCarriageIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link OnCarriageIndicatorType }
     *     
     */
    @Nullable
    public OnCarriageIndicatorType getOnCarriageIndicator() {
        return onCarriageIndicator;
    }

    /**
     * Sets the value of the onCarriageIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link OnCarriageIndicatorType }
     *     
     */
    public void setOnCarriageIndicator(
        @Nullable
        OnCarriageIndicatorType value) {
        this.onCarriageIndicator = value;
    }

    /**
     * Gets the value of the cabotageIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link CabotageIndicatorType }
     *     
     */
    @Nullable
    public CabotageIndicatorType getCabotageIndicator() {
        return cabotageIndicator;
    }

    /**
     * Sets the value of the cabotageIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link CabotageIndicatorType }
     *     
     */
    public void setCabotageIndicator(
        @Nullable
        CabotageIndicatorType value) {
        this.cabotageIndicator = value;
    }

    /**
     * Gets the value of the hazardousRiskIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link HazardousRiskIndicatorType }
     *     
     */
    @Nullable
    public HazardousRiskIndicatorType getHazardousRiskIndicator() {
        return hazardousRiskIndicator;
    }

    /**
     * Sets the value of the hazardousRiskIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link HazardousRiskIndicatorType }
     *     
     */
    public void setHazardousRiskIndicator(
        @Nullable
        HazardousRiskIndicatorType value) {
        this.hazardousRiskIndicator = value;
    }

    /**
     * Gets the value of the estimatedDeliveryDate property.
     * 
     * @return
     *     possible object is
     *     {@link EstimatedDeliveryDateType }
     *     
     */
    @Nullable
    public EstimatedDeliveryDateType getEstimatedDeliveryDate() {
        return estimatedDeliveryDate;
    }

    /**
     * Sets the value of the estimatedDeliveryDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link EstimatedDeliveryDateType }
     *     
     */
    public void setEstimatedDeliveryDate(
        @Nullable
        EstimatedDeliveryDateType value) {
        this.estimatedDeliveryDate = value;
    }

    /**
     * Gets the value of the estimatedDeliveryTime property.
     * 
     * @return
     *     possible object is
     *     {@link EstimatedDeliveryTimeType }
     *     
     */
    @Nullable
    public EstimatedDeliveryTimeType getEstimatedDeliveryTime() {
        return estimatedDeliveryTime;
    }

    /**
     * Sets the value of the estimatedDeliveryTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link EstimatedDeliveryTimeType }
     *     
     */
    public void setEstimatedDeliveryTime(
        @Nullable
        EstimatedDeliveryTimeType value) {
        this.estimatedDeliveryTime = value;
    }

    /**
     * Gets the value of the requiredDeliveryDate property.
     * 
     * @return
     *     possible object is
     *     {@link RequiredDeliveryDateType }
     *     
     */
    @Nullable
    public RequiredDeliveryDateType getRequiredDeliveryDate() {
        return requiredDeliveryDate;
    }

    /**
     * Sets the value of the requiredDeliveryDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link RequiredDeliveryDateType }
     *     
     */
    public void setRequiredDeliveryDate(
        @Nullable
        RequiredDeliveryDateType value) {
        this.requiredDeliveryDate = value;
    }

    /**
     * Gets the value of the requiredDeliveryTime property.
     * 
     * @return
     *     possible object is
     *     {@link RequiredDeliveryTimeType }
     *     
     */
    @Nullable
    public RequiredDeliveryTimeType getRequiredDeliveryTime() {
        return requiredDeliveryTime;
    }

    /**
     * Sets the value of the requiredDeliveryTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link RequiredDeliveryTimeType }
     *     
     */
    public void setRequiredDeliveryTime(
        @Nullable
        RequiredDeliveryTimeType value) {
        this.requiredDeliveryTime = value;
    }

    /**
     * Gets the value of the loadingSequenceID property.
     * 
     * @return
     *     possible object is
     *     {@link LoadingSequenceIDType }
     *     
     */
    @Nullable
    public LoadingSequenceIDType getLoadingSequenceID() {
        return loadingSequenceID;
    }

    /**
     * Sets the value of the loadingSequenceID property.
     * 
     * @param value
     *     allowed object is
     *     {@link LoadingSequenceIDType }
     *     
     */
    public void setLoadingSequenceID(
        @Nullable
        LoadingSequenceIDType value) {
        this.loadingSequenceID = value;
    }

    /**
     * Gets the value of the successiveSequenceID property.
     * 
     * @return
     *     possible object is
     *     {@link SuccessiveSequenceIDType }
     *     
     */
    @Nullable
    public SuccessiveSequenceIDType getSuccessiveSequenceID() {
        return successiveSequenceID;
    }

    /**
     * Sets the value of the successiveSequenceID property.
     * 
     * @param value
     *     allowed object is
     *     {@link SuccessiveSequenceIDType }
     *     
     */
    public void setSuccessiveSequenceID(
        @Nullable
        SuccessiveSequenceIDType value) {
        this.successiveSequenceID = value;
    }

    /**
     * Gets the value of the instructions property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the instructions property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getInstructions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link InstructionsType }
     * </p>
     * 
     * 
     * @return
     *     The value of the instructions property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<InstructionsType> getInstructions() {
        if (instructions == null) {
            instructions = new ArrayList<>();
        }
        return this.instructions;
    }

    /**
     * Gets the value of the demurrageInstructions property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the demurrageInstructions property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDemurrageInstructions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DemurrageInstructionsType }
     * </p>
     * 
     * 
     * @return
     *     The value of the demurrageInstructions property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DemurrageInstructionsType> getDemurrageInstructions() {
        if (demurrageInstructions == null) {
            demurrageInstructions = new ArrayList<>();
        }
        return this.demurrageInstructions;
    }

    /**
     * Gets the value of the crewQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link CrewQuantityType }
     *     
     */
    @Nullable
    public CrewQuantityType getCrewQuantity() {
        return crewQuantity;
    }

    /**
     * Sets the value of the crewQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link CrewQuantityType }
     *     
     */
    public void setCrewQuantity(
        @Nullable
        CrewQuantityType value) {
        this.crewQuantity = value;
    }

    /**
     * Gets the value of the passengerQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link PassengerQuantityType }
     *     
     */
    @Nullable
    public PassengerQuantityType getPassengerQuantity() {
        return passengerQuantity;
    }

    /**
     * Sets the value of the passengerQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link PassengerQuantityType }
     *     
     */
    public void setPassengerQuantity(
        @Nullable
        PassengerQuantityType value) {
        this.passengerQuantity = value;
    }

    /**
     * Gets the value of the transitPeriod property.
     * 
     * @return
     *     possible object is
     *     {@link PeriodType }
     *     
     */
    @Nullable
    public PeriodType getTransitPeriod() {
        return transitPeriod;
    }

    /**
     * Sets the value of the transitPeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link PeriodType }
     *     
     */
    public void setTransitPeriod(
        @Nullable
        PeriodType value) {
        this.transitPeriod = value;
    }

    /**
     * Gets the value of the carrierParty property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the carrierParty property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getCarrierParty().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PartyType }
     * </p>
     * 
     * 
     * @return
     *     The value of the carrierParty property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PartyType> getCarrierParty() {
        if (carrierParty == null) {
            carrierParty = new ArrayList<>();
        }
        return this.carrierParty;
    }

    /**
     * Gets the value of the transportMeans property.
     * 
     * @return
     *     possible object is
     *     {@link TransportMeansType }
     *     
     */
    @Nullable
    public TransportMeansType getTransportMeans() {
        return transportMeans;
    }

    /**
     * Sets the value of the transportMeans property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportMeansType }
     *     
     */
    public void setTransportMeans(
        @Nullable
        TransportMeansType value) {
        this.transportMeans = value;
    }

    /**
     * Gets the value of the loadingPortLocation property.
     * 
     * @return
     *     possible object is
     *     {@link LocationType }
     *     
     */
    @Nullable
    public LocationType getLoadingPortLocation() {
        return loadingPortLocation;
    }

    /**
     * Sets the value of the loadingPortLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationType }
     *     
     */
    public void setLoadingPortLocation(
        @Nullable
        LocationType value) {
        this.loadingPortLocation = value;
    }

    /**
     * Gets the value of the unloadingPortLocation property.
     * 
     * @return
     *     possible object is
     *     {@link LocationType }
     *     
     */
    @Nullable
    public LocationType getUnloadingPortLocation() {
        return unloadingPortLocation;
    }

    /**
     * Sets the value of the unloadingPortLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationType }
     *     
     */
    public void setUnloadingPortLocation(
        @Nullable
        LocationType value) {
        this.unloadingPortLocation = value;
    }

    /**
     * Gets the value of the transshipPortLocation property.
     * 
     * @return
     *     possible object is
     *     {@link LocationType }
     *     
     */
    @Nullable
    public LocationType getTransshipPortLocation() {
        return transshipPortLocation;
    }

    /**
     * Sets the value of the transshipPortLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationType }
     *     
     */
    public void setTransshipPortLocation(
        @Nullable
        LocationType value) {
        this.transshipPortLocation = value;
    }

    /**
     * Gets the value of the loadingTransportEvent property.
     * 
     * @return
     *     possible object is
     *     {@link TransportEventType }
     *     
     */
    @Nullable
    public TransportEventType getLoadingTransportEvent() {
        return loadingTransportEvent;
    }

    /**
     * Sets the value of the loadingTransportEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportEventType }
     *     
     */
    public void setLoadingTransportEvent(
        @Nullable
        TransportEventType value) {
        this.loadingTransportEvent = value;
    }

    /**
     * Gets the value of the examinationTransportEvent property.
     * 
     * @return
     *     possible object is
     *     {@link TransportEventType }
     *     
     */
    @Nullable
    public TransportEventType getExaminationTransportEvent() {
        return examinationTransportEvent;
    }

    /**
     * Sets the value of the examinationTransportEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportEventType }
     *     
     */
    public void setExaminationTransportEvent(
        @Nullable
        TransportEventType value) {
        this.examinationTransportEvent = value;
    }

    /**
     * Gets the value of the availabilityTransportEvent property.
     * 
     * @return
     *     possible object is
     *     {@link TransportEventType }
     *     
     */
    @Nullable
    public TransportEventType getAvailabilityTransportEvent() {
        return availabilityTransportEvent;
    }

    /**
     * Sets the value of the availabilityTransportEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportEventType }
     *     
     */
    public void setAvailabilityTransportEvent(
        @Nullable
        TransportEventType value) {
        this.availabilityTransportEvent = value;
    }

    /**
     * Gets the value of the exportationTransportEvent property.
     * 
     * @return
     *     possible object is
     *     {@link TransportEventType }
     *     
     */
    @Nullable
    public TransportEventType getExportationTransportEvent() {
        return exportationTransportEvent;
    }

    /**
     * Sets the value of the exportationTransportEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportEventType }
     *     
     */
    public void setExportationTransportEvent(
        @Nullable
        TransportEventType value) {
        this.exportationTransportEvent = value;
    }

    /**
     * Gets the value of the dischargeTransportEvent property.
     * 
     * @return
     *     possible object is
     *     {@link TransportEventType }
     *     
     */
    @Nullable
    public TransportEventType getDischargeTransportEvent() {
        return dischargeTransportEvent;
    }

    /**
     * Sets the value of the dischargeTransportEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportEventType }
     *     
     */
    public void setDischargeTransportEvent(
        @Nullable
        TransportEventType value) {
        this.dischargeTransportEvent = value;
    }

    /**
     * Gets the value of the warehousingTransportEvent property.
     * 
     * @return
     *     possible object is
     *     {@link TransportEventType }
     *     
     */
    @Nullable
    public TransportEventType getWarehousingTransportEvent() {
        return warehousingTransportEvent;
    }

    /**
     * Sets the value of the warehousingTransportEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportEventType }
     *     
     */
    public void setWarehousingTransportEvent(
        @Nullable
        TransportEventType value) {
        this.warehousingTransportEvent = value;
    }

    /**
     * Gets the value of the takeoverTransportEvent property.
     * 
     * @return
     *     possible object is
     *     {@link TransportEventType }
     *     
     */
    @Nullable
    public TransportEventType getTakeoverTransportEvent() {
        return takeoverTransportEvent;
    }

    /**
     * Sets the value of the takeoverTransportEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportEventType }
     *     
     */
    public void setTakeoverTransportEvent(
        @Nullable
        TransportEventType value) {
        this.takeoverTransportEvent = value;
    }

    /**
     * Gets the value of the optionalTakeoverTransportEvent property.
     * 
     * @return
     *     possible object is
     *     {@link TransportEventType }
     *     
     */
    @Nullable
    public TransportEventType getOptionalTakeoverTransportEvent() {
        return optionalTakeoverTransportEvent;
    }

    /**
     * Sets the value of the optionalTakeoverTransportEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportEventType }
     *     
     */
    public void setOptionalTakeoverTransportEvent(
        @Nullable
        TransportEventType value) {
        this.optionalTakeoverTransportEvent = value;
    }

    /**
     * Gets the value of the dropoffTransportEvent property.
     * 
     * @return
     *     possible object is
     *     {@link TransportEventType }
     *     
     */
    @Nullable
    public TransportEventType getDropoffTransportEvent() {
        return dropoffTransportEvent;
    }

    /**
     * Sets the value of the dropoffTransportEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportEventType }
     *     
     */
    public void setDropoffTransportEvent(
        @Nullable
        TransportEventType value) {
        this.dropoffTransportEvent = value;
    }

    /**
     * Gets the value of the actualPickupTransportEvent property.
     * 
     * @return
     *     possible object is
     *     {@link TransportEventType }
     *     
     */
    @Nullable
    public TransportEventType getActualPickupTransportEvent() {
        return actualPickupTransportEvent;
    }

    /**
     * Sets the value of the actualPickupTransportEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportEventType }
     *     
     */
    public void setActualPickupTransportEvent(
        @Nullable
        TransportEventType value) {
        this.actualPickupTransportEvent = value;
    }

    /**
     * Gets the value of the deliveryTransportEvent property.
     * 
     * @return
     *     possible object is
     *     {@link TransportEventType }
     *     
     */
    @Nullable
    public TransportEventType getDeliveryTransportEvent() {
        return deliveryTransportEvent;
    }

    /**
     * Sets the value of the deliveryTransportEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportEventType }
     *     
     */
    public void setDeliveryTransportEvent(
        @Nullable
        TransportEventType value) {
        this.deliveryTransportEvent = value;
    }

    /**
     * Gets the value of the receiptTransportEvent property.
     * 
     * @return
     *     possible object is
     *     {@link TransportEventType }
     *     
     */
    @Nullable
    public TransportEventType getReceiptTransportEvent() {
        return receiptTransportEvent;
    }

    /**
     * Sets the value of the receiptTransportEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportEventType }
     *     
     */
    public void setReceiptTransportEvent(
        @Nullable
        TransportEventType value) {
        this.receiptTransportEvent = value;
    }

    /**
     * Gets the value of the storageTransportEvent property.
     * 
     * @return
     *     possible object is
     *     {@link TransportEventType }
     *     
     */
    @Nullable
    public TransportEventType getStorageTransportEvent() {
        return storageTransportEvent;
    }

    /**
     * Sets the value of the storageTransportEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportEventType }
     *     
     */
    public void setStorageTransportEvent(
        @Nullable
        TransportEventType value) {
        this.storageTransportEvent = value;
    }

    /**
     * Gets the value of the acceptanceTransportEvent property.
     * 
     * @return
     *     possible object is
     *     {@link TransportEventType }
     *     
     */
    @Nullable
    public TransportEventType getAcceptanceTransportEvent() {
        return acceptanceTransportEvent;
    }

    /**
     * Sets the value of the acceptanceTransportEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportEventType }
     *     
     */
    public void setAcceptanceTransportEvent(
        @Nullable
        TransportEventType value) {
        this.acceptanceTransportEvent = value;
    }

    /**
     * Gets the value of the terminalOperatorParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getTerminalOperatorParty() {
        return terminalOperatorParty;
    }

    /**
     * Sets the value of the terminalOperatorParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setTerminalOperatorParty(
        @Nullable
        PartyType value) {
        this.terminalOperatorParty = value;
    }

    /**
     * Gets the value of the customsAgentParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getCustomsAgentParty() {
        return customsAgentParty;
    }

    /**
     * Sets the value of the customsAgentParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setCustomsAgentParty(
        @Nullable
        PartyType value) {
        this.customsAgentParty = value;
    }

    /**
     * Gets the value of the estimatedTransitPeriod property.
     * 
     * @return
     *     possible object is
     *     {@link PeriodType }
     *     
     */
    @Nullable
    public PeriodType getEstimatedTransitPeriod() {
        return estimatedTransitPeriod;
    }

    /**
     * Sets the value of the estimatedTransitPeriod property.
     * 
     * @param value
     *     allowed object is
     *     {@link PeriodType }
     *     
     */
    public void setEstimatedTransitPeriod(
        @Nullable
        PeriodType value) {
        this.estimatedTransitPeriod = value;
    }

    /**
     * Gets the value of the freightAllowanceCharge property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the freightAllowanceCharge property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getFreightAllowanceCharge().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AllowanceChargeType }
     * </p>
     * 
     * 
     * @return
     *     The value of the freightAllowanceCharge property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AllowanceChargeType> getFreightAllowanceCharge() {
        if (freightAllowanceCharge == null) {
            freightAllowanceCharge = new ArrayList<>();
        }
        return this.freightAllowanceCharge;
    }

    /**
     * Gets the value of the freightChargeLocation property.
     * 
     * @return
     *     possible object is
     *     {@link LocationType }
     *     
     */
    @Nullable
    public LocationType getFreightChargeLocation() {
        return freightChargeLocation;
    }

    /**
     * Sets the value of the freightChargeLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationType }
     *     
     */
    public void setFreightChargeLocation(
        @Nullable
        LocationType value) {
        this.freightChargeLocation = value;
    }

    /**
     * Gets the value of the detentionTransportEvent property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the detentionTransportEvent property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDetentionTransportEvent().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TransportEventType }
     * </p>
     * 
     * 
     * @return
     *     The value of the detentionTransportEvent property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TransportEventType> getDetentionTransportEvent() {
        if (detentionTransportEvent == null) {
            detentionTransportEvent = new ArrayList<>();
        }
        return this.detentionTransportEvent;
    }

    /**
     * Gets the value of the requestedDepartureTransportEvent property.
     * 
     * @return
     *     possible object is
     *     {@link TransportEventType }
     *     
     */
    @Nullable
    public TransportEventType getRequestedDepartureTransportEvent() {
        return requestedDepartureTransportEvent;
    }

    /**
     * Sets the value of the requestedDepartureTransportEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportEventType }
     *     
     */
    public void setRequestedDepartureTransportEvent(
        @Nullable
        TransportEventType value) {
        this.requestedDepartureTransportEvent = value;
    }

    /**
     * Gets the value of the requestedArrivalTransportEvent property.
     * 
     * @return
     *     possible object is
     *     {@link TransportEventType }
     *     
     */
    @Nullable
    public TransportEventType getRequestedArrivalTransportEvent() {
        return requestedArrivalTransportEvent;
    }

    /**
     * Sets the value of the requestedArrivalTransportEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportEventType }
     *     
     */
    public void setRequestedArrivalTransportEvent(
        @Nullable
        TransportEventType value) {
        this.requestedArrivalTransportEvent = value;
    }

    /**
     * Gets the value of the requestedWaypointTransportEvent property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the requestedWaypointTransportEvent property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getRequestedWaypointTransportEvent().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TransportEventType }
     * </p>
     * 
     * 
     * @return
     *     The value of the requestedWaypointTransportEvent property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TransportEventType> getRequestedWaypointTransportEvent() {
        if (requestedWaypointTransportEvent == null) {
            requestedWaypointTransportEvent = new ArrayList<>();
        }
        return this.requestedWaypointTransportEvent;
    }

    /**
     * Gets the value of the plannedDepartureTransportEvent property.
     * 
     * @return
     *     possible object is
     *     {@link TransportEventType }
     *     
     */
    @Nullable
    public TransportEventType getPlannedDepartureTransportEvent() {
        return plannedDepartureTransportEvent;
    }

    /**
     * Sets the value of the plannedDepartureTransportEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportEventType }
     *     
     */
    public void setPlannedDepartureTransportEvent(
        @Nullable
        TransportEventType value) {
        this.plannedDepartureTransportEvent = value;
    }

    /**
     * Gets the value of the plannedArrivalTransportEvent property.
     * 
     * @return
     *     possible object is
     *     {@link TransportEventType }
     *     
     */
    @Nullable
    public TransportEventType getPlannedArrivalTransportEvent() {
        return plannedArrivalTransportEvent;
    }

    /**
     * Sets the value of the plannedArrivalTransportEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportEventType }
     *     
     */
    public void setPlannedArrivalTransportEvent(
        @Nullable
        TransportEventType value) {
        this.plannedArrivalTransportEvent = value;
    }

    /**
     * Gets the value of the plannedWaypointTransportEvent property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the plannedWaypointTransportEvent property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPlannedWaypointTransportEvent().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TransportEventType }
     * </p>
     * 
     * 
     * @return
     *     The value of the plannedWaypointTransportEvent property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TransportEventType> getPlannedWaypointTransportEvent() {
        if (plannedWaypointTransportEvent == null) {
            plannedWaypointTransportEvent = new ArrayList<>();
        }
        return this.plannedWaypointTransportEvent;
    }

    /**
     * Gets the value of the actualDepartureTransportEvent property.
     * 
     * @return
     *     possible object is
     *     {@link TransportEventType }
     *     
     */
    @Nullable
    public TransportEventType getActualDepartureTransportEvent() {
        return actualDepartureTransportEvent;
    }

    /**
     * Sets the value of the actualDepartureTransportEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportEventType }
     *     
     */
    public void setActualDepartureTransportEvent(
        @Nullable
        TransportEventType value) {
        this.actualDepartureTransportEvent = value;
    }

    /**
     * Gets the value of the actualWaypointTransportEvent property.
     * 
     * @return
     *     possible object is
     *     {@link TransportEventType }
     *     
     */
    @Nullable
    public TransportEventType getActualWaypointTransportEvent() {
        return actualWaypointTransportEvent;
    }

    /**
     * Sets the value of the actualWaypointTransportEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportEventType }
     *     
     */
    public void setActualWaypointTransportEvent(
        @Nullable
        TransportEventType value) {
        this.actualWaypointTransportEvent = value;
    }

    /**
     * Gets the value of the actualArrivalTransportEvent property.
     * 
     * @return
     *     possible object is
     *     {@link TransportEventType }
     *     
     */
    @Nullable
    public TransportEventType getActualArrivalTransportEvent() {
        return actualArrivalTransportEvent;
    }

    /**
     * Sets the value of the actualArrivalTransportEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportEventType }
     *     
     */
    public void setActualArrivalTransportEvent(
        @Nullable
        TransportEventType value) {
        this.actualArrivalTransportEvent = value;
    }

    /**
     * Gets the value of the transportEvent property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the transportEvent property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getTransportEvent().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TransportEventType }
     * </p>
     * 
     * 
     * @return
     *     The value of the transportEvent property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TransportEventType> getTransportEvent() {
        if (transportEvent == null) {
            transportEvent = new ArrayList<>();
        }
        return this.transportEvent;
    }

    /**
     * Gets the value of the estimatedDepartureTransportEvent property.
     * 
     * @return
     *     possible object is
     *     {@link TransportEventType }
     *     
     */
    @Nullable
    public TransportEventType getEstimatedDepartureTransportEvent() {
        return estimatedDepartureTransportEvent;
    }

    /**
     * Sets the value of the estimatedDepartureTransportEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportEventType }
     *     
     */
    public void setEstimatedDepartureTransportEvent(
        @Nullable
        TransportEventType value) {
        this.estimatedDepartureTransportEvent = value;
    }

    /**
     * Gets the value of the estimatedArrivalTransportEvent property.
     * 
     * @return
     *     possible object is
     *     {@link TransportEventType }
     *     
     */
    @Nullable
    public TransportEventType getEstimatedArrivalTransportEvent() {
        return estimatedArrivalTransportEvent;
    }

    /**
     * Sets the value of the estimatedArrivalTransportEvent property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportEventType }
     *     
     */
    public void setEstimatedArrivalTransportEvent(
        @Nullable
        TransportEventType value) {
        this.estimatedArrivalTransportEvent = value;
    }

    /**
     * Gets the value of the passengerPerson property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the passengerPerson property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPassengerPerson().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PersonType }
     * </p>
     * 
     * 
     * @return
     *     The value of the passengerPerson property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PersonType> getPassengerPerson() {
        if (passengerPerson == null) {
            passengerPerson = new ArrayList<>();
        }
        return this.passengerPerson;
    }

    /**
     * Gets the value of the driverPerson property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the driverPerson property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDriverPerson().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PersonType }
     * </p>
     * 
     * 
     * @return
     *     The value of the driverPerson property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PersonType> getDriverPerson() {
        if (driverPerson == null) {
            driverPerson = new ArrayList<>();
        }
        return this.driverPerson;
    }

    /**
     * Gets the value of the reportingPerson property.
     * 
     * @return
     *     possible object is
     *     {@link PersonType }
     *     
     */
    @Nullable
    public PersonType getReportingPerson() {
        return reportingPerson;
    }

    /**
     * Sets the value of the reportingPerson property.
     * 
     * @param value
     *     allowed object is
     *     {@link PersonType }
     *     
     */
    public void setReportingPerson(
        @Nullable
        PersonType value) {
        this.reportingPerson = value;
    }

    /**
     * Gets the value of the crewMemberPerson property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the crewMemberPerson property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getCrewMemberPerson().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PersonType }
     * </p>
     * 
     * 
     * @return
     *     The value of the crewMemberPerson property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PersonType> getCrewMemberPerson() {
        if (crewMemberPerson == null) {
            crewMemberPerson = new ArrayList<>();
        }
        return this.crewMemberPerson;
    }

    /**
     * Gets the value of the securityOfficerPerson property.
     * 
     * @return
     *     possible object is
     *     {@link PersonType }
     *     
     */
    @Nullable
    public PersonType getSecurityOfficerPerson() {
        return securityOfficerPerson;
    }

    /**
     * Sets the value of the securityOfficerPerson property.
     * 
     * @param value
     *     allowed object is
     *     {@link PersonType }
     *     
     */
    public void setSecurityOfficerPerson(
        @Nullable
        PersonType value) {
        this.securityOfficerPerson = value;
    }

    /**
     * Gets the value of the masterPerson property.
     * 
     * @return
     *     possible object is
     *     {@link PersonType }
     *     
     */
    @Nullable
    public PersonType getMasterPerson() {
        return masterPerson;
    }

    /**
     * Sets the value of the masterPerson property.
     * 
     * @param value
     *     allowed object is
     *     {@link PersonType }
     *     
     */
    public void setMasterPerson(
        @Nullable
        PersonType value) {
        this.masterPerson = value;
    }

    /**
     * Gets the value of the shipsSurgeonPerson property.
     * 
     * @return
     *     possible object is
     *     {@link PersonType }
     *     
     */
    @Nullable
    public PersonType getShipsSurgeonPerson() {
        return shipsSurgeonPerson;
    }

    /**
     * Sets the value of the shipsSurgeonPerson property.
     * 
     * @param value
     *     allowed object is
     *     {@link PersonType }
     *     
     */
    public void setShipsSurgeonPerson(
        @Nullable
        PersonType value) {
        this.shipsSurgeonPerson = value;
    }

    /**
     * Gets the value of the destinationPortCall property.
     * 
     * @return
     *     possible object is
     *     {@link PortCallType }
     *     
     */
    @Nullable
    public PortCallType getDestinationPortCall() {
        return destinationPortCall;
    }

    /**
     * Sets the value of the destinationPortCall property.
     * 
     * @param value
     *     allowed object is
     *     {@link PortCallType }
     *     
     */
    public void setDestinationPortCall(
        @Nullable
        PortCallType value) {
        this.destinationPortCall = value;
    }

    /**
     * Gets the value of the shipStoreArticle property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the shipStoreArticle property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getShipStoreArticle().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ShipStoreArticleType }
     * </p>
     * 
     * 
     * @return
     *     The value of the shipStoreArticle property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ShipStoreArticleType> getShipStoreArticle() {
        if (shipStoreArticle == null) {
            shipStoreArticle = new ArrayList<>();
        }
        return this.shipStoreArticle;
    }

    /**
     * Gets the value of the crewPersonEffect property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the crewPersonEffect property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getCrewPersonEffect().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CrewPersonEffectType }
     * </p>
     * 
     * 
     * @return
     *     The value of the crewPersonEffect property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CrewPersonEffectType> getCrewPersonEffect() {
        if (crewPersonEffect == null) {
            crewPersonEffect = new ArrayList<>();
        }
        return this.crewPersonEffect;
    }

    /**
     * Gets the value of the maritimeWaste property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the maritimeWaste property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getMaritimeWaste().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link MaritimeWasteType }
     * </p>
     * 
     * 
     * @return
     *     The value of the maritimeWaste property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<MaritimeWasteType> getMaritimeWaste() {
        if (maritimeWaste == null) {
            maritimeWaste = new ArrayList<>();
        }
        return this.maritimeWaste;
    }

    /**
     * Gets the value of the ballastWaterSummary property.
     * 
     * @return
     *     possible object is
     *     {@link BallastWaterSummaryType }
     *     
     */
    @Nullable
    public BallastWaterSummaryType getBallastWaterSummary() {
        return ballastWaterSummary;
    }

    /**
     * Sets the value of the ballastWaterSummary property.
     * 
     * @param value
     *     allowed object is
     *     {@link BallastWaterSummaryType }
     *     
     */
    public void setBallastWaterSummary(
        @Nullable
        BallastWaterSummaryType value) {
        this.ballastWaterSummary = value;
    }

    /**
     * Gets the value of the ispsRequirements property.
     * 
     * @return
     *     possible object is
     *     {@link ISPSRequirementsType }
     *     
     */
    @Nullable
    public ISPSRequirementsType getISPSRequirements() {
        return ispsRequirements;
    }

    /**
     * Sets the value of the ispsRequirements property.
     * 
     * @param value
     *     allowed object is
     *     {@link ISPSRequirementsType }
     *     
     */
    public void setISPSRequirements(
        @Nullable
        ISPSRequirementsType value) {
        this.ispsRequirements = value;
    }

    /**
     * Gets the value of the maritimeHealthDeclaration property.
     * 
     * @return
     *     possible object is
     *     {@link MaritimeHealthDeclarationType }
     *     
     */
    @Nullable
    public MaritimeHealthDeclarationType getMaritimeHealthDeclaration() {
        return maritimeHealthDeclaration;
    }

    /**
     * Sets the value of the maritimeHealthDeclaration property.
     * 
     * @param value
     *     allowed object is
     *     {@link MaritimeHealthDeclarationType }
     *     
     */
    public void setMaritimeHealthDeclaration(
        @Nullable
        MaritimeHealthDeclarationType value) {
        this.maritimeHealthDeclaration = value;
    }

    /**
     * Gets the value of the fuelConsumption property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the fuelConsumption property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getFuelConsumption().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FuelConsumptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the fuelConsumption property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<FuelConsumptionType> getFuelConsumption() {
        if (fuelConsumption == null) {
            fuelConsumption = new ArrayList<>();
        }
        return this.fuelConsumption;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final ShipmentStageType rhs = ((ShipmentStageType) o);
        if (!EqualsHelper.equals(acceptanceTransportEvent, rhs.acceptanceTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(actualArrivalTransportEvent, rhs.actualArrivalTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(actualDepartureTransportEvent, rhs.actualDepartureTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(actualPickupTransportEvent, rhs.actualPickupTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(actualWaypointTransportEvent, rhs.actualWaypointTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(availabilityTransportEvent, rhs.availabilityTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(ballastWaterSummary, rhs.ballastWaterSummary)) {
            return false;
        }
        if (!EqualsHelper.equals(cabotageIndicator, rhs.cabotageIndicator)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(carrierParty, rhs.carrierParty)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(crewMemberPerson, rhs.crewMemberPerson)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(crewPersonEffect, rhs.crewPersonEffect)) {
            return false;
        }
        if (!EqualsHelper.equals(crewQuantity, rhs.crewQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(customsAgentParty, rhs.customsAgentParty)) {
            return false;
        }
        if (!EqualsHelper.equals(deliveryTransportEvent, rhs.deliveryTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(demurrageInstructions, rhs.demurrageInstructions)) {
            return false;
        }
        if (!EqualsHelper.equals(destinationPortCall, rhs.destinationPortCall)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(detentionTransportEvent, rhs.detentionTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(dischargeTransportEvent, rhs.dischargeTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(driverPerson, rhs.driverPerson)) {
            return false;
        }
        if (!EqualsHelper.equals(dropoffTransportEvent, rhs.dropoffTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(estimatedArrivalTransportEvent, rhs.estimatedArrivalTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(estimatedDeliveryDate, rhs.estimatedDeliveryDate)) {
            return false;
        }
        if (!EqualsHelper.equals(estimatedDeliveryTime, rhs.estimatedDeliveryTime)) {
            return false;
        }
        if (!EqualsHelper.equals(estimatedDepartureTransportEvent, rhs.estimatedDepartureTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(estimatedTransitPeriod, rhs.estimatedTransitPeriod)) {
            return false;
        }
        if (!EqualsHelper.equals(examinationTransportEvent, rhs.examinationTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(exportationTransportEvent, rhs.exportationTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(freightAllowanceCharge, rhs.freightAllowanceCharge)) {
            return false;
        }
        if (!EqualsHelper.equals(freightChargeLocation, rhs.freightChargeLocation)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(fuelConsumption, rhs.fuelConsumption)) {
            return false;
        }
        if (!EqualsHelper.equals(hazardousRiskIndicator, rhs.hazardousRiskIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(instructions, rhs.instructions)) {
            return false;
        }
        if (!EqualsHelper.equals(ispsRequirements, rhs.ispsRequirements)) {
            return false;
        }
        if (!EqualsHelper.equals(loadingPortLocation, rhs.loadingPortLocation)) {
            return false;
        }
        if (!EqualsHelper.equals(loadingSequenceID, rhs.loadingSequenceID)) {
            return false;
        }
        if (!EqualsHelper.equals(loadingTransportEvent, rhs.loadingTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(maritimeHealthDeclaration, rhs.maritimeHealthDeclaration)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(maritimeWaste, rhs.maritimeWaste)) {
            return false;
        }
        if (!EqualsHelper.equals(masterPerson, rhs.masterPerson)) {
            return false;
        }
        if (!EqualsHelper.equals(onCarriageIndicator, rhs.onCarriageIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(optionalTakeoverTransportEvent, rhs.optionalTakeoverTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(passengerPerson, rhs.passengerPerson)) {
            return false;
        }
        if (!EqualsHelper.equals(passengerQuantity, rhs.passengerQuantity)) {
            return false;
        }
        if (!EqualsHelper.equals(plannedArrivalTransportEvent, rhs.plannedArrivalTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(plannedDepartureTransportEvent, rhs.plannedDepartureTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(plannedWaypointTransportEvent, rhs.plannedWaypointTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(preCarriageIndicator, rhs.preCarriageIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(receiptTransportEvent, rhs.receiptTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(reportingPerson, rhs.reportingPerson)) {
            return false;
        }
        if (!EqualsHelper.equals(requestedArrivalTransportEvent, rhs.requestedArrivalTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(requestedDepartureTransportEvent, rhs.requestedDepartureTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(requestedWaypointTransportEvent, rhs.requestedWaypointTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(requiredDeliveryDate, rhs.requiredDeliveryDate)) {
            return false;
        }
        if (!EqualsHelper.equals(requiredDeliveryTime, rhs.requiredDeliveryTime)) {
            return false;
        }
        if (!EqualsHelper.equals(securityOfficerPerson, rhs.securityOfficerPerson)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(shipStoreArticle, rhs.shipStoreArticle)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(shipmentStageType, rhs.shipmentStageType)) {
            return false;
        }
        if (!EqualsHelper.equals(shipmentStageTypeCode, rhs.shipmentStageTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(shipsSurgeonPerson, rhs.shipsSurgeonPerson)) {
            return false;
        }
        if (!EqualsHelper.equals(storageTransportEvent, rhs.storageTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(successiveSequenceID, rhs.successiveSequenceID)) {
            return false;
        }
        if (!EqualsHelper.equals(takeoverTransportEvent, rhs.takeoverTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(terminalOperatorParty, rhs.terminalOperatorParty)) {
            return false;
        }
        if (!EqualsHelper.equals(transitDirectionCode, rhs.transitDirectionCode)) {
            return false;
        }
        if (!EqualsHelper.equals(transitPeriod, rhs.transitPeriod)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(transportEvent, rhs.transportEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(transportMeans, rhs.transportMeans)) {
            return false;
        }
        if (!EqualsHelper.equals(transportMeansTypeCode, rhs.transportMeansTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(transportModeCode, rhs.transportModeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(transshipPortLocation, rhs.transshipPortLocation)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equals(unloadingPortLocation, rhs.unloadingPortLocation)) {
            return false;
        }
        if (!EqualsHelper.equals(warehousingTransportEvent, rhs.warehousingTransportEvent)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(acceptanceTransportEvent).append(actualArrivalTransportEvent).append(actualDepartureTransportEvent).append(actualPickupTransportEvent).append(actualWaypointTransportEvent).append(availabilityTransportEvent).append(ballastWaterSummary).append(cabotageIndicator).append(carrierParty).append(crewMemberPerson).append(crewPersonEffect).append(crewQuantity).append(customsAgentParty).append(deliveryTransportEvent).append(demurrageInstructions).append(destinationPortCall).append(detentionTransportEvent).append(dischargeTransportEvent).append(driverPerson).append(dropoffTransportEvent).append(estimatedArrivalTransportEvent).append(estimatedDeliveryDate).append(estimatedDeliveryTime).append(estimatedDepartureTransportEvent).append(estimatedTransitPeriod).append(examinationTransportEvent).append(exportationTransportEvent).append(freightAllowanceCharge).append(freightChargeLocation).append(fuelConsumption).append(hazardousRiskIndicator).append(id).append(instructions).append(ispsRequirements).append(loadingPortLocation).append(loadingSequenceID).append(loadingTransportEvent).append(maritimeHealthDeclaration).append(maritimeWaste).append(masterPerson).append(onCarriageIndicator).append(optionalTakeoverTransportEvent).append(passengerPerson).append(passengerQuantity).append(plannedArrivalTransportEvent).append(plannedDepartureTransportEvent).append(plannedWaypointTransportEvent).append(preCarriageIndicator).append(receiptTransportEvent).append(reportingPerson).append(requestedArrivalTransportEvent).append(requestedDepartureTransportEvent).append(requestedWaypointTransportEvent).append(requiredDeliveryDate).append(requiredDeliveryTime).append(securityOfficerPerson).append(shipStoreArticle).append(shipmentStageType).append(shipmentStageTypeCode).append(shipsSurgeonPerson).append(storageTransportEvent).append(successiveSequenceID).append(takeoverTransportEvent).append(terminalOperatorParty).append(transitDirectionCode).append(transitPeriod).append(transportEvent).append(transportMeans).append(transportMeansTypeCode).append(transportModeCode).append(transshipPortLocation).append(ublExtensions).append(unloadingPortLocation).append(warehousingTransportEvent).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("acceptanceTransportEvent", acceptanceTransportEvent).append("actualArrivalTransportEvent", actualArrivalTransportEvent).append("actualDepartureTransportEvent", actualDepartureTransportEvent).append("actualPickupTransportEvent", actualPickupTransportEvent).append("actualWaypointTransportEvent", actualWaypointTransportEvent).append("availabilityTransportEvent", availabilityTransportEvent).append("ballastWaterSummary", ballastWaterSummary).append("cabotageIndicator", cabotageIndicator).append("carrierParty", carrierParty).append("crewMemberPerson", crewMemberPerson).append("crewPersonEffect", crewPersonEffect).append("crewQuantity", crewQuantity).append("customsAgentParty", customsAgentParty).append("deliveryTransportEvent", deliveryTransportEvent).append("demurrageInstructions", demurrageInstructions).append("destinationPortCall", destinationPortCall).append("detentionTransportEvent", detentionTransportEvent).append("dischargeTransportEvent", dischargeTransportEvent).append("driverPerson", driverPerson).append("dropoffTransportEvent", dropoffTransportEvent).append("estimatedArrivalTransportEvent", estimatedArrivalTransportEvent).append("estimatedDeliveryDate", estimatedDeliveryDate).append("estimatedDeliveryTime", estimatedDeliveryTime).append("estimatedDepartureTransportEvent", estimatedDepartureTransportEvent).append("estimatedTransitPeriod", estimatedTransitPeriod).append("examinationTransportEvent", examinationTransportEvent).append("exportationTransportEvent", exportationTransportEvent).append("freightAllowanceCharge", freightAllowanceCharge).append("freightChargeLocation", freightChargeLocation).append("fuelConsumption", fuelConsumption).append("hazardousRiskIndicator", hazardousRiskIndicator).append("id", id).append("instructions", instructions).append("ispsRequirements", ispsRequirements).append("loadingPortLocation", loadingPortLocation).append("loadingSequenceID", loadingSequenceID).append("loadingTransportEvent", loadingTransportEvent).append("maritimeHealthDeclaration", maritimeHealthDeclaration).append("maritimeWaste", maritimeWaste).append("masterPerson", masterPerson).append("onCarriageIndicator", onCarriageIndicator).append("optionalTakeoverTransportEvent", optionalTakeoverTransportEvent).append("passengerPerson", passengerPerson).append("passengerQuantity", passengerQuantity).append("plannedArrivalTransportEvent", plannedArrivalTransportEvent).append("plannedDepartureTransportEvent", plannedDepartureTransportEvent).append("plannedWaypointTransportEvent", plannedWaypointTransportEvent).append("preCarriageIndicator", preCarriageIndicator).append("receiptTransportEvent", receiptTransportEvent).append("reportingPerson", reportingPerson).append("requestedArrivalTransportEvent", requestedArrivalTransportEvent).append("requestedDepartureTransportEvent", requestedDepartureTransportEvent).append("requestedWaypointTransportEvent", requestedWaypointTransportEvent).append("requiredDeliveryDate", requiredDeliveryDate).append("requiredDeliveryTime", requiredDeliveryTime).append("securityOfficerPerson", securityOfficerPerson).append("shipStoreArticle", shipStoreArticle).append("shipmentStageType", shipmentStageType).append("shipmentStageTypeCode", shipmentStageTypeCode).append("shipsSurgeonPerson", shipsSurgeonPerson).append("storageTransportEvent", storageTransportEvent).append("successiveSequenceID", successiveSequenceID).append("takeoverTransportEvent", takeoverTransportEvent).append("terminalOperatorParty", terminalOperatorParty).append("transitDirectionCode", transitDirectionCode).append("transitPeriod", transitPeriod).append("transportEvent", transportEvent).append("transportMeans", transportMeans).append("transportMeansTypeCode", transportMeansTypeCode).append("transportModeCode", transportModeCode).append("transshipPortLocation", transshipPortLocation).append("ublExtensions", ublExtensions).append("unloadingPortLocation", unloadingPortLocation).append("warehousingTransportEvent", warehousingTransportEvent).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setShipmentStageType(
        @Nullable
        final List<ShipmentStageTypeType> aList) {
        shipmentStageType = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setInstructions(
        @Nullable
        final List<InstructionsType> aList) {
        instructions = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDemurrageInstructions(
        @Nullable
        final List<DemurrageInstructionsType> aList) {
        demurrageInstructions = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCarrierParty(
        @Nullable
        final List<PartyType> aList) {
        carrierParty = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setFreightAllowanceCharge(
        @Nullable
        final List<AllowanceChargeType> aList) {
        freightAllowanceCharge = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDetentionTransportEvent(
        @Nullable
        final List<TransportEventType> aList) {
        detentionTransportEvent = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setRequestedWaypointTransportEvent(
        @Nullable
        final List<TransportEventType> aList) {
        requestedWaypointTransportEvent = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPlannedWaypointTransportEvent(
        @Nullable
        final List<TransportEventType> aList) {
        plannedWaypointTransportEvent = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTransportEvent(
        @Nullable
        final List<TransportEventType> aList) {
        transportEvent = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPassengerPerson(
        @Nullable
        final List<PersonType> aList) {
        passengerPerson = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDriverPerson(
        @Nullable
        final List<PersonType> aList) {
        driverPerson = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCrewMemberPerson(
        @Nullable
        final List<PersonType> aList) {
        crewMemberPerson = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setShipStoreArticle(
        @Nullable
        final List<ShipStoreArticleType> aList) {
        shipStoreArticle = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCrewPersonEffect(
        @Nullable
        final List<CrewPersonEffectType> aList) {
        crewPersonEffect = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setMaritimeWaste(
        @Nullable
        final List<MaritimeWasteType> aList) {
        maritimeWaste = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setFuelConsumption(
        @Nullable
        final List<FuelConsumptionType> aList) {
        fuelConsumption = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasShipmentStageTypeEntries() {
        return (!getShipmentStageType().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoShipmentStageTypeEntries() {
        return getShipmentStageType().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getShipmentStageTypeCount() {
        return getShipmentStageType().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ShipmentStageTypeType getShipmentStageTypeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getShipmentStageType().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addShipmentStageType(
        @Nonnull
        final ShipmentStageTypeType elem) {
        getShipmentStageType().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasInstructionsEntries() {
        return (!getInstructions().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoInstructionsEntries() {
        return getInstructions().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getInstructionsCount() {
        return getInstructions().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public InstructionsType getInstructionsAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getInstructions().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addInstructions(
        @Nonnull
        final InstructionsType elem) {
        getInstructions().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDemurrageInstructionsEntries() {
        return (!getDemurrageInstructions().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDemurrageInstructionsEntries() {
        return getDemurrageInstructions().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDemurrageInstructionsCount() {
        return getDemurrageInstructions().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DemurrageInstructionsType getDemurrageInstructionsAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDemurrageInstructions().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDemurrageInstructions(
        @Nonnull
        final DemurrageInstructionsType elem) {
        getDemurrageInstructions().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCarrierPartyEntries() {
        return (!getCarrierParty().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCarrierPartyEntries() {
        return getCarrierParty().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCarrierPartyCount() {
        return getCarrierParty().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PartyType getCarrierPartyAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCarrierParty().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCarrierParty(
        @Nonnull
        final PartyType elem) {
        getCarrierParty().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasFreightAllowanceChargeEntries() {
        return (!getFreightAllowanceCharge().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoFreightAllowanceChargeEntries() {
        return getFreightAllowanceCharge().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getFreightAllowanceChargeCount() {
        return getFreightAllowanceCharge().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AllowanceChargeType getFreightAllowanceChargeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getFreightAllowanceCharge().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addFreightAllowanceCharge(
        @Nonnull
        final AllowanceChargeType elem) {
        getFreightAllowanceCharge().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDetentionTransportEventEntries() {
        return (!getDetentionTransportEvent().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDetentionTransportEventEntries() {
        return getDetentionTransportEvent().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDetentionTransportEventCount() {
        return getDetentionTransportEvent().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TransportEventType getDetentionTransportEventAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDetentionTransportEvent().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDetentionTransportEvent(
        @Nonnull
        final TransportEventType elem) {
        getDetentionTransportEvent().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasRequestedWaypointTransportEventEntries() {
        return (!getRequestedWaypointTransportEvent().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoRequestedWaypointTransportEventEntries() {
        return getRequestedWaypointTransportEvent().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getRequestedWaypointTransportEventCount() {
        return getRequestedWaypointTransportEvent().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TransportEventType getRequestedWaypointTransportEventAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getRequestedWaypointTransportEvent().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addRequestedWaypointTransportEvent(
        @Nonnull
        final TransportEventType elem) {
        getRequestedWaypointTransportEvent().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPlannedWaypointTransportEventEntries() {
        return (!getPlannedWaypointTransportEvent().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPlannedWaypointTransportEventEntries() {
        return getPlannedWaypointTransportEvent().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPlannedWaypointTransportEventCount() {
        return getPlannedWaypointTransportEvent().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TransportEventType getPlannedWaypointTransportEventAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPlannedWaypointTransportEvent().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPlannedWaypointTransportEvent(
        @Nonnull
        final TransportEventType elem) {
        getPlannedWaypointTransportEvent().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTransportEventEntries() {
        return (!getTransportEvent().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTransportEventEntries() {
        return getTransportEvent().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTransportEventCount() {
        return getTransportEvent().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TransportEventType getTransportEventAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTransportEvent().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTransportEvent(
        @Nonnull
        final TransportEventType elem) {
        getTransportEvent().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPassengerPersonEntries() {
        return (!getPassengerPerson().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPassengerPersonEntries() {
        return getPassengerPerson().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPassengerPersonCount() {
        return getPassengerPerson().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PersonType getPassengerPersonAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPassengerPerson().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPassengerPerson(
        @Nonnull
        final PersonType elem) {
        getPassengerPerson().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDriverPersonEntries() {
        return (!getDriverPerson().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDriverPersonEntries() {
        return getDriverPerson().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDriverPersonCount() {
        return getDriverPerson().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PersonType getDriverPersonAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDriverPerson().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDriverPerson(
        @Nonnull
        final PersonType elem) {
        getDriverPerson().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCrewMemberPersonEntries() {
        return (!getCrewMemberPerson().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCrewMemberPersonEntries() {
        return getCrewMemberPerson().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCrewMemberPersonCount() {
        return getCrewMemberPerson().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PersonType getCrewMemberPersonAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCrewMemberPerson().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCrewMemberPerson(
        @Nonnull
        final PersonType elem) {
        getCrewMemberPerson().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasShipStoreArticleEntries() {
        return (!getShipStoreArticle().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoShipStoreArticleEntries() {
        return getShipStoreArticle().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getShipStoreArticleCount() {
        return getShipStoreArticle().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ShipStoreArticleType getShipStoreArticleAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getShipStoreArticle().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addShipStoreArticle(
        @Nonnull
        final ShipStoreArticleType elem) {
        getShipStoreArticle().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCrewPersonEffectEntries() {
        return (!getCrewPersonEffect().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCrewPersonEffectEntries() {
        return getCrewPersonEffect().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCrewPersonEffectCount() {
        return getCrewPersonEffect().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CrewPersonEffectType getCrewPersonEffectAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCrewPersonEffect().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCrewPersonEffect(
        @Nonnull
        final CrewPersonEffectType elem) {
        getCrewPersonEffect().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasMaritimeWasteEntries() {
        return (!getMaritimeWaste().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoMaritimeWasteEntries() {
        return getMaritimeWaste().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getMaritimeWasteCount() {
        return getMaritimeWaste().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public MaritimeWasteType getMaritimeWasteAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getMaritimeWaste().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addMaritimeWaste(
        @Nonnull
        final MaritimeWasteType elem) {
        getMaritimeWaste().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasFuelConsumptionEntries() {
        return (!getFuelConsumption().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoFuelConsumptionEntries() {
        return getFuelConsumption().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getFuelConsumptionCount() {
        return getFuelConsumption().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public FuelConsumptionType getFuelConsumptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getFuelConsumption().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addFuelConsumption(
        @Nonnull
        final FuelConsumptionType elem) {
        getFuelConsumption().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        ShipmentStageType ret) {
        ret.acceptanceTransportEvent = ((acceptanceTransportEvent == null)?null:acceptanceTransportEvent.clone());
        ret.actualArrivalTransportEvent = ((actualArrivalTransportEvent == null)?null:actualArrivalTransportEvent.clone());
        ret.actualDepartureTransportEvent = ((actualDepartureTransportEvent == null)?null:actualDepartureTransportEvent.clone());
        ret.actualPickupTransportEvent = ((actualPickupTransportEvent == null)?null:actualPickupTransportEvent.clone());
        ret.actualWaypointTransportEvent = ((actualWaypointTransportEvent == null)?null:actualWaypointTransportEvent.clone());
        ret.availabilityTransportEvent = ((availabilityTransportEvent == null)?null:availabilityTransportEvent.clone());
        ret.ballastWaterSummary = ((ballastWaterSummary == null)?null:ballastWaterSummary.clone());
        ret.cabotageIndicator = ((cabotageIndicator == null)?null:cabotageIndicator.clone());
        if (carrierParty == null) {
            ret.carrierParty = null;
        } else {
            List<PartyType> retCarrierParty = new ArrayList<>();
            for (PartyType aItem: getCarrierParty()) {
                retCarrierParty.add(((aItem == null)?null:aItem.clone()));
            }
            ret.carrierParty = retCarrierParty;
        }
        if (crewMemberPerson == null) {
            ret.crewMemberPerson = null;
        } else {
            List<PersonType> retCrewMemberPerson = new ArrayList<>();
            for (PersonType aItem: getCrewMemberPerson()) {
                retCrewMemberPerson.add(((aItem == null)?null:aItem.clone()));
            }
            ret.crewMemberPerson = retCrewMemberPerson;
        }
        if (crewPersonEffect == null) {
            ret.crewPersonEffect = null;
        } else {
            List<CrewPersonEffectType> retCrewPersonEffect = new ArrayList<>();
            for (CrewPersonEffectType aItem: getCrewPersonEffect()) {
                retCrewPersonEffect.add(((aItem == null)?null:aItem.clone()));
            }
            ret.crewPersonEffect = retCrewPersonEffect;
        }
        ret.crewQuantity = ((crewQuantity == null)?null:crewQuantity.clone());
        ret.customsAgentParty = ((customsAgentParty == null)?null:customsAgentParty.clone());
        ret.deliveryTransportEvent = ((deliveryTransportEvent == null)?null:deliveryTransportEvent.clone());
        if (demurrageInstructions == null) {
            ret.demurrageInstructions = null;
        } else {
            List<DemurrageInstructionsType> retDemurrageInstructions = new ArrayList<>();
            for (DemurrageInstructionsType aItem: getDemurrageInstructions()) {
                retDemurrageInstructions.add(((aItem == null)?null:aItem.clone()));
            }
            ret.demurrageInstructions = retDemurrageInstructions;
        }
        ret.destinationPortCall = ((destinationPortCall == null)?null:destinationPortCall.clone());
        if (detentionTransportEvent == null) {
            ret.detentionTransportEvent = null;
        } else {
            List<TransportEventType> retDetentionTransportEvent = new ArrayList<>();
            for (TransportEventType aItem: getDetentionTransportEvent()) {
                retDetentionTransportEvent.add(((aItem == null)?null:aItem.clone()));
            }
            ret.detentionTransportEvent = retDetentionTransportEvent;
        }
        ret.dischargeTransportEvent = ((dischargeTransportEvent == null)?null:dischargeTransportEvent.clone());
        if (driverPerson == null) {
            ret.driverPerson = null;
        } else {
            List<PersonType> retDriverPerson = new ArrayList<>();
            for (PersonType aItem: getDriverPerson()) {
                retDriverPerson.add(((aItem == null)?null:aItem.clone()));
            }
            ret.driverPerson = retDriverPerson;
        }
        ret.dropoffTransportEvent = ((dropoffTransportEvent == null)?null:dropoffTransportEvent.clone());
        ret.estimatedArrivalTransportEvent = ((estimatedArrivalTransportEvent == null)?null:estimatedArrivalTransportEvent.clone());
        ret.estimatedDeliveryDate = ((estimatedDeliveryDate == null)?null:estimatedDeliveryDate.clone());
        ret.estimatedDeliveryTime = ((estimatedDeliveryTime == null)?null:estimatedDeliveryTime.clone());
        ret.estimatedDepartureTransportEvent = ((estimatedDepartureTransportEvent == null)?null:estimatedDepartureTransportEvent.clone());
        ret.estimatedTransitPeriod = ((estimatedTransitPeriod == null)?null:estimatedTransitPeriod.clone());
        ret.examinationTransportEvent = ((examinationTransportEvent == null)?null:examinationTransportEvent.clone());
        ret.exportationTransportEvent = ((exportationTransportEvent == null)?null:exportationTransportEvent.clone());
        if (freightAllowanceCharge == null) {
            ret.freightAllowanceCharge = null;
        } else {
            List<AllowanceChargeType> retFreightAllowanceCharge = new ArrayList<>();
            for (AllowanceChargeType aItem: getFreightAllowanceCharge()) {
                retFreightAllowanceCharge.add(((aItem == null)?null:aItem.clone()));
            }
            ret.freightAllowanceCharge = retFreightAllowanceCharge;
        }
        ret.freightChargeLocation = ((freightChargeLocation == null)?null:freightChargeLocation.clone());
        if (fuelConsumption == null) {
            ret.fuelConsumption = null;
        } else {
            List<FuelConsumptionType> retFuelConsumption = new ArrayList<>();
            for (FuelConsumptionType aItem: getFuelConsumption()) {
                retFuelConsumption.add(((aItem == null)?null:aItem.clone()));
            }
            ret.fuelConsumption = retFuelConsumption;
        }
        ret.hazardousRiskIndicator = ((hazardousRiskIndicator == null)?null:hazardousRiskIndicator.clone());
        ret.id = ((id == null)?null:id.clone());
        if (instructions == null) {
            ret.instructions = null;
        } else {
            List<InstructionsType> retInstructions = new ArrayList<>();
            for (InstructionsType aItem: getInstructions()) {
                retInstructions.add(((aItem == null)?null:aItem.clone()));
            }
            ret.instructions = retInstructions;
        }
        ret.ispsRequirements = ((ispsRequirements == null)?null:ispsRequirements.clone());
        ret.loadingPortLocation = ((loadingPortLocation == null)?null:loadingPortLocation.clone());
        ret.loadingSequenceID = ((loadingSequenceID == null)?null:loadingSequenceID.clone());
        ret.loadingTransportEvent = ((loadingTransportEvent == null)?null:loadingTransportEvent.clone());
        ret.maritimeHealthDeclaration = ((maritimeHealthDeclaration == null)?null:maritimeHealthDeclaration.clone());
        if (maritimeWaste == null) {
            ret.maritimeWaste = null;
        } else {
            List<MaritimeWasteType> retMaritimeWaste = new ArrayList<>();
            for (MaritimeWasteType aItem: getMaritimeWaste()) {
                retMaritimeWaste.add(((aItem == null)?null:aItem.clone()));
            }
            ret.maritimeWaste = retMaritimeWaste;
        }
        ret.masterPerson = ((masterPerson == null)?null:masterPerson.clone());
        ret.onCarriageIndicator = ((onCarriageIndicator == null)?null:onCarriageIndicator.clone());
        ret.optionalTakeoverTransportEvent = ((optionalTakeoverTransportEvent == null)?null:optionalTakeoverTransportEvent.clone());
        if (passengerPerson == null) {
            ret.passengerPerson = null;
        } else {
            List<PersonType> retPassengerPerson = new ArrayList<>();
            for (PersonType aItem: getPassengerPerson()) {
                retPassengerPerson.add(((aItem == null)?null:aItem.clone()));
            }
            ret.passengerPerson = retPassengerPerson;
        }
        ret.passengerQuantity = ((passengerQuantity == null)?null:passengerQuantity.clone());
        ret.plannedArrivalTransportEvent = ((plannedArrivalTransportEvent == null)?null:plannedArrivalTransportEvent.clone());
        ret.plannedDepartureTransportEvent = ((plannedDepartureTransportEvent == null)?null:plannedDepartureTransportEvent.clone());
        if (plannedWaypointTransportEvent == null) {
            ret.plannedWaypointTransportEvent = null;
        } else {
            List<TransportEventType> retPlannedWaypointTransportEvent = new ArrayList<>();
            for (TransportEventType aItem: getPlannedWaypointTransportEvent()) {
                retPlannedWaypointTransportEvent.add(((aItem == null)?null:aItem.clone()));
            }
            ret.plannedWaypointTransportEvent = retPlannedWaypointTransportEvent;
        }
        ret.preCarriageIndicator = ((preCarriageIndicator == null)?null:preCarriageIndicator.clone());
        ret.receiptTransportEvent = ((receiptTransportEvent == null)?null:receiptTransportEvent.clone());
        ret.reportingPerson = ((reportingPerson == null)?null:reportingPerson.clone());
        ret.requestedArrivalTransportEvent = ((requestedArrivalTransportEvent == null)?null:requestedArrivalTransportEvent.clone());
        ret.requestedDepartureTransportEvent = ((requestedDepartureTransportEvent == null)?null:requestedDepartureTransportEvent.clone());
        if (requestedWaypointTransportEvent == null) {
            ret.requestedWaypointTransportEvent = null;
        } else {
            List<TransportEventType> retRequestedWaypointTransportEvent = new ArrayList<>();
            for (TransportEventType aItem: getRequestedWaypointTransportEvent()) {
                retRequestedWaypointTransportEvent.add(((aItem == null)?null:aItem.clone()));
            }
            ret.requestedWaypointTransportEvent = retRequestedWaypointTransportEvent;
        }
        ret.requiredDeliveryDate = ((requiredDeliveryDate == null)?null:requiredDeliveryDate.clone());
        ret.requiredDeliveryTime = ((requiredDeliveryTime == null)?null:requiredDeliveryTime.clone());
        ret.securityOfficerPerson = ((securityOfficerPerson == null)?null:securityOfficerPerson.clone());
        if (shipStoreArticle == null) {
            ret.shipStoreArticle = null;
        } else {
            List<ShipStoreArticleType> retShipStoreArticle = new ArrayList<>();
            for (ShipStoreArticleType aItem: getShipStoreArticle()) {
                retShipStoreArticle.add(((aItem == null)?null:aItem.clone()));
            }
            ret.shipStoreArticle = retShipStoreArticle;
        }
        if (shipmentStageType == null) {
            ret.shipmentStageType = null;
        } else {
            List<ShipmentStageTypeType> retShipmentStageType = new ArrayList<>();
            for (ShipmentStageTypeType aItem: getShipmentStageType()) {
                retShipmentStageType.add(((aItem == null)?null:aItem.clone()));
            }
            ret.shipmentStageType = retShipmentStageType;
        }
        ret.shipmentStageTypeCode = ((shipmentStageTypeCode == null)?null:shipmentStageTypeCode.clone());
        ret.shipsSurgeonPerson = ((shipsSurgeonPerson == null)?null:shipsSurgeonPerson.clone());
        ret.storageTransportEvent = ((storageTransportEvent == null)?null:storageTransportEvent.clone());
        ret.successiveSequenceID = ((successiveSequenceID == null)?null:successiveSequenceID.clone());
        ret.takeoverTransportEvent = ((takeoverTransportEvent == null)?null:takeoverTransportEvent.clone());
        ret.terminalOperatorParty = ((terminalOperatorParty == null)?null:terminalOperatorParty.clone());
        ret.transitDirectionCode = ((transitDirectionCode == null)?null:transitDirectionCode.clone());
        ret.transitPeriod = ((transitPeriod == null)?null:transitPeriod.clone());
        if (transportEvent == null) {
            ret.transportEvent = null;
        } else {
            List<TransportEventType> retTransportEvent = new ArrayList<>();
            for (TransportEventType aItem: getTransportEvent()) {
                retTransportEvent.add(((aItem == null)?null:aItem.clone()));
            }
            ret.transportEvent = retTransportEvent;
        }
        ret.transportMeans = ((transportMeans == null)?null:transportMeans.clone());
        ret.transportMeansTypeCode = ((transportMeansTypeCode == null)?null:transportMeansTypeCode.clone());
        ret.transportModeCode = ((transportModeCode == null)?null:transportModeCode.clone());
        ret.transshipPortLocation = ((transshipPortLocation == null)?null:transshipPortLocation.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        ret.unloadingPortLocation = ((unloadingPortLocation == null)?null:unloadingPortLocation.clone());
        ret.warehousingTransportEvent = ((warehousingTransportEvent == null)?null:warehousingTransportEvent.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public ShipmentStageType clone() {
        ShipmentStageType ret = new ShipmentStageType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ShipmentStageTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public ShipmentStageTypeCodeType setShipmentStageTypeCode(
        @Nullable
        final String valueParam) {
        ShipmentStageTypeCodeType aObj = getShipmentStageTypeCode();
        if (aObj == null) {
            aObj = new ShipmentStageTypeCodeType(valueParam);
            setShipmentStageTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TransportModeCodeType and never <code>null</code>
     */
    @Nonnull
    public TransportModeCodeType setTransportModeCode(
        @Nullable
        final String valueParam) {
        TransportModeCodeType aObj = getTransportModeCode();
        if (aObj == null) {
            aObj = new TransportModeCodeType(valueParam);
            setTransportModeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TransportMeansTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public TransportMeansTypeCodeType setTransportMeansTypeCode(
        @Nullable
        final String valueParam) {
        TransportMeansTypeCodeType aObj = getTransportMeansTypeCode();
        if (aObj == null) {
            aObj = new TransportMeansTypeCodeType(valueParam);
            setTransportMeansTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TransitDirectionCodeType and never <code>null</code>
     */
    @Nonnull
    public TransitDirectionCodeType setTransitDirectionCode(
        @Nullable
        final String valueParam) {
        TransitDirectionCodeType aObj = getTransitDirectionCode();
        if (aObj == null) {
            aObj = new TransitDirectionCodeType(valueParam);
            setTransitDirectionCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type PreCarriageIndicatorType and never <code>null</code>
     */
    @Nonnull
    public PreCarriageIndicatorType setPreCarriageIndicator(final boolean valueParam) {
        PreCarriageIndicatorType aObj = getPreCarriageIndicator();
        if (aObj == null) {
            aObj = new PreCarriageIndicatorType(valueParam);
            setPreCarriageIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type OnCarriageIndicatorType and never <code>null</code>
     */
    @Nonnull
    public OnCarriageIndicatorType setOnCarriageIndicator(final boolean valueParam) {
        OnCarriageIndicatorType aObj = getOnCarriageIndicator();
        if (aObj == null) {
            aObj = new OnCarriageIndicatorType(valueParam);
            setOnCarriageIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type CabotageIndicatorType and never <code>null</code>
     */
    @Nonnull
    public CabotageIndicatorType setCabotageIndicator(final boolean valueParam) {
        CabotageIndicatorType aObj = getCabotageIndicator();
        if (aObj == null) {
            aObj = new CabotageIndicatorType(valueParam);
            setCabotageIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type HazardousRiskIndicatorType and never <code>null</code>
     */
    @Nonnull
    public HazardousRiskIndicatorType setHazardousRiskIndicator(final boolean valueParam) {
        HazardousRiskIndicatorType aObj = getHazardousRiskIndicator();
        if (aObj == null) {
            aObj = new HazardousRiskIndicatorType(valueParam);
            setHazardousRiskIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EstimatedDeliveryDateType and never <code>null</code>
     */
    @Nonnull
    public EstimatedDeliveryDateType setEstimatedDeliveryDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        EstimatedDeliveryDateType aObj = getEstimatedDeliveryDate();
        if (aObj == null) {
            aObj = new EstimatedDeliveryDateType(valueParam);
            setEstimatedDeliveryDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EstimatedDeliveryDateType and never <code>null</code>
     */
    @Nonnull
    public EstimatedDeliveryDateType setEstimatedDeliveryDate(
        @Nullable
        final LocalDate valueParam) {
        EstimatedDeliveryDateType aObj = getEstimatedDeliveryDate();
        if (aObj == null) {
            aObj = new EstimatedDeliveryDateType(valueParam);
            setEstimatedDeliveryDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EstimatedDeliveryTimeType and never <code>null</code>
     */
    @Nonnull
    public EstimatedDeliveryTimeType setEstimatedDeliveryTime(
        @Nullable
        final XMLOffsetTime valueParam) {
        EstimatedDeliveryTimeType aObj = getEstimatedDeliveryTime();
        if (aObj == null) {
            aObj = new EstimatedDeliveryTimeType(valueParam);
            setEstimatedDeliveryTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EstimatedDeliveryTimeType and never <code>null</code>
     */
    @Nonnull
    public EstimatedDeliveryTimeType setEstimatedDeliveryTime(
        @Nullable
        final LocalTime valueParam) {
        EstimatedDeliveryTimeType aObj = getEstimatedDeliveryTime();
        if (aObj == null) {
            aObj = new EstimatedDeliveryTimeType(valueParam);
            setEstimatedDeliveryTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RequiredDeliveryDateType and never <code>null</code>
     */
    @Nonnull
    public RequiredDeliveryDateType setRequiredDeliveryDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        RequiredDeliveryDateType aObj = getRequiredDeliveryDate();
        if (aObj == null) {
            aObj = new RequiredDeliveryDateType(valueParam);
            setRequiredDeliveryDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RequiredDeliveryDateType and never <code>null</code>
     */
    @Nonnull
    public RequiredDeliveryDateType setRequiredDeliveryDate(
        @Nullable
        final LocalDate valueParam) {
        RequiredDeliveryDateType aObj = getRequiredDeliveryDate();
        if (aObj == null) {
            aObj = new RequiredDeliveryDateType(valueParam);
            setRequiredDeliveryDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RequiredDeliveryTimeType and never <code>null</code>
     */
    @Nonnull
    public RequiredDeliveryTimeType setRequiredDeliveryTime(
        @Nullable
        final XMLOffsetTime valueParam) {
        RequiredDeliveryTimeType aObj = getRequiredDeliveryTime();
        if (aObj == null) {
            aObj = new RequiredDeliveryTimeType(valueParam);
            setRequiredDeliveryTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RequiredDeliveryTimeType and never <code>null</code>
     */
    @Nonnull
    public RequiredDeliveryTimeType setRequiredDeliveryTime(
        @Nullable
        final LocalTime valueParam) {
        RequiredDeliveryTimeType aObj = getRequiredDeliveryTime();
        if (aObj == null) {
            aObj = new RequiredDeliveryTimeType(valueParam);
            setRequiredDeliveryTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type LoadingSequenceIDType and never <code>null</code>
     */
    @Nonnull
    public LoadingSequenceIDType setLoadingSequenceID(
        @Nullable
        final String valueParam) {
        LoadingSequenceIDType aObj = getLoadingSequenceID();
        if (aObj == null) {
            aObj = new LoadingSequenceIDType(valueParam);
            setLoadingSequenceID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SuccessiveSequenceIDType and never <code>null</code>
     */
    @Nonnull
    public SuccessiveSequenceIDType setSuccessiveSequenceID(
        @Nullable
        final String valueParam) {
        SuccessiveSequenceIDType aObj = getSuccessiveSequenceID();
        if (aObj == null) {
            aObj = new SuccessiveSequenceIDType(valueParam);
            setSuccessiveSequenceID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CrewQuantityType and never <code>null</code>
     */
    @Nonnull
    public CrewQuantityType setCrewQuantity(
        @Nullable
        final BigDecimal valueParam) {
        CrewQuantityType aObj = getCrewQuantity();
        if (aObj == null) {
            aObj = new CrewQuantityType(valueParam);
            setCrewQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PassengerQuantityType and never <code>null</code>
     */
    @Nonnull
    public PassengerQuantityType setPassengerQuantity(
        @Nullable
        final BigDecimal valueParam) {
        PassengerQuantityType aObj = getPassengerQuantity();
        if (aObj == null) {
            aObj = new PassengerQuantityType(valueParam);
            setPassengerQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ShipmentStageTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ShipmentStageTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getShipmentStageTypeCodeValue() {
        ShipmentStageTypeCodeType aObj = getShipmentStageTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TransportModeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TransportModeCodeType object or <code>null</code>
     */
    @Nullable
    public String getTransportModeCodeValue() {
        TransportModeCodeType aObj = getTransportModeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TransportMeansTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TransportMeansTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getTransportMeansTypeCodeValue() {
        TransportMeansTypeCodeType aObj = getTransportMeansTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TransitDirectionCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TransitDirectionCodeType object or <code>null</code>
     */
    @Nullable
    public String getTransitDirectionCodeValue() {
        TransitDirectionCodeType aObj = getTransitDirectionCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PreCarriageIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained PreCarriageIndicatorType object or the passed nullValue
     */
    public boolean isPreCarriageIndicatorValue(final boolean nullValue) {
        PreCarriageIndicatorType aObj = getPreCarriageIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained OnCarriageIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained OnCarriageIndicatorType object or the passed nullValue
     */
    public boolean isOnCarriageIndicatorValue(final boolean nullValue) {
        OnCarriageIndicatorType aObj = getOnCarriageIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained CabotageIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained CabotageIndicatorType object or the passed nullValue
     */
    public boolean isCabotageIndicatorValue(final boolean nullValue) {
        CabotageIndicatorType aObj = getCabotageIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained HazardousRiskIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained HazardousRiskIndicatorType object or the passed nullValue
     */
    public boolean isHazardousRiskIndicatorValue(final boolean nullValue) {
        HazardousRiskIndicatorType aObj = getHazardousRiskIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained EstimatedDeliveryDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EstimatedDeliveryDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getEstimatedDeliveryDateValue() {
        EstimatedDeliveryDateType aObj = getEstimatedDeliveryDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained EstimatedDeliveryDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EstimatedDeliveryDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getEstimatedDeliveryDateValueLocal() {
        EstimatedDeliveryDateType aObj = getEstimatedDeliveryDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained EstimatedDeliveryTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EstimatedDeliveryTimeType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetTime getEstimatedDeliveryTimeValue() {
        EstimatedDeliveryTimeType aObj = getEstimatedDeliveryTime();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained EstimatedDeliveryTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EstimatedDeliveryTimeType object or <code>null</code>
     */
    @Nullable
    public LocalTime getEstimatedDeliveryTimeValueLocal() {
        EstimatedDeliveryTimeType aObj = getEstimatedDeliveryTime();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained RequiredDeliveryDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RequiredDeliveryDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getRequiredDeliveryDateValue() {
        RequiredDeliveryDateType aObj = getRequiredDeliveryDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained RequiredDeliveryDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RequiredDeliveryDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getRequiredDeliveryDateValueLocal() {
        RequiredDeliveryDateType aObj = getRequiredDeliveryDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained RequiredDeliveryTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RequiredDeliveryTimeType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetTime getRequiredDeliveryTimeValue() {
        RequiredDeliveryTimeType aObj = getRequiredDeliveryTime();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained RequiredDeliveryTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RequiredDeliveryTimeType object or <code>null</code>
     */
    @Nullable
    public LocalTime getRequiredDeliveryTimeValueLocal() {
        RequiredDeliveryTimeType aObj = getRequiredDeliveryTime();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained LoadingSequenceIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained LoadingSequenceIDType object or <code>null</code>
     */
    @Nullable
    public String getLoadingSequenceIDValue() {
        LoadingSequenceIDType aObj = getLoadingSequenceID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained SuccessiveSequenceIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SuccessiveSequenceIDType object or <code>null</code>
     */
    @Nullable
    public String getSuccessiveSequenceIDValue() {
        SuccessiveSequenceIDType aObj = getSuccessiveSequenceID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CrewQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CrewQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getCrewQuantityValue() {
        CrewQuantityType aObj = getCrewQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PassengerQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PassengerQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getPassengerQuantityValue() {
        PassengerQuantityType aObj = getPassengerQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

}
