
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.AirFlowPercentType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.AnimalFoodApprovedIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.DangerousGoodsApprovedIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.GateIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.HumanFoodApprovedIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.HumidityPercentType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.NameType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PowerIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.RefrigeratedIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for StorageType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="StorageType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Name" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}GateID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}AirFlowPercent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}HumidityPercent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}AnimalFoodApprovedIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}HumanFoodApprovedIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}DangerousGoodsApprovedIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RefrigeratedIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PowerIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}MinimumTemperature" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}MaximumTemperature" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Certificate" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "StorageType", propOrder = {
    "ublExtensions",
    "id",
    "name",
    "gateID",
    "airFlowPercent",
    "humidityPercent",
    "animalFoodApprovedIndicator",
    "humanFoodApprovedIndicator",
    "dangerousGoodsApprovedIndicator",
    "refrigeratedIndicator",
    "powerIndicator",
    "minimumTemperature",
    "maximumTemperature",
    "certificate"
})
@CodingStyleguideUnaware
public class StorageType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private IDType id;
    @XmlElement(name = "Name", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private NameType name;
    @XmlElement(name = "GateID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private GateIDType gateID;
    @XmlElement(name = "AirFlowPercent", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private AirFlowPercentType airFlowPercent;
    @XmlElement(name = "HumidityPercent", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private HumidityPercentType humidityPercent;
    @XmlElement(name = "AnimalFoodApprovedIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private AnimalFoodApprovedIndicatorType animalFoodApprovedIndicator;
    @XmlElement(name = "HumanFoodApprovedIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private HumanFoodApprovedIndicatorType humanFoodApprovedIndicator;
    @XmlElement(name = "DangerousGoodsApprovedIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private DangerousGoodsApprovedIndicatorType dangerousGoodsApprovedIndicator;
    @XmlElement(name = "RefrigeratedIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private RefrigeratedIndicatorType refrigeratedIndicator;
    @XmlElement(name = "PowerIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PowerIndicatorType powerIndicator;
    @XmlElement(name = "MinimumTemperature")
    private TemperatureType minimumTemperature;
    @XmlElement(name = "MaximumTemperature")
    private TemperatureType maximumTemperature;
    @XmlElement(name = "Certificate")
    private List<CertificateType> certificate;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public StorageType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link NameType }
     *     
     */
    @Nullable
    public NameType getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link NameType }
     *     
     */
    public void setName(
        @Nullable
        NameType value) {
        this.name = value;
    }

    /**
     * Gets the value of the gateID property.
     * 
     * @return
     *     possible object is
     *     {@link GateIDType }
     *     
     */
    @Nullable
    public GateIDType getGateID() {
        return gateID;
    }

    /**
     * Sets the value of the gateID property.
     * 
     * @param value
     *     allowed object is
     *     {@link GateIDType }
     *     
     */
    public void setGateID(
        @Nullable
        GateIDType value) {
        this.gateID = value;
    }

    /**
     * Gets the value of the airFlowPercent property.
     * 
     * @return
     *     possible object is
     *     {@link AirFlowPercentType }
     *     
     */
    @Nullable
    public AirFlowPercentType getAirFlowPercent() {
        return airFlowPercent;
    }

    /**
     * Sets the value of the airFlowPercent property.
     * 
     * @param value
     *     allowed object is
     *     {@link AirFlowPercentType }
     *     
     */
    public void setAirFlowPercent(
        @Nullable
        AirFlowPercentType value) {
        this.airFlowPercent = value;
    }

    /**
     * Gets the value of the humidityPercent property.
     * 
     * @return
     *     possible object is
     *     {@link HumidityPercentType }
     *     
     */
    @Nullable
    public HumidityPercentType getHumidityPercent() {
        return humidityPercent;
    }

    /**
     * Sets the value of the humidityPercent property.
     * 
     * @param value
     *     allowed object is
     *     {@link HumidityPercentType }
     *     
     */
    public void setHumidityPercent(
        @Nullable
        HumidityPercentType value) {
        this.humidityPercent = value;
    }

    /**
     * Gets the value of the animalFoodApprovedIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link AnimalFoodApprovedIndicatorType }
     *     
     */
    @Nullable
    public AnimalFoodApprovedIndicatorType getAnimalFoodApprovedIndicator() {
        return animalFoodApprovedIndicator;
    }

    /**
     * Sets the value of the animalFoodApprovedIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link AnimalFoodApprovedIndicatorType }
     *     
     */
    public void setAnimalFoodApprovedIndicator(
        @Nullable
        AnimalFoodApprovedIndicatorType value) {
        this.animalFoodApprovedIndicator = value;
    }

    /**
     * Gets the value of the humanFoodApprovedIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link HumanFoodApprovedIndicatorType }
     *     
     */
    @Nullable
    public HumanFoodApprovedIndicatorType getHumanFoodApprovedIndicator() {
        return humanFoodApprovedIndicator;
    }

    /**
     * Sets the value of the humanFoodApprovedIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link HumanFoodApprovedIndicatorType }
     *     
     */
    public void setHumanFoodApprovedIndicator(
        @Nullable
        HumanFoodApprovedIndicatorType value) {
        this.humanFoodApprovedIndicator = value;
    }

    /**
     * Gets the value of the dangerousGoodsApprovedIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link DangerousGoodsApprovedIndicatorType }
     *     
     */
    @Nullable
    public DangerousGoodsApprovedIndicatorType getDangerousGoodsApprovedIndicator() {
        return dangerousGoodsApprovedIndicator;
    }

    /**
     * Sets the value of the dangerousGoodsApprovedIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link DangerousGoodsApprovedIndicatorType }
     *     
     */
    public void setDangerousGoodsApprovedIndicator(
        @Nullable
        DangerousGoodsApprovedIndicatorType value) {
        this.dangerousGoodsApprovedIndicator = value;
    }

    /**
     * Gets the value of the refrigeratedIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link RefrigeratedIndicatorType }
     *     
     */
    @Nullable
    public RefrigeratedIndicatorType getRefrigeratedIndicator() {
        return refrigeratedIndicator;
    }

    /**
     * Sets the value of the refrigeratedIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link RefrigeratedIndicatorType }
     *     
     */
    public void setRefrigeratedIndicator(
        @Nullable
        RefrigeratedIndicatorType value) {
        this.refrigeratedIndicator = value;
    }

    /**
     * Gets the value of the powerIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link PowerIndicatorType }
     *     
     */
    @Nullable
    public PowerIndicatorType getPowerIndicator() {
        return powerIndicator;
    }

    /**
     * Sets the value of the powerIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link PowerIndicatorType }
     *     
     */
    public void setPowerIndicator(
        @Nullable
        PowerIndicatorType value) {
        this.powerIndicator = value;
    }

    /**
     * Gets the value of the minimumTemperature property.
     * 
     * @return
     *     possible object is
     *     {@link TemperatureType }
     *     
     */
    @Nullable
    public TemperatureType getMinimumTemperature() {
        return minimumTemperature;
    }

    /**
     * Sets the value of the minimumTemperature property.
     * 
     * @param value
     *     allowed object is
     *     {@link TemperatureType }
     *     
     */
    public void setMinimumTemperature(
        @Nullable
        TemperatureType value) {
        this.minimumTemperature = value;
    }

    /**
     * Gets the value of the maximumTemperature property.
     * 
     * @return
     *     possible object is
     *     {@link TemperatureType }
     *     
     */
    @Nullable
    public TemperatureType getMaximumTemperature() {
        return maximumTemperature;
    }

    /**
     * Sets the value of the maximumTemperature property.
     * 
     * @param value
     *     allowed object is
     *     {@link TemperatureType }
     *     
     */
    public void setMaximumTemperature(
        @Nullable
        TemperatureType value) {
        this.maximumTemperature = value;
    }

    /**
     * Gets the value of the certificate property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the certificate property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getCertificate().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CertificateType }
     * </p>
     * 
     * 
     * @return
     *     The value of the certificate property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CertificateType> getCertificate() {
        if (certificate == null) {
            certificate = new ArrayList<>();
        }
        return this.certificate;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final StorageType rhs = ((StorageType) o);
        if (!EqualsHelper.equals(airFlowPercent, rhs.airFlowPercent)) {
            return false;
        }
        if (!EqualsHelper.equals(animalFoodApprovedIndicator, rhs.animalFoodApprovedIndicator)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(certificate, rhs.certificate)) {
            return false;
        }
        if (!EqualsHelper.equals(dangerousGoodsApprovedIndicator, rhs.dangerousGoodsApprovedIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(gateID, rhs.gateID)) {
            return false;
        }
        if (!EqualsHelper.equals(humanFoodApprovedIndicator, rhs.humanFoodApprovedIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(humidityPercent, rhs.humidityPercent)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(maximumTemperature, rhs.maximumTemperature)) {
            return false;
        }
        if (!EqualsHelper.equals(minimumTemperature, rhs.minimumTemperature)) {
            return false;
        }
        if (!EqualsHelper.equals(name, rhs.name)) {
            return false;
        }
        if (!EqualsHelper.equals(powerIndicator, rhs.powerIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(refrigeratedIndicator, rhs.refrigeratedIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(airFlowPercent).append(animalFoodApprovedIndicator).append(certificate).append(dangerousGoodsApprovedIndicator).append(gateID).append(humanFoodApprovedIndicator).append(humidityPercent).append(id).append(maximumTemperature).append(minimumTemperature).append(name).append(powerIndicator).append(refrigeratedIndicator).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("airFlowPercent", airFlowPercent).append("animalFoodApprovedIndicator", animalFoodApprovedIndicator).append("certificate", certificate).append("dangerousGoodsApprovedIndicator", dangerousGoodsApprovedIndicator).append("gateID", gateID).append("humanFoodApprovedIndicator", humanFoodApprovedIndicator).append("humidityPercent", humidityPercent).append("id", id).append("maximumTemperature", maximumTemperature).append("minimumTemperature", minimumTemperature).append("name", name).append("powerIndicator", powerIndicator).append("refrigeratedIndicator", refrigeratedIndicator).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCertificate(
        @Nullable
        final List<CertificateType> aList) {
        certificate = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCertificateEntries() {
        return (!getCertificate().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCertificateEntries() {
        return getCertificate().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCertificateCount() {
        return getCertificate().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CertificateType getCertificateAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCertificate().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCertificate(
        @Nonnull
        final CertificateType elem) {
        getCertificate().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        StorageType ret) {
        ret.airFlowPercent = ((airFlowPercent == null)?null:airFlowPercent.clone());
        ret.animalFoodApprovedIndicator = ((animalFoodApprovedIndicator == null)?null:animalFoodApprovedIndicator.clone());
        if (certificate == null) {
            ret.certificate = null;
        } else {
            List<CertificateType> retCertificate = new ArrayList<>();
            for (CertificateType aItem: getCertificate()) {
                retCertificate.add(((aItem == null)?null:aItem.clone()));
            }
            ret.certificate = retCertificate;
        }
        ret.dangerousGoodsApprovedIndicator = ((dangerousGoodsApprovedIndicator == null)?null:dangerousGoodsApprovedIndicator.clone());
        ret.gateID = ((gateID == null)?null:gateID.clone());
        ret.humanFoodApprovedIndicator = ((humanFoodApprovedIndicator == null)?null:humanFoodApprovedIndicator.clone());
        ret.humidityPercent = ((humidityPercent == null)?null:humidityPercent.clone());
        ret.id = ((id == null)?null:id.clone());
        ret.maximumTemperature = ((maximumTemperature == null)?null:maximumTemperature.clone());
        ret.minimumTemperature = ((minimumTemperature == null)?null:minimumTemperature.clone());
        ret.name = ((name == null)?null:name.clone());
        ret.powerIndicator = ((powerIndicator == null)?null:powerIndicator.clone());
        ret.refrigeratedIndicator = ((refrigeratedIndicator == null)?null:refrigeratedIndicator.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public StorageType clone() {
        StorageType ret = new StorageType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NameType and never <code>null</code>
     */
    @Nonnull
    public NameType setName(
        @Nullable
        final String valueParam) {
        NameType aObj = getName();
        if (aObj == null) {
            aObj = new NameType(valueParam);
            setName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type GateIDType and never <code>null</code>
     */
    @Nonnull
    public GateIDType setGateID(
        @Nullable
        final String valueParam) {
        GateIDType aObj = getGateID();
        if (aObj == null) {
            aObj = new GateIDType(valueParam);
            setGateID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AirFlowPercentType and never <code>null</code>
     */
    @Nonnull
    public AirFlowPercentType setAirFlowPercent(
        @Nullable
        final BigDecimal valueParam) {
        AirFlowPercentType aObj = getAirFlowPercent();
        if (aObj == null) {
            aObj = new AirFlowPercentType(valueParam);
            setAirFlowPercent(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type HumidityPercentType and never <code>null</code>
     */
    @Nonnull
    public HumidityPercentType setHumidityPercent(
        @Nullable
        final BigDecimal valueParam) {
        HumidityPercentType aObj = getHumidityPercent();
        if (aObj == null) {
            aObj = new HumidityPercentType(valueParam);
            setHumidityPercent(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type AnimalFoodApprovedIndicatorType and never <code>null</code>
     */
    @Nonnull
    public AnimalFoodApprovedIndicatorType setAnimalFoodApprovedIndicator(final boolean valueParam) {
        AnimalFoodApprovedIndicatorType aObj = getAnimalFoodApprovedIndicator();
        if (aObj == null) {
            aObj = new AnimalFoodApprovedIndicatorType(valueParam);
            setAnimalFoodApprovedIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type HumanFoodApprovedIndicatorType and never <code>null</code>
     */
    @Nonnull
    public HumanFoodApprovedIndicatorType setHumanFoodApprovedIndicator(final boolean valueParam) {
        HumanFoodApprovedIndicatorType aObj = getHumanFoodApprovedIndicator();
        if (aObj == null) {
            aObj = new HumanFoodApprovedIndicatorType(valueParam);
            setHumanFoodApprovedIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type DangerousGoodsApprovedIndicatorType and never <code>null</code>
     */
    @Nonnull
    public DangerousGoodsApprovedIndicatorType setDangerousGoodsApprovedIndicator(final boolean valueParam) {
        DangerousGoodsApprovedIndicatorType aObj = getDangerousGoodsApprovedIndicator();
        if (aObj == null) {
            aObj = new DangerousGoodsApprovedIndicatorType(valueParam);
            setDangerousGoodsApprovedIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type RefrigeratedIndicatorType and never <code>null</code>
     */
    @Nonnull
    public RefrigeratedIndicatorType setRefrigeratedIndicator(final boolean valueParam) {
        RefrigeratedIndicatorType aObj = getRefrigeratedIndicator();
        if (aObj == null) {
            aObj = new RefrigeratedIndicatorType(valueParam);
            setRefrigeratedIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type PowerIndicatorType and never <code>null</code>
     */
    @Nonnull
    public PowerIndicatorType setPowerIndicator(final boolean valueParam) {
        PowerIndicatorType aObj = getPowerIndicator();
        if (aObj == null) {
            aObj = new PowerIndicatorType(valueParam);
            setPowerIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained NameType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NameType object or <code>null</code>
     */
    @Nullable
    public String getNameValue() {
        NameType aObj = getName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained GateIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained GateIDType object or <code>null</code>
     */
    @Nullable
    public String getGateIDValue() {
        GateIDType aObj = getGateID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained AirFlowPercentType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AirFlowPercentType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getAirFlowPercentValue() {
        AirFlowPercentType aObj = getAirFlowPercent();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained HumidityPercentType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained HumidityPercentType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getHumidityPercentValue() {
        HumidityPercentType aObj = getHumidityPercent();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained AnimalFoodApprovedIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained AnimalFoodApprovedIndicatorType object or the passed nullValue
     */
    public boolean isAnimalFoodApprovedIndicatorValue(final boolean nullValue) {
        AnimalFoodApprovedIndicatorType aObj = getAnimalFoodApprovedIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained HumanFoodApprovedIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained HumanFoodApprovedIndicatorType object or the passed nullValue
     */
    public boolean isHumanFoodApprovedIndicatorValue(final boolean nullValue) {
        HumanFoodApprovedIndicatorType aObj = getHumanFoodApprovedIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained DangerousGoodsApprovedIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained DangerousGoodsApprovedIndicatorType object or the passed nullValue
     */
    public boolean isDangerousGoodsApprovedIndicatorValue(final boolean nullValue) {
        DangerousGoodsApprovedIndicatorType aObj = getDangerousGoodsApprovedIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained RefrigeratedIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained RefrigeratedIndicatorType object or the passed nullValue
     */
    public boolean isRefrigeratedIndicatorValue(final boolean nullValue) {
        RefrigeratedIndicatorType aObj = getRefrigeratedIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained PowerIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained PowerIndicatorType object or the passed nullValue
     */
    public boolean isPowerIndicatorValue(final boolean nullValue) {
        PowerIndicatorType aObj = getPowerIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

}
