
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.AmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.MaximumPercentType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.MinimumPercentType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.RateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.SubcontractingConditionsCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.UnknownPriceIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for SubcontractTermsType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SubcontractTermsType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Rate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}UnknownPriceIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Description" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Amount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}SubcontractingConditionsCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MaximumPercent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}MinimumPercent" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SubcontractTermsType", propOrder = {
    "ublExtensions",
    "rate",
    "unknownPriceIndicator",
    "description",
    "amount",
    "subcontractingConditionsCode",
    "maximumPercent",
    "minimumPercent"
})
@CodingStyleguideUnaware
public class SubcontractTermsType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "Rate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private RateType rate;
    @XmlElement(name = "UnknownPriceIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private UnknownPriceIndicatorType unknownPriceIndicator;
    @XmlElement(name = "Description", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<DescriptionType> description;
    @XmlElement(name = "Amount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private AmountType amount;
    @XmlElement(name = "SubcontractingConditionsCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private SubcontractingConditionsCodeType subcontractingConditionsCode;
    @XmlElement(name = "MaximumPercent", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MaximumPercentType maximumPercent;
    @XmlElement(name = "MinimumPercent", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private MinimumPercentType minimumPercent;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public SubcontractTermsType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the rate property.
     * 
     * @return
     *     possible object is
     *     {@link RateType }
     *     
     */
    @Nullable
    public RateType getRate() {
        return rate;
    }

    /**
     * Sets the value of the rate property.
     * 
     * @param value
     *     allowed object is
     *     {@link RateType }
     *     
     */
    public void setRate(
        @Nullable
        RateType value) {
        this.rate = value;
    }

    /**
     * Gets the value of the unknownPriceIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link UnknownPriceIndicatorType }
     *     
     */
    @Nullable
    public UnknownPriceIndicatorType getUnknownPriceIndicator() {
        return unknownPriceIndicator;
    }

    /**
     * Sets the value of the unknownPriceIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link UnknownPriceIndicatorType }
     *     
     */
    public void setUnknownPriceIndicator(
        @Nullable
        UnknownPriceIndicatorType value) {
        this.unknownPriceIndicator = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the description property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the description property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DescriptionType> getDescription() {
        if (description == null) {
            description = new ArrayList<>();
        }
        return this.description;
    }

    /**
     * Gets the value of the amount property.
     * 
     * @return
     *     possible object is
     *     {@link AmountType }
     *     
     */
    @Nullable
    public AmountType getAmount() {
        return amount;
    }

    /**
     * Sets the value of the amount property.
     * 
     * @param value
     *     allowed object is
     *     {@link AmountType }
     *     
     */
    public void setAmount(
        @Nullable
        AmountType value) {
        this.amount = value;
    }

    /**
     * Gets the value of the subcontractingConditionsCode property.
     * 
     * @return
     *     possible object is
     *     {@link SubcontractingConditionsCodeType }
     *     
     */
    @Nullable
    public SubcontractingConditionsCodeType getSubcontractingConditionsCode() {
        return subcontractingConditionsCode;
    }

    /**
     * Sets the value of the subcontractingConditionsCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link SubcontractingConditionsCodeType }
     *     
     */
    public void setSubcontractingConditionsCode(
        @Nullable
        SubcontractingConditionsCodeType value) {
        this.subcontractingConditionsCode = value;
    }

    /**
     * Gets the value of the maximumPercent property.
     * 
     * @return
     *     possible object is
     *     {@link MaximumPercentType }
     *     
     */
    @Nullable
    public MaximumPercentType getMaximumPercent() {
        return maximumPercent;
    }

    /**
     * Sets the value of the maximumPercent property.
     * 
     * @param value
     *     allowed object is
     *     {@link MaximumPercentType }
     *     
     */
    public void setMaximumPercent(
        @Nullable
        MaximumPercentType value) {
        this.maximumPercent = value;
    }

    /**
     * Gets the value of the minimumPercent property.
     * 
     * @return
     *     possible object is
     *     {@link MinimumPercentType }
     *     
     */
    @Nullable
    public MinimumPercentType getMinimumPercent() {
        return minimumPercent;
    }

    /**
     * Sets the value of the minimumPercent property.
     * 
     * @param value
     *     allowed object is
     *     {@link MinimumPercentType }
     *     
     */
    public void setMinimumPercent(
        @Nullable
        MinimumPercentType value) {
        this.minimumPercent = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final SubcontractTermsType rhs = ((SubcontractTermsType) o);
        if (!EqualsHelper.equals(amount, rhs.amount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equals(maximumPercent, rhs.maximumPercent)) {
            return false;
        }
        if (!EqualsHelper.equals(minimumPercent, rhs.minimumPercent)) {
            return false;
        }
        if (!EqualsHelper.equals(rate, rhs.rate)) {
            return false;
        }
        if (!EqualsHelper.equals(subcontractingConditionsCode, rhs.subcontractingConditionsCode)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equals(unknownPriceIndicator, rhs.unknownPriceIndicator)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(amount).append(description).append(maximumPercent).append(minimumPercent).append(rate).append(subcontractingConditionsCode).append(ublExtensions).append(unknownPriceIndicator).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("amount", amount).append("description", description).append("maximumPercent", maximumPercent).append("minimumPercent", minimumPercent).append("rate", rate).append("subcontractingConditionsCode", subcontractingConditionsCode).append("ublExtensions", ublExtensions).append("unknownPriceIndicator", unknownPriceIndicator).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<DescriptionType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DescriptionType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final DescriptionType elem) {
        getDescription().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        SubcontractTermsType ret) {
        ret.amount = ((amount == null)?null:amount.clone());
        if (description == null) {
            ret.description = null;
        } else {
            List<DescriptionType> retDescription = new ArrayList<>();
            for (DescriptionType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        ret.maximumPercent = ((maximumPercent == null)?null:maximumPercent.clone());
        ret.minimumPercent = ((minimumPercent == null)?null:minimumPercent.clone());
        ret.rate = ((rate == null)?null:rate.clone());
        ret.subcontractingConditionsCode = ((subcontractingConditionsCode == null)?null:subcontractingConditionsCode.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        ret.unknownPriceIndicator = ((unknownPriceIndicator == null)?null:unknownPriceIndicator.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public SubcontractTermsType clone() {
        SubcontractTermsType ret = new SubcontractTermsType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RateType and never <code>null</code>
     */
    @Nonnull
    public RateType setRate(
        @Nullable
        final BigDecimal valueParam) {
        RateType aObj = getRate();
        if (aObj == null) {
            aObj = new RateType(valueParam);
            setRate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type UnknownPriceIndicatorType and never <code>null</code>
     */
    @Nonnull
    public UnknownPriceIndicatorType setUnknownPriceIndicator(final boolean valueParam) {
        UnknownPriceIndicatorType aObj = getUnknownPriceIndicator();
        if (aObj == null) {
            aObj = new UnknownPriceIndicatorType(valueParam);
            setUnknownPriceIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AmountType and never <code>null</code>
     */
    @Nonnull
    public AmountType setAmount(
        @Nullable
        final BigDecimal valueParam) {
        AmountType aObj = getAmount();
        if (aObj == null) {
            aObj = new AmountType(valueParam);
            setAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SubcontractingConditionsCodeType and never <code>null</code>
     */
    @Nonnull
    public SubcontractingConditionsCodeType setSubcontractingConditionsCode(
        @Nullable
        final String valueParam) {
        SubcontractingConditionsCodeType aObj = getSubcontractingConditionsCode();
        if (aObj == null) {
            aObj = new SubcontractingConditionsCodeType(valueParam);
            setSubcontractingConditionsCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MaximumPercentType and never <code>null</code>
     */
    @Nonnull
    public MaximumPercentType setMaximumPercent(
        @Nullable
        final BigDecimal valueParam) {
        MaximumPercentType aObj = getMaximumPercent();
        if (aObj == null) {
            aObj = new MaximumPercentType(valueParam);
            setMaximumPercent(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type MinimumPercentType and never <code>null</code>
     */
    @Nonnull
    public MinimumPercentType setMinimumPercent(
        @Nullable
        final BigDecimal valueParam) {
        MinimumPercentType aObj = getMinimumPercent();
        if (aObj == null) {
            aObj = new MinimumPercentType(valueParam);
            setMinimumPercent(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained RateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RateType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getRateValue() {
        RateType aObj = getRate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained UnknownPriceIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained UnknownPriceIndicatorType object or the passed nullValue
     */
    public boolean isUnknownPriceIndicatorValue(final boolean nullValue) {
        UnknownPriceIndicatorType aObj = getUnknownPriceIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained AmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getAmountValue() {
        AmountType aObj = getAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained SubcontractingConditionsCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SubcontractingConditionsCodeType object or <code>null</code>
     */
    @Nullable
    public String getSubcontractingConditionsCodeValue() {
        SubcontractingConditionsCodeType aObj = getSubcontractingConditionsCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MaximumPercentType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MaximumPercentType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getMaximumPercentValue() {
        MaximumPercentType aObj = getMaximumPercent();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained MinimumPercentType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained MinimumPercentType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getMinimumPercentValue() {
        MinimumPercentType aObj = getMinimumPercent();
        return (aObj == null)?null:aObj.getValue();
    }

}
