
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.CompanyLegalFormCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.CompanyLegalFormType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.EmployeeQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.OperatingYearsQuantityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PersonalSituationType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for TendererQualificationRequestType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="TendererQualificationRequestType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CompanyLegalFormCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CompanyLegalForm" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PersonalSituation" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}OperatingYearsQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}EmployeeQuantity" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Description" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}RequiredBusinessClassificationScheme" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TechnicalEvaluationCriterion" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}FinancialEvaluationCriterion" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}SpecificTendererRequirement" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}EconomicOperatorRole" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TendererQualificationRequestType", propOrder = {
    "ublExtensions",
    "companyLegalFormCode",
    "companyLegalForm",
    "personalSituation",
    "operatingYearsQuantity",
    "employeeQuantity",
    "description",
    "requiredBusinessClassificationScheme",
    "technicalEvaluationCriterion",
    "financialEvaluationCriterion",
    "specificTendererRequirement",
    "economicOperatorRole"
})
@CodingStyleguideUnaware
public class TendererQualificationRequestType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "CompanyLegalFormCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CompanyLegalFormCodeType companyLegalFormCode;
    @XmlElement(name = "CompanyLegalForm", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<CompanyLegalFormType> companyLegalForm;
    @XmlElement(name = "PersonalSituation", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<PersonalSituationType> personalSituation;
    @XmlElement(name = "OperatingYearsQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private OperatingYearsQuantityType operatingYearsQuantity;
    @XmlElement(name = "EmployeeQuantity", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private EmployeeQuantityType employeeQuantity;
    @XmlElement(name = "Description", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<DescriptionType> description;
    @XmlElement(name = "RequiredBusinessClassificationScheme")
    private List<ClassificationSchemeType> requiredBusinessClassificationScheme;
    @XmlElement(name = "TechnicalEvaluationCriterion")
    private List<EvaluationCriterionType> technicalEvaluationCriterion;
    @XmlElement(name = "FinancialEvaluationCriterion")
    private List<EvaluationCriterionType> financialEvaluationCriterion;
    @XmlElement(name = "SpecificTendererRequirement")
    private List<TendererRequirementType> specificTendererRequirement;
    @XmlElement(name = "EconomicOperatorRole")
    private List<EconomicOperatorRoleType> economicOperatorRole;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public TendererQualificationRequestType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the companyLegalFormCode property.
     * 
     * @return
     *     possible object is
     *     {@link CompanyLegalFormCodeType }
     *     
     */
    @Nullable
    public CompanyLegalFormCodeType getCompanyLegalFormCode() {
        return companyLegalFormCode;
    }

    /**
     * Sets the value of the companyLegalFormCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CompanyLegalFormCodeType }
     *     
     */
    public void setCompanyLegalFormCode(
        @Nullable
        CompanyLegalFormCodeType value) {
        this.companyLegalFormCode = value;
    }

    /**
     * Gets the value of the companyLegalForm property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the companyLegalForm property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getCompanyLegalForm().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CompanyLegalFormType }
     * </p>
     * 
     * 
     * @return
     *     The value of the companyLegalForm property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CompanyLegalFormType> getCompanyLegalForm() {
        if (companyLegalForm == null) {
            companyLegalForm = new ArrayList<>();
        }
        return this.companyLegalForm;
    }

    /**
     * Gets the value of the personalSituation property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the personalSituation property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPersonalSituation().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PersonalSituationType }
     * </p>
     * 
     * 
     * @return
     *     The value of the personalSituation property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PersonalSituationType> getPersonalSituation() {
        if (personalSituation == null) {
            personalSituation = new ArrayList<>();
        }
        return this.personalSituation;
    }

    /**
     * Gets the value of the operatingYearsQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link OperatingYearsQuantityType }
     *     
     */
    @Nullable
    public OperatingYearsQuantityType getOperatingYearsQuantity() {
        return operatingYearsQuantity;
    }

    /**
     * Sets the value of the operatingYearsQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link OperatingYearsQuantityType }
     *     
     */
    public void setOperatingYearsQuantity(
        @Nullable
        OperatingYearsQuantityType value) {
        this.operatingYearsQuantity = value;
    }

    /**
     * Gets the value of the employeeQuantity property.
     * 
     * @return
     *     possible object is
     *     {@link EmployeeQuantityType }
     *     
     */
    @Nullable
    public EmployeeQuantityType getEmployeeQuantity() {
        return employeeQuantity;
    }

    /**
     * Sets the value of the employeeQuantity property.
     * 
     * @param value
     *     allowed object is
     *     {@link EmployeeQuantityType }
     *     
     */
    public void setEmployeeQuantity(
        @Nullable
        EmployeeQuantityType value) {
        this.employeeQuantity = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the description property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the description property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DescriptionType> getDescription() {
        if (description == null) {
            description = new ArrayList<>();
        }
        return this.description;
    }

    /**
     * Gets the value of the requiredBusinessClassificationScheme property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the requiredBusinessClassificationScheme property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getRequiredBusinessClassificationScheme().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ClassificationSchemeType }
     * </p>
     * 
     * 
     * @return
     *     The value of the requiredBusinessClassificationScheme property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ClassificationSchemeType> getRequiredBusinessClassificationScheme() {
        if (requiredBusinessClassificationScheme == null) {
            requiredBusinessClassificationScheme = new ArrayList<>();
        }
        return this.requiredBusinessClassificationScheme;
    }

    /**
     * Gets the value of the technicalEvaluationCriterion property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the technicalEvaluationCriterion property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getTechnicalEvaluationCriterion().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link EvaluationCriterionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the technicalEvaluationCriterion property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<EvaluationCriterionType> getTechnicalEvaluationCriterion() {
        if (technicalEvaluationCriterion == null) {
            technicalEvaluationCriterion = new ArrayList<>();
        }
        return this.technicalEvaluationCriterion;
    }

    /**
     * Gets the value of the financialEvaluationCriterion property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the financialEvaluationCriterion property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getFinancialEvaluationCriterion().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link EvaluationCriterionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the financialEvaluationCriterion property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<EvaluationCriterionType> getFinancialEvaluationCriterion() {
        if (financialEvaluationCriterion == null) {
            financialEvaluationCriterion = new ArrayList<>();
        }
        return this.financialEvaluationCriterion;
    }

    /**
     * Gets the value of the specificTendererRequirement property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the specificTendererRequirement property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getSpecificTendererRequirement().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TendererRequirementType }
     * </p>
     * 
     * 
     * @return
     *     The value of the specificTendererRequirement property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TendererRequirementType> getSpecificTendererRequirement() {
        if (specificTendererRequirement == null) {
            specificTendererRequirement = new ArrayList<>();
        }
        return this.specificTendererRequirement;
    }

    /**
     * Gets the value of the economicOperatorRole property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the economicOperatorRole property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getEconomicOperatorRole().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link EconomicOperatorRoleType }
     * </p>
     * 
     * 
     * @return
     *     The value of the economicOperatorRole property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<EconomicOperatorRoleType> getEconomicOperatorRole() {
        if (economicOperatorRole == null) {
            economicOperatorRole = new ArrayList<>();
        }
        return this.economicOperatorRole;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final TendererQualificationRequestType rhs = ((TendererQualificationRequestType) o);
        if (!EqualsHelper.equalsCollection(companyLegalForm, rhs.companyLegalForm)) {
            return false;
        }
        if (!EqualsHelper.equals(companyLegalFormCode, rhs.companyLegalFormCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(economicOperatorRole, rhs.economicOperatorRole)) {
            return false;
        }
        if (!EqualsHelper.equals(employeeQuantity, rhs.employeeQuantity)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(financialEvaluationCriterion, rhs.financialEvaluationCriterion)) {
            return false;
        }
        if (!EqualsHelper.equals(operatingYearsQuantity, rhs.operatingYearsQuantity)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(personalSituation, rhs.personalSituation)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(requiredBusinessClassificationScheme, rhs.requiredBusinessClassificationScheme)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(specificTendererRequirement, rhs.specificTendererRequirement)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(technicalEvaluationCriterion, rhs.technicalEvaluationCriterion)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(companyLegalForm).append(companyLegalFormCode).append(description).append(economicOperatorRole).append(employeeQuantity).append(financialEvaluationCriterion).append(operatingYearsQuantity).append(personalSituation).append(requiredBusinessClassificationScheme).append(specificTendererRequirement).append(technicalEvaluationCriterion).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("companyLegalForm", companyLegalForm).append("companyLegalFormCode", companyLegalFormCode).append("description", description).append("economicOperatorRole", economicOperatorRole).append("employeeQuantity", employeeQuantity).append("financialEvaluationCriterion", financialEvaluationCriterion).append("operatingYearsQuantity", operatingYearsQuantity).append("personalSituation", personalSituation).append("requiredBusinessClassificationScheme", requiredBusinessClassificationScheme).append("specificTendererRequirement", specificTendererRequirement).append("technicalEvaluationCriterion", technicalEvaluationCriterion).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCompanyLegalForm(
        @Nullable
        final List<CompanyLegalFormType> aList) {
        companyLegalForm = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPersonalSituation(
        @Nullable
        final List<PersonalSituationType> aList) {
        personalSituation = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<DescriptionType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setRequiredBusinessClassificationScheme(
        @Nullable
        final List<ClassificationSchemeType> aList) {
        requiredBusinessClassificationScheme = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTechnicalEvaluationCriterion(
        @Nullable
        final List<EvaluationCriterionType> aList) {
        technicalEvaluationCriterion = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setFinancialEvaluationCriterion(
        @Nullable
        final List<EvaluationCriterionType> aList) {
        financialEvaluationCriterion = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSpecificTendererRequirement(
        @Nullable
        final List<TendererRequirementType> aList) {
        specificTendererRequirement = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setEconomicOperatorRole(
        @Nullable
        final List<EconomicOperatorRoleType> aList) {
        economicOperatorRole = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCompanyLegalFormEntries() {
        return (!getCompanyLegalForm().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCompanyLegalFormEntries() {
        return getCompanyLegalForm().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCompanyLegalFormCount() {
        return getCompanyLegalForm().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CompanyLegalFormType getCompanyLegalFormAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCompanyLegalForm().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCompanyLegalForm(
        @Nonnull
        final CompanyLegalFormType elem) {
        getCompanyLegalForm().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPersonalSituationEntries() {
        return (!getPersonalSituation().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPersonalSituationEntries() {
        return getPersonalSituation().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPersonalSituationCount() {
        return getPersonalSituation().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PersonalSituationType getPersonalSituationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPersonalSituation().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPersonalSituation(
        @Nonnull
        final PersonalSituationType elem) {
        getPersonalSituation().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DescriptionType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final DescriptionType elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasRequiredBusinessClassificationSchemeEntries() {
        return (!getRequiredBusinessClassificationScheme().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoRequiredBusinessClassificationSchemeEntries() {
        return getRequiredBusinessClassificationScheme().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getRequiredBusinessClassificationSchemeCount() {
        return getRequiredBusinessClassificationScheme().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ClassificationSchemeType getRequiredBusinessClassificationSchemeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getRequiredBusinessClassificationScheme().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addRequiredBusinessClassificationScheme(
        @Nonnull
        final ClassificationSchemeType elem) {
        getRequiredBusinessClassificationScheme().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTechnicalEvaluationCriterionEntries() {
        return (!getTechnicalEvaluationCriterion().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTechnicalEvaluationCriterionEntries() {
        return getTechnicalEvaluationCriterion().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTechnicalEvaluationCriterionCount() {
        return getTechnicalEvaluationCriterion().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public EvaluationCriterionType getTechnicalEvaluationCriterionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTechnicalEvaluationCriterion().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTechnicalEvaluationCriterion(
        @Nonnull
        final EvaluationCriterionType elem) {
        getTechnicalEvaluationCriterion().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasFinancialEvaluationCriterionEntries() {
        return (!getFinancialEvaluationCriterion().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoFinancialEvaluationCriterionEntries() {
        return getFinancialEvaluationCriterion().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getFinancialEvaluationCriterionCount() {
        return getFinancialEvaluationCriterion().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public EvaluationCriterionType getFinancialEvaluationCriterionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getFinancialEvaluationCriterion().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addFinancialEvaluationCriterion(
        @Nonnull
        final EvaluationCriterionType elem) {
        getFinancialEvaluationCriterion().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSpecificTendererRequirementEntries() {
        return (!getSpecificTendererRequirement().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSpecificTendererRequirementEntries() {
        return getSpecificTendererRequirement().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSpecificTendererRequirementCount() {
        return getSpecificTendererRequirement().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TendererRequirementType getSpecificTendererRequirementAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSpecificTendererRequirement().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSpecificTendererRequirement(
        @Nonnull
        final TendererRequirementType elem) {
        getSpecificTendererRequirement().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasEconomicOperatorRoleEntries() {
        return (!getEconomicOperatorRole().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoEconomicOperatorRoleEntries() {
        return getEconomicOperatorRole().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getEconomicOperatorRoleCount() {
        return getEconomicOperatorRole().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public EconomicOperatorRoleType getEconomicOperatorRoleAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getEconomicOperatorRole().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addEconomicOperatorRole(
        @Nonnull
        final EconomicOperatorRoleType elem) {
        getEconomicOperatorRole().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        TendererQualificationRequestType ret) {
        if (companyLegalForm == null) {
            ret.companyLegalForm = null;
        } else {
            List<CompanyLegalFormType> retCompanyLegalForm = new ArrayList<>();
            for (CompanyLegalFormType aItem: getCompanyLegalForm()) {
                retCompanyLegalForm.add(((aItem == null)?null:aItem.clone()));
            }
            ret.companyLegalForm = retCompanyLegalForm;
        }
        ret.companyLegalFormCode = ((companyLegalFormCode == null)?null:companyLegalFormCode.clone());
        if (description == null) {
            ret.description = null;
        } else {
            List<DescriptionType> retDescription = new ArrayList<>();
            for (DescriptionType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        if (economicOperatorRole == null) {
            ret.economicOperatorRole = null;
        } else {
            List<EconomicOperatorRoleType> retEconomicOperatorRole = new ArrayList<>();
            for (EconomicOperatorRoleType aItem: getEconomicOperatorRole()) {
                retEconomicOperatorRole.add(((aItem == null)?null:aItem.clone()));
            }
            ret.economicOperatorRole = retEconomicOperatorRole;
        }
        ret.employeeQuantity = ((employeeQuantity == null)?null:employeeQuantity.clone());
        if (financialEvaluationCriterion == null) {
            ret.financialEvaluationCriterion = null;
        } else {
            List<EvaluationCriterionType> retFinancialEvaluationCriterion = new ArrayList<>();
            for (EvaluationCriterionType aItem: getFinancialEvaluationCriterion()) {
                retFinancialEvaluationCriterion.add(((aItem == null)?null:aItem.clone()));
            }
            ret.financialEvaluationCriterion = retFinancialEvaluationCriterion;
        }
        ret.operatingYearsQuantity = ((operatingYearsQuantity == null)?null:operatingYearsQuantity.clone());
        if (personalSituation == null) {
            ret.personalSituation = null;
        } else {
            List<PersonalSituationType> retPersonalSituation = new ArrayList<>();
            for (PersonalSituationType aItem: getPersonalSituation()) {
                retPersonalSituation.add(((aItem == null)?null:aItem.clone()));
            }
            ret.personalSituation = retPersonalSituation;
        }
        if (requiredBusinessClassificationScheme == null) {
            ret.requiredBusinessClassificationScheme = null;
        } else {
            List<ClassificationSchemeType> retRequiredBusinessClassificationScheme = new ArrayList<>();
            for (ClassificationSchemeType aItem: getRequiredBusinessClassificationScheme()) {
                retRequiredBusinessClassificationScheme.add(((aItem == null)?null:aItem.clone()));
            }
            ret.requiredBusinessClassificationScheme = retRequiredBusinessClassificationScheme;
        }
        if (specificTendererRequirement == null) {
            ret.specificTendererRequirement = null;
        } else {
            List<TendererRequirementType> retSpecificTendererRequirement = new ArrayList<>();
            for (TendererRequirementType aItem: getSpecificTendererRequirement()) {
                retSpecificTendererRequirement.add(((aItem == null)?null:aItem.clone()));
            }
            ret.specificTendererRequirement = retSpecificTendererRequirement;
        }
        if (technicalEvaluationCriterion == null) {
            ret.technicalEvaluationCriterion = null;
        } else {
            List<EvaluationCriterionType> retTechnicalEvaluationCriterion = new ArrayList<>();
            for (EvaluationCriterionType aItem: getTechnicalEvaluationCriterion()) {
                retTechnicalEvaluationCriterion.add(((aItem == null)?null:aItem.clone()));
            }
            ret.technicalEvaluationCriterion = retTechnicalEvaluationCriterion;
        }
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public TendererQualificationRequestType clone() {
        TendererQualificationRequestType ret = new TendererQualificationRequestType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CompanyLegalFormCodeType and never <code>null</code>
     */
    @Nonnull
    public CompanyLegalFormCodeType setCompanyLegalFormCode(
        @Nullable
        final String valueParam) {
        CompanyLegalFormCodeType aObj = getCompanyLegalFormCode();
        if (aObj == null) {
            aObj = new CompanyLegalFormCodeType(valueParam);
            setCompanyLegalFormCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type OperatingYearsQuantityType and never <code>null</code>
     */
    @Nonnull
    public OperatingYearsQuantityType setOperatingYearsQuantity(
        @Nullable
        final BigDecimal valueParam) {
        OperatingYearsQuantityType aObj = getOperatingYearsQuantity();
        if (aObj == null) {
            aObj = new OperatingYearsQuantityType(valueParam);
            setOperatingYearsQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EmployeeQuantityType and never <code>null</code>
     */
    @Nonnull
    public EmployeeQuantityType setEmployeeQuantity(
        @Nullable
        final BigDecimal valueParam) {
        EmployeeQuantityType aObj = getEmployeeQuantity();
        if (aObj == null) {
            aObj = new EmployeeQuantityType(valueParam);
            setEmployeeQuantity(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained CompanyLegalFormCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CompanyLegalFormCodeType object or <code>null</code>
     */
    @Nullable
    public String getCompanyLegalFormCodeValue() {
        CompanyLegalFormCodeType aObj = getCompanyLegalFormCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained OperatingYearsQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained OperatingYearsQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getOperatingYearsQuantityValue() {
        OperatingYearsQuantityType aObj = getOperatingYearsQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained EmployeeQuantityType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EmployeeQuantityType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getEmployeeQuantityValue() {
        EmployeeQuantityType aObj = getEmployeeQuantity();
        return (aObj == null)?null:aObj.getValue();
    }

}
