
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.CriterionTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.EvaluationMethodTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.FulfilmentIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.FulfilmentIndicatorTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.NameType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.WeightNumericType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.WeightingConsiderationDescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for TenderingCriterionType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="TenderingCriterionType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CriterionTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Name" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Description" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}WeightNumeric" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}FulfilmentIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}FulfilmentIndicatorTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}EvaluationMethodTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}WeightingConsiderationDescription" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ProcurementProjectLotReference" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}CommodityClassification" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}SubTenderingCriterion" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Legislation" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TenderingCriterionPropertyGroup" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TenderingCriterionType", propOrder = {
    "ublExtensions",
    "id",
    "criterionTypeCode",
    "name",
    "description",
    "weightNumeric",
    "fulfilmentIndicator",
    "fulfilmentIndicatorTypeCode",
    "evaluationMethodTypeCode",
    "weightingConsiderationDescription",
    "procurementProjectLotReference",
    "commodityClassification",
    "subTenderingCriterion",
    "legislation",
    "tenderingCriterionPropertyGroup"
})
@CodingStyleguideUnaware
public class TenderingCriterionType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "CriterionTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CriterionTypeCodeType criterionTypeCode;
    @XmlElement(name = "Name", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<NameType> name;
    @XmlElement(name = "Description", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<DescriptionType> description;
    @XmlElement(name = "WeightNumeric", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private WeightNumericType weightNumeric;
    @XmlElement(name = "FulfilmentIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private FulfilmentIndicatorType fulfilmentIndicator;
    @XmlElement(name = "FulfilmentIndicatorTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private FulfilmentIndicatorTypeCodeType fulfilmentIndicatorTypeCode;
    @XmlElement(name = "EvaluationMethodTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private EvaluationMethodTypeCodeType evaluationMethodTypeCode;
    @XmlElement(name = "WeightingConsiderationDescription", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<WeightingConsiderationDescriptionType> weightingConsiderationDescription;
    @XmlElement(name = "ProcurementProjectLotReference")
    private List<ProcurementProjectLotReferenceType> procurementProjectLotReference;
    @XmlElement(name = "CommodityClassification")
    private List<CommodityClassificationType> commodityClassification;
    @XmlElement(name = "SubTenderingCriterion")
    private List<TenderingCriterionType> subTenderingCriterion;
    @XmlElement(name = "Legislation")
    private List<LegislationType> legislation;
    @XmlElement(name = "TenderingCriterionPropertyGroup")
    private List<TenderingCriterionPropertyGroupType> tenderingCriterionPropertyGroup;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public TenderingCriterionType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the criterionTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link CriterionTypeCodeType }
     *     
     */
    @Nullable
    public CriterionTypeCodeType getCriterionTypeCode() {
        return criterionTypeCode;
    }

    /**
     * Sets the value of the criterionTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link CriterionTypeCodeType }
     *     
     */
    public void setCriterionTypeCode(
        @Nullable
        CriterionTypeCodeType value) {
        this.criterionTypeCode = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the name property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getName().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NameType }
     * </p>
     * 
     * 
     * @return
     *     The value of the name property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NameType> getName() {
        if (name == null) {
            name = new ArrayList<>();
        }
        return this.name;
    }

    /**
     * Gets the value of the description property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the description property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the description property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DescriptionType> getDescription() {
        if (description == null) {
            description = new ArrayList<>();
        }
        return this.description;
    }

    /**
     * Gets the value of the weightNumeric property.
     * 
     * @return
     *     possible object is
     *     {@link WeightNumericType }
     *     
     */
    @Nullable
    public WeightNumericType getWeightNumeric() {
        return weightNumeric;
    }

    /**
     * Sets the value of the weightNumeric property.
     * 
     * @param value
     *     allowed object is
     *     {@link WeightNumericType }
     *     
     */
    public void setWeightNumeric(
        @Nullable
        WeightNumericType value) {
        this.weightNumeric = value;
    }

    /**
     * Gets the value of the fulfilmentIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link FulfilmentIndicatorType }
     *     
     */
    @Nullable
    public FulfilmentIndicatorType getFulfilmentIndicator() {
        return fulfilmentIndicator;
    }

    /**
     * Sets the value of the fulfilmentIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link FulfilmentIndicatorType }
     *     
     */
    public void setFulfilmentIndicator(
        @Nullable
        FulfilmentIndicatorType value) {
        this.fulfilmentIndicator = value;
    }

    /**
     * Gets the value of the fulfilmentIndicatorTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link FulfilmentIndicatorTypeCodeType }
     *     
     */
    @Nullable
    public FulfilmentIndicatorTypeCodeType getFulfilmentIndicatorTypeCode() {
        return fulfilmentIndicatorTypeCode;
    }

    /**
     * Sets the value of the fulfilmentIndicatorTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link FulfilmentIndicatorTypeCodeType }
     *     
     */
    public void setFulfilmentIndicatorTypeCode(
        @Nullable
        FulfilmentIndicatorTypeCodeType value) {
        this.fulfilmentIndicatorTypeCode = value;
    }

    /**
     * Gets the value of the evaluationMethodTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link EvaluationMethodTypeCodeType }
     *     
     */
    @Nullable
    public EvaluationMethodTypeCodeType getEvaluationMethodTypeCode() {
        return evaluationMethodTypeCode;
    }

    /**
     * Sets the value of the evaluationMethodTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link EvaluationMethodTypeCodeType }
     *     
     */
    public void setEvaluationMethodTypeCode(
        @Nullable
        EvaluationMethodTypeCodeType value) {
        this.evaluationMethodTypeCode = value;
    }

    /**
     * Gets the value of the weightingConsiderationDescription property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the weightingConsiderationDescription property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getWeightingConsiderationDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link WeightingConsiderationDescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the weightingConsiderationDescription property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<WeightingConsiderationDescriptionType> getWeightingConsiderationDescription() {
        if (weightingConsiderationDescription == null) {
            weightingConsiderationDescription = new ArrayList<>();
        }
        return this.weightingConsiderationDescription;
    }

    /**
     * Gets the value of the procurementProjectLotReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the procurementProjectLotReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getProcurementProjectLotReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ProcurementProjectLotReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the procurementProjectLotReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ProcurementProjectLotReferenceType> getProcurementProjectLotReference() {
        if (procurementProjectLotReference == null) {
            procurementProjectLotReference = new ArrayList<>();
        }
        return this.procurementProjectLotReference;
    }

    /**
     * Gets the value of the commodityClassification property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the commodityClassification property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getCommodityClassification().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CommodityClassificationType }
     * </p>
     * 
     * 
     * @return
     *     The value of the commodityClassification property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<CommodityClassificationType> getCommodityClassification() {
        if (commodityClassification == null) {
            commodityClassification = new ArrayList<>();
        }
        return this.commodityClassification;
    }

    /**
     * Gets the value of the subTenderingCriterion property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the subTenderingCriterion property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getSubTenderingCriterion().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TenderingCriterionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the subTenderingCriterion property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TenderingCriterionType> getSubTenderingCriterion() {
        if (subTenderingCriterion == null) {
            subTenderingCriterion = new ArrayList<>();
        }
        return this.subTenderingCriterion;
    }

    /**
     * Gets the value of the legislation property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the legislation property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getLegislation().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link LegislationType }
     * </p>
     * 
     * 
     * @return
     *     The value of the legislation property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<LegislationType> getLegislation() {
        if (legislation == null) {
            legislation = new ArrayList<>();
        }
        return this.legislation;
    }

    /**
     * Gets the value of the tenderingCriterionPropertyGroup property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the tenderingCriterionPropertyGroup property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getTenderingCriterionPropertyGroup().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TenderingCriterionPropertyGroupType }
     * </p>
     * 
     * 
     * @return
     *     The value of the tenderingCriterionPropertyGroup property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TenderingCriterionPropertyGroupType> getTenderingCriterionPropertyGroup() {
        if (tenderingCriterionPropertyGroup == null) {
            tenderingCriterionPropertyGroup = new ArrayList<>();
        }
        return this.tenderingCriterionPropertyGroup;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final TenderingCriterionType rhs = ((TenderingCriterionType) o);
        if (!EqualsHelper.equalsCollection(commodityClassification, rhs.commodityClassification)) {
            return false;
        }
        if (!EqualsHelper.equals(criterionTypeCode, rhs.criterionTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equals(evaluationMethodTypeCode, rhs.evaluationMethodTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(fulfilmentIndicator, rhs.fulfilmentIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(fulfilmentIndicatorTypeCode, rhs.fulfilmentIndicatorTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(legislation, rhs.legislation)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(name, rhs.name)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(procurementProjectLotReference, rhs.procurementProjectLotReference)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(subTenderingCriterion, rhs.subTenderingCriterion)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(tenderingCriterionPropertyGroup, rhs.tenderingCriterionPropertyGroup)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equals(weightNumeric, rhs.weightNumeric)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(weightingConsiderationDescription, rhs.weightingConsiderationDescription)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(commodityClassification).append(criterionTypeCode).append(description).append(evaluationMethodTypeCode).append(fulfilmentIndicator).append(fulfilmentIndicatorTypeCode).append(id).append(legislation).append(name).append(procurementProjectLotReference).append(subTenderingCriterion).append(tenderingCriterionPropertyGroup).append(ublExtensions).append(weightNumeric).append(weightingConsiderationDescription).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("commodityClassification", commodityClassification).append("criterionTypeCode", criterionTypeCode).append("description", description).append("evaluationMethodTypeCode", evaluationMethodTypeCode).append("fulfilmentIndicator", fulfilmentIndicator).append("fulfilmentIndicatorTypeCode", fulfilmentIndicatorTypeCode).append("id", id).append("legislation", legislation).append("name", name).append("procurementProjectLotReference", procurementProjectLotReference).append("subTenderingCriterion", subTenderingCriterion).append("tenderingCriterionPropertyGroup", tenderingCriterionPropertyGroup).append("ublExtensions", ublExtensions).append("weightNumeric", weightNumeric).append("weightingConsiderationDescription", weightingConsiderationDescription).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setName(
        @Nullable
        final List<NameType> aList) {
        name = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<DescriptionType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setWeightingConsiderationDescription(
        @Nullable
        final List<WeightingConsiderationDescriptionType> aList) {
        weightingConsiderationDescription = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setProcurementProjectLotReference(
        @Nullable
        final List<ProcurementProjectLotReferenceType> aList) {
        procurementProjectLotReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setCommodityClassification(
        @Nullable
        final List<CommodityClassificationType> aList) {
        commodityClassification = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSubTenderingCriterion(
        @Nullable
        final List<TenderingCriterionType> aList) {
        subTenderingCriterion = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setLegislation(
        @Nullable
        final List<LegislationType> aList) {
        legislation = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTenderingCriterionPropertyGroup(
        @Nullable
        final List<TenderingCriterionPropertyGroupType> aList) {
        tenderingCriterionPropertyGroup = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasNameEntries() {
        return (!getName().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoNameEntries() {
        return getName().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getNameCount() {
        return getName().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NameType getNameAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getName().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addName(
        @Nonnull
        final NameType elem) {
        getName().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DescriptionType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final DescriptionType elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasWeightingConsiderationDescriptionEntries() {
        return (!getWeightingConsiderationDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoWeightingConsiderationDescriptionEntries() {
        return getWeightingConsiderationDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getWeightingConsiderationDescriptionCount() {
        return getWeightingConsiderationDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public WeightingConsiderationDescriptionType getWeightingConsiderationDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getWeightingConsiderationDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addWeightingConsiderationDescription(
        @Nonnull
        final WeightingConsiderationDescriptionType elem) {
        getWeightingConsiderationDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasProcurementProjectLotReferenceEntries() {
        return (!getProcurementProjectLotReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoProcurementProjectLotReferenceEntries() {
        return getProcurementProjectLotReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getProcurementProjectLotReferenceCount() {
        return getProcurementProjectLotReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ProcurementProjectLotReferenceType getProcurementProjectLotReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getProcurementProjectLotReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addProcurementProjectLotReference(
        @Nonnull
        final ProcurementProjectLotReferenceType elem) {
        getProcurementProjectLotReference().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasCommodityClassificationEntries() {
        return (!getCommodityClassification().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoCommodityClassificationEntries() {
        return getCommodityClassification().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getCommodityClassificationCount() {
        return getCommodityClassification().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public CommodityClassificationType getCommodityClassificationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getCommodityClassification().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addCommodityClassification(
        @Nonnull
        final CommodityClassificationType elem) {
        getCommodityClassification().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSubTenderingCriterionEntries() {
        return (!getSubTenderingCriterion().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSubTenderingCriterionEntries() {
        return getSubTenderingCriterion().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSubTenderingCriterionCount() {
        return getSubTenderingCriterion().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TenderingCriterionType getSubTenderingCriterionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSubTenderingCriterion().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSubTenderingCriterion(
        @Nonnull
        final TenderingCriterionType elem) {
        getSubTenderingCriterion().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasLegislationEntries() {
        return (!getLegislation().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoLegislationEntries() {
        return getLegislation().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getLegislationCount() {
        return getLegislation().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public LegislationType getLegislationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getLegislation().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addLegislation(
        @Nonnull
        final LegislationType elem) {
        getLegislation().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTenderingCriterionPropertyGroupEntries() {
        return (!getTenderingCriterionPropertyGroup().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTenderingCriterionPropertyGroupEntries() {
        return getTenderingCriterionPropertyGroup().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTenderingCriterionPropertyGroupCount() {
        return getTenderingCriterionPropertyGroup().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TenderingCriterionPropertyGroupType getTenderingCriterionPropertyGroupAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTenderingCriterionPropertyGroup().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTenderingCriterionPropertyGroup(
        @Nonnull
        final TenderingCriterionPropertyGroupType elem) {
        getTenderingCriterionPropertyGroup().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        TenderingCriterionType ret) {
        if (commodityClassification == null) {
            ret.commodityClassification = null;
        } else {
            List<CommodityClassificationType> retCommodityClassification = new ArrayList<>();
            for (CommodityClassificationType aItem: getCommodityClassification()) {
                retCommodityClassification.add(((aItem == null)?null:aItem.clone()));
            }
            ret.commodityClassification = retCommodityClassification;
        }
        ret.criterionTypeCode = ((criterionTypeCode == null)?null:criterionTypeCode.clone());
        if (description == null) {
            ret.description = null;
        } else {
            List<DescriptionType> retDescription = new ArrayList<>();
            for (DescriptionType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        ret.evaluationMethodTypeCode = ((evaluationMethodTypeCode == null)?null:evaluationMethodTypeCode.clone());
        ret.fulfilmentIndicator = ((fulfilmentIndicator == null)?null:fulfilmentIndicator.clone());
        ret.fulfilmentIndicatorTypeCode = ((fulfilmentIndicatorTypeCode == null)?null:fulfilmentIndicatorTypeCode.clone());
        ret.id = ((id == null)?null:id.clone());
        if (legislation == null) {
            ret.legislation = null;
        } else {
            List<LegislationType> retLegislation = new ArrayList<>();
            for (LegislationType aItem: getLegislation()) {
                retLegislation.add(((aItem == null)?null:aItem.clone()));
            }
            ret.legislation = retLegislation;
        }
        if (name == null) {
            ret.name = null;
        } else {
            List<NameType> retName = new ArrayList<>();
            for (NameType aItem: getName()) {
                retName.add(((aItem == null)?null:aItem.clone()));
            }
            ret.name = retName;
        }
        if (procurementProjectLotReference == null) {
            ret.procurementProjectLotReference = null;
        } else {
            List<ProcurementProjectLotReferenceType> retProcurementProjectLotReference = new ArrayList<>();
            for (ProcurementProjectLotReferenceType aItem: getProcurementProjectLotReference()) {
                retProcurementProjectLotReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.procurementProjectLotReference = retProcurementProjectLotReference;
        }
        if (subTenderingCriterion == null) {
            ret.subTenderingCriterion = null;
        } else {
            List<TenderingCriterionType> retSubTenderingCriterion = new ArrayList<>();
            for (TenderingCriterionType aItem: getSubTenderingCriterion()) {
                retSubTenderingCriterion.add(((aItem == null)?null:aItem.clone()));
            }
            ret.subTenderingCriterion = retSubTenderingCriterion;
        }
        if (tenderingCriterionPropertyGroup == null) {
            ret.tenderingCriterionPropertyGroup = null;
        } else {
            List<TenderingCriterionPropertyGroupType> retTenderingCriterionPropertyGroup = new ArrayList<>();
            for (TenderingCriterionPropertyGroupType aItem: getTenderingCriterionPropertyGroup()) {
                retTenderingCriterionPropertyGroup.add(((aItem == null)?null:aItem.clone()));
            }
            ret.tenderingCriterionPropertyGroup = retTenderingCriterionPropertyGroup;
        }
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        ret.weightNumeric = ((weightNumeric == null)?null:weightNumeric.clone());
        if (weightingConsiderationDescription == null) {
            ret.weightingConsiderationDescription = null;
        } else {
            List<WeightingConsiderationDescriptionType> retWeightingConsiderationDescription = new ArrayList<>();
            for (WeightingConsiderationDescriptionType aItem: getWeightingConsiderationDescription()) {
                retWeightingConsiderationDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.weightingConsiderationDescription = retWeightingConsiderationDescription;
        }
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public TenderingCriterionType clone() {
        TenderingCriterionType ret = new TenderingCriterionType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CriterionTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public CriterionTypeCodeType setCriterionTypeCode(
        @Nullable
        final String valueParam) {
        CriterionTypeCodeType aObj = getCriterionTypeCode();
        if (aObj == null) {
            aObj = new CriterionTypeCodeType(valueParam);
            setCriterionTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type WeightNumericType and never <code>null</code>
     */
    @Nonnull
    public WeightNumericType setWeightNumeric(
        @Nullable
        final BigDecimal valueParam) {
        WeightNumericType aObj = getWeightNumeric();
        if (aObj == null) {
            aObj = new WeightNumericType(valueParam);
            setWeightNumeric(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type FulfilmentIndicatorType and never <code>null</code>
     */
    @Nonnull
    public FulfilmentIndicatorType setFulfilmentIndicator(final boolean valueParam) {
        FulfilmentIndicatorType aObj = getFulfilmentIndicator();
        if (aObj == null) {
            aObj = new FulfilmentIndicatorType(valueParam);
            setFulfilmentIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type FulfilmentIndicatorTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public FulfilmentIndicatorTypeCodeType setFulfilmentIndicatorTypeCode(
        @Nullable
        final String valueParam) {
        FulfilmentIndicatorTypeCodeType aObj = getFulfilmentIndicatorTypeCode();
        if (aObj == null) {
            aObj = new FulfilmentIndicatorTypeCodeType(valueParam);
            setFulfilmentIndicatorTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type EvaluationMethodTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public EvaluationMethodTypeCodeType setEvaluationMethodTypeCode(
        @Nullable
        final String valueParam) {
        EvaluationMethodTypeCodeType aObj = getEvaluationMethodTypeCode();
        if (aObj == null) {
            aObj = new EvaluationMethodTypeCodeType(valueParam);
            setEvaluationMethodTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CriterionTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CriterionTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getCriterionTypeCodeValue() {
        CriterionTypeCodeType aObj = getCriterionTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained WeightNumericType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained WeightNumericType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getWeightNumericValue() {
        WeightNumericType aObj = getWeightNumeric();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained FulfilmentIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained FulfilmentIndicatorType object or the passed nullValue
     */
    public boolean isFulfilmentIndicatorValue(final boolean nullValue) {
        FulfilmentIndicatorType aObj = getFulfilmentIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained FulfilmentIndicatorTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained FulfilmentIndicatorTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getFulfilmentIndicatorTypeCodeValue() {
        FulfilmentIndicatorTypeCodeType aObj = getFulfilmentIndicatorTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained EvaluationMethodTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained EvaluationMethodTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getEvaluationMethodTypeCodeValue() {
        EvaluationMethodTypeCodeType aObj = getEvaluationMethodTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
