
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.AirFlowPercentType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.AnimalFoodApprovedIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.CharacteristicsType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.DamageRemarksType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.DangerousGoodsApprovedIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.DispositionCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.FullnessIndicationCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.GrossVolumeMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.GrossWeightMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.HumanFoodApprovedIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.HumidityPercentType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.InformationType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.LegalStatusIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.OwnerTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PowerIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ProviderTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ReferencedConsignmentIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.RefrigeratedIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.RefrigerationOnIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ReturnabilityIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.SizeTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.SpecialTransportRequirementsType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TareWeightMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TraceIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TrackingDeviceCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TransportEquipmentTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for TransportEquipmentType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="TransportEquipmentType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ReferencedConsignmentID" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TransportEquipmentTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ProviderTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}OwnerTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}SizeTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}DispositionCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}FullnessIndicationCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RefrigerationOnIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Information" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ReturnabilityIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}LegalStatusIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}AirFlowPercent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}HumidityPercent" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}AnimalFoodApprovedIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}HumanFoodApprovedIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}DangerousGoodsApprovedIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RefrigeratedIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Characteristics" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}DamageRemarks" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Description" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}SpecialTransportRequirements" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}GrossWeightMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}GrossVolumeMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TareWeightMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TrackingDeviceCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PowerIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TraceID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}MeasurementDimension" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TransportEquipmentSeal" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}MinimumTemperature" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}MaximumTemperature" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ProviderParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}LoadingProofParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}SupplierParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}OwnerParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}OperatingParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}LoadingLocation" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}UnloadingLocation" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}StorageLocation" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PositioningTransportEvent" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}QuarantineTransportEvent" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}DeliveryTransportEvent" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PickupTransportEvent" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}HandlingTransportEvent" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}LoadingTransportEvent" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}TransportEvent" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ApplicableTransportMeans" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}HaulageTradingTerms" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}HazardousGoodsTransit" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}PackagedTransportHandlingUnit" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ServiceAllowanceCharge" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}FreightAllowanceCharge" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AttachedTransportEquipment" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Delivery" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Pickup" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Despatch" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ShipmentDocumentReference" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ContainedInTransportEquipment" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Package" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}GoodsItem" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}VerifiedGrossMass" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TransportEquipmentType", propOrder = {
    "ublExtensions",
    "id",
    "referencedConsignmentID",
    "transportEquipmentTypeCode",
    "providerTypeCode",
    "ownerTypeCode",
    "sizeTypeCode",
    "dispositionCode",
    "fullnessIndicationCode",
    "refrigerationOnIndicator",
    "information",
    "returnabilityIndicator",
    "legalStatusIndicator",
    "airFlowPercent",
    "humidityPercent",
    "animalFoodApprovedIndicator",
    "humanFoodApprovedIndicator",
    "dangerousGoodsApprovedIndicator",
    "refrigeratedIndicator",
    "characteristics",
    "damageRemarks",
    "description",
    "specialTransportRequirements",
    "grossWeightMeasure",
    "grossVolumeMeasure",
    "tareWeightMeasure",
    "trackingDeviceCode",
    "powerIndicator",
    "traceID",
    "measurementDimension",
    "transportEquipmentSeal",
    "minimumTemperature",
    "maximumTemperature",
    "providerParty",
    "loadingProofParty",
    "supplierParty",
    "ownerParty",
    "operatingParty",
    "loadingLocation",
    "unloadingLocation",
    "storageLocation",
    "positioningTransportEvent",
    "quarantineTransportEvent",
    "deliveryTransportEvent",
    "pickupTransportEvent",
    "handlingTransportEvent",
    "loadingTransportEvent",
    "transportEvent",
    "applicableTransportMeans",
    "haulageTradingTerms",
    "hazardousGoodsTransit",
    "packagedTransportHandlingUnit",
    "serviceAllowanceCharge",
    "freightAllowanceCharge",
    "attachedTransportEquipment",
    "delivery",
    "pickup",
    "despatch",
    "shipmentDocumentReference",
    "containedInTransportEquipment",
    "_package",
    "goodsItem",
    "verifiedGrossMass"
})
@CodingStyleguideUnaware
public class TransportEquipmentType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IDType id;
    @XmlElement(name = "ReferencedConsignmentID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<ReferencedConsignmentIDType> referencedConsignmentID;
    @XmlElement(name = "TransportEquipmentTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TransportEquipmentTypeCodeType transportEquipmentTypeCode;
    @XmlElement(name = "ProviderTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ProviderTypeCodeType providerTypeCode;
    @XmlElement(name = "OwnerTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private OwnerTypeCodeType ownerTypeCode;
    @XmlElement(name = "SizeTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private SizeTypeCodeType sizeTypeCode;
    @XmlElement(name = "DispositionCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private DispositionCodeType dispositionCode;
    @XmlElement(name = "FullnessIndicationCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private FullnessIndicationCodeType fullnessIndicationCode;
    @XmlElement(name = "RefrigerationOnIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private RefrigerationOnIndicatorType refrigerationOnIndicator;
    @XmlElement(name = "Information", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<InformationType> information;
    @XmlElement(name = "ReturnabilityIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ReturnabilityIndicatorType returnabilityIndicator;
    @XmlElement(name = "LegalStatusIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private LegalStatusIndicatorType legalStatusIndicator;
    @XmlElement(name = "AirFlowPercent", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private AirFlowPercentType airFlowPercent;
    @XmlElement(name = "HumidityPercent", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private HumidityPercentType humidityPercent;
    @XmlElement(name = "AnimalFoodApprovedIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private AnimalFoodApprovedIndicatorType animalFoodApprovedIndicator;
    @XmlElement(name = "HumanFoodApprovedIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private HumanFoodApprovedIndicatorType humanFoodApprovedIndicator;
    @XmlElement(name = "DangerousGoodsApprovedIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private DangerousGoodsApprovedIndicatorType dangerousGoodsApprovedIndicator;
    @XmlElement(name = "RefrigeratedIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private RefrigeratedIndicatorType refrigeratedIndicator;
    @XmlElement(name = "Characteristics", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CharacteristicsType characteristics;
    @XmlElement(name = "DamageRemarks", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<DamageRemarksType> damageRemarks;
    @XmlElement(name = "Description", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<DescriptionType> description;
    @XmlElement(name = "SpecialTransportRequirements", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<SpecialTransportRequirementsType> specialTransportRequirements;
    @XmlElement(name = "GrossWeightMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private GrossWeightMeasureType grossWeightMeasure;
    @XmlElement(name = "GrossVolumeMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private GrossVolumeMeasureType grossVolumeMeasure;
    @XmlElement(name = "TareWeightMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TareWeightMeasureType tareWeightMeasure;
    @XmlElement(name = "TrackingDeviceCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TrackingDeviceCodeType trackingDeviceCode;
    @XmlElement(name = "PowerIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PowerIndicatorType powerIndicator;
    @XmlElement(name = "TraceID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TraceIDType traceID;
    @XmlElement(name = "MeasurementDimension")
    private List<DimensionType> measurementDimension;
    @XmlElement(name = "TransportEquipmentSeal")
    private List<TransportEquipmentSealType> transportEquipmentSeal;
    @XmlElement(name = "MinimumTemperature")
    private TemperatureType minimumTemperature;
    @XmlElement(name = "MaximumTemperature")
    private TemperatureType maximumTemperature;
    @XmlElement(name = "ProviderParty")
    private PartyType providerParty;
    @XmlElement(name = "LoadingProofParty")
    private PartyType loadingProofParty;
    @XmlElement(name = "SupplierParty")
    private SupplierPartyType supplierParty;
    @XmlElement(name = "OwnerParty")
    private PartyType ownerParty;
    @XmlElement(name = "OperatingParty")
    private PartyType operatingParty;
    @XmlElement(name = "LoadingLocation")
    private LocationType loadingLocation;
    @XmlElement(name = "UnloadingLocation")
    private LocationType unloadingLocation;
    @XmlElement(name = "StorageLocation")
    private LocationType storageLocation;
    @XmlElement(name = "PositioningTransportEvent")
    private List<TransportEventType> positioningTransportEvent;
    @XmlElement(name = "QuarantineTransportEvent")
    private List<TransportEventType> quarantineTransportEvent;
    @XmlElement(name = "DeliveryTransportEvent")
    private List<TransportEventType> deliveryTransportEvent;
    @XmlElement(name = "PickupTransportEvent")
    private List<TransportEventType> pickupTransportEvent;
    @XmlElement(name = "HandlingTransportEvent")
    private List<TransportEventType> handlingTransportEvent;
    @XmlElement(name = "LoadingTransportEvent")
    private List<TransportEventType> loadingTransportEvent;
    @XmlElement(name = "TransportEvent")
    private List<TransportEventType> transportEvent;
    @XmlElement(name = "ApplicableTransportMeans")
    private TransportMeansType applicableTransportMeans;
    @XmlElement(name = "HaulageTradingTerms")
    private List<TradingTermsType> haulageTradingTerms;
    @XmlElement(name = "HazardousGoodsTransit")
    private List<HazardousGoodsTransitType> hazardousGoodsTransit;
    @XmlElement(name = "PackagedTransportHandlingUnit")
    private List<TransportHandlingUnitType> packagedTransportHandlingUnit;
    @XmlElement(name = "ServiceAllowanceCharge")
    private List<AllowanceChargeType> serviceAllowanceCharge;
    @XmlElement(name = "FreightAllowanceCharge")
    private List<AllowanceChargeType> freightAllowanceCharge;
    @XmlElement(name = "AttachedTransportEquipment")
    private List<TransportEquipmentType> attachedTransportEquipment;
    @XmlElement(name = "Delivery")
    private DeliveryType delivery;
    @XmlElement(name = "Pickup")
    private PickupType pickup;
    @XmlElement(name = "Despatch")
    private DespatchType despatch;
    @XmlElement(name = "ShipmentDocumentReference")
    private List<DocumentReferenceType> shipmentDocumentReference;
    @XmlElement(name = "ContainedInTransportEquipment")
    private List<TransportEquipmentType> containedInTransportEquipment;
    @XmlElement(name = "Package")
    private List<PackageType> _package;
    @XmlElement(name = "GoodsItem")
    private List<GoodsItemType> goodsItem;
    @XmlElement(name = "VerifiedGrossMass")
    private VerifiedGrossMassType verifiedGrossMass;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public TransportEquipmentType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the referencedConsignmentID property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the referencedConsignmentID property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getReferencedConsignmentID().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ReferencedConsignmentIDType }
     * </p>
     * 
     * 
     * @return
     *     The value of the referencedConsignmentID property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ReferencedConsignmentIDType> getReferencedConsignmentID() {
        if (referencedConsignmentID == null) {
            referencedConsignmentID = new ArrayList<>();
        }
        return this.referencedConsignmentID;
    }

    /**
     * Gets the value of the transportEquipmentTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link TransportEquipmentTypeCodeType }
     *     
     */
    @Nullable
    public TransportEquipmentTypeCodeType getTransportEquipmentTypeCode() {
        return transportEquipmentTypeCode;
    }

    /**
     * Sets the value of the transportEquipmentTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportEquipmentTypeCodeType }
     *     
     */
    public void setTransportEquipmentTypeCode(
        @Nullable
        TransportEquipmentTypeCodeType value) {
        this.transportEquipmentTypeCode = value;
    }

    /**
     * Gets the value of the providerTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link ProviderTypeCodeType }
     *     
     */
    @Nullable
    public ProviderTypeCodeType getProviderTypeCode() {
        return providerTypeCode;
    }

    /**
     * Sets the value of the providerTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProviderTypeCodeType }
     *     
     */
    public void setProviderTypeCode(
        @Nullable
        ProviderTypeCodeType value) {
        this.providerTypeCode = value;
    }

    /**
     * Gets the value of the ownerTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link OwnerTypeCodeType }
     *     
     */
    @Nullable
    public OwnerTypeCodeType getOwnerTypeCode() {
        return ownerTypeCode;
    }

    /**
     * Sets the value of the ownerTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link OwnerTypeCodeType }
     *     
     */
    public void setOwnerTypeCode(
        @Nullable
        OwnerTypeCodeType value) {
        this.ownerTypeCode = value;
    }

    /**
     * Gets the value of the sizeTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link SizeTypeCodeType }
     *     
     */
    @Nullable
    public SizeTypeCodeType getSizeTypeCode() {
        return sizeTypeCode;
    }

    /**
     * Sets the value of the sizeTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link SizeTypeCodeType }
     *     
     */
    public void setSizeTypeCode(
        @Nullable
        SizeTypeCodeType value) {
        this.sizeTypeCode = value;
    }

    /**
     * Gets the value of the dispositionCode property.
     * 
     * @return
     *     possible object is
     *     {@link DispositionCodeType }
     *     
     */
    @Nullable
    public DispositionCodeType getDispositionCode() {
        return dispositionCode;
    }

    /**
     * Sets the value of the dispositionCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link DispositionCodeType }
     *     
     */
    public void setDispositionCode(
        @Nullable
        DispositionCodeType value) {
        this.dispositionCode = value;
    }

    /**
     * Gets the value of the fullnessIndicationCode property.
     * 
     * @return
     *     possible object is
     *     {@link FullnessIndicationCodeType }
     *     
     */
    @Nullable
    public FullnessIndicationCodeType getFullnessIndicationCode() {
        return fullnessIndicationCode;
    }

    /**
     * Sets the value of the fullnessIndicationCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link FullnessIndicationCodeType }
     *     
     */
    public void setFullnessIndicationCode(
        @Nullable
        FullnessIndicationCodeType value) {
        this.fullnessIndicationCode = value;
    }

    /**
     * Gets the value of the refrigerationOnIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link RefrigerationOnIndicatorType }
     *     
     */
    @Nullable
    public RefrigerationOnIndicatorType getRefrigerationOnIndicator() {
        return refrigerationOnIndicator;
    }

    /**
     * Sets the value of the refrigerationOnIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link RefrigerationOnIndicatorType }
     *     
     */
    public void setRefrigerationOnIndicator(
        @Nullable
        RefrigerationOnIndicatorType value) {
        this.refrigerationOnIndicator = value;
    }

    /**
     * Gets the value of the information property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the information property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getInformation().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link InformationType }
     * </p>
     * 
     * 
     * @return
     *     The value of the information property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<InformationType> getInformation() {
        if (information == null) {
            information = new ArrayList<>();
        }
        return this.information;
    }

    /**
     * Gets the value of the returnabilityIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link ReturnabilityIndicatorType }
     *     
     */
    @Nullable
    public ReturnabilityIndicatorType getReturnabilityIndicator() {
        return returnabilityIndicator;
    }

    /**
     * Sets the value of the returnabilityIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link ReturnabilityIndicatorType }
     *     
     */
    public void setReturnabilityIndicator(
        @Nullable
        ReturnabilityIndicatorType value) {
        this.returnabilityIndicator = value;
    }

    /**
     * Gets the value of the legalStatusIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link LegalStatusIndicatorType }
     *     
     */
    @Nullable
    public LegalStatusIndicatorType getLegalStatusIndicator() {
        return legalStatusIndicator;
    }

    /**
     * Sets the value of the legalStatusIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link LegalStatusIndicatorType }
     *     
     */
    public void setLegalStatusIndicator(
        @Nullable
        LegalStatusIndicatorType value) {
        this.legalStatusIndicator = value;
    }

    /**
     * Gets the value of the airFlowPercent property.
     * 
     * @return
     *     possible object is
     *     {@link AirFlowPercentType }
     *     
     */
    @Nullable
    public AirFlowPercentType getAirFlowPercent() {
        return airFlowPercent;
    }

    /**
     * Sets the value of the airFlowPercent property.
     * 
     * @param value
     *     allowed object is
     *     {@link AirFlowPercentType }
     *     
     */
    public void setAirFlowPercent(
        @Nullable
        AirFlowPercentType value) {
        this.airFlowPercent = value;
    }

    /**
     * Gets the value of the humidityPercent property.
     * 
     * @return
     *     possible object is
     *     {@link HumidityPercentType }
     *     
     */
    @Nullable
    public HumidityPercentType getHumidityPercent() {
        return humidityPercent;
    }

    /**
     * Sets the value of the humidityPercent property.
     * 
     * @param value
     *     allowed object is
     *     {@link HumidityPercentType }
     *     
     */
    public void setHumidityPercent(
        @Nullable
        HumidityPercentType value) {
        this.humidityPercent = value;
    }

    /**
     * Gets the value of the animalFoodApprovedIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link AnimalFoodApprovedIndicatorType }
     *     
     */
    @Nullable
    public AnimalFoodApprovedIndicatorType getAnimalFoodApprovedIndicator() {
        return animalFoodApprovedIndicator;
    }

    /**
     * Sets the value of the animalFoodApprovedIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link AnimalFoodApprovedIndicatorType }
     *     
     */
    public void setAnimalFoodApprovedIndicator(
        @Nullable
        AnimalFoodApprovedIndicatorType value) {
        this.animalFoodApprovedIndicator = value;
    }

    /**
     * Gets the value of the humanFoodApprovedIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link HumanFoodApprovedIndicatorType }
     *     
     */
    @Nullable
    public HumanFoodApprovedIndicatorType getHumanFoodApprovedIndicator() {
        return humanFoodApprovedIndicator;
    }

    /**
     * Sets the value of the humanFoodApprovedIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link HumanFoodApprovedIndicatorType }
     *     
     */
    public void setHumanFoodApprovedIndicator(
        @Nullable
        HumanFoodApprovedIndicatorType value) {
        this.humanFoodApprovedIndicator = value;
    }

    /**
     * Gets the value of the dangerousGoodsApprovedIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link DangerousGoodsApprovedIndicatorType }
     *     
     */
    @Nullable
    public DangerousGoodsApprovedIndicatorType getDangerousGoodsApprovedIndicator() {
        return dangerousGoodsApprovedIndicator;
    }

    /**
     * Sets the value of the dangerousGoodsApprovedIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link DangerousGoodsApprovedIndicatorType }
     *     
     */
    public void setDangerousGoodsApprovedIndicator(
        @Nullable
        DangerousGoodsApprovedIndicatorType value) {
        this.dangerousGoodsApprovedIndicator = value;
    }

    /**
     * Gets the value of the refrigeratedIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link RefrigeratedIndicatorType }
     *     
     */
    @Nullable
    public RefrigeratedIndicatorType getRefrigeratedIndicator() {
        return refrigeratedIndicator;
    }

    /**
     * Sets the value of the refrigeratedIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link RefrigeratedIndicatorType }
     *     
     */
    public void setRefrigeratedIndicator(
        @Nullable
        RefrigeratedIndicatorType value) {
        this.refrigeratedIndicator = value;
    }

    /**
     * Gets the value of the characteristics property.
     * 
     * @return
     *     possible object is
     *     {@link CharacteristicsType }
     *     
     */
    @Nullable
    public CharacteristicsType getCharacteristics() {
        return characteristics;
    }

    /**
     * Sets the value of the characteristics property.
     * 
     * @param value
     *     allowed object is
     *     {@link CharacteristicsType }
     *     
     */
    public void setCharacteristics(
        @Nullable
        CharacteristicsType value) {
        this.characteristics = value;
    }

    /**
     * Gets the value of the damageRemarks property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the damageRemarks property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDamageRemarks().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DamageRemarksType }
     * </p>
     * 
     * 
     * @return
     *     The value of the damageRemarks property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DamageRemarksType> getDamageRemarks() {
        if (damageRemarks == null) {
            damageRemarks = new ArrayList<>();
        }
        return this.damageRemarks;
    }

    /**
     * Gets the value of the description property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the description property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the description property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DescriptionType> getDescription() {
        if (description == null) {
            description = new ArrayList<>();
        }
        return this.description;
    }

    /**
     * Gets the value of the specialTransportRequirements property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the specialTransportRequirements property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getSpecialTransportRequirements().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SpecialTransportRequirementsType }
     * </p>
     * 
     * 
     * @return
     *     The value of the specialTransportRequirements property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<SpecialTransportRequirementsType> getSpecialTransportRequirements() {
        if (specialTransportRequirements == null) {
            specialTransportRequirements = new ArrayList<>();
        }
        return this.specialTransportRequirements;
    }

    /**
     * Gets the value of the grossWeightMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link GrossWeightMeasureType }
     *     
     */
    @Nullable
    public GrossWeightMeasureType getGrossWeightMeasure() {
        return grossWeightMeasure;
    }

    /**
     * Sets the value of the grossWeightMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link GrossWeightMeasureType }
     *     
     */
    public void setGrossWeightMeasure(
        @Nullable
        GrossWeightMeasureType value) {
        this.grossWeightMeasure = value;
    }

    /**
     * Gets the value of the grossVolumeMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link GrossVolumeMeasureType }
     *     
     */
    @Nullable
    public GrossVolumeMeasureType getGrossVolumeMeasure() {
        return grossVolumeMeasure;
    }

    /**
     * Sets the value of the grossVolumeMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link GrossVolumeMeasureType }
     *     
     */
    public void setGrossVolumeMeasure(
        @Nullable
        GrossVolumeMeasureType value) {
        this.grossVolumeMeasure = value;
    }

    /**
     * Gets the value of the tareWeightMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link TareWeightMeasureType }
     *     
     */
    @Nullable
    public TareWeightMeasureType getTareWeightMeasure() {
        return tareWeightMeasure;
    }

    /**
     * Sets the value of the tareWeightMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link TareWeightMeasureType }
     *     
     */
    public void setTareWeightMeasure(
        @Nullable
        TareWeightMeasureType value) {
        this.tareWeightMeasure = value;
    }

    /**
     * Gets the value of the trackingDeviceCode property.
     * 
     * @return
     *     possible object is
     *     {@link TrackingDeviceCodeType }
     *     
     */
    @Nullable
    public TrackingDeviceCodeType getTrackingDeviceCode() {
        return trackingDeviceCode;
    }

    /**
     * Sets the value of the trackingDeviceCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TrackingDeviceCodeType }
     *     
     */
    public void setTrackingDeviceCode(
        @Nullable
        TrackingDeviceCodeType value) {
        this.trackingDeviceCode = value;
    }

    /**
     * Gets the value of the powerIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link PowerIndicatorType }
     *     
     */
    @Nullable
    public PowerIndicatorType getPowerIndicator() {
        return powerIndicator;
    }

    /**
     * Sets the value of the powerIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link PowerIndicatorType }
     *     
     */
    public void setPowerIndicator(
        @Nullable
        PowerIndicatorType value) {
        this.powerIndicator = value;
    }

    /**
     * Gets the value of the traceID property.
     * 
     * @return
     *     possible object is
     *     {@link TraceIDType }
     *     
     */
    @Nullable
    public TraceIDType getTraceID() {
        return traceID;
    }

    /**
     * Sets the value of the traceID property.
     * 
     * @param value
     *     allowed object is
     *     {@link TraceIDType }
     *     
     */
    public void setTraceID(
        @Nullable
        TraceIDType value) {
        this.traceID = value;
    }

    /**
     * Gets the value of the measurementDimension property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the measurementDimension property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getMeasurementDimension().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DimensionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the measurementDimension property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DimensionType> getMeasurementDimension() {
        if (measurementDimension == null) {
            measurementDimension = new ArrayList<>();
        }
        return this.measurementDimension;
    }

    /**
     * Gets the value of the transportEquipmentSeal property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the transportEquipmentSeal property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getTransportEquipmentSeal().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TransportEquipmentSealType }
     * </p>
     * 
     * 
     * @return
     *     The value of the transportEquipmentSeal property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TransportEquipmentSealType> getTransportEquipmentSeal() {
        if (transportEquipmentSeal == null) {
            transportEquipmentSeal = new ArrayList<>();
        }
        return this.transportEquipmentSeal;
    }

    /**
     * Gets the value of the minimumTemperature property.
     * 
     * @return
     *     possible object is
     *     {@link TemperatureType }
     *     
     */
    @Nullable
    public TemperatureType getMinimumTemperature() {
        return minimumTemperature;
    }

    /**
     * Sets the value of the minimumTemperature property.
     * 
     * @param value
     *     allowed object is
     *     {@link TemperatureType }
     *     
     */
    public void setMinimumTemperature(
        @Nullable
        TemperatureType value) {
        this.minimumTemperature = value;
    }

    /**
     * Gets the value of the maximumTemperature property.
     * 
     * @return
     *     possible object is
     *     {@link TemperatureType }
     *     
     */
    @Nullable
    public TemperatureType getMaximumTemperature() {
        return maximumTemperature;
    }

    /**
     * Sets the value of the maximumTemperature property.
     * 
     * @param value
     *     allowed object is
     *     {@link TemperatureType }
     *     
     */
    public void setMaximumTemperature(
        @Nullable
        TemperatureType value) {
        this.maximumTemperature = value;
    }

    /**
     * Gets the value of the providerParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getProviderParty() {
        return providerParty;
    }

    /**
     * Sets the value of the providerParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setProviderParty(
        @Nullable
        PartyType value) {
        this.providerParty = value;
    }

    /**
     * Gets the value of the loadingProofParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getLoadingProofParty() {
        return loadingProofParty;
    }

    /**
     * Sets the value of the loadingProofParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setLoadingProofParty(
        @Nullable
        PartyType value) {
        this.loadingProofParty = value;
    }

    /**
     * Gets the value of the supplierParty property.
     * 
     * @return
     *     possible object is
     *     {@link SupplierPartyType }
     *     
     */
    @Nullable
    public SupplierPartyType getSupplierParty() {
        return supplierParty;
    }

    /**
     * Sets the value of the supplierParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link SupplierPartyType }
     *     
     */
    public void setSupplierParty(
        @Nullable
        SupplierPartyType value) {
        this.supplierParty = value;
    }

    /**
     * Gets the value of the ownerParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getOwnerParty() {
        return ownerParty;
    }

    /**
     * Sets the value of the ownerParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setOwnerParty(
        @Nullable
        PartyType value) {
        this.ownerParty = value;
    }

    /**
     * Gets the value of the operatingParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getOperatingParty() {
        return operatingParty;
    }

    /**
     * Sets the value of the operatingParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setOperatingParty(
        @Nullable
        PartyType value) {
        this.operatingParty = value;
    }

    /**
     * Gets the value of the loadingLocation property.
     * 
     * @return
     *     possible object is
     *     {@link LocationType }
     *     
     */
    @Nullable
    public LocationType getLoadingLocation() {
        return loadingLocation;
    }

    /**
     * Sets the value of the loadingLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationType }
     *     
     */
    public void setLoadingLocation(
        @Nullable
        LocationType value) {
        this.loadingLocation = value;
    }

    /**
     * Gets the value of the unloadingLocation property.
     * 
     * @return
     *     possible object is
     *     {@link LocationType }
     *     
     */
    @Nullable
    public LocationType getUnloadingLocation() {
        return unloadingLocation;
    }

    /**
     * Sets the value of the unloadingLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationType }
     *     
     */
    public void setUnloadingLocation(
        @Nullable
        LocationType value) {
        this.unloadingLocation = value;
    }

    /**
     * Gets the value of the storageLocation property.
     * 
     * @return
     *     possible object is
     *     {@link LocationType }
     *     
     */
    @Nullable
    public LocationType getStorageLocation() {
        return storageLocation;
    }

    /**
     * Sets the value of the storageLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationType }
     *     
     */
    public void setStorageLocation(
        @Nullable
        LocationType value) {
        this.storageLocation = value;
    }

    /**
     * Gets the value of the positioningTransportEvent property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the positioningTransportEvent property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPositioningTransportEvent().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TransportEventType }
     * </p>
     * 
     * 
     * @return
     *     The value of the positioningTransportEvent property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TransportEventType> getPositioningTransportEvent() {
        if (positioningTransportEvent == null) {
            positioningTransportEvent = new ArrayList<>();
        }
        return this.positioningTransportEvent;
    }

    /**
     * Gets the value of the quarantineTransportEvent property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the quarantineTransportEvent property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getQuarantineTransportEvent().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TransportEventType }
     * </p>
     * 
     * 
     * @return
     *     The value of the quarantineTransportEvent property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TransportEventType> getQuarantineTransportEvent() {
        if (quarantineTransportEvent == null) {
            quarantineTransportEvent = new ArrayList<>();
        }
        return this.quarantineTransportEvent;
    }

    /**
     * Gets the value of the deliveryTransportEvent property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the deliveryTransportEvent property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDeliveryTransportEvent().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TransportEventType }
     * </p>
     * 
     * 
     * @return
     *     The value of the deliveryTransportEvent property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TransportEventType> getDeliveryTransportEvent() {
        if (deliveryTransportEvent == null) {
            deliveryTransportEvent = new ArrayList<>();
        }
        return this.deliveryTransportEvent;
    }

    /**
     * Gets the value of the pickupTransportEvent property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the pickupTransportEvent property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPickupTransportEvent().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TransportEventType }
     * </p>
     * 
     * 
     * @return
     *     The value of the pickupTransportEvent property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TransportEventType> getPickupTransportEvent() {
        if (pickupTransportEvent == null) {
            pickupTransportEvent = new ArrayList<>();
        }
        return this.pickupTransportEvent;
    }

    /**
     * Gets the value of the handlingTransportEvent property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the handlingTransportEvent property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getHandlingTransportEvent().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TransportEventType }
     * </p>
     * 
     * 
     * @return
     *     The value of the handlingTransportEvent property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TransportEventType> getHandlingTransportEvent() {
        if (handlingTransportEvent == null) {
            handlingTransportEvent = new ArrayList<>();
        }
        return this.handlingTransportEvent;
    }

    /**
     * Gets the value of the loadingTransportEvent property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the loadingTransportEvent property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getLoadingTransportEvent().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TransportEventType }
     * </p>
     * 
     * 
     * @return
     *     The value of the loadingTransportEvent property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TransportEventType> getLoadingTransportEvent() {
        if (loadingTransportEvent == null) {
            loadingTransportEvent = new ArrayList<>();
        }
        return this.loadingTransportEvent;
    }

    /**
     * Gets the value of the transportEvent property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the transportEvent property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getTransportEvent().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TransportEventType }
     * </p>
     * 
     * 
     * @return
     *     The value of the transportEvent property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TransportEventType> getTransportEvent() {
        if (transportEvent == null) {
            transportEvent = new ArrayList<>();
        }
        return this.transportEvent;
    }

    /**
     * Gets the value of the applicableTransportMeans property.
     * 
     * @return
     *     possible object is
     *     {@link TransportMeansType }
     *     
     */
    @Nullable
    public TransportMeansType getApplicableTransportMeans() {
        return applicableTransportMeans;
    }

    /**
     * Sets the value of the applicableTransportMeans property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportMeansType }
     *     
     */
    public void setApplicableTransportMeans(
        @Nullable
        TransportMeansType value) {
        this.applicableTransportMeans = value;
    }

    /**
     * Gets the value of the haulageTradingTerms property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the haulageTradingTerms property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getHaulageTradingTerms().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TradingTermsType }
     * </p>
     * 
     * 
     * @return
     *     The value of the haulageTradingTerms property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TradingTermsType> getHaulageTradingTerms() {
        if (haulageTradingTerms == null) {
            haulageTradingTerms = new ArrayList<>();
        }
        return this.haulageTradingTerms;
    }

    /**
     * Gets the value of the hazardousGoodsTransit property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the hazardousGoodsTransit property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getHazardousGoodsTransit().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link HazardousGoodsTransitType }
     * </p>
     * 
     * 
     * @return
     *     The value of the hazardousGoodsTransit property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<HazardousGoodsTransitType> getHazardousGoodsTransit() {
        if (hazardousGoodsTransit == null) {
            hazardousGoodsTransit = new ArrayList<>();
        }
        return this.hazardousGoodsTransit;
    }

    /**
     * Gets the value of the packagedTransportHandlingUnit property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the packagedTransportHandlingUnit property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPackagedTransportHandlingUnit().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TransportHandlingUnitType }
     * </p>
     * 
     * 
     * @return
     *     The value of the packagedTransportHandlingUnit property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TransportHandlingUnitType> getPackagedTransportHandlingUnit() {
        if (packagedTransportHandlingUnit == null) {
            packagedTransportHandlingUnit = new ArrayList<>();
        }
        return this.packagedTransportHandlingUnit;
    }

    /**
     * Gets the value of the serviceAllowanceCharge property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the serviceAllowanceCharge property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getServiceAllowanceCharge().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AllowanceChargeType }
     * </p>
     * 
     * 
     * @return
     *     The value of the serviceAllowanceCharge property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AllowanceChargeType> getServiceAllowanceCharge() {
        if (serviceAllowanceCharge == null) {
            serviceAllowanceCharge = new ArrayList<>();
        }
        return this.serviceAllowanceCharge;
    }

    /**
     * Gets the value of the freightAllowanceCharge property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the freightAllowanceCharge property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getFreightAllowanceCharge().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link AllowanceChargeType }
     * </p>
     * 
     * 
     * @return
     *     The value of the freightAllowanceCharge property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<AllowanceChargeType> getFreightAllowanceCharge() {
        if (freightAllowanceCharge == null) {
            freightAllowanceCharge = new ArrayList<>();
        }
        return this.freightAllowanceCharge;
    }

    /**
     * Gets the value of the attachedTransportEquipment property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the attachedTransportEquipment property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getAttachedTransportEquipment().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TransportEquipmentType }
     * </p>
     * 
     * 
     * @return
     *     The value of the attachedTransportEquipment property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TransportEquipmentType> getAttachedTransportEquipment() {
        if (attachedTransportEquipment == null) {
            attachedTransportEquipment = new ArrayList<>();
        }
        return this.attachedTransportEquipment;
    }

    /**
     * Gets the value of the delivery property.
     * 
     * @return
     *     possible object is
     *     {@link DeliveryType }
     *     
     */
    @Nullable
    public DeliveryType getDelivery() {
        return delivery;
    }

    /**
     * Sets the value of the delivery property.
     * 
     * @param value
     *     allowed object is
     *     {@link DeliveryType }
     *     
     */
    public void setDelivery(
        @Nullable
        DeliveryType value) {
        this.delivery = value;
    }

    /**
     * Gets the value of the pickup property.
     * 
     * @return
     *     possible object is
     *     {@link PickupType }
     *     
     */
    @Nullable
    public PickupType getPickup() {
        return pickup;
    }

    /**
     * Sets the value of the pickup property.
     * 
     * @param value
     *     allowed object is
     *     {@link PickupType }
     *     
     */
    public void setPickup(
        @Nullable
        PickupType value) {
        this.pickup = value;
    }

    /**
     * Gets the value of the despatch property.
     * 
     * @return
     *     possible object is
     *     {@link DespatchType }
     *     
     */
    @Nullable
    public DespatchType getDespatch() {
        return despatch;
    }

    /**
     * Sets the value of the despatch property.
     * 
     * @param value
     *     allowed object is
     *     {@link DespatchType }
     *     
     */
    public void setDespatch(
        @Nullable
        DespatchType value) {
        this.despatch = value;
    }

    /**
     * Gets the value of the shipmentDocumentReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the shipmentDocumentReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getShipmentDocumentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the shipmentDocumentReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentReferenceType> getShipmentDocumentReference() {
        if (shipmentDocumentReference == null) {
            shipmentDocumentReference = new ArrayList<>();
        }
        return this.shipmentDocumentReference;
    }

    /**
     * Gets the value of the containedInTransportEquipment property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the containedInTransportEquipment property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getContainedInTransportEquipment().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link TransportEquipmentType }
     * </p>
     * 
     * 
     * @return
     *     The value of the containedInTransportEquipment property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<TransportEquipmentType> getContainedInTransportEquipment() {
        if (containedInTransportEquipment == null) {
            containedInTransportEquipment = new ArrayList<>();
        }
        return this.containedInTransportEquipment;
    }

    /**
     * Gets the value of the package property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the package property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getPackage().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PackageType }
     * </p>
     * 
     * 
     * @return
     *     The value of the package property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<PackageType> getPackage() {
        if (_package == null) {
            _package = new ArrayList<>();
        }
        return this._package;
    }

    /**
     * Gets the value of the goodsItem property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the goodsItem property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getGoodsItem().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link GoodsItemType }
     * </p>
     * 
     * 
     * @return
     *     The value of the goodsItem property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<GoodsItemType> getGoodsItem() {
        if (goodsItem == null) {
            goodsItem = new ArrayList<>();
        }
        return this.goodsItem;
    }

    /**
     * Gets the value of the verifiedGrossMass property.
     * 
     * @return
     *     possible object is
     *     {@link VerifiedGrossMassType }
     *     
     */
    @Nullable
    public VerifiedGrossMassType getVerifiedGrossMass() {
        return verifiedGrossMass;
    }

    /**
     * Sets the value of the verifiedGrossMass property.
     * 
     * @param value
     *     allowed object is
     *     {@link VerifiedGrossMassType }
     *     
     */
    public void setVerifiedGrossMass(
        @Nullable
        VerifiedGrossMassType value) {
        this.verifiedGrossMass = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final TransportEquipmentType rhs = ((TransportEquipmentType) o);
        if (!EqualsHelper.equalsCollection(_package, rhs._package)) {
            return false;
        }
        if (!EqualsHelper.equals(airFlowPercent, rhs.airFlowPercent)) {
            return false;
        }
        if (!EqualsHelper.equals(animalFoodApprovedIndicator, rhs.animalFoodApprovedIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(applicableTransportMeans, rhs.applicableTransportMeans)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(attachedTransportEquipment, rhs.attachedTransportEquipment)) {
            return false;
        }
        if (!EqualsHelper.equals(characteristics, rhs.characteristics)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(containedInTransportEquipment, rhs.containedInTransportEquipment)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(damageRemarks, rhs.damageRemarks)) {
            return false;
        }
        if (!EqualsHelper.equals(dangerousGoodsApprovedIndicator, rhs.dangerousGoodsApprovedIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(delivery, rhs.delivery)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(deliveryTransportEvent, rhs.deliveryTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equals(despatch, rhs.despatch)) {
            return false;
        }
        if (!EqualsHelper.equals(dispositionCode, rhs.dispositionCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(freightAllowanceCharge, rhs.freightAllowanceCharge)) {
            return false;
        }
        if (!EqualsHelper.equals(fullnessIndicationCode, rhs.fullnessIndicationCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(goodsItem, rhs.goodsItem)) {
            return false;
        }
        if (!EqualsHelper.equals(grossVolumeMeasure, rhs.grossVolumeMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(grossWeightMeasure, rhs.grossWeightMeasure)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(handlingTransportEvent, rhs.handlingTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(haulageTradingTerms, rhs.haulageTradingTerms)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(hazardousGoodsTransit, rhs.hazardousGoodsTransit)) {
            return false;
        }
        if (!EqualsHelper.equals(humanFoodApprovedIndicator, rhs.humanFoodApprovedIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(humidityPercent, rhs.humidityPercent)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(information, rhs.information)) {
            return false;
        }
        if (!EqualsHelper.equals(legalStatusIndicator, rhs.legalStatusIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(loadingLocation, rhs.loadingLocation)) {
            return false;
        }
        if (!EqualsHelper.equals(loadingProofParty, rhs.loadingProofParty)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(loadingTransportEvent, rhs.loadingTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(maximumTemperature, rhs.maximumTemperature)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(measurementDimension, rhs.measurementDimension)) {
            return false;
        }
        if (!EqualsHelper.equals(minimumTemperature, rhs.minimumTemperature)) {
            return false;
        }
        if (!EqualsHelper.equals(operatingParty, rhs.operatingParty)) {
            return false;
        }
        if (!EqualsHelper.equals(ownerParty, rhs.ownerParty)) {
            return false;
        }
        if (!EqualsHelper.equals(ownerTypeCode, rhs.ownerTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(packagedTransportHandlingUnit, rhs.packagedTransportHandlingUnit)) {
            return false;
        }
        if (!EqualsHelper.equals(pickup, rhs.pickup)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(pickupTransportEvent, rhs.pickupTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(positioningTransportEvent, rhs.positioningTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(powerIndicator, rhs.powerIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(providerParty, rhs.providerParty)) {
            return false;
        }
        if (!EqualsHelper.equals(providerTypeCode, rhs.providerTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(quarantineTransportEvent, rhs.quarantineTransportEvent)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(referencedConsignmentID, rhs.referencedConsignmentID)) {
            return false;
        }
        if (!EqualsHelper.equals(refrigeratedIndicator, rhs.refrigeratedIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(refrigerationOnIndicator, rhs.refrigerationOnIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(returnabilityIndicator, rhs.returnabilityIndicator)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(serviceAllowanceCharge, rhs.serviceAllowanceCharge)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(shipmentDocumentReference, rhs.shipmentDocumentReference)) {
            return false;
        }
        if (!EqualsHelper.equals(sizeTypeCode, rhs.sizeTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(specialTransportRequirements, rhs.specialTransportRequirements)) {
            return false;
        }
        if (!EqualsHelper.equals(storageLocation, rhs.storageLocation)) {
            return false;
        }
        if (!EqualsHelper.equals(supplierParty, rhs.supplierParty)) {
            return false;
        }
        if (!EqualsHelper.equals(tareWeightMeasure, rhs.tareWeightMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(traceID, rhs.traceID)) {
            return false;
        }
        if (!EqualsHelper.equals(trackingDeviceCode, rhs.trackingDeviceCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(transportEquipmentSeal, rhs.transportEquipmentSeal)) {
            return false;
        }
        if (!EqualsHelper.equals(transportEquipmentTypeCode, rhs.transportEquipmentTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(transportEvent, rhs.transportEvent)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equals(unloadingLocation, rhs.unloadingLocation)) {
            return false;
        }
        if (!EqualsHelper.equals(verifiedGrossMass, rhs.verifiedGrossMass)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(_package).append(airFlowPercent).append(animalFoodApprovedIndicator).append(applicableTransportMeans).append(attachedTransportEquipment).append(characteristics).append(containedInTransportEquipment).append(damageRemarks).append(dangerousGoodsApprovedIndicator).append(delivery).append(deliveryTransportEvent).append(description).append(despatch).append(dispositionCode).append(freightAllowanceCharge).append(fullnessIndicationCode).append(goodsItem).append(grossVolumeMeasure).append(grossWeightMeasure).append(handlingTransportEvent).append(haulageTradingTerms).append(hazardousGoodsTransit).append(humanFoodApprovedIndicator).append(humidityPercent).append(id).append(information).append(legalStatusIndicator).append(loadingLocation).append(loadingProofParty).append(loadingTransportEvent).append(maximumTemperature).append(measurementDimension).append(minimumTemperature).append(operatingParty).append(ownerParty).append(ownerTypeCode).append(packagedTransportHandlingUnit).append(pickup).append(pickupTransportEvent).append(positioningTransportEvent).append(powerIndicator).append(providerParty).append(providerTypeCode).append(quarantineTransportEvent).append(referencedConsignmentID).append(refrigeratedIndicator).append(refrigerationOnIndicator).append(returnabilityIndicator).append(serviceAllowanceCharge).append(shipmentDocumentReference).append(sizeTypeCode).append(specialTransportRequirements).append(storageLocation).append(supplierParty).append(tareWeightMeasure).append(traceID).append(trackingDeviceCode).append(transportEquipmentSeal).append(transportEquipmentTypeCode).append(transportEvent).append(ublExtensions).append(unloadingLocation).append(verifiedGrossMass).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("_package", _package).append("airFlowPercent", airFlowPercent).append("animalFoodApprovedIndicator", animalFoodApprovedIndicator).append("applicableTransportMeans", applicableTransportMeans).append("attachedTransportEquipment", attachedTransportEquipment).append("characteristics", characteristics).append("containedInTransportEquipment", containedInTransportEquipment).append("damageRemarks", damageRemarks).append("dangerousGoodsApprovedIndicator", dangerousGoodsApprovedIndicator).append("delivery", delivery).append("deliveryTransportEvent", deliveryTransportEvent).append("description", description).append("despatch", despatch).append("dispositionCode", dispositionCode).append("freightAllowanceCharge", freightAllowanceCharge).append("fullnessIndicationCode", fullnessIndicationCode).append("goodsItem", goodsItem).append("grossVolumeMeasure", grossVolumeMeasure).append("grossWeightMeasure", grossWeightMeasure).append("handlingTransportEvent", handlingTransportEvent).append("haulageTradingTerms", haulageTradingTerms).append("hazardousGoodsTransit", hazardousGoodsTransit).append("humanFoodApprovedIndicator", humanFoodApprovedIndicator).append("humidityPercent", humidityPercent).append("id", id).append("information", information).append("legalStatusIndicator", legalStatusIndicator).append("loadingLocation", loadingLocation).append("loadingProofParty", loadingProofParty).append("loadingTransportEvent", loadingTransportEvent).append("maximumTemperature", maximumTemperature).append("measurementDimension", measurementDimension).append("minimumTemperature", minimumTemperature).append("operatingParty", operatingParty).append("ownerParty", ownerParty).append("ownerTypeCode", ownerTypeCode).append("packagedTransportHandlingUnit", packagedTransportHandlingUnit).append("pickup", pickup).append("pickupTransportEvent", pickupTransportEvent).append("positioningTransportEvent", positioningTransportEvent).append("powerIndicator", powerIndicator).append("providerParty", providerParty).append("providerTypeCode", providerTypeCode).append("quarantineTransportEvent", quarantineTransportEvent).append("referencedConsignmentID", referencedConsignmentID).append("refrigeratedIndicator", refrigeratedIndicator).append("refrigerationOnIndicator", refrigerationOnIndicator).append("returnabilityIndicator", returnabilityIndicator).append("serviceAllowanceCharge", serviceAllowanceCharge).append("shipmentDocumentReference", shipmentDocumentReference).append("sizeTypeCode", sizeTypeCode).append("specialTransportRequirements", specialTransportRequirements).append("storageLocation", storageLocation).append("supplierParty", supplierParty).append("tareWeightMeasure", tareWeightMeasure).append("traceID", traceID).append("trackingDeviceCode", trackingDeviceCode).append("transportEquipmentSeal", transportEquipmentSeal).append("transportEquipmentTypeCode", transportEquipmentTypeCode).append("transportEvent", transportEvent).append("ublExtensions", ublExtensions).append("unloadingLocation", unloadingLocation).append("verifiedGrossMass", verifiedGrossMass).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setReferencedConsignmentID(
        @Nullable
        final List<ReferencedConsignmentIDType> aList) {
        referencedConsignmentID = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setInformation(
        @Nullable
        final List<InformationType> aList) {
        information = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDamageRemarks(
        @Nullable
        final List<DamageRemarksType> aList) {
        damageRemarks = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<DescriptionType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSpecialTransportRequirements(
        @Nullable
        final List<SpecialTransportRequirementsType> aList) {
        specialTransportRequirements = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setMeasurementDimension(
        @Nullable
        final List<DimensionType> aList) {
        measurementDimension = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTransportEquipmentSeal(
        @Nullable
        final List<TransportEquipmentSealType> aList) {
        transportEquipmentSeal = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPositioningTransportEvent(
        @Nullable
        final List<TransportEventType> aList) {
        positioningTransportEvent = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setQuarantineTransportEvent(
        @Nullable
        final List<TransportEventType> aList) {
        quarantineTransportEvent = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDeliveryTransportEvent(
        @Nullable
        final List<TransportEventType> aList) {
        deliveryTransportEvent = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPickupTransportEvent(
        @Nullable
        final List<TransportEventType> aList) {
        pickupTransportEvent = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setHandlingTransportEvent(
        @Nullable
        final List<TransportEventType> aList) {
        handlingTransportEvent = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setLoadingTransportEvent(
        @Nullable
        final List<TransportEventType> aList) {
        loadingTransportEvent = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setTransportEvent(
        @Nullable
        final List<TransportEventType> aList) {
        transportEvent = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setHaulageTradingTerms(
        @Nullable
        final List<TradingTermsType> aList) {
        haulageTradingTerms = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setHazardousGoodsTransit(
        @Nullable
        final List<HazardousGoodsTransitType> aList) {
        hazardousGoodsTransit = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPackagedTransportHandlingUnit(
        @Nullable
        final List<TransportHandlingUnitType> aList) {
        packagedTransportHandlingUnit = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setServiceAllowanceCharge(
        @Nullable
        final List<AllowanceChargeType> aList) {
        serviceAllowanceCharge = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setFreightAllowanceCharge(
        @Nullable
        final List<AllowanceChargeType> aList) {
        freightAllowanceCharge = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setAttachedTransportEquipment(
        @Nullable
        final List<TransportEquipmentType> aList) {
        attachedTransportEquipment = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setShipmentDocumentReference(
        @Nullable
        final List<DocumentReferenceType> aList) {
        shipmentDocumentReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setContainedInTransportEquipment(
        @Nullable
        final List<TransportEquipmentType> aList) {
        containedInTransportEquipment = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setPackage(
        @Nullable
        final List<PackageType> aList) {
        _package = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setGoodsItem(
        @Nullable
        final List<GoodsItemType> aList) {
        goodsItem = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasReferencedConsignmentIDEntries() {
        return (!getReferencedConsignmentID().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoReferencedConsignmentIDEntries() {
        return getReferencedConsignmentID().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getReferencedConsignmentIDCount() {
        return getReferencedConsignmentID().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ReferencedConsignmentIDType getReferencedConsignmentIDAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getReferencedConsignmentID().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addReferencedConsignmentID(
        @Nonnull
        final ReferencedConsignmentIDType elem) {
        getReferencedConsignmentID().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasInformationEntries() {
        return (!getInformation().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoInformationEntries() {
        return getInformation().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getInformationCount() {
        return getInformation().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public InformationType getInformationAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getInformation().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addInformation(
        @Nonnull
        final InformationType elem) {
        getInformation().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDamageRemarksEntries() {
        return (!getDamageRemarks().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDamageRemarksEntries() {
        return getDamageRemarks().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDamageRemarksCount() {
        return getDamageRemarks().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DamageRemarksType getDamageRemarksAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDamageRemarks().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDamageRemarks(
        @Nonnull
        final DamageRemarksType elem) {
        getDamageRemarks().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DescriptionType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final DescriptionType elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSpecialTransportRequirementsEntries() {
        return (!getSpecialTransportRequirements().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSpecialTransportRequirementsEntries() {
        return getSpecialTransportRequirements().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSpecialTransportRequirementsCount() {
        return getSpecialTransportRequirements().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public SpecialTransportRequirementsType getSpecialTransportRequirementsAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSpecialTransportRequirements().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSpecialTransportRequirements(
        @Nonnull
        final SpecialTransportRequirementsType elem) {
        getSpecialTransportRequirements().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasMeasurementDimensionEntries() {
        return (!getMeasurementDimension().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoMeasurementDimensionEntries() {
        return getMeasurementDimension().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getMeasurementDimensionCount() {
        return getMeasurementDimension().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DimensionType getMeasurementDimensionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getMeasurementDimension().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addMeasurementDimension(
        @Nonnull
        final DimensionType elem) {
        getMeasurementDimension().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTransportEquipmentSealEntries() {
        return (!getTransportEquipmentSeal().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTransportEquipmentSealEntries() {
        return getTransportEquipmentSeal().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTransportEquipmentSealCount() {
        return getTransportEquipmentSeal().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TransportEquipmentSealType getTransportEquipmentSealAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTransportEquipmentSeal().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTransportEquipmentSeal(
        @Nonnull
        final TransportEquipmentSealType elem) {
        getTransportEquipmentSeal().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPositioningTransportEventEntries() {
        return (!getPositioningTransportEvent().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPositioningTransportEventEntries() {
        return getPositioningTransportEvent().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPositioningTransportEventCount() {
        return getPositioningTransportEvent().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TransportEventType getPositioningTransportEventAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPositioningTransportEvent().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPositioningTransportEvent(
        @Nonnull
        final TransportEventType elem) {
        getPositioningTransportEvent().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasQuarantineTransportEventEntries() {
        return (!getQuarantineTransportEvent().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoQuarantineTransportEventEntries() {
        return getQuarantineTransportEvent().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getQuarantineTransportEventCount() {
        return getQuarantineTransportEvent().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TransportEventType getQuarantineTransportEventAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getQuarantineTransportEvent().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addQuarantineTransportEvent(
        @Nonnull
        final TransportEventType elem) {
        getQuarantineTransportEvent().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDeliveryTransportEventEntries() {
        return (!getDeliveryTransportEvent().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDeliveryTransportEventEntries() {
        return getDeliveryTransportEvent().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDeliveryTransportEventCount() {
        return getDeliveryTransportEvent().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TransportEventType getDeliveryTransportEventAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDeliveryTransportEvent().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDeliveryTransportEvent(
        @Nonnull
        final TransportEventType elem) {
        getDeliveryTransportEvent().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPickupTransportEventEntries() {
        return (!getPickupTransportEvent().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPickupTransportEventEntries() {
        return getPickupTransportEvent().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPickupTransportEventCount() {
        return getPickupTransportEvent().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TransportEventType getPickupTransportEventAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPickupTransportEvent().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPickupTransportEvent(
        @Nonnull
        final TransportEventType elem) {
        getPickupTransportEvent().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasHandlingTransportEventEntries() {
        return (!getHandlingTransportEvent().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoHandlingTransportEventEntries() {
        return getHandlingTransportEvent().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getHandlingTransportEventCount() {
        return getHandlingTransportEvent().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TransportEventType getHandlingTransportEventAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getHandlingTransportEvent().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addHandlingTransportEvent(
        @Nonnull
        final TransportEventType elem) {
        getHandlingTransportEvent().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasLoadingTransportEventEntries() {
        return (!getLoadingTransportEvent().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoLoadingTransportEventEntries() {
        return getLoadingTransportEvent().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getLoadingTransportEventCount() {
        return getLoadingTransportEvent().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TransportEventType getLoadingTransportEventAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getLoadingTransportEvent().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addLoadingTransportEvent(
        @Nonnull
        final TransportEventType elem) {
        getLoadingTransportEvent().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasTransportEventEntries() {
        return (!getTransportEvent().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoTransportEventEntries() {
        return getTransportEvent().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getTransportEventCount() {
        return getTransportEvent().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TransportEventType getTransportEventAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getTransportEvent().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addTransportEvent(
        @Nonnull
        final TransportEventType elem) {
        getTransportEvent().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasHaulageTradingTermsEntries() {
        return (!getHaulageTradingTerms().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoHaulageTradingTermsEntries() {
        return getHaulageTradingTerms().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getHaulageTradingTermsCount() {
        return getHaulageTradingTerms().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TradingTermsType getHaulageTradingTermsAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getHaulageTradingTerms().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addHaulageTradingTerms(
        @Nonnull
        final TradingTermsType elem) {
        getHaulageTradingTerms().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasHazardousGoodsTransitEntries() {
        return (!getHazardousGoodsTransit().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoHazardousGoodsTransitEntries() {
        return getHazardousGoodsTransit().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getHazardousGoodsTransitCount() {
        return getHazardousGoodsTransit().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public HazardousGoodsTransitType getHazardousGoodsTransitAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getHazardousGoodsTransit().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addHazardousGoodsTransit(
        @Nonnull
        final HazardousGoodsTransitType elem) {
        getHazardousGoodsTransit().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPackagedTransportHandlingUnitEntries() {
        return (!getPackagedTransportHandlingUnit().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPackagedTransportHandlingUnitEntries() {
        return getPackagedTransportHandlingUnit().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPackagedTransportHandlingUnitCount() {
        return getPackagedTransportHandlingUnit().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TransportHandlingUnitType getPackagedTransportHandlingUnitAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPackagedTransportHandlingUnit().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPackagedTransportHandlingUnit(
        @Nonnull
        final TransportHandlingUnitType elem) {
        getPackagedTransportHandlingUnit().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasServiceAllowanceChargeEntries() {
        return (!getServiceAllowanceCharge().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoServiceAllowanceChargeEntries() {
        return getServiceAllowanceCharge().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getServiceAllowanceChargeCount() {
        return getServiceAllowanceCharge().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AllowanceChargeType getServiceAllowanceChargeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getServiceAllowanceCharge().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addServiceAllowanceCharge(
        @Nonnull
        final AllowanceChargeType elem) {
        getServiceAllowanceCharge().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasFreightAllowanceChargeEntries() {
        return (!getFreightAllowanceCharge().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoFreightAllowanceChargeEntries() {
        return getFreightAllowanceCharge().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getFreightAllowanceChargeCount() {
        return getFreightAllowanceCharge().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public AllowanceChargeType getFreightAllowanceChargeAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getFreightAllowanceCharge().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addFreightAllowanceCharge(
        @Nonnull
        final AllowanceChargeType elem) {
        getFreightAllowanceCharge().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasAttachedTransportEquipmentEntries() {
        return (!getAttachedTransportEquipment().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoAttachedTransportEquipmentEntries() {
        return getAttachedTransportEquipment().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getAttachedTransportEquipmentCount() {
        return getAttachedTransportEquipment().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TransportEquipmentType getAttachedTransportEquipmentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getAttachedTransportEquipment().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addAttachedTransportEquipment(
        @Nonnull
        final TransportEquipmentType elem) {
        getAttachedTransportEquipment().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasShipmentDocumentReferenceEntries() {
        return (!getShipmentDocumentReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoShipmentDocumentReferenceEntries() {
        return getShipmentDocumentReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getShipmentDocumentReferenceCount() {
        return getShipmentDocumentReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentReferenceType getShipmentDocumentReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getShipmentDocumentReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addShipmentDocumentReference(
        @Nonnull
        final DocumentReferenceType elem) {
        getShipmentDocumentReference().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasContainedInTransportEquipmentEntries() {
        return (!getContainedInTransportEquipment().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoContainedInTransportEquipmentEntries() {
        return getContainedInTransportEquipment().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getContainedInTransportEquipmentCount() {
        return getContainedInTransportEquipment().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public TransportEquipmentType getContainedInTransportEquipmentAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getContainedInTransportEquipment().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addContainedInTransportEquipment(
        @Nonnull
        final TransportEquipmentType elem) {
        getContainedInTransportEquipment().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasPackageEntries() {
        return (!getPackage().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoPackageEntries() {
        return getPackage().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getPackageCount() {
        return getPackage().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public PackageType getPackageAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getPackage().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addPackage(
        @Nonnull
        final PackageType elem) {
        getPackage().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasGoodsItemEntries() {
        return (!getGoodsItem().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoGoodsItemEntries() {
        return getGoodsItem().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getGoodsItemCount() {
        return getGoodsItem().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public GoodsItemType getGoodsItemAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getGoodsItem().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addGoodsItem(
        @Nonnull
        final GoodsItemType elem) {
        getGoodsItem().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        TransportEquipmentType ret) {
        if (_package == null) {
            ret._package = null;
        } else {
            List<PackageType> retPackage = new ArrayList<>();
            for (PackageType aItem: getPackage()) {
                retPackage.add(((aItem == null)?null:aItem.clone()));
            }
            ret._package = retPackage;
        }
        ret.airFlowPercent = ((airFlowPercent == null)?null:airFlowPercent.clone());
        ret.animalFoodApprovedIndicator = ((animalFoodApprovedIndicator == null)?null:animalFoodApprovedIndicator.clone());
        ret.applicableTransportMeans = ((applicableTransportMeans == null)?null:applicableTransportMeans.clone());
        if (attachedTransportEquipment == null) {
            ret.attachedTransportEquipment = null;
        } else {
            List<TransportEquipmentType> retAttachedTransportEquipment = new ArrayList<>();
            for (TransportEquipmentType aItem: getAttachedTransportEquipment()) {
                retAttachedTransportEquipment.add(((aItem == null)?null:aItem.clone()));
            }
            ret.attachedTransportEquipment = retAttachedTransportEquipment;
        }
        ret.characteristics = ((characteristics == null)?null:characteristics.clone());
        if (containedInTransportEquipment == null) {
            ret.containedInTransportEquipment = null;
        } else {
            List<TransportEquipmentType> retContainedInTransportEquipment = new ArrayList<>();
            for (TransportEquipmentType aItem: getContainedInTransportEquipment()) {
                retContainedInTransportEquipment.add(((aItem == null)?null:aItem.clone()));
            }
            ret.containedInTransportEquipment = retContainedInTransportEquipment;
        }
        if (damageRemarks == null) {
            ret.damageRemarks = null;
        } else {
            List<DamageRemarksType> retDamageRemarks = new ArrayList<>();
            for (DamageRemarksType aItem: getDamageRemarks()) {
                retDamageRemarks.add(((aItem == null)?null:aItem.clone()));
            }
            ret.damageRemarks = retDamageRemarks;
        }
        ret.dangerousGoodsApprovedIndicator = ((dangerousGoodsApprovedIndicator == null)?null:dangerousGoodsApprovedIndicator.clone());
        ret.delivery = ((delivery == null)?null:delivery.clone());
        if (deliveryTransportEvent == null) {
            ret.deliveryTransportEvent = null;
        } else {
            List<TransportEventType> retDeliveryTransportEvent = new ArrayList<>();
            for (TransportEventType aItem: getDeliveryTransportEvent()) {
                retDeliveryTransportEvent.add(((aItem == null)?null:aItem.clone()));
            }
            ret.deliveryTransportEvent = retDeliveryTransportEvent;
        }
        if (description == null) {
            ret.description = null;
        } else {
            List<DescriptionType> retDescription = new ArrayList<>();
            for (DescriptionType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        ret.despatch = ((despatch == null)?null:despatch.clone());
        ret.dispositionCode = ((dispositionCode == null)?null:dispositionCode.clone());
        if (freightAllowanceCharge == null) {
            ret.freightAllowanceCharge = null;
        } else {
            List<AllowanceChargeType> retFreightAllowanceCharge = new ArrayList<>();
            for (AllowanceChargeType aItem: getFreightAllowanceCharge()) {
                retFreightAllowanceCharge.add(((aItem == null)?null:aItem.clone()));
            }
            ret.freightAllowanceCharge = retFreightAllowanceCharge;
        }
        ret.fullnessIndicationCode = ((fullnessIndicationCode == null)?null:fullnessIndicationCode.clone());
        if (goodsItem == null) {
            ret.goodsItem = null;
        } else {
            List<GoodsItemType> retGoodsItem = new ArrayList<>();
            for (GoodsItemType aItem: getGoodsItem()) {
                retGoodsItem.add(((aItem == null)?null:aItem.clone()));
            }
            ret.goodsItem = retGoodsItem;
        }
        ret.grossVolumeMeasure = ((grossVolumeMeasure == null)?null:grossVolumeMeasure.clone());
        ret.grossWeightMeasure = ((grossWeightMeasure == null)?null:grossWeightMeasure.clone());
        if (handlingTransportEvent == null) {
            ret.handlingTransportEvent = null;
        } else {
            List<TransportEventType> retHandlingTransportEvent = new ArrayList<>();
            for (TransportEventType aItem: getHandlingTransportEvent()) {
                retHandlingTransportEvent.add(((aItem == null)?null:aItem.clone()));
            }
            ret.handlingTransportEvent = retHandlingTransportEvent;
        }
        if (haulageTradingTerms == null) {
            ret.haulageTradingTerms = null;
        } else {
            List<TradingTermsType> retHaulageTradingTerms = new ArrayList<>();
            for (TradingTermsType aItem: getHaulageTradingTerms()) {
                retHaulageTradingTerms.add(((aItem == null)?null:aItem.clone()));
            }
            ret.haulageTradingTerms = retHaulageTradingTerms;
        }
        if (hazardousGoodsTransit == null) {
            ret.hazardousGoodsTransit = null;
        } else {
            List<HazardousGoodsTransitType> retHazardousGoodsTransit = new ArrayList<>();
            for (HazardousGoodsTransitType aItem: getHazardousGoodsTransit()) {
                retHazardousGoodsTransit.add(((aItem == null)?null:aItem.clone()));
            }
            ret.hazardousGoodsTransit = retHazardousGoodsTransit;
        }
        ret.humanFoodApprovedIndicator = ((humanFoodApprovedIndicator == null)?null:humanFoodApprovedIndicator.clone());
        ret.humidityPercent = ((humidityPercent == null)?null:humidityPercent.clone());
        ret.id = ((id == null)?null:id.clone());
        if (information == null) {
            ret.information = null;
        } else {
            List<InformationType> retInformation = new ArrayList<>();
            for (InformationType aItem: getInformation()) {
                retInformation.add(((aItem == null)?null:aItem.clone()));
            }
            ret.information = retInformation;
        }
        ret.legalStatusIndicator = ((legalStatusIndicator == null)?null:legalStatusIndicator.clone());
        ret.loadingLocation = ((loadingLocation == null)?null:loadingLocation.clone());
        ret.loadingProofParty = ((loadingProofParty == null)?null:loadingProofParty.clone());
        if (loadingTransportEvent == null) {
            ret.loadingTransportEvent = null;
        } else {
            List<TransportEventType> retLoadingTransportEvent = new ArrayList<>();
            for (TransportEventType aItem: getLoadingTransportEvent()) {
                retLoadingTransportEvent.add(((aItem == null)?null:aItem.clone()));
            }
            ret.loadingTransportEvent = retLoadingTransportEvent;
        }
        ret.maximumTemperature = ((maximumTemperature == null)?null:maximumTemperature.clone());
        if (measurementDimension == null) {
            ret.measurementDimension = null;
        } else {
            List<DimensionType> retMeasurementDimension = new ArrayList<>();
            for (DimensionType aItem: getMeasurementDimension()) {
                retMeasurementDimension.add(((aItem == null)?null:aItem.clone()));
            }
            ret.measurementDimension = retMeasurementDimension;
        }
        ret.minimumTemperature = ((minimumTemperature == null)?null:minimumTemperature.clone());
        ret.operatingParty = ((operatingParty == null)?null:operatingParty.clone());
        ret.ownerParty = ((ownerParty == null)?null:ownerParty.clone());
        ret.ownerTypeCode = ((ownerTypeCode == null)?null:ownerTypeCode.clone());
        if (packagedTransportHandlingUnit == null) {
            ret.packagedTransportHandlingUnit = null;
        } else {
            List<TransportHandlingUnitType> retPackagedTransportHandlingUnit = new ArrayList<>();
            for (TransportHandlingUnitType aItem: getPackagedTransportHandlingUnit()) {
                retPackagedTransportHandlingUnit.add(((aItem == null)?null:aItem.clone()));
            }
            ret.packagedTransportHandlingUnit = retPackagedTransportHandlingUnit;
        }
        ret.pickup = ((pickup == null)?null:pickup.clone());
        if (pickupTransportEvent == null) {
            ret.pickupTransportEvent = null;
        } else {
            List<TransportEventType> retPickupTransportEvent = new ArrayList<>();
            for (TransportEventType aItem: getPickupTransportEvent()) {
                retPickupTransportEvent.add(((aItem == null)?null:aItem.clone()));
            }
            ret.pickupTransportEvent = retPickupTransportEvent;
        }
        if (positioningTransportEvent == null) {
            ret.positioningTransportEvent = null;
        } else {
            List<TransportEventType> retPositioningTransportEvent = new ArrayList<>();
            for (TransportEventType aItem: getPositioningTransportEvent()) {
                retPositioningTransportEvent.add(((aItem == null)?null:aItem.clone()));
            }
            ret.positioningTransportEvent = retPositioningTransportEvent;
        }
        ret.powerIndicator = ((powerIndicator == null)?null:powerIndicator.clone());
        ret.providerParty = ((providerParty == null)?null:providerParty.clone());
        ret.providerTypeCode = ((providerTypeCode == null)?null:providerTypeCode.clone());
        if (quarantineTransportEvent == null) {
            ret.quarantineTransportEvent = null;
        } else {
            List<TransportEventType> retQuarantineTransportEvent = new ArrayList<>();
            for (TransportEventType aItem: getQuarantineTransportEvent()) {
                retQuarantineTransportEvent.add(((aItem == null)?null:aItem.clone()));
            }
            ret.quarantineTransportEvent = retQuarantineTransportEvent;
        }
        if (referencedConsignmentID == null) {
            ret.referencedConsignmentID = null;
        } else {
            List<ReferencedConsignmentIDType> retReferencedConsignmentID = new ArrayList<>();
            for (ReferencedConsignmentIDType aItem: getReferencedConsignmentID()) {
                retReferencedConsignmentID.add(((aItem == null)?null:aItem.clone()));
            }
            ret.referencedConsignmentID = retReferencedConsignmentID;
        }
        ret.refrigeratedIndicator = ((refrigeratedIndicator == null)?null:refrigeratedIndicator.clone());
        ret.refrigerationOnIndicator = ((refrigerationOnIndicator == null)?null:refrigerationOnIndicator.clone());
        ret.returnabilityIndicator = ((returnabilityIndicator == null)?null:returnabilityIndicator.clone());
        if (serviceAllowanceCharge == null) {
            ret.serviceAllowanceCharge = null;
        } else {
            List<AllowanceChargeType> retServiceAllowanceCharge = new ArrayList<>();
            for (AllowanceChargeType aItem: getServiceAllowanceCharge()) {
                retServiceAllowanceCharge.add(((aItem == null)?null:aItem.clone()));
            }
            ret.serviceAllowanceCharge = retServiceAllowanceCharge;
        }
        if (shipmentDocumentReference == null) {
            ret.shipmentDocumentReference = null;
        } else {
            List<DocumentReferenceType> retShipmentDocumentReference = new ArrayList<>();
            for (DocumentReferenceType aItem: getShipmentDocumentReference()) {
                retShipmentDocumentReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.shipmentDocumentReference = retShipmentDocumentReference;
        }
        ret.sizeTypeCode = ((sizeTypeCode == null)?null:sizeTypeCode.clone());
        if (specialTransportRequirements == null) {
            ret.specialTransportRequirements = null;
        } else {
            List<SpecialTransportRequirementsType> retSpecialTransportRequirements = new ArrayList<>();
            for (SpecialTransportRequirementsType aItem: getSpecialTransportRequirements()) {
                retSpecialTransportRequirements.add(((aItem == null)?null:aItem.clone()));
            }
            ret.specialTransportRequirements = retSpecialTransportRequirements;
        }
        ret.storageLocation = ((storageLocation == null)?null:storageLocation.clone());
        ret.supplierParty = ((supplierParty == null)?null:supplierParty.clone());
        ret.tareWeightMeasure = ((tareWeightMeasure == null)?null:tareWeightMeasure.clone());
        ret.traceID = ((traceID == null)?null:traceID.clone());
        ret.trackingDeviceCode = ((trackingDeviceCode == null)?null:trackingDeviceCode.clone());
        if (transportEquipmentSeal == null) {
            ret.transportEquipmentSeal = null;
        } else {
            List<TransportEquipmentSealType> retTransportEquipmentSeal = new ArrayList<>();
            for (TransportEquipmentSealType aItem: getTransportEquipmentSeal()) {
                retTransportEquipmentSeal.add(((aItem == null)?null:aItem.clone()));
            }
            ret.transportEquipmentSeal = retTransportEquipmentSeal;
        }
        ret.transportEquipmentTypeCode = ((transportEquipmentTypeCode == null)?null:transportEquipmentTypeCode.clone());
        if (transportEvent == null) {
            ret.transportEvent = null;
        } else {
            List<TransportEventType> retTransportEvent = new ArrayList<>();
            for (TransportEventType aItem: getTransportEvent()) {
                retTransportEvent.add(((aItem == null)?null:aItem.clone()));
            }
            ret.transportEvent = retTransportEvent;
        }
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        ret.unloadingLocation = ((unloadingLocation == null)?null:unloadingLocation.clone());
        ret.verifiedGrossMass = ((verifiedGrossMass == null)?null:verifiedGrossMass.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public TransportEquipmentType clone() {
        TransportEquipmentType ret = new TransportEquipmentType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TransportEquipmentTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public TransportEquipmentTypeCodeType setTransportEquipmentTypeCode(
        @Nullable
        final String valueParam) {
        TransportEquipmentTypeCodeType aObj = getTransportEquipmentTypeCode();
        if (aObj == null) {
            aObj = new TransportEquipmentTypeCodeType(valueParam);
            setTransportEquipmentTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ProviderTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public ProviderTypeCodeType setProviderTypeCode(
        @Nullable
        final String valueParam) {
        ProviderTypeCodeType aObj = getProviderTypeCode();
        if (aObj == null) {
            aObj = new ProviderTypeCodeType(valueParam);
            setProviderTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type OwnerTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public OwnerTypeCodeType setOwnerTypeCode(
        @Nullable
        final String valueParam) {
        OwnerTypeCodeType aObj = getOwnerTypeCode();
        if (aObj == null) {
            aObj = new OwnerTypeCodeType(valueParam);
            setOwnerTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SizeTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public SizeTypeCodeType setSizeTypeCode(
        @Nullable
        final String valueParam) {
        SizeTypeCodeType aObj = getSizeTypeCode();
        if (aObj == null) {
            aObj = new SizeTypeCodeType(valueParam);
            setSizeTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type DispositionCodeType and never <code>null</code>
     */
    @Nonnull
    public DispositionCodeType setDispositionCode(
        @Nullable
        final String valueParam) {
        DispositionCodeType aObj = getDispositionCode();
        if (aObj == null) {
            aObj = new DispositionCodeType(valueParam);
            setDispositionCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type FullnessIndicationCodeType and never <code>null</code>
     */
    @Nonnull
    public FullnessIndicationCodeType setFullnessIndicationCode(
        @Nullable
        final String valueParam) {
        FullnessIndicationCodeType aObj = getFullnessIndicationCode();
        if (aObj == null) {
            aObj = new FullnessIndicationCodeType(valueParam);
            setFullnessIndicationCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type RefrigerationOnIndicatorType and never <code>null</code>
     */
    @Nonnull
    public RefrigerationOnIndicatorType setRefrigerationOnIndicator(final boolean valueParam) {
        RefrigerationOnIndicatorType aObj = getRefrigerationOnIndicator();
        if (aObj == null) {
            aObj = new RefrigerationOnIndicatorType(valueParam);
            setRefrigerationOnIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type ReturnabilityIndicatorType and never <code>null</code>
     */
    @Nonnull
    public ReturnabilityIndicatorType setReturnabilityIndicator(final boolean valueParam) {
        ReturnabilityIndicatorType aObj = getReturnabilityIndicator();
        if (aObj == null) {
            aObj = new ReturnabilityIndicatorType(valueParam);
            setReturnabilityIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type LegalStatusIndicatorType and never <code>null</code>
     */
    @Nonnull
    public LegalStatusIndicatorType setLegalStatusIndicator(final boolean valueParam) {
        LegalStatusIndicatorType aObj = getLegalStatusIndicator();
        if (aObj == null) {
            aObj = new LegalStatusIndicatorType(valueParam);
            setLegalStatusIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type AirFlowPercentType and never <code>null</code>
     */
    @Nonnull
    public AirFlowPercentType setAirFlowPercent(
        @Nullable
        final BigDecimal valueParam) {
        AirFlowPercentType aObj = getAirFlowPercent();
        if (aObj == null) {
            aObj = new AirFlowPercentType(valueParam);
            setAirFlowPercent(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type HumidityPercentType and never <code>null</code>
     */
    @Nonnull
    public HumidityPercentType setHumidityPercent(
        @Nullable
        final BigDecimal valueParam) {
        HumidityPercentType aObj = getHumidityPercent();
        if (aObj == null) {
            aObj = new HumidityPercentType(valueParam);
            setHumidityPercent(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type AnimalFoodApprovedIndicatorType and never <code>null</code>
     */
    @Nonnull
    public AnimalFoodApprovedIndicatorType setAnimalFoodApprovedIndicator(final boolean valueParam) {
        AnimalFoodApprovedIndicatorType aObj = getAnimalFoodApprovedIndicator();
        if (aObj == null) {
            aObj = new AnimalFoodApprovedIndicatorType(valueParam);
            setAnimalFoodApprovedIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type HumanFoodApprovedIndicatorType and never <code>null</code>
     */
    @Nonnull
    public HumanFoodApprovedIndicatorType setHumanFoodApprovedIndicator(final boolean valueParam) {
        HumanFoodApprovedIndicatorType aObj = getHumanFoodApprovedIndicator();
        if (aObj == null) {
            aObj = new HumanFoodApprovedIndicatorType(valueParam);
            setHumanFoodApprovedIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type DangerousGoodsApprovedIndicatorType and never <code>null</code>
     */
    @Nonnull
    public DangerousGoodsApprovedIndicatorType setDangerousGoodsApprovedIndicator(final boolean valueParam) {
        DangerousGoodsApprovedIndicatorType aObj = getDangerousGoodsApprovedIndicator();
        if (aObj == null) {
            aObj = new DangerousGoodsApprovedIndicatorType(valueParam);
            setDangerousGoodsApprovedIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type RefrigeratedIndicatorType and never <code>null</code>
     */
    @Nonnull
    public RefrigeratedIndicatorType setRefrigeratedIndicator(final boolean valueParam) {
        RefrigeratedIndicatorType aObj = getRefrigeratedIndicator();
        if (aObj == null) {
            aObj = new RefrigeratedIndicatorType(valueParam);
            setRefrigeratedIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CharacteristicsType and never <code>null</code>
     */
    @Nonnull
    public CharacteristicsType setCharacteristics(
        @Nullable
        final String valueParam) {
        CharacteristicsType aObj = getCharacteristics();
        if (aObj == null) {
            aObj = new CharacteristicsType(valueParam);
            setCharacteristics(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type GrossWeightMeasureType and never <code>null</code>
     */
    @Nonnull
    public GrossWeightMeasureType setGrossWeightMeasure(
        @Nullable
        final BigDecimal valueParam) {
        GrossWeightMeasureType aObj = getGrossWeightMeasure();
        if (aObj == null) {
            aObj = new GrossWeightMeasureType(valueParam);
            setGrossWeightMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type GrossVolumeMeasureType and never <code>null</code>
     */
    @Nonnull
    public GrossVolumeMeasureType setGrossVolumeMeasure(
        @Nullable
        final BigDecimal valueParam) {
        GrossVolumeMeasureType aObj = getGrossVolumeMeasure();
        if (aObj == null) {
            aObj = new GrossVolumeMeasureType(valueParam);
            setGrossVolumeMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TareWeightMeasureType and never <code>null</code>
     */
    @Nonnull
    public TareWeightMeasureType setTareWeightMeasure(
        @Nullable
        final BigDecimal valueParam) {
        TareWeightMeasureType aObj = getTareWeightMeasure();
        if (aObj == null) {
            aObj = new TareWeightMeasureType(valueParam);
            setTareWeightMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TrackingDeviceCodeType and never <code>null</code>
     */
    @Nonnull
    public TrackingDeviceCodeType setTrackingDeviceCode(
        @Nullable
        final String valueParam) {
        TrackingDeviceCodeType aObj = getTrackingDeviceCode();
        if (aObj == null) {
            aObj = new TrackingDeviceCodeType(valueParam);
            setTrackingDeviceCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type PowerIndicatorType and never <code>null</code>
     */
    @Nonnull
    public PowerIndicatorType setPowerIndicator(final boolean valueParam) {
        PowerIndicatorType aObj = getPowerIndicator();
        if (aObj == null) {
            aObj = new PowerIndicatorType(valueParam);
            setPowerIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TraceIDType and never <code>null</code>
     */
    @Nonnull
    public TraceIDType setTraceID(
        @Nullable
        final String valueParam) {
        TraceIDType aObj = getTraceID();
        if (aObj == null) {
            aObj = new TraceIDType(valueParam);
            setTraceID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TransportEquipmentTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TransportEquipmentTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getTransportEquipmentTypeCodeValue() {
        TransportEquipmentTypeCodeType aObj = getTransportEquipmentTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ProviderTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ProviderTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getProviderTypeCodeValue() {
        ProviderTypeCodeType aObj = getProviderTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained OwnerTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained OwnerTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getOwnerTypeCodeValue() {
        OwnerTypeCodeType aObj = getOwnerTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained SizeTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SizeTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getSizeTypeCodeValue() {
        SizeTypeCodeType aObj = getSizeTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained DispositionCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained DispositionCodeType object or <code>null</code>
     */
    @Nullable
    public String getDispositionCodeValue() {
        DispositionCodeType aObj = getDispositionCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained FullnessIndicationCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained FullnessIndicationCodeType object or <code>null</code>
     */
    @Nullable
    public String getFullnessIndicationCodeValue() {
        FullnessIndicationCodeType aObj = getFullnessIndicationCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained RefrigerationOnIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained RefrigerationOnIndicatorType object or the passed nullValue
     */
    public boolean isRefrigerationOnIndicatorValue(final boolean nullValue) {
        RefrigerationOnIndicatorType aObj = getRefrigerationOnIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained ReturnabilityIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained ReturnabilityIndicatorType object or the passed nullValue
     */
    public boolean isReturnabilityIndicatorValue(final boolean nullValue) {
        ReturnabilityIndicatorType aObj = getReturnabilityIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained LegalStatusIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained LegalStatusIndicatorType object or the passed nullValue
     */
    public boolean isLegalStatusIndicatorValue(final boolean nullValue) {
        LegalStatusIndicatorType aObj = getLegalStatusIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained AirFlowPercentType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained AirFlowPercentType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getAirFlowPercentValue() {
        AirFlowPercentType aObj = getAirFlowPercent();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained HumidityPercentType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained HumidityPercentType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getHumidityPercentValue() {
        HumidityPercentType aObj = getHumidityPercent();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained AnimalFoodApprovedIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained AnimalFoodApprovedIndicatorType object or the passed nullValue
     */
    public boolean isAnimalFoodApprovedIndicatorValue(final boolean nullValue) {
        AnimalFoodApprovedIndicatorType aObj = getAnimalFoodApprovedIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained HumanFoodApprovedIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained HumanFoodApprovedIndicatorType object or the passed nullValue
     */
    public boolean isHumanFoodApprovedIndicatorValue(final boolean nullValue) {
        HumanFoodApprovedIndicatorType aObj = getHumanFoodApprovedIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained DangerousGoodsApprovedIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained DangerousGoodsApprovedIndicatorType object or the passed nullValue
     */
    public boolean isDangerousGoodsApprovedIndicatorValue(final boolean nullValue) {
        DangerousGoodsApprovedIndicatorType aObj = getDangerousGoodsApprovedIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained RefrigeratedIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained RefrigeratedIndicatorType object or the passed nullValue
     */
    public boolean isRefrigeratedIndicatorValue(final boolean nullValue) {
        RefrigeratedIndicatorType aObj = getRefrigeratedIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained CharacteristicsType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CharacteristicsType object or <code>null</code>
     */
    @Nullable
    public String getCharacteristicsValue() {
        CharacteristicsType aObj = getCharacteristics();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained GrossWeightMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained GrossWeightMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getGrossWeightMeasureValue() {
        GrossWeightMeasureType aObj = getGrossWeightMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained GrossVolumeMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained GrossVolumeMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getGrossVolumeMeasureValue() {
        GrossVolumeMeasureType aObj = getGrossVolumeMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TareWeightMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TareWeightMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getTareWeightMeasureValue() {
        TareWeightMeasureType aObj = getTareWeightMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TrackingDeviceCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TrackingDeviceCodeType object or <code>null</code>
     */
    @Nullable
    public String getTrackingDeviceCodeValue() {
        TrackingDeviceCodeType aObj = getTrackingDeviceCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained PowerIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained PowerIndicatorType object or the passed nullValue
     */
    public boolean isPowerIndicatorValue(final boolean nullValue) {
        PowerIndicatorType aObj = getPowerIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained TraceIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TraceIDType object or <code>null</code>
     */
    @Nullable
    public String getTraceIDValue() {
        TraceIDType aObj = getTraceID();
        return (aObj == null)?null:aObj.getValue();
    }

}
