
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.DirectionCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.JourneyIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.RegistrationNationalityIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.RegistrationNationalityType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TradeServiceCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TransportMeansTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for TransportMeansType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="TransportMeansType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}JourneyID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RegistrationNationalityID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RegistrationNationality" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}DirectionCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TransportMeansTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TradeServiceCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Stowage" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}AirTransport" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}RoadTransport" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}RailTransport" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}MaritimeTransport" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}OwnerParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}MeasurementDimension" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "TransportMeansType", propOrder = {
    "ublExtensions",
    "journeyID",
    "registrationNationalityID",
    "registrationNationality",
    "directionCode",
    "transportMeansTypeCode",
    "tradeServiceCode",
    "stowage",
    "airTransport",
    "roadTransport",
    "railTransport",
    "maritimeTransport",
    "ownerParty",
    "measurementDimension"
})
@CodingStyleguideUnaware
public class TransportMeansType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "JourneyID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private JourneyIDType journeyID;
    @XmlElement(name = "RegistrationNationalityID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private RegistrationNationalityIDType registrationNationalityID;
    @XmlElement(name = "RegistrationNationality", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<RegistrationNationalityType> registrationNationality;
    @XmlElement(name = "DirectionCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private DirectionCodeType directionCode;
    @XmlElement(name = "TransportMeansTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TransportMeansTypeCodeType transportMeansTypeCode;
    @XmlElement(name = "TradeServiceCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TradeServiceCodeType tradeServiceCode;
    @XmlElement(name = "Stowage")
    private StowageType stowage;
    @XmlElement(name = "AirTransport")
    private AirTransportType airTransport;
    @XmlElement(name = "RoadTransport")
    private RoadTransportType roadTransport;
    @XmlElement(name = "RailTransport")
    private RailTransportType railTransport;
    @XmlElement(name = "MaritimeTransport")
    private MaritimeTransportType maritimeTransport;
    @XmlElement(name = "OwnerParty")
    private PartyType ownerParty;
    @XmlElement(name = "MeasurementDimension")
    private List<DimensionType> measurementDimension;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public TransportMeansType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the journeyID property.
     * 
     * @return
     *     possible object is
     *     {@link JourneyIDType }
     *     
     */
    @Nullable
    public JourneyIDType getJourneyID() {
        return journeyID;
    }

    /**
     * Sets the value of the journeyID property.
     * 
     * @param value
     *     allowed object is
     *     {@link JourneyIDType }
     *     
     */
    public void setJourneyID(
        @Nullable
        JourneyIDType value) {
        this.journeyID = value;
    }

    /**
     * Gets the value of the registrationNationalityID property.
     * 
     * @return
     *     possible object is
     *     {@link RegistrationNationalityIDType }
     *     
     */
    @Nullable
    public RegistrationNationalityIDType getRegistrationNationalityID() {
        return registrationNationalityID;
    }

    /**
     * Sets the value of the registrationNationalityID property.
     * 
     * @param value
     *     allowed object is
     *     {@link RegistrationNationalityIDType }
     *     
     */
    public void setRegistrationNationalityID(
        @Nullable
        RegistrationNationalityIDType value) {
        this.registrationNationalityID = value;
    }

    /**
     * Gets the value of the registrationNationality property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the registrationNationality property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getRegistrationNationality().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link RegistrationNationalityType }
     * </p>
     * 
     * 
     * @return
     *     The value of the registrationNationality property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<RegistrationNationalityType> getRegistrationNationality() {
        if (registrationNationality == null) {
            registrationNationality = new ArrayList<>();
        }
        return this.registrationNationality;
    }

    /**
     * Gets the value of the directionCode property.
     * 
     * @return
     *     possible object is
     *     {@link DirectionCodeType }
     *     
     */
    @Nullable
    public DirectionCodeType getDirectionCode() {
        return directionCode;
    }

    /**
     * Sets the value of the directionCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link DirectionCodeType }
     *     
     */
    public void setDirectionCode(
        @Nullable
        DirectionCodeType value) {
        this.directionCode = value;
    }

    /**
     * Gets the value of the transportMeansTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link TransportMeansTypeCodeType }
     *     
     */
    @Nullable
    public TransportMeansTypeCodeType getTransportMeansTypeCode() {
        return transportMeansTypeCode;
    }

    /**
     * Sets the value of the transportMeansTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TransportMeansTypeCodeType }
     *     
     */
    public void setTransportMeansTypeCode(
        @Nullable
        TransportMeansTypeCodeType value) {
        this.transportMeansTypeCode = value;
    }

    /**
     * Gets the value of the tradeServiceCode property.
     * 
     * @return
     *     possible object is
     *     {@link TradeServiceCodeType }
     *     
     */
    @Nullable
    public TradeServiceCodeType getTradeServiceCode() {
        return tradeServiceCode;
    }

    /**
     * Sets the value of the tradeServiceCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link TradeServiceCodeType }
     *     
     */
    public void setTradeServiceCode(
        @Nullable
        TradeServiceCodeType value) {
        this.tradeServiceCode = value;
    }

    /**
     * Gets the value of the stowage property.
     * 
     * @return
     *     possible object is
     *     {@link StowageType }
     *     
     */
    @Nullable
    public StowageType getStowage() {
        return stowage;
    }

    /**
     * Sets the value of the stowage property.
     * 
     * @param value
     *     allowed object is
     *     {@link StowageType }
     *     
     */
    public void setStowage(
        @Nullable
        StowageType value) {
        this.stowage = value;
    }

    /**
     * Gets the value of the airTransport property.
     * 
     * @return
     *     possible object is
     *     {@link AirTransportType }
     *     
     */
    @Nullable
    public AirTransportType getAirTransport() {
        return airTransport;
    }

    /**
     * Sets the value of the airTransport property.
     * 
     * @param value
     *     allowed object is
     *     {@link AirTransportType }
     *     
     */
    public void setAirTransport(
        @Nullable
        AirTransportType value) {
        this.airTransport = value;
    }

    /**
     * Gets the value of the roadTransport property.
     * 
     * @return
     *     possible object is
     *     {@link RoadTransportType }
     *     
     */
    @Nullable
    public RoadTransportType getRoadTransport() {
        return roadTransport;
    }

    /**
     * Sets the value of the roadTransport property.
     * 
     * @param value
     *     allowed object is
     *     {@link RoadTransportType }
     *     
     */
    public void setRoadTransport(
        @Nullable
        RoadTransportType value) {
        this.roadTransport = value;
    }

    /**
     * Gets the value of the railTransport property.
     * 
     * @return
     *     possible object is
     *     {@link RailTransportType }
     *     
     */
    @Nullable
    public RailTransportType getRailTransport() {
        return railTransport;
    }

    /**
     * Sets the value of the railTransport property.
     * 
     * @param value
     *     allowed object is
     *     {@link RailTransportType }
     *     
     */
    public void setRailTransport(
        @Nullable
        RailTransportType value) {
        this.railTransport = value;
    }

    /**
     * Gets the value of the maritimeTransport property.
     * 
     * @return
     *     possible object is
     *     {@link MaritimeTransportType }
     *     
     */
    @Nullable
    public MaritimeTransportType getMaritimeTransport() {
        return maritimeTransport;
    }

    /**
     * Sets the value of the maritimeTransport property.
     * 
     * @param value
     *     allowed object is
     *     {@link MaritimeTransportType }
     *     
     */
    public void setMaritimeTransport(
        @Nullable
        MaritimeTransportType value) {
        this.maritimeTransport = value;
    }

    /**
     * Gets the value of the ownerParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getOwnerParty() {
        return ownerParty;
    }

    /**
     * Sets the value of the ownerParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setOwnerParty(
        @Nullable
        PartyType value) {
        this.ownerParty = value;
    }

    /**
     * Gets the value of the measurementDimension property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the measurementDimension property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getMeasurementDimension().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DimensionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the measurementDimension property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DimensionType> getMeasurementDimension() {
        if (measurementDimension == null) {
            measurementDimension = new ArrayList<>();
        }
        return this.measurementDimension;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final TransportMeansType rhs = ((TransportMeansType) o);
        if (!EqualsHelper.equals(airTransport, rhs.airTransport)) {
            return false;
        }
        if (!EqualsHelper.equals(directionCode, rhs.directionCode)) {
            return false;
        }
        if (!EqualsHelper.equals(journeyID, rhs.journeyID)) {
            return false;
        }
        if (!EqualsHelper.equals(maritimeTransport, rhs.maritimeTransport)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(measurementDimension, rhs.measurementDimension)) {
            return false;
        }
        if (!EqualsHelper.equals(ownerParty, rhs.ownerParty)) {
            return false;
        }
        if (!EqualsHelper.equals(railTransport, rhs.railTransport)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(registrationNationality, rhs.registrationNationality)) {
            return false;
        }
        if (!EqualsHelper.equals(registrationNationalityID, rhs.registrationNationalityID)) {
            return false;
        }
        if (!EqualsHelper.equals(roadTransport, rhs.roadTransport)) {
            return false;
        }
        if (!EqualsHelper.equals(stowage, rhs.stowage)) {
            return false;
        }
        if (!EqualsHelper.equals(tradeServiceCode, rhs.tradeServiceCode)) {
            return false;
        }
        if (!EqualsHelper.equals(transportMeansTypeCode, rhs.transportMeansTypeCode)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(airTransport).append(directionCode).append(journeyID).append(maritimeTransport).append(measurementDimension).append(ownerParty).append(railTransport).append(registrationNationality).append(registrationNationalityID).append(roadTransport).append(stowage).append(tradeServiceCode).append(transportMeansTypeCode).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("airTransport", airTransport).append("directionCode", directionCode).append("journeyID", journeyID).append("maritimeTransport", maritimeTransport).append("measurementDimension", measurementDimension).append("ownerParty", ownerParty).append("railTransport", railTransport).append("registrationNationality", registrationNationality).append("registrationNationalityID", registrationNationalityID).append("roadTransport", roadTransport).append("stowage", stowage).append("tradeServiceCode", tradeServiceCode).append("transportMeansTypeCode", transportMeansTypeCode).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setRegistrationNationality(
        @Nullable
        final List<RegistrationNationalityType> aList) {
        registrationNationality = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setMeasurementDimension(
        @Nullable
        final List<DimensionType> aList) {
        measurementDimension = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasRegistrationNationalityEntries() {
        return (!getRegistrationNationality().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoRegistrationNationalityEntries() {
        return getRegistrationNationality().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getRegistrationNationalityCount() {
        return getRegistrationNationality().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public RegistrationNationalityType getRegistrationNationalityAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getRegistrationNationality().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addRegistrationNationality(
        @Nonnull
        final RegistrationNationalityType elem) {
        getRegistrationNationality().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasMeasurementDimensionEntries() {
        return (!getMeasurementDimension().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoMeasurementDimensionEntries() {
        return getMeasurementDimension().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getMeasurementDimensionCount() {
        return getMeasurementDimension().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DimensionType getMeasurementDimensionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getMeasurementDimension().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addMeasurementDimension(
        @Nonnull
        final DimensionType elem) {
        getMeasurementDimension().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        TransportMeansType ret) {
        ret.airTransport = ((airTransport == null)?null:airTransport.clone());
        ret.directionCode = ((directionCode == null)?null:directionCode.clone());
        ret.journeyID = ((journeyID == null)?null:journeyID.clone());
        ret.maritimeTransport = ((maritimeTransport == null)?null:maritimeTransport.clone());
        if (measurementDimension == null) {
            ret.measurementDimension = null;
        } else {
            List<DimensionType> retMeasurementDimension = new ArrayList<>();
            for (DimensionType aItem: getMeasurementDimension()) {
                retMeasurementDimension.add(((aItem == null)?null:aItem.clone()));
            }
            ret.measurementDimension = retMeasurementDimension;
        }
        ret.ownerParty = ((ownerParty == null)?null:ownerParty.clone());
        ret.railTransport = ((railTransport == null)?null:railTransport.clone());
        if (registrationNationality == null) {
            ret.registrationNationality = null;
        } else {
            List<RegistrationNationalityType> retRegistrationNationality = new ArrayList<>();
            for (RegistrationNationalityType aItem: getRegistrationNationality()) {
                retRegistrationNationality.add(((aItem == null)?null:aItem.clone()));
            }
            ret.registrationNationality = retRegistrationNationality;
        }
        ret.registrationNationalityID = ((registrationNationalityID == null)?null:registrationNationalityID.clone());
        ret.roadTransport = ((roadTransport == null)?null:roadTransport.clone());
        ret.stowage = ((stowage == null)?null:stowage.clone());
        ret.tradeServiceCode = ((tradeServiceCode == null)?null:tradeServiceCode.clone());
        ret.transportMeansTypeCode = ((transportMeansTypeCode == null)?null:transportMeansTypeCode.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public TransportMeansType clone() {
        TransportMeansType ret = new TransportMeansType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type JourneyIDType and never <code>null</code>
     */
    @Nonnull
    public JourneyIDType setJourneyID(
        @Nullable
        final String valueParam) {
        JourneyIDType aObj = getJourneyID();
        if (aObj == null) {
            aObj = new JourneyIDType(valueParam);
            setJourneyID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RegistrationNationalityIDType and never <code>null</code>
     */
    @Nonnull
    public RegistrationNationalityIDType setRegistrationNationalityID(
        @Nullable
        final String valueParam) {
        RegistrationNationalityIDType aObj = getRegistrationNationalityID();
        if (aObj == null) {
            aObj = new RegistrationNationalityIDType(valueParam);
            setRegistrationNationalityID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type DirectionCodeType and never <code>null</code>
     */
    @Nonnull
    public DirectionCodeType setDirectionCode(
        @Nullable
        final String valueParam) {
        DirectionCodeType aObj = getDirectionCode();
        if (aObj == null) {
            aObj = new DirectionCodeType(valueParam);
            setDirectionCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TransportMeansTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public TransportMeansTypeCodeType setTransportMeansTypeCode(
        @Nullable
        final String valueParam) {
        TransportMeansTypeCodeType aObj = getTransportMeansTypeCode();
        if (aObj == null) {
            aObj = new TransportMeansTypeCodeType(valueParam);
            setTransportMeansTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TradeServiceCodeType and never <code>null</code>
     */
    @Nonnull
    public TradeServiceCodeType setTradeServiceCode(
        @Nullable
        final String valueParam) {
        TradeServiceCodeType aObj = getTradeServiceCode();
        if (aObj == null) {
            aObj = new TradeServiceCodeType(valueParam);
            setTradeServiceCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained JourneyIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained JourneyIDType object or <code>null</code>
     */
    @Nullable
    public String getJourneyIDValue() {
        JourneyIDType aObj = getJourneyID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained RegistrationNationalityIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RegistrationNationalityIDType object or <code>null</code>
     */
    @Nullable
    public String getRegistrationNationalityIDValue() {
        RegistrationNationalityIDType aObj = getRegistrationNationalityID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained DirectionCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained DirectionCodeType object or <code>null</code>
     */
    @Nullable
    public String getDirectionCodeValue() {
        DirectionCodeType aObj = getDirectionCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TransportMeansTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TransportMeansTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getTransportMeansTypeCodeValue() {
        TransportMeansTypeCodeType aObj = getTransportMeansTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TradeServiceCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TradeServiceCodeType object or <code>null</code>
     */
    @Nullable
    public String getTradeServiceCodeValue() {
        TradeServiceCodeType aObj = getTradeServiceCode();
        return (aObj == null)?null:aObj.getValue();
    }

}
