
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.PriceAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TaxInclusivePriceAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.TimeAmountType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for UnstructuredPriceType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="UnstructuredPriceType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}PriceAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TaxInclusivePriceAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}TimeAmount" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "UnstructuredPriceType", propOrder = {
    "ublExtensions",
    "priceAmount",
    "taxInclusivePriceAmount",
    "timeAmount"
})
@CodingStyleguideUnaware
public class UnstructuredPriceType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "PriceAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private PriceAmountType priceAmount;
    @XmlElement(name = "TaxInclusivePriceAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TaxInclusivePriceAmountType taxInclusivePriceAmount;
    @XmlElement(name = "TimeAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private TimeAmountType timeAmount;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public UnstructuredPriceType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the priceAmount property.
     * 
     * @return
     *     possible object is
     *     {@link PriceAmountType }
     *     
     */
    @Nullable
    public PriceAmountType getPriceAmount() {
        return priceAmount;
    }

    /**
     * Sets the value of the priceAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link PriceAmountType }
     *     
     */
    public void setPriceAmount(
        @Nullable
        PriceAmountType value) {
        this.priceAmount = value;
    }

    /**
     * Gets the value of the taxInclusivePriceAmount property.
     * 
     * @return
     *     possible object is
     *     {@link TaxInclusivePriceAmountType }
     *     
     */
    @Nullable
    public TaxInclusivePriceAmountType getTaxInclusivePriceAmount() {
        return taxInclusivePriceAmount;
    }

    /**
     * Sets the value of the taxInclusivePriceAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link TaxInclusivePriceAmountType }
     *     
     */
    public void setTaxInclusivePriceAmount(
        @Nullable
        TaxInclusivePriceAmountType value) {
        this.taxInclusivePriceAmount = value;
    }

    /**
     * Gets the value of the timeAmount property.
     * 
     * @return
     *     possible object is
     *     {@link TimeAmountType }
     *     
     */
    @Nullable
    public TimeAmountType getTimeAmount() {
        return timeAmount;
    }

    /**
     * Sets the value of the timeAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link TimeAmountType }
     *     
     */
    public void setTimeAmount(
        @Nullable
        TimeAmountType value) {
        this.timeAmount = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final UnstructuredPriceType rhs = ((UnstructuredPriceType) o);
        if (!EqualsHelper.equals(priceAmount, rhs.priceAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(taxInclusivePriceAmount, rhs.taxInclusivePriceAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(timeAmount, rhs.timeAmount)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(priceAmount).append(taxInclusivePriceAmount).append(timeAmount).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("priceAmount", priceAmount).append("taxInclusivePriceAmount", taxInclusivePriceAmount).append("timeAmount", timeAmount).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        UnstructuredPriceType ret) {
        ret.priceAmount = ((priceAmount == null)?null:priceAmount.clone());
        ret.taxInclusivePriceAmount = ((taxInclusivePriceAmount == null)?null:taxInclusivePriceAmount.clone());
        ret.timeAmount = ((timeAmount == null)?null:timeAmount.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public UnstructuredPriceType clone() {
        UnstructuredPriceType ret = new UnstructuredPriceType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type PriceAmountType and never <code>null</code>
     */
    @Nonnull
    public PriceAmountType setPriceAmount(
        @Nullable
        final BigDecimal valueParam) {
        PriceAmountType aObj = getPriceAmount();
        if (aObj == null) {
            aObj = new PriceAmountType(valueParam);
            setPriceAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TaxInclusivePriceAmountType and never <code>null</code>
     */
    @Nonnull
    public TaxInclusivePriceAmountType setTaxInclusivePriceAmount(
        @Nullable
        final BigDecimal valueParam) {
        TaxInclusivePriceAmountType aObj = getTaxInclusivePriceAmount();
        if (aObj == null) {
            aObj = new TaxInclusivePriceAmountType(valueParam);
            setTaxInclusivePriceAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type TimeAmountType and never <code>null</code>
     */
    @Nonnull
    public TimeAmountType setTimeAmount(
        @Nullable
        final String valueParam) {
        TimeAmountType aObj = getTimeAmount();
        if (aObj == null) {
            aObj = new TimeAmountType(valueParam);
            setTimeAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained PriceAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained PriceAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getPriceAmountValue() {
        PriceAmountType aObj = getPriceAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TaxInclusivePriceAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TaxInclusivePriceAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getTaxInclusivePriceAmountValue() {
        TaxInclusivePriceAmountType aObj = getTaxInclusivePriceAmount();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained TimeAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained TimeAmountType object or <code>null</code>
     */
    @Nullable
    public String getTimeAmountValue() {
        TimeAmountType aObj = getTimeAmount();
        return (aObj == null)?null:aObj.getValue();
    }

}
