
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.math.BigDecimal;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.AtAnchorageIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.CourseOverGroundDirectionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.NavigationStatusCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.RateOfTurnMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.SpeedOverGroundMeasureType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for VesselDynamicsType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="VesselDynamicsType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}NavigationStatusCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}AtAnchorageIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CourseOverGroundDirection" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}SpeedOverGroundMeasure" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}RateOfTurnMeasure" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "VesselDynamicsType", propOrder = {
    "ublExtensions",
    "navigationStatusCode",
    "atAnchorageIndicator",
    "courseOverGroundDirection",
    "speedOverGroundMeasure",
    "rateOfTurnMeasure"
})
@CodingStyleguideUnaware
public class VesselDynamicsType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "NavigationStatusCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private NavigationStatusCodeType navigationStatusCode;
    @XmlElement(name = "AtAnchorageIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private AtAnchorageIndicatorType atAnchorageIndicator;
    @XmlElement(name = "CourseOverGroundDirection", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CourseOverGroundDirectionType courseOverGroundDirection;
    @XmlElement(name = "SpeedOverGroundMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private SpeedOverGroundMeasureType speedOverGroundMeasure;
    @XmlElement(name = "RateOfTurnMeasure", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private RateOfTurnMeasureType rateOfTurnMeasure;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public VesselDynamicsType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the navigationStatusCode property.
     * 
     * @return
     *     possible object is
     *     {@link NavigationStatusCodeType }
     *     
     */
    @Nullable
    public NavigationStatusCodeType getNavigationStatusCode() {
        return navigationStatusCode;
    }

    /**
     * Sets the value of the navigationStatusCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link NavigationStatusCodeType }
     *     
     */
    public void setNavigationStatusCode(
        @Nullable
        NavigationStatusCodeType value) {
        this.navigationStatusCode = value;
    }

    /**
     * Gets the value of the atAnchorageIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link AtAnchorageIndicatorType }
     *     
     */
    @Nullable
    public AtAnchorageIndicatorType getAtAnchorageIndicator() {
        return atAnchorageIndicator;
    }

    /**
     * Sets the value of the atAnchorageIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link AtAnchorageIndicatorType }
     *     
     */
    public void setAtAnchorageIndicator(
        @Nullable
        AtAnchorageIndicatorType value) {
        this.atAnchorageIndicator = value;
    }

    /**
     * Gets the value of the courseOverGroundDirection property.
     * 
     * @return
     *     possible object is
     *     {@link CourseOverGroundDirectionType }
     *     
     */
    @Nullable
    public CourseOverGroundDirectionType getCourseOverGroundDirection() {
        return courseOverGroundDirection;
    }

    /**
     * Sets the value of the courseOverGroundDirection property.
     * 
     * @param value
     *     allowed object is
     *     {@link CourseOverGroundDirectionType }
     *     
     */
    public void setCourseOverGroundDirection(
        @Nullable
        CourseOverGroundDirectionType value) {
        this.courseOverGroundDirection = value;
    }

    /**
     * Gets the value of the speedOverGroundMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link SpeedOverGroundMeasureType }
     *     
     */
    @Nullable
    public SpeedOverGroundMeasureType getSpeedOverGroundMeasure() {
        return speedOverGroundMeasure;
    }

    /**
     * Sets the value of the speedOverGroundMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link SpeedOverGroundMeasureType }
     *     
     */
    public void setSpeedOverGroundMeasure(
        @Nullable
        SpeedOverGroundMeasureType value) {
        this.speedOverGroundMeasure = value;
    }

    /**
     * Gets the value of the rateOfTurnMeasure property.
     * 
     * @return
     *     possible object is
     *     {@link RateOfTurnMeasureType }
     *     
     */
    @Nullable
    public RateOfTurnMeasureType getRateOfTurnMeasure() {
        return rateOfTurnMeasure;
    }

    /**
     * Sets the value of the rateOfTurnMeasure property.
     * 
     * @param value
     *     allowed object is
     *     {@link RateOfTurnMeasureType }
     *     
     */
    public void setRateOfTurnMeasure(
        @Nullable
        RateOfTurnMeasureType value) {
        this.rateOfTurnMeasure = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final VesselDynamicsType rhs = ((VesselDynamicsType) o);
        if (!EqualsHelper.equals(atAnchorageIndicator, rhs.atAnchorageIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(courseOverGroundDirection, rhs.courseOverGroundDirection)) {
            return false;
        }
        if (!EqualsHelper.equals(navigationStatusCode, rhs.navigationStatusCode)) {
            return false;
        }
        if (!EqualsHelper.equals(rateOfTurnMeasure, rhs.rateOfTurnMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(speedOverGroundMeasure, rhs.speedOverGroundMeasure)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(atAnchorageIndicator).append(courseOverGroundDirection).append(navigationStatusCode).append(rateOfTurnMeasure).append(speedOverGroundMeasure).append(ublExtensions).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("atAnchorageIndicator", atAnchorageIndicator).append("courseOverGroundDirection", courseOverGroundDirection).append("navigationStatusCode", navigationStatusCode).append("rateOfTurnMeasure", rateOfTurnMeasure).append("speedOverGroundMeasure", speedOverGroundMeasure).append("ublExtensions", ublExtensions).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        VesselDynamicsType ret) {
        ret.atAnchorageIndicator = ((atAnchorageIndicator == null)?null:atAnchorageIndicator.clone());
        ret.courseOverGroundDirection = ((courseOverGroundDirection == null)?null:courseOverGroundDirection.clone());
        ret.navigationStatusCode = ((navigationStatusCode == null)?null:navigationStatusCode.clone());
        ret.rateOfTurnMeasure = ((rateOfTurnMeasure == null)?null:rateOfTurnMeasure.clone());
        ret.speedOverGroundMeasure = ((speedOverGroundMeasure == null)?null:speedOverGroundMeasure.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public VesselDynamicsType clone() {
        VesselDynamicsType ret = new VesselDynamicsType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NavigationStatusCodeType and never <code>null</code>
     */
    @Nonnull
    public NavigationStatusCodeType setNavigationStatusCode(
        @Nullable
        final String valueParam) {
        NavigationStatusCodeType aObj = getNavigationStatusCode();
        if (aObj == null) {
            aObj = new NavigationStatusCodeType(valueParam);
            setNavigationStatusCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type AtAnchorageIndicatorType and never <code>null</code>
     */
    @Nonnull
    public AtAnchorageIndicatorType setAtAnchorageIndicator(final boolean valueParam) {
        AtAnchorageIndicatorType aObj = getAtAnchorageIndicator();
        if (aObj == null) {
            aObj = new AtAnchorageIndicatorType(valueParam);
            setAtAnchorageIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CourseOverGroundDirectionType and never <code>null</code>
     */
    @Nonnull
    public CourseOverGroundDirectionType setCourseOverGroundDirection(
        @Nullable
        final String valueParam) {
        CourseOverGroundDirectionType aObj = getCourseOverGroundDirection();
        if (aObj == null) {
            aObj = new CourseOverGroundDirectionType(valueParam);
            setCourseOverGroundDirection(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type SpeedOverGroundMeasureType and never <code>null</code>
     */
    @Nonnull
    public SpeedOverGroundMeasureType setSpeedOverGroundMeasure(
        @Nullable
        final BigDecimal valueParam) {
        SpeedOverGroundMeasureType aObj = getSpeedOverGroundMeasure();
        if (aObj == null) {
            aObj = new SpeedOverGroundMeasureType(valueParam);
            setSpeedOverGroundMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type RateOfTurnMeasureType and never <code>null</code>
     */
    @Nonnull
    public RateOfTurnMeasureType setRateOfTurnMeasure(
        @Nullable
        final BigDecimal valueParam) {
        RateOfTurnMeasureType aObj = getRateOfTurnMeasure();
        if (aObj == null) {
            aObj = new RateOfTurnMeasureType(valueParam);
            setRateOfTurnMeasure(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained NavigationStatusCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NavigationStatusCodeType object or <code>null</code>
     */
    @Nullable
    public String getNavigationStatusCodeValue() {
        NavigationStatusCodeType aObj = getNavigationStatusCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained AtAnchorageIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained AtAnchorageIndicatorType object or the passed nullValue
     */
    public boolean isAtAnchorageIndicatorValue(final boolean nullValue) {
        AtAnchorageIndicatorType aObj = getAtAnchorageIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained CourseOverGroundDirectionType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CourseOverGroundDirectionType object or <code>null</code>
     */
    @Nullable
    public String getCourseOverGroundDirectionValue() {
        CourseOverGroundDirectionType aObj = getCourseOverGroundDirection();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained SpeedOverGroundMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained SpeedOverGroundMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getSpeedOverGroundMeasureValue() {
        SpeedOverGroundMeasureType aObj = getSpeedOverGroundMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained RateOfTurnMeasureType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained RateOfTurnMeasureType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getRateOfTurnMeasureValue() {
        RateOfTurnMeasureType aObj = getRateOfTurnMeasure();
        return (aObj == null)?null:aObj.getValue();
    }

}
