
package oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24;

import java.io.Serializable;
import java.time.LocalDate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.VisitDateType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for WHOAffectedAreaVisitType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="WHOAffectedAreaVisitType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}VisitDate"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}WHOAffectedAreaPortLocation"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "WHOAffectedAreaVisitType", propOrder = {
    "ublExtensions",
    "visitDate",
    "whoAffectedAreaPortLocation"
})
@CodingStyleguideUnaware
public class WHOAffectedAreaVisitType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "VisitDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private VisitDateType visitDate;
    @XmlElement(name = "WHOAffectedAreaPortLocation", required = true)
    private LocationType whoAffectedAreaPortLocation;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public WHOAffectedAreaVisitType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the visitDate property.
     * 
     * @return
     *     possible object is
     *     {@link VisitDateType }
     *     
     */
    @Nullable
    public VisitDateType getVisitDate() {
        return visitDate;
    }

    /**
     * Sets the value of the visitDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link VisitDateType }
     *     
     */
    public void setVisitDate(
        @Nullable
        VisitDateType value) {
        this.visitDate = value;
    }

    /**
     * Gets the value of the whoAffectedAreaPortLocation property.
     * 
     * @return
     *     possible object is
     *     {@link LocationType }
     *     
     */
    @Nullable
    public LocationType getWHOAffectedAreaPortLocation() {
        return whoAffectedAreaPortLocation;
    }

    /**
     * Sets the value of the whoAffectedAreaPortLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationType }
     *     
     */
    public void setWHOAffectedAreaPortLocation(
        @Nullable
        LocationType value) {
        this.whoAffectedAreaPortLocation = value;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final WHOAffectedAreaVisitType rhs = ((WHOAffectedAreaVisitType) o);
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equals(visitDate, rhs.visitDate)) {
            return false;
        }
        if (!EqualsHelper.equals(whoAffectedAreaPortLocation, rhs.whoAffectedAreaPortLocation)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(ublExtensions).append(visitDate).append(whoAffectedAreaPortLocation).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("ublExtensions", ublExtensions).append("visitDate", visitDate).append("whoAffectedAreaPortLocation", whoAffectedAreaPortLocation).getToString();
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        WHOAffectedAreaVisitType ret) {
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        ret.visitDate = ((visitDate == null)?null:visitDate.clone());
        ret.whoAffectedAreaPortLocation = ((whoAffectedAreaPortLocation == null)?null:whoAffectedAreaPortLocation.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public WHOAffectedAreaVisitType clone() {
        WHOAffectedAreaVisitType ret = new WHOAffectedAreaVisitType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type VisitDateType and never <code>null</code>
     */
    @Nonnull
    public VisitDateType setVisitDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        VisitDateType aObj = getVisitDate();
        if (aObj == null) {
            aObj = new VisitDateType(valueParam);
            setVisitDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type VisitDateType and never <code>null</code>
     */
    @Nonnull
    public VisitDateType setVisitDate(
        @Nullable
        final LocalDate valueParam) {
        VisitDateType aObj = getVisitDate();
        if (aObj == null) {
            aObj = new VisitDateType(valueParam);
            setVisitDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained VisitDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained VisitDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getVisitDateValue() {
        VisitDateType aObj = getVisitDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained VisitDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained VisitDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getVisitDateValueLocal() {
        VisitDateType aObj = getVisitDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

}
