
package oasis.names.specification.ubl.schema.xsd.waybill_24;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import com.helger.commons.annotation.CodingStyleguideUnaware;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.datetime.XMLOffsetDate;
import com.helger.commons.datetime.XMLOffsetTime;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.IExplicitlyCloneable;
import com.helger.commons.string.ToStringGenerator;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24.DocumentDistributionType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24.DocumentReferenceType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24.ExchangeRateType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24.LocationType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24.PartyType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24.ShipmentType;
import oasis.names.specification.ubl.schema.xsd.commonaggregatecomponents_24.SignatureType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.AdValoremIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.CarrierAssignedIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ConsolidatedIndicatorType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.CustomizationIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.DeclaredCarriageValueAmountType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.DescriptionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.IDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.IssueDateType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.IssueTimeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.NameType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.NoteType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.OtherInstructionType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ProfileExecutionIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ProfileIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.ShippingOrderIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.StatusCodeType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.UBLVersionIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.UUIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.VersionIDType;
import oasis.names.specification.ubl.schema.xsd.commonbasiccomponents_24.WaybillTypeCodeType;
import oasis.names.specification.ubl.schema.xsd.commonextensioncomponents_24.UBLExtensionsType;


/**
 * <p>Java class for WaybillType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="WaybillType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2}UBLExtensions" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}UBLVersionID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CustomizationID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ProfileID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ProfileExecutionID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ID"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}CarrierAssignedID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}UUID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}VersionID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}StatusCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}IssueDate" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}IssueTime" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Name" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Description" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}Note" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ShippingOrderID" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}WaybillTypeCode" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}ConsolidatedIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}AdValoremIndicator" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}DeclaredCarriageValueAmount" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2}OtherInstruction" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}IssueLocation" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}SenderParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ReceiverParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ConsignorParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}CarrierParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}FreightForwarderParty" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Shipment"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}DocumentReference" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}ExchangeRate" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}DocumentDistribution" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2}Signature" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * <p>This class was annotated by ph-jaxb-plugin -Xph-annotate</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-equalshashcode</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-tostring</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-list-extension</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-cloneable2</p>
 * <p>This class contains methods created by ph-jaxb-plugin -Xph-value-extender</p>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "WaybillType", propOrder = {
    "ublExtensions",
    "ublVersionID",
    "customizationID",
    "profileID",
    "profileExecutionID",
    "id",
    "carrierAssignedID",
    "uuid",
    "versionID",
    "statusCode",
    "issueDate",
    "issueTime",
    "name",
    "description",
    "note",
    "shippingOrderID",
    "waybillTypeCode",
    "consolidatedIndicator",
    "adValoremIndicator",
    "declaredCarriageValueAmount",
    "otherInstruction",
    "issueLocation",
    "senderParty",
    "receiverParty",
    "consignorParty",
    "carrierParty",
    "freightForwarderParty",
    "shipment",
    "documentReference",
    "exchangeRate",
    "documentDistribution",
    "signature"
})
@CodingStyleguideUnaware
public class WaybillType implements Serializable, IExplicitlyCloneable
{

    /**
     * A container for all extensions present in the document.
     * 
     */
    @XmlElement(name = "UBLExtensions", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonExtensionComponents-2")
    private UBLExtensionsType ublExtensions;
    @XmlElement(name = "UBLVersionID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private UBLVersionIDType ublVersionID;
    @XmlElement(name = "CustomizationID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CustomizationIDType customizationID;
    @XmlElement(name = "ProfileID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ProfileIDType profileID;
    @XmlElement(name = "ProfileExecutionID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ProfileExecutionIDType profileExecutionID;
    @XmlElement(name = "ID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2", required = true)
    private IDType id;
    @XmlElement(name = "CarrierAssignedID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private CarrierAssignedIDType carrierAssignedID;
    @XmlElement(name = "UUID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private UUIDType uuid;
    @XmlElement(name = "VersionID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private VersionIDType versionID;
    @XmlElement(name = "StatusCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private StatusCodeType statusCode;
    @XmlElement(name = "IssueDate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IssueDateType issueDate;
    @XmlElement(name = "IssueTime", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private IssueTimeType issueTime;
    @XmlElement(name = "Name", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private NameType name;
    @XmlElement(name = "Description", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<DescriptionType> description;
    @XmlElement(name = "Note", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<NoteType> note;
    @XmlElement(name = "ShippingOrderID", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ShippingOrderIDType shippingOrderID;
    @XmlElement(name = "WaybillTypeCode", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private WaybillTypeCodeType waybillTypeCode;
    @XmlElement(name = "ConsolidatedIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private ConsolidatedIndicatorType consolidatedIndicator;
    @XmlElement(name = "AdValoremIndicator", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private AdValoremIndicatorType adValoremIndicator;
    @XmlElement(name = "DeclaredCarriageValueAmount", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private DeclaredCarriageValueAmountType declaredCarriageValueAmount;
    @XmlElement(name = "OtherInstruction", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonBasicComponents-2")
    private List<OtherInstructionType> otherInstruction;
    @XmlElement(name = "IssueLocation", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2")
    private LocationType issueLocation;
    @XmlElement(name = "SenderParty", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2")
    private PartyType senderParty;
    @XmlElement(name = "ReceiverParty", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2")
    private PartyType receiverParty;
    @XmlElement(name = "ConsignorParty", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2")
    private PartyType consignorParty;
    @XmlElement(name = "CarrierParty", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2")
    private PartyType carrierParty;
    @XmlElement(name = "FreightForwarderParty", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2")
    private PartyType freightForwarderParty;
    @XmlElement(name = "Shipment", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2", required = true)
    private ShipmentType shipment;
    @XmlElement(name = "DocumentReference", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2")
    private List<DocumentReferenceType> documentReference;
    @XmlElement(name = "ExchangeRate", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2")
    private List<ExchangeRateType> exchangeRate;
    @XmlElement(name = "DocumentDistribution", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2")
    private List<DocumentDistributionType> documentDistribution;
    @XmlElement(name = "Signature", namespace = "urn:oasis:names:specification:ubl:schema:xsd:CommonAggregateComponents-2")
    private List<SignatureType> signature;

    /**
     * Default constructor<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     */
    public WaybillType() {
    }

    /**
     * A container for all extensions present in the document.
     * 
     * @return
     *     possible object is
     *     {@link UBLExtensionsType }
     *     
     */
    @Nullable
    public UBLExtensionsType getUBLExtensions() {
        return ublExtensions;
    }

    /**
     * Sets the value of the ublExtensions property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLExtensionsType }
     *     
     * @see #getUBLExtensions()
     */
    public void setUBLExtensions(
        @Nullable
        UBLExtensionsType value) {
        this.ublExtensions = value;
    }

    /**
     * Gets the value of the ublVersionID property.
     * 
     * @return
     *     possible object is
     *     {@link UBLVersionIDType }
     *     
     */
    @Nullable
    public UBLVersionIDType getUBLVersionID() {
        return ublVersionID;
    }

    /**
     * Sets the value of the ublVersionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link UBLVersionIDType }
     *     
     */
    public void setUBLVersionID(
        @Nullable
        UBLVersionIDType value) {
        this.ublVersionID = value;
    }

    /**
     * Gets the value of the customizationID property.
     * 
     * @return
     *     possible object is
     *     {@link CustomizationIDType }
     *     
     */
    @Nullable
    public CustomizationIDType getCustomizationID() {
        return customizationID;
    }

    /**
     * Sets the value of the customizationID property.
     * 
     * @param value
     *     allowed object is
     *     {@link CustomizationIDType }
     *     
     */
    public void setCustomizationID(
        @Nullable
        CustomizationIDType value) {
        this.customizationID = value;
    }

    /**
     * Gets the value of the profileID property.
     * 
     * @return
     *     possible object is
     *     {@link ProfileIDType }
     *     
     */
    @Nullable
    public ProfileIDType getProfileID() {
        return profileID;
    }

    /**
     * Sets the value of the profileID property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProfileIDType }
     *     
     */
    public void setProfileID(
        @Nullable
        ProfileIDType value) {
        this.profileID = value;
    }

    /**
     * Gets the value of the profileExecutionID property.
     * 
     * @return
     *     possible object is
     *     {@link ProfileExecutionIDType }
     *     
     */
    @Nullable
    public ProfileExecutionIDType getProfileExecutionID() {
        return profileExecutionID;
    }

    /**
     * Sets the value of the profileExecutionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link ProfileExecutionIDType }
     *     
     */
    public void setProfileExecutionID(
        @Nullable
        ProfileExecutionIDType value) {
        this.profileExecutionID = value;
    }

    /**
     * Gets the value of the id property.
     * 
     * @return
     *     possible object is
     *     {@link IDType }
     *     
     */
    @Nullable
    public IDType getID() {
        return id;
    }

    /**
     * Sets the value of the id property.
     * 
     * @param value
     *     allowed object is
     *     {@link IDType }
     *     
     */
    public void setID(
        @Nullable
        IDType value) {
        this.id = value;
    }

    /**
     * Gets the value of the carrierAssignedID property.
     * 
     * @return
     *     possible object is
     *     {@link CarrierAssignedIDType }
     *     
     */
    @Nullable
    public CarrierAssignedIDType getCarrierAssignedID() {
        return carrierAssignedID;
    }

    /**
     * Sets the value of the carrierAssignedID property.
     * 
     * @param value
     *     allowed object is
     *     {@link CarrierAssignedIDType }
     *     
     */
    public void setCarrierAssignedID(
        @Nullable
        CarrierAssignedIDType value) {
        this.carrierAssignedID = value;
    }

    /**
     * Gets the value of the uuid property.
     * 
     * @return
     *     possible object is
     *     {@link UUIDType }
     *     
     */
    @Nullable
    public UUIDType getUUID() {
        return uuid;
    }

    /**
     * Sets the value of the uuid property.
     * 
     * @param value
     *     allowed object is
     *     {@link UUIDType }
     *     
     */
    public void setUUID(
        @Nullable
        UUIDType value) {
        this.uuid = value;
    }

    /**
     * Gets the value of the versionID property.
     * 
     * @return
     *     possible object is
     *     {@link VersionIDType }
     *     
     */
    @Nullable
    public VersionIDType getVersionID() {
        return versionID;
    }

    /**
     * Sets the value of the versionID property.
     * 
     * @param value
     *     allowed object is
     *     {@link VersionIDType }
     *     
     */
    public void setVersionID(
        @Nullable
        VersionIDType value) {
        this.versionID = value;
    }

    /**
     * Gets the value of the statusCode property.
     * 
     * @return
     *     possible object is
     *     {@link StatusCodeType }
     *     
     */
    @Nullable
    public StatusCodeType getStatusCode() {
        return statusCode;
    }

    /**
     * Sets the value of the statusCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link StatusCodeType }
     *     
     */
    public void setStatusCode(
        @Nullable
        StatusCodeType value) {
        this.statusCode = value;
    }

    /**
     * Gets the value of the issueDate property.
     * 
     * @return
     *     possible object is
     *     {@link IssueDateType }
     *     
     */
    @Nullable
    public IssueDateType getIssueDate() {
        return issueDate;
    }

    /**
     * Sets the value of the issueDate property.
     * 
     * @param value
     *     allowed object is
     *     {@link IssueDateType }
     *     
     */
    public void setIssueDate(
        @Nullable
        IssueDateType value) {
        this.issueDate = value;
    }

    /**
     * Gets the value of the issueTime property.
     * 
     * @return
     *     possible object is
     *     {@link IssueTimeType }
     *     
     */
    @Nullable
    public IssueTimeType getIssueTime() {
        return issueTime;
    }

    /**
     * Sets the value of the issueTime property.
     * 
     * @param value
     *     allowed object is
     *     {@link IssueTimeType }
     *     
     */
    public void setIssueTime(
        @Nullable
        IssueTimeType value) {
        this.issueTime = value;
    }

    /**
     * Gets the value of the name property.
     * 
     * @return
     *     possible object is
     *     {@link NameType }
     *     
     */
    @Nullable
    public NameType getName() {
        return name;
    }

    /**
     * Sets the value of the name property.
     * 
     * @param value
     *     allowed object is
     *     {@link NameType }
     *     
     */
    public void setName(
        @Nullable
        NameType value) {
        this.name = value;
    }

    /**
     * Gets the value of the description property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the description property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDescription().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DescriptionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the description property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DescriptionType> getDescription() {
        if (description == null) {
            description = new ArrayList<>();
        }
        return this.description;
    }

    /**
     * Gets the value of the note property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the note property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getNote().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link NoteType }
     * </p>
     * 
     * 
     * @return
     *     The value of the note property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<NoteType> getNote() {
        if (note == null) {
            note = new ArrayList<>();
        }
        return this.note;
    }

    /**
     * Gets the value of the shippingOrderID property.
     * 
     * @return
     *     possible object is
     *     {@link ShippingOrderIDType }
     *     
     */
    @Nullable
    public ShippingOrderIDType getShippingOrderID() {
        return shippingOrderID;
    }

    /**
     * Sets the value of the shippingOrderID property.
     * 
     * @param value
     *     allowed object is
     *     {@link ShippingOrderIDType }
     *     
     */
    public void setShippingOrderID(
        @Nullable
        ShippingOrderIDType value) {
        this.shippingOrderID = value;
    }

    /**
     * Gets the value of the waybillTypeCode property.
     * 
     * @return
     *     possible object is
     *     {@link WaybillTypeCodeType }
     *     
     */
    @Nullable
    public WaybillTypeCodeType getWaybillTypeCode() {
        return waybillTypeCode;
    }

    /**
     * Sets the value of the waybillTypeCode property.
     * 
     * @param value
     *     allowed object is
     *     {@link WaybillTypeCodeType }
     *     
     */
    public void setWaybillTypeCode(
        @Nullable
        WaybillTypeCodeType value) {
        this.waybillTypeCode = value;
    }

    /**
     * Gets the value of the consolidatedIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link ConsolidatedIndicatorType }
     *     
     */
    @Nullable
    public ConsolidatedIndicatorType getConsolidatedIndicator() {
        return consolidatedIndicator;
    }

    /**
     * Sets the value of the consolidatedIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link ConsolidatedIndicatorType }
     *     
     */
    public void setConsolidatedIndicator(
        @Nullable
        ConsolidatedIndicatorType value) {
        this.consolidatedIndicator = value;
    }

    /**
     * Gets the value of the adValoremIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link AdValoremIndicatorType }
     *     
     */
    @Nullable
    public AdValoremIndicatorType getAdValoremIndicator() {
        return adValoremIndicator;
    }

    /**
     * Sets the value of the adValoremIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link AdValoremIndicatorType }
     *     
     */
    public void setAdValoremIndicator(
        @Nullable
        AdValoremIndicatorType value) {
        this.adValoremIndicator = value;
    }

    /**
     * Gets the value of the declaredCarriageValueAmount property.
     * 
     * @return
     *     possible object is
     *     {@link DeclaredCarriageValueAmountType }
     *     
     */
    @Nullable
    public DeclaredCarriageValueAmountType getDeclaredCarriageValueAmount() {
        return declaredCarriageValueAmount;
    }

    /**
     * Sets the value of the declaredCarriageValueAmount property.
     * 
     * @param value
     *     allowed object is
     *     {@link DeclaredCarriageValueAmountType }
     *     
     */
    public void setDeclaredCarriageValueAmount(
        @Nullable
        DeclaredCarriageValueAmountType value) {
        this.declaredCarriageValueAmount = value;
    }

    /**
     * Gets the value of the otherInstruction property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the otherInstruction property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getOtherInstruction().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link OtherInstructionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the otherInstruction property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<OtherInstructionType> getOtherInstruction() {
        if (otherInstruction == null) {
            otherInstruction = new ArrayList<>();
        }
        return this.otherInstruction;
    }

    /**
     * Gets the value of the issueLocation property.
     * 
     * @return
     *     possible object is
     *     {@link LocationType }
     *     
     */
    @Nullable
    public LocationType getIssueLocation() {
        return issueLocation;
    }

    /**
     * Sets the value of the issueLocation property.
     * 
     * @param value
     *     allowed object is
     *     {@link LocationType }
     *     
     */
    public void setIssueLocation(
        @Nullable
        LocationType value) {
        this.issueLocation = value;
    }

    /**
     * Gets the value of the senderParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getSenderParty() {
        return senderParty;
    }

    /**
     * Sets the value of the senderParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setSenderParty(
        @Nullable
        PartyType value) {
        this.senderParty = value;
    }

    /**
     * Gets the value of the receiverParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getReceiverParty() {
        return receiverParty;
    }

    /**
     * Sets the value of the receiverParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setReceiverParty(
        @Nullable
        PartyType value) {
        this.receiverParty = value;
    }

    /**
     * Gets the value of the consignorParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getConsignorParty() {
        return consignorParty;
    }

    /**
     * Sets the value of the consignorParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setConsignorParty(
        @Nullable
        PartyType value) {
        this.consignorParty = value;
    }

    /**
     * Gets the value of the carrierParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getCarrierParty() {
        return carrierParty;
    }

    /**
     * Sets the value of the carrierParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setCarrierParty(
        @Nullable
        PartyType value) {
        this.carrierParty = value;
    }

    /**
     * Gets the value of the freightForwarderParty property.
     * 
     * @return
     *     possible object is
     *     {@link PartyType }
     *     
     */
    @Nullable
    public PartyType getFreightForwarderParty() {
        return freightForwarderParty;
    }

    /**
     * Sets the value of the freightForwarderParty property.
     * 
     * @param value
     *     allowed object is
     *     {@link PartyType }
     *     
     */
    public void setFreightForwarderParty(
        @Nullable
        PartyType value) {
        this.freightForwarderParty = value;
    }

    /**
     * Gets the value of the shipment property.
     * 
     * @return
     *     possible object is
     *     {@link ShipmentType }
     *     
     */
    @Nullable
    public ShipmentType getShipment() {
        return shipment;
    }

    /**
     * Sets the value of the shipment property.
     * 
     * @param value
     *     allowed object is
     *     {@link ShipmentType }
     *     
     */
    public void setShipment(
        @Nullable
        ShipmentType value) {
        this.shipment = value;
    }

    /**
     * Gets the value of the documentReference property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the documentReference property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDocumentReference().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentReferenceType }
     * </p>
     * 
     * 
     * @return
     *     The value of the documentReference property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentReferenceType> getDocumentReference() {
        if (documentReference == null) {
            documentReference = new ArrayList<>();
        }
        return this.documentReference;
    }

    /**
     * Gets the value of the exchangeRate property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the exchangeRate property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getExchangeRate().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link ExchangeRateType }
     * </p>
     * 
     * 
     * @return
     *     The value of the exchangeRate property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<ExchangeRateType> getExchangeRate() {
        if (exchangeRate == null) {
            exchangeRate = new ArrayList<>();
        }
        return this.exchangeRate;
    }

    /**
     * Gets the value of the documentDistribution property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the documentDistribution property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getDocumentDistribution().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DocumentDistributionType }
     * </p>
     * 
     * 
     * @return
     *     The value of the documentDistribution property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<DocumentDistributionType> getDocumentDistribution() {
        if (documentDistribution == null) {
            documentDistribution = new ArrayList<>();
        }
        return this.documentDistribution;
    }

    /**
     * Gets the value of the signature property.
     * 
     * <p>This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the signature property.</p>
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * </p>
     * <pre>
     * getSignature().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link SignatureType }
     * </p>
     * 
     * 
     * @return
     *     The value of the signature property.
     */
    @Nonnull
    @ReturnsMutableObject("JAXB implementation style")
    public List<SignatureType> getSignature() {
        if (signature == null) {
            signature = new ArrayList<>();
        }
        return this.signature;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public boolean equals(final Object o) {
        if (o == this) {
            return true;
        }
        if ((o == null)||(!getClass().equals(o.getClass()))) {
            return false;
        }
        final WaybillType rhs = ((WaybillType) o);
        if (!EqualsHelper.equals(adValoremIndicator, rhs.adValoremIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(carrierAssignedID, rhs.carrierAssignedID)) {
            return false;
        }
        if (!EqualsHelper.equals(carrierParty, rhs.carrierParty)) {
            return false;
        }
        if (!EqualsHelper.equals(consignorParty, rhs.consignorParty)) {
            return false;
        }
        if (!EqualsHelper.equals(consolidatedIndicator, rhs.consolidatedIndicator)) {
            return false;
        }
        if (!EqualsHelper.equals(customizationID, rhs.customizationID)) {
            return false;
        }
        if (!EqualsHelper.equals(declaredCarriageValueAmount, rhs.declaredCarriageValueAmount)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(description, rhs.description)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(documentDistribution, rhs.documentDistribution)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(documentReference, rhs.documentReference)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(exchangeRate, rhs.exchangeRate)) {
            return false;
        }
        if (!EqualsHelper.equals(freightForwarderParty, rhs.freightForwarderParty)) {
            return false;
        }
        if (!EqualsHelper.equals(id, rhs.id)) {
            return false;
        }
        if (!EqualsHelper.equals(issueDate, rhs.issueDate)) {
            return false;
        }
        if (!EqualsHelper.equals(issueLocation, rhs.issueLocation)) {
            return false;
        }
        if (!EqualsHelper.equals(issueTime, rhs.issueTime)) {
            return false;
        }
        if (!EqualsHelper.equals(name, rhs.name)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(note, rhs.note)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(otherInstruction, rhs.otherInstruction)) {
            return false;
        }
        if (!EqualsHelper.equals(profileExecutionID, rhs.profileExecutionID)) {
            return false;
        }
        if (!EqualsHelper.equals(profileID, rhs.profileID)) {
            return false;
        }
        if (!EqualsHelper.equals(receiverParty, rhs.receiverParty)) {
            return false;
        }
        if (!EqualsHelper.equals(senderParty, rhs.senderParty)) {
            return false;
        }
        if (!EqualsHelper.equals(shipment, rhs.shipment)) {
            return false;
        }
        if (!EqualsHelper.equals(shippingOrderID, rhs.shippingOrderID)) {
            return false;
        }
        if (!EqualsHelper.equalsCollection(signature, rhs.signature)) {
            return false;
        }
        if (!EqualsHelper.equals(statusCode, rhs.statusCode)) {
            return false;
        }
        if (!EqualsHelper.equals(ublExtensions, rhs.ublExtensions)) {
            return false;
        }
        if (!EqualsHelper.equals(ublVersionID, rhs.ublVersionID)) {
            return false;
        }
        if (!EqualsHelper.equals(uuid, rhs.uuid)) {
            return false;
        }
        if (!EqualsHelper.equals(versionID, rhs.versionID)) {
            return false;
        }
        if (!EqualsHelper.equals(waybillTypeCode, rhs.waybillTypeCode)) {
            return false;
        }
        return true;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-equalshashcode
     * 
     */
    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(adValoremIndicator).append(carrierAssignedID).append(carrierParty).append(consignorParty).append(consolidatedIndicator).append(customizationID).append(declaredCarriageValueAmount).append(description).append(documentDistribution).append(documentReference).append(exchangeRate).append(freightForwarderParty).append(id).append(issueDate).append(issueLocation).append(issueTime).append(name).append(note).append(otherInstruction).append(profileExecutionID).append(profileID).append(receiverParty).append(senderParty).append(shipment).append(shippingOrderID).append(signature).append(statusCode).append(ublExtensions).append(ublVersionID).append(uuid).append(versionID).append(waybillTypeCode).getHashCode();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-tostring
     * 
     */
    @Override
    public String toString() {
        return new ToStringGenerator(this).append("adValoremIndicator", adValoremIndicator).append("carrierAssignedID", carrierAssignedID).append("carrierParty", carrierParty).append("consignorParty", consignorParty).append("consolidatedIndicator", consolidatedIndicator).append("customizationID", customizationID).append("declaredCarriageValueAmount", declaredCarriageValueAmount).append("description", description).append("documentDistribution", documentDistribution).append("documentReference", documentReference).append("exchangeRate", exchangeRate).append("freightForwarderParty", freightForwarderParty).append("id", id).append("issueDate", issueDate).append("issueLocation", issueLocation).append("issueTime", issueTime).append("name", name).append("note", note).append("otherInstruction", otherInstruction).append("profileExecutionID", profileExecutionID).append("profileID", profileID).append("receiverParty", receiverParty).append("senderParty", senderParty).append("shipment", shipment).append("shippingOrderID", shippingOrderID).append("signature", signature).append("statusCode", statusCode).append("ublExtensions", ublExtensions).append("ublVersionID", ublVersionID).append("uuid", uuid).append("versionID", versionID).append("waybillTypeCode", waybillTypeCode).getToString();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDescription(
        @Nullable
        final List<DescriptionType> aList) {
        description = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setNote(
        @Nullable
        final List<NoteType> aList) {
        note = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setOtherInstruction(
        @Nullable
        final List<OtherInstructionType> aList) {
        otherInstruction = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDocumentReference(
        @Nullable
        final List<DocumentReferenceType> aList) {
        documentReference = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setExchangeRate(
        @Nullable
        final List<ExchangeRateType> aList) {
        exchangeRate = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setDocumentDistribution(
        @Nullable
        final List<DocumentDistributionType> aList) {
        documentDistribution = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param aList
     *     The new list member to set. May be <code>null</code>.
     */
    public void setSignature(
        @Nullable
        final List<SignatureType> aList) {
        signature = aList;
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDescriptionEntries() {
        return (!getDescription().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDescriptionEntries() {
        return getDescription().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDescriptionCount() {
        return getDescription().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DescriptionType getDescriptionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDescription().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDescription(
        @Nonnull
        final DescriptionType elem) {
        getDescription().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoteEntries() {
        return (!getNote().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoNoteEntries() {
        return getNote().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getNoteCount() {
        return getNote().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public NoteType getNoteAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getNote().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addNote(
        @Nonnull
        final NoteType elem) {
        getNote().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasOtherInstructionEntries() {
        return (!getOtherInstruction().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoOtherInstructionEntries() {
        return getOtherInstruction().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getOtherInstructionCount() {
        return getOtherInstruction().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public OtherInstructionType getOtherInstructionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getOtherInstruction().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addOtherInstruction(
        @Nonnull
        final OtherInstructionType elem) {
        getOtherInstruction().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDocumentReferenceEntries() {
        return (!getDocumentReference().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDocumentReferenceEntries() {
        return getDocumentReference().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDocumentReferenceCount() {
        return getDocumentReference().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentReferenceType getDocumentReferenceAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDocumentReference().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDocumentReference(
        @Nonnull
        final DocumentReferenceType elem) {
        getDocumentReference().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasExchangeRateEntries() {
        return (!getExchangeRate().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoExchangeRateEntries() {
        return getExchangeRate().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getExchangeRateCount() {
        return getExchangeRate().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public ExchangeRateType getExchangeRateAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getExchangeRate().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addExchangeRate(
        @Nonnull
        final ExchangeRateType elem) {
        getExchangeRate().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasDocumentDistributionEntries() {
        return (!getDocumentDistribution().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoDocumentDistributionEntries() {
        return getDocumentDistribution().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getDocumentDistributionCount() {
        return getDocumentDistribution().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public DocumentDistributionType getDocumentDistributionAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getDocumentDistribution().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addDocumentDistribution(
        @Nonnull
        final DocumentDistributionType elem) {
        getDocumentDistribution().add(elem);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if at least one item is contained, <code>false</code> otherwise.
     */
    public boolean hasSignatureEntries() {
        return (!getSignature().isEmpty());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     <code>true</code> if no item is contained, <code>false</code> otherwise.
     */
    public boolean hasNoSignatureEntries() {
        return getSignature().isEmpty();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @return
     *     The number of contained elements. Always &ge; 0.
     */
    @Nonnegative
    public int getSignatureCount() {
        return getSignature().size();
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param index
     *     The index to retrieve
     * @return
     *     The element at the specified index. May be <code>null</code>
     * @throws IndexOutOfBoundsException
     *     if the index is invalid!
     */
    @Nullable
    public SignatureType getSignatureAtIndex(
        @Nonnegative
        final int index)
        throws IndexOutOfBoundsException
    {
        return getSignature().get(index);
    }

    /**
     * Created by ph-jaxb-plugin -Xph-list-extension
     * 
     * @param elem
     *     The element to be added. May not be <code>null</code>.
     */
    public void addSignature(
        @Nonnull
        final SignatureType elem) {
        getSignature().add(elem);
    }

    /**
     * This method clones all values from <code>this</code> to the passed object. All data in the parameter object is overwritten!Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @param ret
     *     The target object to clone to. May not be <code>null</code>.
     */
    public void cloneTo(
        @Nonnull
        WaybillType ret) {
        ret.adValoremIndicator = ((adValoremIndicator == null)?null:adValoremIndicator.clone());
        ret.carrierAssignedID = ((carrierAssignedID == null)?null:carrierAssignedID.clone());
        ret.carrierParty = ((carrierParty == null)?null:carrierParty.clone());
        ret.consignorParty = ((consignorParty == null)?null:consignorParty.clone());
        ret.consolidatedIndicator = ((consolidatedIndicator == null)?null:consolidatedIndicator.clone());
        ret.customizationID = ((customizationID == null)?null:customizationID.clone());
        ret.declaredCarriageValueAmount = ((declaredCarriageValueAmount == null)?null:declaredCarriageValueAmount.clone());
        if (description == null) {
            ret.description = null;
        } else {
            List<DescriptionType> retDescription = new ArrayList<>();
            for (DescriptionType aItem: getDescription()) {
                retDescription.add(((aItem == null)?null:aItem.clone()));
            }
            ret.description = retDescription;
        }
        if (documentDistribution == null) {
            ret.documentDistribution = null;
        } else {
            List<DocumentDistributionType> retDocumentDistribution = new ArrayList<>();
            for (DocumentDistributionType aItem: getDocumentDistribution()) {
                retDocumentDistribution.add(((aItem == null)?null:aItem.clone()));
            }
            ret.documentDistribution = retDocumentDistribution;
        }
        if (documentReference == null) {
            ret.documentReference = null;
        } else {
            List<DocumentReferenceType> retDocumentReference = new ArrayList<>();
            for (DocumentReferenceType aItem: getDocumentReference()) {
                retDocumentReference.add(((aItem == null)?null:aItem.clone()));
            }
            ret.documentReference = retDocumentReference;
        }
        if (exchangeRate == null) {
            ret.exchangeRate = null;
        } else {
            List<ExchangeRateType> retExchangeRate = new ArrayList<>();
            for (ExchangeRateType aItem: getExchangeRate()) {
                retExchangeRate.add(((aItem == null)?null:aItem.clone()));
            }
            ret.exchangeRate = retExchangeRate;
        }
        ret.freightForwarderParty = ((freightForwarderParty == null)?null:freightForwarderParty.clone());
        ret.id = ((id == null)?null:id.clone());
        ret.issueDate = ((issueDate == null)?null:issueDate.clone());
        ret.issueLocation = ((issueLocation == null)?null:issueLocation.clone());
        ret.issueTime = ((issueTime == null)?null:issueTime.clone());
        ret.name = ((name == null)?null:name.clone());
        if (note == null) {
            ret.note = null;
        } else {
            List<NoteType> retNote = new ArrayList<>();
            for (NoteType aItem: getNote()) {
                retNote.add(((aItem == null)?null:aItem.clone()));
            }
            ret.note = retNote;
        }
        if (otherInstruction == null) {
            ret.otherInstruction = null;
        } else {
            List<OtherInstructionType> retOtherInstruction = new ArrayList<>();
            for (OtherInstructionType aItem: getOtherInstruction()) {
                retOtherInstruction.add(((aItem == null)?null:aItem.clone()));
            }
            ret.otherInstruction = retOtherInstruction;
        }
        ret.profileExecutionID = ((profileExecutionID == null)?null:profileExecutionID.clone());
        ret.profileID = ((profileID == null)?null:profileID.clone());
        ret.receiverParty = ((receiverParty == null)?null:receiverParty.clone());
        ret.senderParty = ((senderParty == null)?null:senderParty.clone());
        ret.shipment = ((shipment == null)?null:shipment.clone());
        ret.shippingOrderID = ((shippingOrderID == null)?null:shippingOrderID.clone());
        if (signature == null) {
            ret.signature = null;
        } else {
            List<SignatureType> retSignature = new ArrayList<>();
            for (SignatureType aItem: getSignature()) {
                retSignature.add(((aItem == null)?null:aItem.clone()));
            }
            ret.signature = retSignature;
        }
        ret.statusCode = ((statusCode == null)?null:statusCode.clone());
        ret.ublExtensions = ((ublExtensions == null)?null:ublExtensions.clone());
        ret.ublVersionID = ((ublVersionID == null)?null:ublVersionID.clone());
        ret.uuid = ((uuid == null)?null:uuid.clone());
        ret.versionID = ((versionID == null)?null:versionID.clone());
        ret.waybillTypeCode = ((waybillTypeCode == null)?null:waybillTypeCode.clone());
    }

    /**
     * Created by ph-jaxb-plugin -Xph-cloneable2
     * 
     * @return
     *     The cloned object. Never <code>null</code>.
     */
    @Nonnull
    @ReturnsMutableCopy
    @Override
    public WaybillType clone() {
        WaybillType ret = new WaybillType();
        cloneTo(ret);
        return ret;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type UBLVersionIDType and never <code>null</code>
     */
    @Nonnull
    public UBLVersionIDType setUBLVersionID(
        @Nullable
        final String valueParam) {
        UBLVersionIDType aObj = getUBLVersionID();
        if (aObj == null) {
            aObj = new UBLVersionIDType(valueParam);
            setUBLVersionID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CustomizationIDType and never <code>null</code>
     */
    @Nonnull
    public CustomizationIDType setCustomizationID(
        @Nullable
        final String valueParam) {
        CustomizationIDType aObj = getCustomizationID();
        if (aObj == null) {
            aObj = new CustomizationIDType(valueParam);
            setCustomizationID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ProfileIDType and never <code>null</code>
     */
    @Nonnull
    public ProfileIDType setProfileID(
        @Nullable
        final String valueParam) {
        ProfileIDType aObj = getProfileID();
        if (aObj == null) {
            aObj = new ProfileIDType(valueParam);
            setProfileID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ProfileExecutionIDType and never <code>null</code>
     */
    @Nonnull
    public ProfileExecutionIDType setProfileExecutionID(
        @Nullable
        final String valueParam) {
        ProfileExecutionIDType aObj = getProfileExecutionID();
        if (aObj == null) {
            aObj = new ProfileExecutionIDType(valueParam);
            setProfileExecutionID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IDType and never <code>null</code>
     */
    @Nonnull
    public IDType setID(
        @Nullable
        final String valueParam) {
        IDType aObj = getID();
        if (aObj == null) {
            aObj = new IDType(valueParam);
            setID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type CarrierAssignedIDType and never <code>null</code>
     */
    @Nonnull
    public CarrierAssignedIDType setCarrierAssignedID(
        @Nullable
        final String valueParam) {
        CarrierAssignedIDType aObj = getCarrierAssignedID();
        if (aObj == null) {
            aObj = new CarrierAssignedIDType(valueParam);
            setCarrierAssignedID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type UUIDType and never <code>null</code>
     */
    @Nonnull
    public UUIDType setUUID(
        @Nullable
        final String valueParam) {
        UUIDType aObj = getUUID();
        if (aObj == null) {
            aObj = new UUIDType(valueParam);
            setUUID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type VersionIDType and never <code>null</code>
     */
    @Nonnull
    public VersionIDType setVersionID(
        @Nullable
        final String valueParam) {
        VersionIDType aObj = getVersionID();
        if (aObj == null) {
            aObj = new VersionIDType(valueParam);
            setVersionID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type StatusCodeType and never <code>null</code>
     */
    @Nonnull
    public StatusCodeType setStatusCode(
        @Nullable
        final String valueParam) {
        StatusCodeType aObj = getStatusCode();
        if (aObj == null) {
            aObj = new StatusCodeType(valueParam);
            setStatusCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IssueDateType and never <code>null</code>
     */
    @Nonnull
    public IssueDateType setIssueDate(
        @Nullable
        final XMLOffsetDate valueParam) {
        IssueDateType aObj = getIssueDate();
        if (aObj == null) {
            aObj = new IssueDateType(valueParam);
            setIssueDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalDate<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IssueDateType and never <code>null</code>
     */
    @Nonnull
    public IssueDateType setIssueDate(
        @Nullable
        final LocalDate valueParam) {
        IssueDateType aObj = getIssueDate();
        if (aObj == null) {
            aObj = new IssueDateType(valueParam);
            setIssueDate(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type XMLOffsetTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IssueTimeType and never <code>null</code>
     */
    @Nonnull
    public IssueTimeType setIssueTime(
        @Nullable
        final XMLOffsetTime valueParam) {
        IssueTimeType aObj = getIssueTime();
        if (aObj == null) {
            aObj = new IssueTimeType(valueParam);
            setIssueTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type LocalTime<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type IssueTimeType and never <code>null</code>
     */
    @Nonnull
    public IssueTimeType setIssueTime(
        @Nullable
        final LocalTime valueParam) {
        IssueTimeType aObj = getIssueTime();
        if (aObj == null) {
            aObj = new IssueTimeType(valueParam);
            setIssueTime(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type NameType and never <code>null</code>
     */
    @Nonnull
    public NameType setName(
        @Nullable
        final String valueParam) {
        NameType aObj = getName();
        if (aObj == null) {
            aObj = new NameType(valueParam);
            setName(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type ShippingOrderIDType and never <code>null</code>
     */
    @Nonnull
    public ShippingOrderIDType setShippingOrderID(
        @Nullable
        final String valueParam) {
        ShippingOrderIDType aObj = getShippingOrderID();
        if (aObj == null) {
            aObj = new ShippingOrderIDType(valueParam);
            setShippingOrderID(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type String<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type WaybillTypeCodeType and never <code>null</code>
     */
    @Nonnull
    public WaybillTypeCodeType setWaybillTypeCode(
        @Nullable
        final String valueParam) {
        WaybillTypeCodeType aObj = getWaybillTypeCode();
        if (aObj == null) {
            aObj = new WaybillTypeCodeType(valueParam);
            setWaybillTypeCode(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type ConsolidatedIndicatorType and never <code>null</code>
     */
    @Nonnull
    public ConsolidatedIndicatorType setConsolidatedIndicator(final boolean valueParam) {
        ConsolidatedIndicatorType aObj = getConsolidatedIndicator();
        if (aObj == null) {
            aObj = new ConsolidatedIndicatorType(valueParam);
            setConsolidatedIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type boolean<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set.
     * @return
     *     The created intermediary object of type AdValoremIndicatorType and never <code>null</code>
     */
    @Nonnull
    public AdValoremIndicatorType setAdValoremIndicator(final boolean valueParam) {
        AdValoremIndicatorType aObj = getAdValoremIndicator();
        if (aObj == null) {
            aObj = new AdValoremIndicatorType(valueParam);
            setAdValoremIndicator(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Special setter with value of type BigDecimal<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param valueParam
     *     The value to be set. May be <code>null</code>.
     * @return
     *     The created intermediary object of type DeclaredCarriageValueAmountType and never <code>null</code>
     */
    @Nonnull
    public DeclaredCarriageValueAmountType setDeclaredCarriageValueAmount(
        @Nullable
        final BigDecimal valueParam) {
        DeclaredCarriageValueAmountType aObj = getDeclaredCarriageValueAmount();
        if (aObj == null) {
            aObj = new DeclaredCarriageValueAmountType(valueParam);
            setDeclaredCarriageValueAmount(aObj);
        } else {
            aObj.setValue(valueParam);
        }
        return aObj;
    }

    /**
     * Get the value of the contained UBLVersionIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained UBLVersionIDType object or <code>null</code>
     */
    @Nullable
    public String getUBLVersionIDValue() {
        UBLVersionIDType aObj = getUBLVersionID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CustomizationIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CustomizationIDType object or <code>null</code>
     */
    @Nullable
    public String getCustomizationIDValue() {
        CustomizationIDType aObj = getCustomizationID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ProfileIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ProfileIDType object or <code>null</code>
     */
    @Nullable
    public String getProfileIDValue() {
        ProfileIDType aObj = getProfileID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ProfileExecutionIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ProfileExecutionIDType object or <code>null</code>
     */
    @Nullable
    public String getProfileExecutionIDValue() {
        ProfileExecutionIDType aObj = getProfileExecutionID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IDType object or <code>null</code>
     */
    @Nullable
    public String getIDValue() {
        IDType aObj = getID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained CarrierAssignedIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained CarrierAssignedIDType object or <code>null</code>
     */
    @Nullable
    public String getCarrierAssignedIDValue() {
        CarrierAssignedIDType aObj = getCarrierAssignedID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained UUIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained UUIDType object or <code>null</code>
     */
    @Nullable
    public String getUUIDValue() {
        UUIDType aObj = getUUID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained VersionIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained VersionIDType object or <code>null</code>
     */
    @Nullable
    public String getVersionIDValue() {
        VersionIDType aObj = getVersionID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained StatusCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained StatusCodeType object or <code>null</code>
     */
    @Nullable
    public String getStatusCodeValue() {
        StatusCodeType aObj = getStatusCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IssueDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IssueDateType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetDate getIssueDateValue() {
        IssueDateType aObj = getIssueDate();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IssueDateType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IssueDateType object or <code>null</code>
     */
    @Nullable
    public LocalDate getIssueDateValueLocal() {
        IssueDateType aObj = getIssueDate();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained IssueTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IssueTimeType object or <code>null</code>
     */
    @Nullable
    public XMLOffsetTime getIssueTimeValue() {
        IssueTimeType aObj = getIssueTime();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained IssueTimeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained IssueTimeType object or <code>null</code>
     */
    @Nullable
    public LocalTime getIssueTimeValueLocal() {
        IssueTimeType aObj = getIssueTime();
        return (aObj == null)?null:aObj.getValueLocal();
    }

    /**
     * Get the value of the contained NameType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained NameType object or <code>null</code>
     */
    @Nullable
    public String getNameValue() {
        NameType aObj = getName();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ShippingOrderIDType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained ShippingOrderIDType object or <code>null</code>
     */
    @Nullable
    public String getShippingOrderIDValue() {
        ShippingOrderIDType aObj = getShippingOrderID();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained WaybillTypeCodeType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained WaybillTypeCodeType object or <code>null</code>
     */
    @Nullable
    public String getWaybillTypeCodeValue() {
        WaybillTypeCodeType aObj = getWaybillTypeCode();
        return (aObj == null)?null:aObj.getValue();
    }

    /**
     * Get the value of the contained ConsolidatedIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained ConsolidatedIndicatorType object or the passed nullValue
     */
    public boolean isConsolidatedIndicatorValue(final boolean nullValue) {
        ConsolidatedIndicatorType aObj = getConsolidatedIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained AdValoremIndicatorType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @param nullValue
     *     The value to be returned, if the owning object is <code>null</code>
     * @return
     *     Either the value of the contained AdValoremIndicatorType object or the passed nullValue
     */
    public boolean isAdValoremIndicatorValue(final boolean nullValue) {
        AdValoremIndicatorType aObj = getAdValoremIndicator();
        return (aObj == null)?nullValue:aObj.isValue();
    }

    /**
     * Get the value of the contained DeclaredCarriageValueAmountType object<br>
     * Note: automatically created by ph-jaxb-plugin -Xph-value-extender
     * 
     * @return
     *     Either the value of the contained DeclaredCarriageValueAmountType object or <code>null</code>
     */
    @Nullable
    public BigDecimal getDeclaredCarriageValueAmountValue() {
        DeclaredCarriageValueAmountType aObj = getDeclaredCarriageValueAmount();
        return (aObj == null)?null:aObj.getValue();
    }

}
