/*
 * Decompiled with CFR 0.152.
 */
package com.informix.jdbc;

import com.informix.jdbc.IfxConnection;
import com.informix.util.IfxErrMsg;
import com.informix.util.Trace;
import com.informix.util.TraceFlag;
import com.informix.util.dateUtil;
import com.informix.util.stringUtil;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;

public class IfxNativeSQL {
    private static final Object logger = Trace.getLoggerForClass(IfxNativeSQL.class);
    static final char LBRACE = '{';
    static final char RBRACE = '}';
    static final String SLBRACE = "{";
    static final String SRBRACE = "}";
    static final String SLPAREN = "(";
    static final String SRPAREN = ")";
    static final char LPAREN = '(';
    static final char RPAREN = ')';
    static final String SBPAREN = "()";
    static final char DQUOTE = '\"';
    static final String SDQUOTE = "\"";
    static final String SQUOTE = "'";
    static final char QUOTE = '\'';
    static final char LBRACK = '[';
    static final char RBRACK = ']';
    static final String SLBRACK = "[";
    static final String SRBRACK = "]";
    static final char COMMA = ',';
    static final String SCOMMA = ",";
    static final char SEMICOLON = ';';
    static final String SSEMICOLON = ";";
    static final char SPACE = ' ';
    static final String SSPACE = " ";
    static final char TAB = '\t';
    static final String STAB = "\t";
    private String newString = null;
    private IfxConnection conn = null;
    private Trace trace = null;
    private static Hashtable<String, String> funcTable = null;

    IfxNativeSQL(String sql, IfxConnection jconn) throws SQLException {
        if (sql == null) {
            this.newString = null;
            throw IfxErrMsg.getSQLException(-79708, jconn);
        }
        this.conn = jconn;
        if (TraceFlag.isTraceEnabled() && this.conn != null) {
            this.trace = this.conn.getTrace();
        }
        this.newString = this.parseSQLString(sql);
    }

    String getNewString() {
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxNativeSQL: getNewString() called");
        }
        return this.newString;
    }

    String parseSQLString(String sql) throws SQLException {
        String searchCond = "";
        boolean ansiJoinSupp = this.conn.isANSIJoin();
        String resStr = "";
        int isAStoredProcCall = 0;
        boolean validSequence = true;
        int startQuote = -1;
        if (TraceFlag.isTraceEnabled()) {
            this.trace.writeTrace(logger, 1, "IfxNativeSQL:parseSQLString(): entered");
        }
        if (sql.indexOf(123) == -1 || sql.indexOf(125) == -1) {
            return sql;
        }
        String markers = "{} \t";
        StringTokenizer strT = new StringTokenizer(sql, markers, true);
        String oldToken = "";
        String token = "";
        while (strT.hasMoreTokens()) {
            String lastChar;
            String firstChar;
            String f;
            if (token.trim().length() > 0) {
                oldToken = token.toLowerCase();
            }
            token = strT.nextToken();
            String nativeString = "";
            startQuote = IfxNativeSQL.trackQuotes(token, startQuote);
            if (!token.equals(SLBRACE)) {
                if (!ansiJoinSupp && token.equalsIgnoreCase("WHERE")) {
                    if (searchCond.length() > 0) {
                        resStr = resStr + "and";
                        continue;
                    }
                    resStr = resStr + token;
                    continue;
                }
                resStr = resStr + token;
                continue;
            }
            if (IfxNativeSQL.isWithinQuotes(startQuote)) {
                resStr = resStr + token;
                continue;
            }
            if (this.using9xSyntax(oldToken)) {
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 2, "IfxNativeSQL():'{' was a 9.x bracket");
                }
                resStr = resStr + token;
                continue;
            }
            int nsrbraces = 0;
            for (int i = 0; i < sql.length(); ++i) {
                char c = sql.charAt(i);
                if (c != SRBRACE.charAt(0)) continue;
                ++nsrbraces;
            }
            int nsrbracefound = 0;
            boolean isproccall = false;
            while (strT.hasMoreTokens() && (!token.equals(SRBRACE) || nsrbracefound < nsrbraces && isproccall)) {
                oldToken = token;
                token = strT.nextToken();
                if (token.equalsIgnoreCase("call")) {
                    isproccall = true;
                }
                if (token.equals(SRBRACE)) {
                    ++nsrbracefound;
                }
                if (token.equals(SRBRACE) && (nsrbracefound >= nsrbraces || !isproccall)) continue;
                nativeString = nativeString + token;
            }
            StringTokenizer str = new StringTokenizer(nativeString);
            String kw = str.hasMoreTokens() ? str.nextToken() : "";
            if (TraceFlag.isTraceEnabled()) {
                this.trace.writeTrace(logger, 2, "IfxNativeSQL(): keyword = '" + kw + SQUOTE);
            }
            if (kw.equalsIgnoreCase("call")) {
                isAStoredProcCall = 1;
            } else {
                StringTokenizer checkT = new StringTokenizer(nativeString);
                if (checkT.countTokens() < 4) {
                    isAStoredProcCall = 0;
                } else {
                    checkT.nextToken();
                    isAStoredProcCall = !checkT.nextToken().equals("=") ? 0 : (!checkT.nextToken().equalsIgnoreCase("call") ? 0 : 2);
                }
            }
            if (isAStoredProcCall > 0) {
                String splname;
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, "IfxNativeSQL(): isAStoredProcCall =" + isAStoredProcCall);
                }
                if (!str.hasMoreTokens()) {
                    throw IfxErrMsg.getSQLException(-79710, SLBRACE + nativeString + SRBRACE, this.conn);
                }
                String exe = "execute procedure ";
                if (this.conn.isUSVER() && isAStoredProcCall > 1) {
                    exe = "execute function ";
                }
                if (isAStoredProcCall > 1) {
                    str.nextToken();
                    str.nextToken();
                }
                if ((splname = str.nextToken()).indexOf(40) > 0) {
                    splname = splname.substring(0, splname.indexOf(40));
                }
                int lstring = nativeString.indexOf(40);
                int rstring = nativeString.lastIndexOf(41) + 1;
                f = lstring != -1 && rstring != -1 ? splname + nativeString.substring(nativeString.indexOf(40), nativeString.lastIndexOf(41) + 1) : splname;
                resStr = resStr + exe + f;
                if (f.indexOf(40) == -1) {
                    resStr = resStr + SBPAREN;
                }
                if (!TraceFlag.isTraceEnabled()) continue;
                this.trace.writeTrace(logger, 3, "IfxNativeSQL(): resStr ='" + resStr + SQUOTE);
                continue;
            }
            if (kw.equals("d") && str.hasMoreTokens()) {
                String d = str.nextToken(SRBRACE).trim();
                String locdateStr = null;
                firstChar = d.substring(0, 1);
                lastChar = d.substring(d.length() - 1, d.length());
                String nativedateStr = d.substring(1, d.length() - 1);
                if (!firstChar.equals(SQUOTE) || !lastChar.equals(SQUOTE)) {
                    throw IfxErrMsg.getSQLMinorException(-79710, SDQUOTE + sql + SDQUOTE, -80004, "''' ", this.conn);
                }
                locdateStr = dateUtil.convertNativeSQLDate(nativedateStr, this.conn);
                resStr = resStr + SQUOTE + locdateStr + SQUOTE;
                if (!TraceFlag.isTraceEnabled()) continue;
                this.trace.writeTrace(logger, 3, "IfxNativeSQL(): resStr = '" + resStr + SQUOTE);
                continue;
            }
            if (kw.equals("t") && str.hasMoreTokens()) {
                String t = str.nextToken(SRBRACE).trim();
                String loctimeStr = null;
                boolean isTime = true;
                firstChar = t.substring(0, 1);
                lastChar = t.substring(t.length() - 1, t.length());
                String nativetimeStr = t.substring(1, t.length() - 1);
                if (!firstChar.equals(SQUOTE) || !lastChar.equals(SQUOTE)) {
                    throw IfxErrMsg.getSQLMinorException(-79710, SDQUOTE + sql + SDQUOTE, -80004, "''' ", this.conn);
                }
                loctimeStr = dateUtil.convertNativeSQLDateTime(nativetimeStr, this.conn, isTime);
                resStr = resStr + SQUOTE + loctimeStr + SQUOTE;
                if (!TraceFlag.isTraceEnabled()) continue;
                this.trace.writeTrace(logger, 3, "IfxNativeSQL(): resStr = '" + resStr + SQUOTE);
                continue;
            }
            if (kw.equals("ts") && str.hasMoreTokens()) {
                String ts = str.nextToken(SRBRACE).trim();
                String locdatetimeStr = null;
                boolean isTime = false;
                firstChar = ts.substring(0, 1);
                lastChar = ts.substring(ts.length() - 1, ts.length());
                String nativedatetimeStr = ts.substring(1, ts.length() - 1);
                if (!firstChar.equals(SQUOTE) || !lastChar.equals(SQUOTE)) {
                    throw IfxErrMsg.getSQLMinorException(-79710, SDQUOTE + sql + SDQUOTE, -80004, "''' ", this.conn);
                }
                locdatetimeStr = dateUtil.convertNativeSQLDateTime(nativedatetimeStr, this.conn, isTime);
                resStr = resStr + SQUOTE + locdatetimeStr + SQUOTE;
                if (!TraceFlag.isTraceEnabled()) continue;
                this.trace.writeTrace(logger, 3, "IfxNativeSQL(): resStr = '" + resStr + SQUOTE);
                continue;
            }
            if (kw.equals("fn") && str.hasMoreTokens()) {
                StringTokenizer argsT;
                f = str.nextToken(SRBRACE);
                StringTokenizer fT = new StringTokenizer(f, SBPAREN);
                if (!fT.hasMoreTokens()) {
                    throw IfxErrMsg.getSQLException(-79710, SDQUOTE + str + SDQUOTE, this.conn);
                }
                String func = fT.nextToken().trim();
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, "IfxNativeSQL(): func = '" + func + SQUOTE);
                }
                String args = fT.hasMoreTokens() ? fT.nextToken(SBPAREN) : "";
                if (TraceFlag.isTraceEnabled()) {
                    this.trace.writeTrace(logger, 3, "IfxNativeSQL(): args = '" + args + SQUOTE);
                }
                String ifxFunc = funcTable.get(func.toLowerCase());
                String ifxFuncNA = funcTable.get(func.toUpperCase());
                if (ifxFunc != null) {
                    resStr = resStr + ifxFunc + SLPAREN + args + SRPAREN;
                    continue;
                }
                if (ifxFuncNA != null) {
                    resStr = resStr + ifxFuncNA;
                    continue;
                }
                if (func.equalsIgnoreCase("cot")) {
                    resStr = resStr + SLPAREN + "cos" + SLPAREN + args + SRPAREN + "/sin" + SLPAREN + args + SRPAREN + SRPAREN;
                    continue;
                }
                if (func.equalsIgnoreCase("degrees")) {
                    resStr = resStr + SLPAREN + args + " * 180 / " + Math.PI + SRPAREN;
                    continue;
                }
                if (func.equalsIgnoreCase("pi")) {
                    resStr = resStr + Math.PI;
                    continue;
                }
                if (func.equalsIgnoreCase("radians")) {
                    resStr = resStr + SLPAREN + args + " * " + Math.PI + " / 180" + SRPAREN + SSPACE;
                    continue;
                }
                if (func.equalsIgnoreCase("rand")) {
                    Random r = new Random(stringUtil.stringToInt(args));
                    resStr = resStr + r.nextFloat();
                    if (!TraceFlag.isTraceEnabled()) continue;
                    this.trace.writeTrace(logger, 3, "IfxNativeSQL: resStr == '" + resStr + SQUOTE);
                    continue;
                }
                if (func.equalsIgnoreCase("concat")) {
                    argsT = new StringTokenizer(args, SCOMMA);
                    String arglist = "";
                    while (argsT.hasMoreTokens()) {
                        arglist = arglist + argsT.nextToken();
                        if (!argsT.hasMoreTokens()) continue;
                        arglist = arglist + " || ";
                    }
                    resStr = resStr + arglist;
                    if (!TraceFlag.isTraceEnabled()) continue;
                    this.trace.writeTrace(logger, 3, "IfxNativeSQL: resStr == '" + resStr + SQUOTE);
                    continue;
                }
                if (func.equalsIgnoreCase("left")) {
                    StringTokenizer leftT = new StringTokenizer(args, SCOMMA);
                    if (leftT.countTokens() == 2) {
                        String arg1 = leftT.nextToken().trim();
                        String countStr = leftT.nextToken().trim();
                        int cnt = stringUtil.stringToInt(countStr) + 1;
                        resStr = resStr + ' ' + arg1 + '[' + "1, " + cnt + ']';
                    }
                    if (!TraceFlag.isTraceEnabled()) continue;
                    this.trace.writeTrace(logger, 3, "IfxNativeSQL: resStr == '" + resStr + SQUOTE);
                    continue;
                }
                if (func.equalsIgnoreCase("ltrim")) {
                    resStr = resStr + "trim " + SLPAREN + "LEADING FROM " + args + SRPAREN;
                    continue;
                }
                if (func.equalsIgnoreCase("rtrim")) {
                    resStr = resStr + "trim " + SLPAREN + "TRAILING FROM " + args + SRPAREN;
                    continue;
                }
                if (func.equalsIgnoreCase("dayofweek")) {
                    resStr = resStr + SLPAREN + "weekday" + SLPAREN + args + SRPAREN + "+1" + SRPAREN;
                    continue;
                }
                if (func.equalsIgnoreCase("hour")) {
                    resStr = resStr + "extend" + SLPAREN + args + ", hour to hour" + SRPAREN;
                    continue;
                }
                if (func.equalsIgnoreCase("minute")) {
                    resStr = resStr + "extend" + SLPAREN + args + ", minute to minute" + SRPAREN;
                    continue;
                }
                if (func.equalsIgnoreCase("second")) {
                    resStr = resStr + "extend" + SLPAREN + args + ", second to second" + SRPAREN;
                    continue;
                }
                if (func.equalsIgnoreCase("database")) {
                    String db = this.conn.getDbName();
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, "IfxNativeSQL: db == '" + db + SQUOTE);
                    }
                    if (db == null) continue;
                    resStr = resStr + db;
                    continue;
                }
                if (func.equalsIgnoreCase("ifnull")) {
                    argsT = new StringTokenizer(args, SCOMMA);
                    if (argsT.countTokens() != 2) {
                        throw IfxErrMsg.getSQLException(-79713, SDQUOTE + f + SDQUOTE, this.conn);
                    }
                    String expr = argsT.nextToken().trim();
                    String value = argsT.nextToken().trim();
                    resStr = resStr + "ifnull('" + expr + "', " + value + SRPAREN;
                    if (!TraceFlag.isTraceEnabled()) continue;
                    this.trace.writeTrace(logger, 3, "IfxNativeSQL: resStr == '" + resStr + SQUOTE);
                    continue;
                }
                if (func.equalsIgnoreCase("convert")) {
                    argsT = new StringTokenizer(args, SCOMMA);
                    if (argsT.countTokens() != 2) {
                        throw IfxErrMsg.getSQLException(-79713, SDQUOTE + f + SDQUOTE, this.conn);
                    }
                    String val = argsT.nextToken().trim();
                    String type = argsT.nextToken().trim();
                    if (type.equalsIgnoreCase("BINARY") || type.equalsIgnoreCase("BIT") || type.equalsIgnoreCase("LONGVARBINARY") || type.equalsIgnoreCase("VARBINARY")) {
                        throw IfxErrMsg.getSQLException(-79714, ": " + type, this.conn);
                    }
                    resStr = resStr + val;
                    if (!TraceFlag.isTraceEnabled()) continue;
                    this.trace.writeTrace(logger, 3, "IfxNativeSQL: resStr == '" + resStr + SQUOTE);
                    continue;
                }
                resStr = resStr + func + SLPAREN + args + SRPAREN;
                continue;
            }
            if (kw.equals("escape") && str.hasMoreTokens()) {
                String f2 = str.nextToken(SRBRACE);
                StringTokenizer fT = new StringTokenizer(f2, SSPACE);
                if (fT.hasMoreTokens()) {
                    resStr = resStr + "escape " + fT.nextToken();
                }
                if (!TraceFlag.isTraceEnabled()) continue;
                this.trace.writeTrace(logger, 3, "IfxNativeSQL: resStr == '" + resStr + SQUOTE);
                continue;
            }
            if (kw.equals("limit") && str.hasMoreTokens()) {
                f = str.nextToken(SRBRACE);
                StringTokenizer fT = new StringTokenizer(f, SSPACE);
                String limit = fT.nextToken();
                String skip = "";
                if (fT.hasMoreTokens()) {
                    skip = fT.nextToken();
                }
                resStr = resStr + "LIMIT " + limit;
                if (skip.isEmpty()) continue;
                resStr = "SELECT SKIP " + skip + resStr.substring(6);
                continue;
            }
            if (kw.equals("oj") && str.hasMoreTokens()) {
                String ojS = str.nextToken(SRBRACE);
                StringTokenizer ojT = new StringTokenizer(ojS, SSPACE, true);
                Vector<String> tabList = new Vector<String>();
                String tmp = "";
                String tab = "";
                while (ojT.hasMoreTokens()) {
                    tmp = ojT.nextToken();
                    tab = "";
                    if (tmp.equalsIgnoreCase("ON") || tmp.equalsIgnoreCase("LEFT") || tmp.equalsIgnoreCase("RIGHT") || tmp.equalsIgnoreCase("FULL")) {
                        throw IfxErrMsg.getSQLMinorException(-79715, -80005, SDQUOTE + ojS + SDQUOTE, this.conn);
                    }
                    while (!(!ojT.hasMoreTokens() || tmp.equalsIgnoreCase("LEFT") || tmp.equalsIgnoreCase("RIGHT") || tmp.equalsIgnoreCase("FULL") || tmp.equalsIgnoreCase("OUTER") || tmp.equalsIgnoreCase("JOIN") || tmp.equalsIgnoreCase("ON"))) {
                        tab = tab + tmp;
                        tmp = ojT.nextToken();
                    }
                    if (TraceFlag.isTraceEnabled()) {
                        this.trace.writeTrace(logger, 3, "IfxNativeSQL: tab == '" + tab + SQUOTE);
                    }
                    if (ansiJoinSupp) {
                        resStr = resStr + tab.trim();
                    } else {
                        tabList.add(tab.trim());
                    }
                    if (!ojT.hasMoreTokens()) {
                        throw IfxErrMsg.getSQLMinorException(-79715, -80005, SDQUOTE + ojS + SDQUOTE, this.conn);
                    }
                    String tok = tmp;
                    if (tok.equalsIgnoreCase("ON")) {
                        String tempCond = "";
                        while (ojT.hasMoreTokens()) {
                            tok = ojT.nextToken();
                            if (ansiJoinSupp) {
                                tempCond = tempCond + tok;
                                continue;
                            }
                            if (tok.equalsIgnoreCase("ON")) {
                                tempCond = tempCond + " and ";
                                continue;
                            }
                            tempCond = tempCond + tok;
                        }
                        if (TraceFlag.isTraceEnabled()) {
                            this.trace.writeTrace(logger, 3, "IfxNativeSQL: searchCond == '" + tempCond + SQUOTE);
                        }
                        searchCond = ansiJoinSupp ? " on" + tempCond : " where " + tempCond;
                    } else if (tok.equalsIgnoreCase("LEFT") || tok.equalsIgnoreCase("RIGHT") || tok.equalsIgnoreCase("FULL")) {
                        if (ojT.countTokens() < 3) {
                            throw IfxErrMsg.getSQLMinorException(-79715, -80005, SDQUOTE + ojS + SDQUOTE, this.conn);
                        }
                        if (!(ojT.nextToken().equals(SSPACE) && ojT.nextToken().equalsIgnoreCase("OUTER") && ojT.nextToken().equals(SSPACE) && ojT.nextToken().equalsIgnoreCase("JOIN"))) {
                            throw IfxErrMsg.getSQLMinorException(-79715, -80005, SDQUOTE + ojS + SDQUOTE, this.conn);
                        }
                        if (ansiJoinSupp) {
                            resStr = resStr + SSPACE + tok + " outer join ";
                        }
                    } else {
                        throw IfxErrMsg.getSQLMinorException(-79715, -80005, SDQUOTE + ojS + SDQUOTE, this.conn);
                    }
                    if (!TraceFlag.isTraceEnabled()) continue;
                    this.trace.writeTrace(logger, 3, "IfxNativeSQL: resStr == '" + resStr + SQUOTE);
                }
                if (!ansiJoinSupp) {
                    String newJoin = "";
                    int i = 0;
                    int listSize = tabList.size();
                    for (i = 0; i < listSize; ++i) {
                        newJoin = i > 0 ? newJoin + ", outer(" + (String)tabList.elementAt(i) : newJoin + (String)tabList.elementAt(i);
                    }
                    for (i = 1; i <= listSize - 1; ++i) {
                        newJoin = newJoin + SRPAREN;
                    }
                    resStr = resStr + newJoin;
                }
                if (searchCond.length() <= 0) continue;
                resStr = resStr + searchCond;
                continue;
            }
            validSequence = false;
        }
        if (validSequence) {
            return resStr;
        }
        return sql;
    }

    private boolean using9xSyntax(String s) {
        if (s == null) {
            return false;
        }
        boolean returnValue = false;
        String workingString = s.trim();
        if (workingString.length() == 0 || !workingString.endsWith("t")) {
            return returnValue;
        }
        int len = workingString.length();
        String[] compStrings = new String[]{"multiset", "list", "set"};
        for (int loop = 0; loop < compStrings.length && !returnValue; ++loop) {
            int compLen = compStrings[loop].length();
            if (compLen > len || !workingString.substring(len - compLen, len).equals(compStrings[loop])) continue;
            returnValue = true;
        }
        return returnValue;
    }

    private static int trackQuotes(String token, int currentStartQuoteVal) {
        int retVal = currentStartQuoteVal;
        block4: for (int i = 0; i < token.length(); ++i) {
            char ch = token.charAt(i);
            switch (ch) {
                case '\'': {
                    if (retVal == -1) {
                        retVal = ch;
                        continue block4;
                    }
                    if (retVal != ch) continue block4;
                    if (i + 1 < token.length() && token.charAt(i + 1) == '\'') {
                        ++i;
                        continue block4;
                    }
                    retVal = -1;
                    continue block4;
                }
                case '\"': {
                    if (retVal == -1) {
                        retVal = ch;
                        continue block4;
                    }
                    if (retVal != ch) continue block4;
                    if (i + 1 < token.length() && token.charAt(i + 1) == '\"') {
                        ++i;
                        continue block4;
                    }
                    retVal = -1;
                    continue block4;
                }
            }
        }
        return retVal;
    }

    private static boolean isWithinQuotes(int currStartQuoteStatus) {
        return currStartQuoteStatus != -1;
    }

    static {
        if (funcTable == null) {
            funcTable = new Hashtable();
            funcTable.put("abs", "abs");
            funcTable.put("acos", "acos");
            funcTable.put("asin", "asin");
            funcTable.put("atan", "atan");
            funcTable.put("atan2", "atan2");
            funcTable.put("ceiling", "round");
            funcTable.put("exp", "exp");
            funcTable.put("floor", "trunc");
            funcTable.put("log", "logn");
            funcTable.put("log10", "log10");
            funcTable.put("mod", "mod");
            funcTable.put("power", "pow");
            funcTable.put("round", "round");
            funcTable.put("sin", "sin");
            funcTable.put("sign", "sign");
            funcTable.put("sqrt", "sqrt");
            funcTable.put("tan", "tan");
            funcTable.put("truncate", "trunc");
            funcTable.put("length", "length");
            funcTable.put("dayofmonth", "day");
            funcTable.put("month", "month");
            funcTable.put("year", "year");
            funcTable.put("CURDATE", "today");
            funcTable.put("CURTIME", "current");
            funcTable.put("NOW", "current");
            funcTable.put("USER", "user");
        }
    }
}

