/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.BoundStatement;
import com.datastax.oss.driver.api.core.cql.BoundStatementBuilder;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.PreparedStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.data.CqlDuration;
import com.datastax.oss.driver.api.core.data.CqlVector;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.internal.core.type.DefaultListType;
import com.datastax.oss.driver.internal.core.type.DefaultMapType;
import com.datastax.oss.driver.internal.core.type.DefaultSetType;
import com.datastax.oss.driver.internal.core.type.DefaultVectorType;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.ing.data.cassandra.jdbc.CassandraConnection;
import com.ing.data.cassandra.jdbc.CassandraParameterMetaData;
import com.ing.data.cassandra.jdbc.CassandraResultSet;
import com.ing.data.cassandra.jdbc.CassandraStatement;
import com.ing.data.cassandra.jdbc.CassandraStatementJsonSupport;
import com.ing.data.cassandra.jdbc.types.DataTypeEnum;
import com.ing.data.cassandra.jdbc.utils.ConversionsUtil;
import com.ing.data.cassandra.jdbc.utils.JsonUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLNonTransientException;
import java.sql.SQLRecoverableException;
import java.sql.SQLTransientException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletionStage;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CassandraPreparedStatement
extends CassandraStatement
implements java.sql.PreparedStatement,
CassandraStatementJsonSupport {
    private static final Logger LOG = LoggerFactory.getLogger(CassandraPreparedStatement.class);
    private final int count;
    private final PreparedStatement preparedStatement;
    private BoundStatement boundStatement;
    private ArrayList<BoundStatement> batchStatements;

    CassandraPreparedStatement(CassandraConnection connection, String cql) throws SQLException {
        this(connection, cql, 1003, 1007, 1);
    }

    CassandraPreparedStatement(CassandraConnection connection, String cql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(connection, cql, resultSetType, resultSetConcurrency, resultSetHoldability);
        if (LOG.isTraceEnabled() || connection.isDebugMode()) {
            LOG.trace("CQL: {}", (Object)this.cql);
        }
        try {
            this.preparedStatement = this.getCqlSession().prepare(cql);
            this.boundStatement = ((BoundStatementBuilder)this.preparedStatement.boundStatementBuilder(new Object[0]).setExecutionProfile(this.connection.getActiveExecutionProfile())).build();
            this.batchStatements = new ArrayList();
            this.count = cql.length() - cql.replace("?", "").length();
        }
        catch (Exception e) {
            throw new SQLTransientException(e);
        }
    }

    private void checkIndex(int index) throws SQLException {
        if (index > this.count) {
            throw new SQLRecoverableException(String.format("The index %d is greater than the count of bound variable markers in the CQL: %d", index, this.count));
        }
        if (index < 1) {
            throw new SQLRecoverableException(String.format("The binding index must be a positive number: %d", index));
        }
    }

    String getCql() {
        return this.cql;
    }

    CqlSession getCqlSession() {
        return (CqlSession)this.connection.getSession();
    }

    ColumnDefinitions getBoundStatementVariableDefinitions() {
        return this.boundStatement.getPreparedStatement().getVariableDefinitions();
    }

    private static <T> List<T> handleAsList(Class<?> objectClass, Object object) {
        if (!List.class.isAssignableFrom(objectClass)) {
            return null;
        }
        return (List)object.getClass().cast(object);
    }

    private static <T> Set<T> handleAsSet(Class<?> objectClass, Object object) {
        if (!Set.class.isAssignableFrom(objectClass)) {
            return null;
        }
        return (Set)object.getClass().cast(object);
    }

    private static <K, V> HashMap<K, V> handleAsMap(Class<?> objectClass, Object object) {
        if (!Map.class.isAssignableFrom(objectClass)) {
            return null;
        }
        return (HashMap)object.getClass().cast(object);
    }

    @Override
    public void close() {
        try {
            this.connection.removeStatement(this);
        }
        catch (Exception e) {
            LOG.warn("Unable to close the prepared statement: {}", (Object)e.getMessage());
        }
    }

    private void doExecute() throws SQLException {
        try {
            this.resetResults();
            if (LOG.isTraceEnabled() || this.connection.isDebugMode()) {
                LOG.trace("CQL: {}", (Object)this.cql);
            }
            this.boundStatement = (BoundStatement)((BoundStatement)this.boundStatement.setPageSize(this.getFetchSize())).setConsistencyLevel(this.connection.getConsistencyLevel());
            for (int i = 0; i < this.getBoundStatementVariableDefinitions().size(); ++i) {
                if (this.boundStatement.isSet(i)) continue;
                this.boundStatement.setToNull(i);
            }
            this.currentResultSet = new CassandraResultSet((CassandraStatement)this, this.getCqlSession().execute((Statement)this.boundStatement));
        }
        catch (Exception e) {
            throw new SQLTransientException(e);
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.batchStatements.add(this.boundStatement);
        this.boundStatement = ((BoundStatementBuilder)this.preparedStatement.boundStatementBuilder(new Object[0]).setExecutionProfile(this.connection.getActiveExecutionProfile())).build();
        if (this.batchStatements.size() > 1000) {
            throw new SQLNonTransientException(String.format("Too many queries at once (%d). You must split your queries into more batches!", this.batchStatements.size()));
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkNotClosed();
    }

    @Override
    public boolean execute() throws SQLException {
        this.checkNotClosed();
        this.doExecute();
        return this.currentResultSet != null && ((CassandraResultSet)this.currentResultSet).isQueryResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        int[] returnCounts = new int[this.batchStatements.size()];
        try {
            ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
            if (LOG.isTraceEnabled() || this.connection.isDebugMode()) {
                LOG.trace("CQL statements: {}", (Object)this.batchStatements.size());
            }
            for (BoundStatement statement : this.batchStatements) {
                for (int i = 0; i < statement.getPreparedStatement().getVariableDefinitions().size(); ++i) {
                    if (statement.isSet(i)) continue;
                    statement.setToNull(i);
                }
                if (LOG.isTraceEnabled() || this.connection.isDebugMode()) {
                    LOG.trace("CQL: {}", (Object)this.cql);
                }
                BoundStatement boundStatement = (BoundStatement)statement.setConsistencyLevel(this.connection.getConsistencyLevel());
                CompletionStage resultSetFuture = this.getCqlSession().executeAsync((Statement)boundStatement);
                futures.add(resultSetFuture);
            }
            int i = 0;
            boolean hasFailures = false;
            StringBuilder errMsgBuilder = new StringBuilder("At least one statement in batch has failed:");
            for (CompletionStage future : futures) {
                try {
                    AsyncResultSet asyncResultSet = (AsyncResultSet)CompletableFutures.getUninterruptibly((CompletionStage)future);
                    if (asyncResultSet.getColumnDefinitions().size() > 0) {
                        returnCounts[i] = -3;
                        hasFailures = true;
                        errMsgBuilder.append(String.format("\n - Statement #%d: %s", i, "attempts to return a result set"));
                        continue;
                    }
                    returnCounts[i] = -2;
                }
                catch (Exception e) {
                    returnCounts[i] = -3;
                    hasFailures = true;
                    errMsgBuilder.append(String.format("\n - Statement #%d: %s", i, e.getMessage()));
                }
                finally {
                    ++i;
                }
            }
            if (hasFailures) {
                throw new BatchUpdateException(errMsgBuilder.toString(), returnCounts);
            }
        }
        catch (SQLException sqlEx) {
            throw sqlEx;
        }
        catch (Exception e) {
            throw new SQLTransientException(e);
        }
        finally {
            this.batchStatements = new ArrayList();
        }
        return returnCounts;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        this.checkNotClosed();
        this.doExecute();
        if (this.currentResultSet == null) {
            throw new SQLNonTransientException("No ResultSet returned from the CQL statement passed in an 'executeQuery()' method.");
        }
        return this.currentResultSet;
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.checkNotClosed();
        this.doExecute();
        return 0;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.getResultSet().getMetaData();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new CassandraParameterMetaData(this.boundStatement, this.count);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.boundStatement = x == null ? (BoundStatement)this.boundStatement.setToNull(parameterIndex - 1) : (BoundStatement)this.boundStatement.setBigDecimal(parameterIndex - 1, x);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        InputStream in = x.getBinaryStream();
        this.setBlob(parameterIndex, in);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        if (inputStream == null) {
            this.boundStatement = (BoundStatement)this.boundStatement.setToNull(parameterIndex - 1);
        } else {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] data = new byte[16384];
            try {
                int nRead;
                while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                }
            }
            catch (IOException e) {
                throw new SQLNonTransientException(e);
            }
            try {
                buffer.flush();
            }
            catch (IOException e) {
                throw new SQLNonTransientException(e);
            }
            this.boundStatement = (BoundStatement)this.boundStatement.setByteBuffer(parameterIndex - 1, ByteBuffer.wrap(buffer.toByteArray()));
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.boundStatement = (BoundStatement)this.boundStatement.setBoolean(parameterIndex - 1, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.boundStatement = (BoundStatement)this.boundStatement.setByte(parameterIndex - 1, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.boundStatement = (BoundStatement)this.boundStatement.setByteBuffer(parameterIndex - 1, ByteBuffer.wrap(x));
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        try {
            String targetString = IOUtils.toString((Reader)reader);
            reader.close();
            this.setString(parameterIndex, targetString);
        }
        catch (IOException e) {
            throw new SQLNonTransientException(e);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.boundStatement = x == null ? (BoundStatement)this.boundStatement.setToNull(parameterIndex - 1) : (BoundStatement)this.boundStatement.setLocalDate(parameterIndex - 1, x.toLocalDate());
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.setDate(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.boundStatement = (BoundStatement)this.boundStatement.setDouble(parameterIndex - 1, x);
    }

    public void setDuration(int parameterIndex, CqlDuration x) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.boundStatement = x == null ? (BoundStatement)this.boundStatement.setToNull(parameterIndex - 1) : (BoundStatement)this.boundStatement.setCqlDuration(parameterIndex - 1, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.boundStatement = (BoundStatement)this.boundStatement.setFloat(parameterIndex - 1, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.boundStatement = DataTypeEnum.VARINT.cqlType.equals(this.getBoundStatementVariableDefinitions().get(parameterIndex - 1).getType().asCql(false, false)) ? (BoundStatement)this.boundStatement.setBigInteger(parameterIndex - 1, BigInteger.valueOf(Long.parseLong(String.valueOf(x)))) : (BoundStatement)this.boundStatement.setInt(parameterIndex - 1, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.boundStatement = (BoundStatement)this.boundStatement.setLong(parameterIndex - 1, x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.setString(parameterIndex, value);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.boundStatement = (BoundStatement)this.boundStatement.setToNull(parameterIndex - 1);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        int targetType = x.getClass().equals(Long.class) ? -5 : (x.getClass().equals(ByteArrayInputStream.class) ? -2 : (x instanceof byte[] ? -3 : (x instanceof Blob ? 2004 : (x instanceof Clob ? 2005 : (x.getClass().equals(String.class) ? 12 : (x.getClass().equals(Boolean.class) ? 16 : (x.getClass().equals(BigDecimal.class) ? 3 : (x.getClass().equals(BigInteger.class) ? -5 : (x.getClass().equals(Double.class) ? 8 : (x.getClass().equals(Float.class) ? 6 : (x.getClass().equals(Inet4Address.class) ? 1111 : (x.getClass().equals(Integer.class) ? 4 : (x.getClass().equals(Timestamp.class) || x instanceof Calendar || x.getClass().equals(java.util.Date.class) || x.getClass().equals(LocalDateTime.class) ? 93 : (x.getClass().equals(Date.class) || x.getClass().equals(LocalDate.class) ? 91 : (x.getClass().equals(Time.class) || x.getClass().equals(LocalTime.class) ? 92 : (x.getClass().equals(OffsetDateTime.class) ? 2014 : (x.getClass().equals(OffsetTime.class) ? 2013 : (x.getClass().equals(Byte.class) ? -6 : (x.getClass().equals(Short.class) ? 5 : (x.getClass().equals(URL.class) ? 70 : (x.getClass().equals(CqlDuration.class) ? 1111 : (x.getClass().equals(UUID.class) ? 1111 : (x.getClass().equals(CqlVector.class) ? 1111 : 1111)))))))))))))))))))))));
        this.setObject(parameterIndex, x, targetType, 0);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    @Override
    public final void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        switch (targetSqlType) {
            case -5: {
                if (x instanceof BigInteger) {
                    this.boundStatement = (BoundStatement)this.boundStatement.setBigInteger(parameterIndex - 1, (BigInteger)x);
                    break;
                }
                this.boundStatement = (BoundStatement)this.boundStatement.setLong(parameterIndex - 1, Long.parseLong(x.toString()));
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: 
            case 2005: 
            case 2011: {
                byte[] array = ConversionsUtil.convertToByteArray(x);
                this.boundStatement = (BoundStatement)this.boundStatement.setByteBuffer(parameterIndex - 1, ByteBuffer.wrap(array));
                break;
            }
            case -7: 
            case 16: {
                this.boundStatement = (BoundStatement)this.boundStatement.setBoolean(parameterIndex - 1, ((Boolean)x).booleanValue());
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 70: {
                this.boundStatement = (BoundStatement)this.boundStatement.setString(parameterIndex - 1, x.toString());
                break;
            }
            case 93: 
            case 2014: {
                this.boundStatement = (BoundStatement)this.boundStatement.setInstant(parameterIndex - 1, ConversionsUtil.convertToInstant(x));
                break;
            }
            case 2: 
            case 3: {
                this.boundStatement = (BoundStatement)this.boundStatement.setBigDecimal(parameterIndex - 1, (BigDecimal)x);
                break;
            }
            case 8: {
                this.boundStatement = (BoundStatement)this.boundStatement.setDouble(parameterIndex - 1, ((Double)x).doubleValue());
                break;
            }
            case 6: 
            case 7: {
                this.boundStatement = (BoundStatement)this.boundStatement.setFloat(parameterIndex - 1, ((Float)x).floatValue());
                break;
            }
            case 4: {
                if (DataTypeEnum.VARINT.cqlType.equals(this.getBoundStatementVariableDefinitions().get(parameterIndex - 1).getType().asCql(false, false))) {
                    this.boundStatement = (BoundStatement)this.boundStatement.setBigInteger(parameterIndex - 1, BigInteger.valueOf(Long.parseLong(x.toString())));
                    break;
                }
                this.boundStatement = (BoundStatement)this.boundStatement.setInt(parameterIndex - 1, ((Integer)x).intValue());
                break;
            }
            case 5: {
                this.boundStatement = (BoundStatement)this.boundStatement.setShort(parameterIndex - 1, ((Short)x).shortValue());
                break;
            }
            case -6: {
                this.boundStatement = (BoundStatement)this.boundStatement.setByte(parameterIndex - 1, ((Byte)x).byteValue());
                break;
            }
            case 91: {
                this.boundStatement = (BoundStatement)this.boundStatement.setLocalDate(parameterIndex - 1, ConversionsUtil.convertToLocalDate(x));
                break;
            }
            case 92: 
            case 2013: {
                this.boundStatement = (BoundStatement)this.boundStatement.setLocalTime(parameterIndex - 1, ConversionsUtil.convertToLocalTime(x));
                break;
            }
            case -8: {
                this.boundStatement.setToNull(parameterIndex - 1);
                break;
            }
            case 1111: {
                if (x instanceof TupleValue) {
                    this.boundStatement = (BoundStatement)this.boundStatement.setTupleValue(parameterIndex - 1, (TupleValue)x);
                    break;
                }
                if (x instanceof UUID) {
                    this.boundStatement = (BoundStatement)this.boundStatement.setUuid(parameterIndex - 1, (UUID)x);
                    break;
                }
                if (x instanceof CqlDuration) {
                    this.boundStatement = (BoundStatement)this.boundStatement.setCqlDuration(parameterIndex - 1, (CqlDuration)x);
                    break;
                }
                if (x instanceof CqlVector) {
                    CqlVector vector = (CqlVector)x;
                    DefaultVectorType vectorType = (DefaultVectorType)this.getBoundStatementVariableDefinitions().get(parameterIndex - 1).getType();
                    Class<?> itemsClass = DataTypeEnum.fromCqlTypeName((String)vectorType.getElementType().asCql((boolean)false, (boolean)false)).javaType;
                    if (Number.class.isAssignableFrom(itemsClass)) {
                        this.boundStatement = (BoundStatement)this.boundStatement.setVector(parameterIndex - 1, vector, itemsClass.asSubclass(Number.class));
                        break;
                    }
                    throw new SQLException("Vector elements are not numbers.");
                }
                if (x instanceof InetAddress) {
                    this.boundStatement = (BoundStatement)this.boundStatement.setInetAddress(parameterIndex - 1, (InetAddress)x);
                    break;
                }
                if (List.class.isAssignableFrom(x.getClass())) {
                    List handledList = CassandraPreparedStatement.handleAsList(x.getClass(), x);
                    DefaultListType listType = (DefaultListType)this.getBoundStatementVariableDefinitions().get(parameterIndex - 1).getType();
                    Class<?> itemsClass = DataTypeEnum.fromCqlTypeName((String)listType.getElementType().asCql((boolean)false, (boolean)false)).javaType;
                    this.boundStatement = (BoundStatement)this.boundStatement.setList(parameterIndex - 1, handledList, itemsClass);
                    break;
                }
                if (Set.class.isAssignableFrom(x.getClass())) {
                    Set handledSet = CassandraPreparedStatement.handleAsSet(x.getClass(), x);
                    DefaultSetType setType = (DefaultSetType)this.getBoundStatementVariableDefinitions().get(parameterIndex - 1).getType();
                    Class<?> itemsClass = DataTypeEnum.fromCqlTypeName((String)setType.getElementType().asCql((boolean)false, (boolean)false)).javaType;
                    this.boundStatement = (BoundStatement)this.boundStatement.setSet(parameterIndex - 1, handledSet, itemsClass);
                    break;
                }
                if (!Map.class.isAssignableFrom(x.getClass())) break;
                HashMap handledMap = CassandraPreparedStatement.handleAsMap(x.getClass(), x);
                DefaultMapType mapType = (DefaultMapType)this.getBoundStatementVariableDefinitions().get(parameterIndex - 1).getType();
                Class<?> keysClass = DataTypeEnum.fromCqlTypeName((String)mapType.getKeyType().asCql((boolean)false, (boolean)false)).javaType;
                Class<?> valuesClass = DataTypeEnum.fromCqlTypeName((String)mapType.getValueType().asCql((boolean)false, (boolean)false)).javaType;
                this.boundStatement = (BoundStatement)this.boundStatement.setMap(parameterIndex - 1, handledMap, keysClass, valuesClass);
                break;
            }
            default: {
                throw new SQLException(String.format("Unsupported JDBC type: %s", targetSqlType));
            }
        }
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.boundStatement.setToNull(parameterIndex - 1);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.boundStatement = (BoundStatement)this.boundStatement.setShort(parameterIndex - 1, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.boundStatement = (BoundStatement)this.boundStatement.setString(parameterIndex - 1, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.boundStatement = x == null ? (BoundStatement)this.boundStatement.setToNull(parameterIndex - 1) : (BoundStatement)this.boundStatement.setLocalTime(parameterIndex - 1, x.toLocalTime());
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.setTime(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        this.boundStatement = x == null ? (BoundStatement)this.boundStatement.setToNull(parameterIndex - 1) : (BoundStatement)this.boundStatement.setInstant(parameterIndex - 1, x.toInstant());
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setURL(int parameterIndex, URL value) throws SQLException {
        this.checkNotClosed();
        this.checkIndex(parameterIndex);
        String url = value.toString();
        this.setString(parameterIndex, url);
    }

    @Override
    public <T> void setJson(int parameterIndex, T x) throws SQLException {
        this.checkNotClosed();
        try {
            String json = JsonUtil.getObjectMapper().writeValueAsString(x);
            this.setString(parameterIndex, json);
        }
        catch (JsonProcessingException e) {
            throw new SQLException(String.format("Unable to convert the object of type %s to bind the column of index %d", x.getClass().getName(), parameterIndex));
        }
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkNotClosed();
        return this.currentResultSet;
    }
}

