/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc;

import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.protocol.internal.response.result.ColumnSpec;
import com.datastax.oss.protocol.internal.response.result.RawType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;

public class ColumnDefinitions
implements Iterable<Definition> {
    private final Definition[] byIdx;
    private final Map<String, int[]> byName;

    public ColumnDefinitions(Definition[] definitions) {
        this.byIdx = definitions;
        this.byName = new HashMap<String, int[]>(definitions.length);
        for (int i = 0; i < definitions.length; ++i) {
            int[] previous = this.byName.put(definitions[i].name.toLowerCase(), new int[]{i});
            if (previous == null) continue;
            int[] indexes = new int[previous.length + 1];
            System.arraycopy(previous, 0, indexes, 0, previous.length);
            indexes[indexes.length - 1] = i;
            this.byName.put(definitions[i].name.toLowerCase(), indexes);
        }
    }

    public int size() {
        return this.byIdx.length;
    }

    public boolean contains(String name) {
        return this.findAllIdx(name) != null;
    }

    public int getIndexOf(String name) {
        return this.findFirstIdx(name);
    }

    @Override
    @Nonnull
    public Iterator<Definition> iterator() {
        return Arrays.asList(this.byIdx).iterator();
    }

    public List<Definition> asList() {
        return Arrays.asList(this.byIdx);
    }

    public String getName(int i) {
        return this.byIdx[i].name;
    }

    public DataType getType(int i) {
        return this.byIdx[i].type;
    }

    public DataType getType(String name) {
        return this.getType(this.getFirstIdx(name));
    }

    public String getKeyspace(int i) {
        return this.byIdx[i].keyspace;
    }

    public String getKeyspace(String name) {
        return this.getKeyspace(this.getFirstIdx(name));
    }

    public String getTable(int i) {
        return this.byIdx[i].table;
    }

    public String getTable(String name) {
        return this.getTable(this.getFirstIdx(name));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Columns[");
        for (int i = 0; i < this.size(); ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            Definition def = this.byIdx[i];
            sb.append(def.name).append('(').append(def.type).append(')');
        }
        sb.append(']');
        return sb.toString();
    }

    int findFirstIdx(String name) {
        int[] indexes = this.findAllIdx(name);
        if (indexes == null) {
            return -1;
        }
        return indexes[0];
    }

    int[] findAllIdx(String name) {
        boolean caseSensitive = false;
        String columnName = name;
        if (name.length() >= 2 && name.charAt(0) == '\"' && name.charAt(name.length() - 1) == '\"') {
            columnName = name.substring(1, name.length() - 1);
            caseSensitive = true;
        }
        int[] indexes = this.byName.get(columnName.toLowerCase());
        if (!caseSensitive || indexes == null) {
            return indexes;
        }
        int nbMatch = 0;
        for (int index : indexes) {
            if (!columnName.equals(this.byIdx[index].name)) continue;
            ++nbMatch;
        }
        if (nbMatch == indexes.length) {
            return indexes;
        }
        int[] result = new int[nbMatch];
        int j = 0;
        for (int idx : indexes) {
            if (!columnName.equals(this.byIdx[idx].name)) continue;
            result[j++] = idx;
        }
        return result;
    }

    int[] getAllIdx(String name) {
        int[] indexes = this.findAllIdx(name);
        if (indexes == null) {
            throw new IllegalArgumentException(String.format("Name provided was not in the list of valid column labels: %s", name));
        }
        return indexes;
    }

    int getFirstIdx(String name) {
        return this.getAllIdx(name)[0];
    }

    public static class Definition {
        private final String keyspace;
        private final String table;
        private final String name;
        private final DataType type;

        public Definition(String keyspace, String table, String name, DataType type) {
            this.keyspace = keyspace;
            this.table = table;
            this.name = name;
            this.type = type;
        }

        public static Definition buildDefinitionInAnonymousTable(String name, DataType type) {
            return new Definition("", "", name, type);
        }

        public ColumnSpec toColumnSpec(int idx) {
            return new ColumnSpec(this.keyspace, this.table, this.name, idx, (RawType)RawType.PRIMITIVES.get(this.type.getProtocolCode()));
        }

        public String getKeyspace() {
            return this.keyspace;
        }

        public String getTable() {
            return this.table;
        }

        public String getName() {
            return this.name;
        }

        public DataType getType() {
            return this.type;
        }

        public final int hashCode() {
            return Arrays.hashCode(new Object[]{this.keyspace, this.table, this.name, this.type});
        }

        public final boolean equals(Object o) {
            if (!(o instanceof Definition)) {
                return false;
            }
            Definition other = (Definition)o;
            return this.keyspace.equals(other.keyspace) && this.table.equals(other.table) && this.name.equals(other.name) && this.type.equals(other.type);
        }
    }
}

