/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.ing.data.cassandra.jdbc.codec.AbstractCodec;
import com.ing.data.cassandra.jdbc.utils.ByteBufferUtil;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;

public class BigintToBigDecimalCodec
extends AbstractCodec<BigDecimal>
implements TypeCodec<BigDecimal> {
    @Nonnull
    public GenericType<BigDecimal> getJavaType() {
        return GenericType.BIG_DECIMAL;
    }

    @Nonnull
    public DataType getCqlType() {
        return DataTypes.BIGINT;
    }

    public ByteBuffer encode(BigDecimal value, @Nonnull ProtocolVersion protocolVersion) {
        if (value == null) {
            return null;
        }
        return ByteBufferUtil.bytes(value.longValue());
    }

    public BigDecimal decode(ByteBuffer bytes, @Nonnull ProtocolVersion protocolVersion) {
        if (bytes == null) {
            return null;
        }
        long value = ByteBufferUtil.toLong(bytes.duplicate());
        return new BigDecimal(value);
    }

    @Override
    BigDecimal parseNonNull(@Nonnull String value) {
        return BigDecimal.valueOf(Long.parseLong(value));
    }

    @Override
    String formatNonNull(@Nonnull BigDecimal value) {
        return String.valueOf(value);
    }
}

