/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.ing.data.cassandra.jdbc.codec.AbstractCodec;
import com.ing.data.cassandra.jdbc.utils.ByteBufferUtil;
import java.nio.ByteBuffer;
import javax.annotation.Nonnull;

public class IntToLongCodec
extends AbstractCodec<Long>
implements TypeCodec<Long> {
    @Nonnull
    public GenericType<Long> getJavaType() {
        return GenericType.LONG;
    }

    @Nonnull
    public DataType getCqlType() {
        return DataTypes.INT;
    }

    public ByteBuffer encode(Long value, @Nonnull ProtocolVersion protocolVersion) {
        if (value == null) {
            return null;
        }
        return ByteBufferUtil.bytes(value.intValue());
    }

    public Long decode(ByteBuffer bytes, @Nonnull ProtocolVersion protocolVersion) {
        if (bytes == null) {
            return null;
        }
        return ByteBufferUtil.toLong(bytes.duplicate());
    }

    @Override
    Long parseNonNull(@Nonnull String value) {
        return Long.valueOf(value);
    }

    @Override
    String formatNonNull(@Nonnull Long value) {
        return String.valueOf(value);
    }
}

