/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.metadata;

import com.datastax.oss.driver.api.core.type.DataTypes;
import com.ing.data.cassandra.jdbc.CassandraMetadataResultSet;
import com.ing.data.cassandra.jdbc.CassandraStatement;
import com.ing.data.cassandra.jdbc.ColumnDefinitions;
import com.ing.data.cassandra.jdbc.metadata.AbstractMetadataResultSetBuilder;
import com.ing.data.cassandra.jdbc.metadata.MetadataResultSet;
import com.ing.data.cassandra.jdbc.metadata.MetadataRow;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;

public class SchemaMetadataResultSetBuilder
extends AbstractMetadataResultSetBuilder {
    public SchemaMetadataResultSetBuilder(CassandraStatement statement) throws SQLException {
        super(statement);
    }

    public CassandraMetadataResultSet buildSchemas(String schemaPattern) throws SQLException {
        ArrayList<MetadataRow> schemas = new ArrayList<MetadataRow>();
        String catalog = this.connection.getCatalog();
        MetadataRow.MetadataRowTemplate rowTemplate = new MetadataRow.MetadataRowTemplate(ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TABLE_SCHEM", DataTypes.TEXT), ColumnDefinitions.Definition.buildDefinitionInAnonymousTable("TABLE_CATALOG", DataTypes.TEXT));
        this.filterBySchemaNamePattern(schemaPattern, keyspaceMetadata -> {
            MetadataRow row = new MetadataRow().withTemplate(rowTemplate, keyspaceMetadata.getName().asInternal(), catalog);
            schemas.add(row);
        }, null);
        schemas.sort(Comparator.comparing(row -> row.getString("TABLE_SCHEM")));
        return CassandraMetadataResultSet.buildFrom(this.statement, new MetadataResultSet(rowTemplate).setRows(schemas));
    }
}

