/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.types;

import com.datastax.oss.driver.api.core.data.CqlDuration;
import com.datastax.oss.driver.api.core.data.CqlVector;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.data.UdtValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.VectorType;
import com.ing.data.cassandra.jdbc.metadata.VersionedMetadata;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.semver4j.Semver;

public enum DataTypeEnum implements VersionedMetadata
{
    ASCII(1, String.class, DataTypeEnum.cqlName(DataTypes.ASCII)),
    BIGINT(2, Long.class, DataTypeEnum.cqlName(DataTypes.BIGINT)),
    BLOB(3, ByteBuffer.class, DataTypeEnum.cqlName(DataTypes.BLOB)),
    BOOLEAN(4, Boolean.class, DataTypeEnum.cqlName(DataTypes.BOOLEAN)),
    COUNTER(5, Long.class, DataTypeEnum.cqlName(DataTypes.COUNTER)),
    CUSTOM(0, ByteBuffer.class, "CUSTOM"),
    DATE(17, Date.class, DataTypeEnum.cqlName(DataTypes.DATE)),
    DECIMAL(6, BigDecimal.class, DataTypeEnum.cqlName(DataTypes.DECIMAL)),
    DOUBLE(7, Double.class, DataTypeEnum.cqlName(DataTypes.DOUBLE)),
    DURATION(21, CqlDuration.class, DataTypeEnum.cqlName(DataTypes.DURATION)),
    FLOAT(8, Float.class, DataTypeEnum.cqlName(DataTypes.FLOAT)),
    INET(16, InetAddress.class, DataTypeEnum.cqlName(DataTypes.INET)),
    INT(9, Integer.class, DataTypeEnum.cqlName(DataTypes.INT)),
    LIST(32, List.class, "list"),
    MAP(33, Map.class, "map"),
    SET(34, Set.class, "set"),
    SMALLINT(19, Short.class, DataTypeEnum.cqlName(DataTypes.SMALLINT)),
    TEXT(13, String.class, DataTypeEnum.cqlName(DataTypes.TEXT)),
    TIME(18, Time.class, DataTypeEnum.cqlName(DataTypes.TIME)),
    TIMESTAMP(11, Timestamp.class, DataTypeEnum.cqlName(DataTypes.TIMESTAMP)),
    TIMEUUID(15, UUID.class, DataTypeEnum.cqlName(DataTypes.TIMEUUID)),
    TINYINT(20, Byte.class, DataTypeEnum.cqlName(DataTypes.TINYINT)),
    TUPLE(49, TupleValue.class, "tuple"),
    UDT(48, UdtValue.class, "UDT"),
    UUID(12, UUID.class, DataTypeEnum.cqlName(DataTypes.UUID)),
    VARCHAR(13, String.class, "VARCHAR"),
    VARINT(14, BigInteger.class, DataTypeEnum.cqlName(DataTypes.VARINT)),
    VECTOR(32, CqlVector.class, "Vector", "5.0", null);

    static final String VECTOR_CLASSNAME = "org.apache.cassandra.db.marshal.VectorType";
    private static final Map<String, DataTypeEnum> CQL_DATATYPE_TO_DATATYPE;
    public final Class<?> javaType;
    public final String cqlType;
    final int protocolId;
    final Semver validFrom;
    final Semver invalidFrom;

    private DataTypeEnum(int protocolId, Class<?> javaType, String cqlType, String validFrom, String invalidFrom) {
        this.protocolId = protocolId;
        this.javaType = javaType;
        this.cqlType = cqlType;
        this.validFrom = Semver.coerce((String)validFrom);
        this.invalidFrom = Semver.coerce((String)invalidFrom);
    }

    private DataTypeEnum(int protocolId, Class<?> javaType, String cqlType, String validFrom) {
        this(protocolId, javaType, cqlType, validFrom, null);
    }

    private DataTypeEnum(int protocolId, Class<?> javaType, String cqlType) {
        this(protocolId, javaType, cqlType, null);
    }

    public static DataTypeEnum fromCqlTypeName(String cqlTypeName) {
        if (cqlTypeName.startsWith(DataTypeEnum.UDT.cqlType)) {
            return UDT;
        }
        if (cqlTypeName.contains(VECTOR_CLASSNAME)) {
            return VECTOR;
        }
        int collectionTypeCharPos = cqlTypeName.indexOf("<");
        String cqlDataType = cqlTypeName;
        if (collectionTypeCharPos > 0) {
            cqlDataType = cqlTypeName.substring(0, collectionTypeCharPos);
        }
        return CQL_DATATYPE_TO_DATATYPE.get(cqlDataType);
    }

    public static DataTypeEnum fromDataType(DataType dataType) {
        if (dataType instanceof UserDefinedType) {
            return UDT;
        }
        if (dataType instanceof VectorType) {
            return VECTOR;
        }
        return DataTypeEnum.fromCqlTypeName(dataType.asCql(false, false));
    }

    public boolean isCollection() {
        switch (this) {
            case LIST: 
            case SET: 
            case MAP: 
            case VECTOR: {
                return true;
            }
        }
        return false;
    }

    public Class<?> asJavaClass() {
        return this.javaType;
    }

    public String asLowercaseCql() {
        return this.cqlType.toLowerCase();
    }

    public String toString() {
        return super.toString().toLowerCase();
    }

    @Override
    public String getName() {
        return this.cqlType;
    }

    @Override
    public Semver isValidFrom() {
        return this.validFrom;
    }

    @Override
    public Semver isInvalidFrom() {
        return this.invalidFrom;
    }

    public static String cqlName(@Nonnull DataType dataType) {
        String rawCql = dataType.asCql(false, false);
        if (rawCql.contains(VECTOR_CLASSNAME)) {
            return DataTypeEnum.VECTOR.cqlType;
        }
        return rawCql;
    }

    static {
        CQL_DATATYPE_TO_DATATYPE = new HashMap<String, DataTypeEnum>();
        for (DataTypeEnum dataType : DataTypeEnum.values()) {
            CQL_DATATYPE_TO_DATATYPE.put(dataType.cqlType, dataType);
        }
    }
}

