/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.types;

import com.ing.data.cassandra.jdbc.types.AbstractJdbcUUID;
import com.ing.data.cassandra.jdbc.types.MarshalException;
import java.nio.ByteBuffer;
import java.util.UUID;
import javax.annotation.Nonnull;

public class JdbcUUID
extends AbstractJdbcUUID {
    public static final JdbcUUID INSTANCE = new JdbcUUID();

    JdbcUUID() {
    }

    public UUID compose(ByteBuffer bytes) {
        if (bytes == null) {
            return null;
        }
        ByteBuffer slicedBytes = bytes.slice();
        if (slicedBytes.remaining() < 16) {
            return new UUID(0L, 0L);
        }
        return new UUID(slicedBytes.getLong(), slicedBytes.getLong());
    }

    @Override
    public UUID compose(@Nonnull Object obj) {
        return UUID.fromString(obj.toString());
    }

    public String getString(ByteBuffer bytes) {
        if (bytes == null || !bytes.hasRemaining()) {
            return null;
        }
        if (bytes.remaining() != 16) {
            throw new MarshalException("UUIDs must be exactly 16 bytes, but found: " + bytes.remaining());
        }
        return this.compose(bytes).toString();
    }

    @Override
    public Object decompose(UUID obj) {
        return obj;
    }
}

