/*
 * Decompiled with CFR 0.152.
 */
package com.ing.data.cassandra.jdbc.utils;

import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.internal.core.cql.DefaultColumnDefinition;
import com.datastax.oss.driver.internal.core.cql.DefaultColumnDefinitions;
import com.datastax.oss.driver.internal.core.cql.DefaultRow;
import com.ing.data.cassandra.jdbc.ColumnDefinitions;
import com.ing.data.cassandra.jdbc.SpecialCommands;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpecialCommandsUtil {
    static final Logger LOG = LoggerFactory.getLogger(SpecialCommandsUtil.class);
    static final String CMD_CONSISTENCY_PATTERN = "CONSISTENCY( \\w+)?";

    private SpecialCommandsUtil() {
    }

    public static boolean containsSpecialCommands(String cql) {
        Pattern pattern = Pattern.compile(CMD_CONSISTENCY_PATTERN, 10);
        return pattern.matcher(cql).find();
    }

    public static SpecialCommands.SpecialCommandExecutor getCommandExecutor(String cql) {
        Matcher matcher = Pattern.compile(CMD_CONSISTENCY_PATTERN, 10).matcher(cql.trim());
        if (!matcher.matches()) {
            LOG.trace("CQL statement is not a supported special command: {}", (Object)cql);
            return null;
        }
        String levelParameter = null;
        if (matcher.group(1) != null) {
            levelParameter = matcher.group(1).trim();
        }
        return new SpecialCommands.ConsistencyLevelExecutor(levelParameter);
    }

    public static ResultSet buildEmptyResultSet() {
        return SpecialCommandsUtil.buildSpecialCommandResultSet(new ColumnDefinitions.Definition[0], Collections.emptyList());
    }

    public static ResultSet buildSpecialCommandResultSet(ColumnDefinitions.Definition[] colDefinitions, List<List<ByteBuffer>> rows) {
        ArrayList<DefaultColumnDefinition> columnDefinitions = new ArrayList<DefaultColumnDefinition>();
        for (int i = 0; i < colDefinitions.length; ++i) {
            columnDefinitions.add(new DefaultColumnDefinition(colDefinitions[i].toColumnSpec(i), AttachmentPoint.NONE));
        }
        final ColumnDefinitions rsColumns = DefaultColumnDefinitions.valueOf(columnDefinitions);
        final List rsRows = rows.stream().map(rowData -> new DefaultRow(rsColumns, rowData)).collect(Collectors.toList());
        return new ResultSet(){

            public boolean wasApplied() {
                return true;
            }

            @Nonnull
            public ColumnDefinitions getColumnDefinitions() {
                return rsColumns;
            }

            @Nonnull
            public List<ExecutionInfo> getExecutionInfos() {
                return new ArrayList<ExecutionInfo>();
            }

            public boolean isFullyFetched() {
                return true;
            }

            public int getAvailableWithoutFetching() {
                return 0;
            }

            @Nonnull
            public Iterator<Row> iterator() {
                return rsRows.iterator();
            }
        };
    }
}

