/*
 * Decompiled with CFR 0.152.
 */
package com.karuslabs.elementary.junit;

import com.karuslabs.elementary.junit.annotations.Label;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;

public class Labels
implements Iterable<Map.Entry<String, Element>> {
    private final RoundEnvironment environment;
    private Map<String, Element> all;
    private Map<String, Map<String, Element>> groups;

    public Labels(RoundEnvironment environment) {
        this.environment = environment;
    }

    public Element get(String label) {
        Element element = this.all().get(label);
        if (element == null) {
            throw new NoSuchElementException("An element annotated with @Label(\"" + label + "\") does not exist. Did you spell the label correctly?");
        }
        return element;
    }

    public Element single() {
        Collection<Element> elements = this.all().values();
        if (elements.size() == 1) {
            return ((Element[])elements.toArray(Element[]::new))[0];
        }
        throw new IllegalStateException("Labels.single() can only be called if 1 element is annotated with @Label. However, there are " + elements.size() + " elements annotated with @Label.");
    }

    public Map<String, Element> group(String group) {
        Map<String, Element> elements = this.groups().get(group);
        if (elements == null) {
            throw new NoSuchElementException("The group, \"" + group + "\" does not exist. Did you spell the group correctly?");
        }
        return elements;
    }

    public Map<String, Element> all() {
        this.initialize();
        return this.all;
    }

    public Map<String, Map<String, Element>> groups() {
        this.initialize();
        return this.groups;
    }

    void initialize() {
        if (this.all == null || this.groups == null) {
            this.all = new HashMap<String, Element>();
            this.groups = new HashMap<String, Map<String, Element>>();
            for (Element element : this.environment.getElementsAnnotatedWith(Label.class)) {
                Label annotation = element.getAnnotation(Label.class);
                if (this.all.put(annotation.value(), element) != null) {
                    throw new IllegalStateException("An element annotated with @Label(\"" + annotation.value() + "\") already exists. Labels must be unique in a single annotation processing round.");
                }
                Map group = this.groups.computeIfAbsent(annotation.group(), k -> new HashMap());
                group.put(annotation.value(), element);
            }
        }
    }

    @Override
    public Iterator<Map.Entry<String, Element>> iterator() {
        return this.all().entrySet().iterator();
    }

    public int size() {
        return this.all().size();
    }
}

