/*
 * Decompiled with CFR 0.152.
 */
package com.karuslabs.utilitary;

import java.util.Collection;

public class Source
implements CharSequence {
    private final StringBuilder builder = new StringBuilder();
    private String indentation = "";

    public static String arguments(Object ... arguments) {
        StringBuilder builder = new StringBuilder().append('(');
        for (int i = 0; i < arguments.length; ++i) {
            builder.append(arguments[i]);
            if (i >= arguments.length - 1) continue;
            builder.append(", ");
        }
        return builder.append(')').toString();
    }

    public static String arguments(Collection<?> arguments) {
        StringBuilder builder = new StringBuilder().append('(');
        int i = 0;
        for (Object parameter : arguments) {
            builder.append(parameter);
            if (i < arguments.size() - 1) {
                builder.append(", ");
            }
            ++i;
        }
        return builder.append(')').toString();
    }

    public Source assign(String name, String value) {
        return this.assign("var", name, value);
    }

    public Source assign(String type, String name, String value) {
        this.builder.append(this.indentation).append(type).append(" ").append(name).append(" = ").append(value).append(";").append('\n');
        return this;
    }

    public Source cast(String name, String type, String value) {
        this.builder.append(this.indentation).append("var ").append(name).append(" = (").append(type).append(") ").append(value).append(";").append('\n');
        return this;
    }

    public Source pack(String pack) {
        this.builder.append("package ").append(pack).append(";").append('\n');
        return this;
    }

    public Source include(String pack) {
        this.builder.append("import ").append(pack).append(";").append('\n');
        return this;
    }

    public Source line() {
        this.builder.append('\n');
        return this;
    }

    public Source line(Object value) {
        this.builder.append(this.indentation).append(value).append('\n');
        return this;
    }

    public Source line(Object ... values) {
        this.builder.append(this.indentation);
        for (Object value : values) {
            this.builder.append(value);
        }
        this.builder.append('\n');
        return this;
    }

    public Source append(Object value) {
        this.builder.append(value);
        return this;
    }

    public Source indent() {
        this.indentation = this.indentation + "    ";
        return this;
    }

    public Source unindent() {
        this.indentation = this.indentation.length() <= 4 ? "" : this.indentation.substring(0, this.indentation.length() - 4);
        return this;
    }

    public Source indentation(int indentation) {
        this.indentation = " ".repeat(indentation);
        return this;
    }

    @Override
    public char charAt(int index) {
        return this.builder.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.builder.subSequence(start, end);
    }

    @Override
    public int length() {
        return this.builder.length();
    }

    @Override
    public String toString() {
        return this.builder.toString();
    }
}

