/*
 * Decompiled with CFR 0.152.
 */
package com.karuslabs.utilitary.snippet;

import com.karuslabs.utilitary.snippet.Line;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class Snippet
implements CharSequence {
    public final TreeMap<Integer, Line> lines;
    public final int first;
    public final int last;
    private final String value;

    public Snippet(TreeMap<Integer, Line> lines) {
        this.lines = lines;
        this.first = lines.firstKey();
        this.last = lines.lastKey();
        this.value = lines.values().stream().collect(Collectors.joining("\n"));
    }

    @Override
    public int length() {
        return this.value.length();
    }

    @Override
    public char charAt(int index) {
        return this.value.charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.value.subSequence(start, end);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Snippet)) {
            return false;
        }
        Snippet snippet = (Snippet)other;
        return this.lines.equals(snippet.lines);
    }

    public int hashCode() {
        return Objects.hash(this.lines);
    }

    @Override
    public String toString() {
        return this.value;
    }
}

