/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.client;

import com.kubling.teiid.client.RequestMessage;
import com.kubling.teiid.core.TeiidProcessingException;
import com.kubling.teiid.core.util.UnitTestUtil;
import com.kubling.teiid.netty.handler.codec.serialization.CompactObjectInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRequestMessage {
    public static RequestMessage example() {
        RequestMessage message = new RequestMessage();
        message.setStatementType(RequestMessage.StatementType.CALLABLE);
        message.setFetchSize(100);
        ArrayList<Integer> params = new ArrayList<Integer>();
        params.add(100);
        params.add(200);
        params.add(300);
        params.add(400);
        message.setParameterValues(params);
        message.setPartialResults(true);
        message.setStyleSheet("myStyleSheet");
        message.setExecutionPayload((Serializable)((Object)"myExecutionPayload"));
        try {
            message.setTxnAutoWrapMode("ON");
        }
        catch (TeiidProcessingException e) {
            throw new RuntimeException(e);
        }
        message.setShowPlan(RequestMessage.ShowPlan.ON);
        message.setRowLimit(1313);
        message.setReturnAutoGeneratedKeys(true);
        message.setDelaySerialization(true);
        message.setSpanContext("foo");
        return message;
    }

    @Test
    public void testSerialize() throws Exception {
        RequestMessage copy = (RequestMessage)UnitTestUtil.helpSerialize((Serializable)TestRequestMessage.example());
        Assertions.assertTrue((boolean)copy.isCallableStatement());
        Assertions.assertEquals((int)100, (int)copy.getFetchSize());
        Assertions.assertNotNull((Object)copy.getParameterValues());
        Assertions.assertEquals((int)4, (int)copy.getParameterValues().size());
        Assertions.assertEquals((Object)100, copy.getParameterValues().get(0));
        Assertions.assertEquals((Object)200, copy.getParameterValues().get(1));
        Assertions.assertEquals((Object)300, copy.getParameterValues().get(2));
        Assertions.assertEquals((Object)400, copy.getParameterValues().get(3));
        Assertions.assertFalse((boolean)copy.isPreparedStatement());
        Assertions.assertEquals((Object)"myStyleSheet", (Object)copy.getStyleSheet());
        Assertions.assertEquals((Object)"myExecutionPayload", (Object)copy.getExecutionPayload());
        Assertions.assertEquals((Object)"ON", (Object)copy.getTxnAutoWrapMode());
        Assertions.assertEquals((Object)RequestMessage.ShowPlan.ON, (Object)copy.getShowPlan());
        Assertions.assertEquals((int)1313, (int)copy.getRowLimit());
        Assertions.assertTrue((boolean)copy.isReturnAutoGeneratedKeys());
        Assertions.assertTrue((boolean)copy.isDelaySerialization());
        Assertions.assertEquals((Object)"foo", (Object)copy.getSpanContext());
    }

    @Test
    public void testInvalidTxnAutoWrap() {
        RequestMessage rm = new RequestMessage();
        try {
            rm.setTxnAutoWrapMode("foo");
            Assertions.fail((String)"exception expected");
        }
        catch (TeiidProcessingException e) {
            Assertions.assertEquals((Object)"TEIID20000 'FOO' is an invalid transaction autowrap mode.", (Object)e.getMessage());
        }
    }

    @Test
    public void test83() throws FileNotFoundException, IOException, ClassNotFoundException {
        CompactObjectInputStream ois = new CompactObjectInputStream((InputStream)new FileInputStream(UnitTestUtil.getTestDataFile((String)"req.ser")), RequestMessage.class.getClassLoader());
        RequestMessage rm = (RequestMessage)ois.readObject();
        ois.close();
        Assertions.assertFalse((boolean)rm.isReturnAutoGeneratedKeys());
        Assertions.assertFalse((boolean)rm.isDelaySerialization());
    }
}

