/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.client.plan;

import com.kubling.teiid.client.plan.PlanNode;
import java.util.ArrayList;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPlanNode {
    public static PlanNode example1() {
        PlanNode map = new PlanNode("x");
        map.addProperty("test", "");
        map.addProperty("null", (String)null);
        map.addProperty("string", "string");
        ArrayList<String> list1 = new ArrayList<String>();
        list1.add("item1");
        list1.add("item2");
        list1.add("item3");
        map.addProperty("list<string>", list1);
        PlanNode child = new PlanNode("y");
        ArrayList<String> outputCols = new ArrayList<String>();
        outputCols.add("Name (string)");
        outputCols.add("Year (integer)");
        child.addProperty("outputCols", outputCols);
        child.addProperty("Join Type", "INNER JOIN");
        ArrayList<String> crits = new ArrayList<String>();
        crits.add("Item.ID = History.ID");
        child.addProperty("Criteria", crits);
        child.addProperty("Other", new ArrayList());
        map.addProperty("child", child);
        return map;
    }

    @Test
    public void testXml() throws Exception {
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><node name=\"x\"><property name=\"test\"><value></value></property><property name=\"null\"></property><property name=\"string\"><value>string</value></property><property name=\"list&lt;string&gt;\"><value>item1</value><value>item2</value><value>item3</value></property><property name=\"child\"><node name=\"y\"><property name=\"outputCols\"><value>Name (string)</value><value>Year (integer)</value></property><property name=\"Join Type\"><value>INNER JOIN</value></property><property name=\"Criteria\"><value>Item.ID = History.ID</value></property><property name=\"Other\"></property></node></property></node>", (Object)TestPlanNode.example1().toXml());
    }

    @Test
    public void testXmlRoundtrip() throws Exception {
        PlanNode example1 = TestPlanNode.example1();
        example1.addProperty("last", "x");
        String planString = example1.toXml();
        PlanNode planNode = PlanNode.fromXml((String)planString);
        Assertions.assertEquals((Object)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><node name=\"x\"><property name=\"test\"><value></value></property><property name=\"null\"></property><property name=\"string\"><value>string</value></property><property name=\"list&lt;string&gt;\"><value>item1</value><value>item2</value><value>item3</value></property><property name=\"child\"><node name=\"y\"><property name=\"outputCols\"><value>Name (string)</value><value>Year (integer)</value></property><property name=\"Join Type\"><value>INNER JOIN</value></property><property name=\"Criteria\"><value>Item.ID = History.ID</value></property><property name=\"Other\"></property></node></property><property name=\"last\"><value>x</value></property></node>", (Object)planNode.toXml());
    }

    @Test
    public void testText() throws Exception {
        Assertions.assertEquals((Object)"x\n  + test:\n  + null\n  + string:string\n  + list<string>:\n    0: item1\n    1: item2\n    2: item3\n  + child:\n    y\n      + outputCols:\n        0: Name (string)\n        1: Year (integer)\n      + Join Type:INNER JOIN\n      + Criteria:Item.ID = History.ID\n      + Other\n", (Object)TestPlanNode.example1().toString());
    }

    @Test
    public void testYaml() throws Exception {
        Assertions.assertEquals((Object)"x:\n  test: \n  null: ~\n  string: string\n  list<string>:\n    - item1\n    - item2\n    - item3\n  child:\n    y:\n      outputCols:\n        - Name (string)\n        - Year (integer)\n      Join Type: INNER JOIN\n      Criteria: Item.ID = History.ID\n      Other: ~\n", (Object)TestPlanNode.example1().toYaml());
    }
}

