/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.client.util;

import com.kubling.teiid.client.util.ExceptionUtil;
import com.kubling.teiid.core.BundleUtil;
import com.kubling.teiid.core.TeiidException;
import com.kubling.teiid.jdbc.JDBCPlugin;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestExceptionUtil {
    @Test
    public void testSanitize() {
        TeiidException te = new TeiidException((BundleUtil.Event)JDBCPlugin.Event.TEIID20000, "you don't want to see this");
        te.initCause((Throwable)new Exception("or this"));
        Throwable t = ExceptionUtil.sanitize((Throwable)te, (boolean)true);
        Assertions.assertTrue((t.getStackTrace().length != 0 ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)t.getCause());
        Assertions.assertEquals((Object)"TEIID20000", (Object)t.getMessage());
        Assertions.assertEquals((Object)"java.lang.Exception", (Object)t.getCause().getMessage());
        t = ExceptionUtil.sanitize((Throwable)te, (boolean)false);
        Assertions.assertEquals((int)0, (int)t.getStackTrace().length);
        Assertions.assertEquals((Object)"TEIID20000", (Object)t.getMessage());
    }
}

