/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.jdbc;

import com.kubling.teiid.client.DQP;
import com.kubling.teiid.client.RequestMessage;
import com.kubling.teiid.client.ResultsMessage;
import com.kubling.teiid.client.util.ResultsFuture;
import com.kubling.teiid.core.TeiidProcessingException;
import com.kubling.teiid.core.util.TimestampWithTimezone;
import com.kubling.teiid.jdbc.ConnectionImpl;
import com.kubling.teiid.jdbc.DeferredMetadataProvider;
import com.kubling.teiid.jdbc.MetadataProvider;
import com.kubling.teiid.jdbc.ResultSetImpl;
import com.kubling.teiid.jdbc.ResultSetMetaDataImpl;
import com.kubling.teiid.jdbc.StatementImpl;
import com.kubling.teiid.jdbc.TeiidSQLException;
import com.kubling.teiid.jdbc.TestResultSet;
import com.kubling.teiid.query.unittest.TimestampUtil;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import net.jcip.annotations.NotThreadSafe;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@NotThreadSafe
public class TestAllResultsImpl {
    static final long REQUEST_ID = 0L;
    private static final int TYPE_FORWARD_ONLY = 1003;
    private static final int TYPE_SCROLL_SENSITIVE = 1005;
    private StatementImpl statement;

    @BeforeEach
    public void setUp() throws Exception {
        this.statement = TestResultSet.createMockStatement(1005);
    }

    @Test
    public void testHasNext1() throws Exception {
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg1(), this.statement);
        while (rs.next()) {
        }
        boolean actual = rs.hasNext();
        boolean expected = false;
        Assertions.assertEquals((Object)expected, (Object)actual);
        rs.close();
    }

    @Test
    public void testHasNext2() throws Exception {
        List<Object>[] results = TestAllResultsImpl.exampleResults1(5);
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg1(), this.statement);
        for (int i = 1; i < results.length; ++i) {
            rs.next();
        }
        boolean actual = rs.hasNext();
        boolean expected = true;
        Assertions.assertEquals((Object)expected, (Object)actual);
        rs.close();
    }

    @Test
    public void testNext1() throws Exception {
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg1(), this.statement);
        boolean actual = rs.next();
        boolean expected = true;
        Assertions.assertEquals((Object)expected, (Object)actual, (String)" Actual doesn't match with expected. ");
        rs.close();
    }

    @Test
    public void testNext2() throws Exception {
        List<Object>[] results = TestAllResultsImpl.exampleResults1(5);
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg1(), this.statement);
        int i = 0;
        while (rs.next()) {
            List actual = rs.getCurrentRecord();
            List<Object> expected = results[i];
            Assertions.assertEquals(expected, (Object)actual);
            ++i;
        }
        rs.close();
    }

    @Test
    public void testNext3() throws Exception {
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg1(), this.statement);
        Assertions.assertEquals((Integer)0, (Integer)rs.getRow());
        rs.close();
    }

    @Test
    public void testNext4() throws Exception {
        List<Object>[] results = TestAllResultsImpl.exampleResults1(5);
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg1(), this.statement);
        for (int i = 0; i < results.length - 1; ++i) {
            rs.next();
            List actual = rs.getCurrentRecord();
            List<Object> expected = results[i];
            Assertions.assertEquals(expected, (Object)actual);
        }
        rs.close();
    }

    @Test
    public void testNext5() throws Exception {
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg1(), this.statement);
        while (rs.next()) {
        }
        boolean actual = rs.hasNext();
        boolean expected = false;
        Assertions.assertEquals((Object)expected, (Object)actual);
        rs.close();
    }

    @Test
    public void testGetObject1() throws Exception {
        List[] results = this.exampleResults2();
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg2a(), this.statement);
        String actual = null;
        String expected = "a3";
        for (int i = 0; i < results.length - 2; ++i) {
            rs.next();
        }
        if (rs.next()) {
            actual = (String)rs.getObject(2);
        }
        Assertions.assertEquals((Object)expected, actual);
        rs.close();
    }

    @Test
    public void testGetObject2() throws Exception {
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg2a(), this.statement);
        if (rs.next()) {
            try {
                rs.getObject(6);
            }
            catch (Exception e) {
                if (e instanceof IllegalArgumentException) {
                    // empty if block
                }
            }
        }
        rs.close();
    }

    @Test
    public void testGetRow() throws Exception {
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg2(), this.statement);
        int expected = 0;
        Assertions.assertEquals((int)expected, (int)rs.getRow());
        if (rs.next()) {
            expected = 1;
            Assertions.assertEquals((int)expected, (int)rs.getRow());
        }
        rs.close();
    }

    @Test
    public void testPrevious() throws Exception {
        List<Object>[] results = TestAllResultsImpl.exampleResults1(5);
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg1(), this.statement);
        while (rs.next()) {
        }
        int i = results.length - 1;
        while (rs.previous()) {
            ArrayList<Integer> expected = new ArrayList<Integer>(1);
            expected.add(i + 1);
            Assertions.assertEquals(expected, (Object)rs.getCurrentRecord());
            --i;
        }
        rs.close();
    }

    @Test
    public void testGetCurrentRecord() throws Exception {
        List[] results = this.exampleResults2();
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg2(), this.statement);
        rs.next();
        List actual = rs.getCurrentRecord();
        Assertions.assertEquals((Object)results[0], (Object)actual);
        rs.close();
    }

    @Test
    public void testGetMetaData() throws Exception {
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg2a(), this.statement);
        ResultSetMetaData rmetadata = rs.getMetaData();
        Assertions.assertEquals((int)2, (int)rmetadata.getColumnCount());
        String[] columnNames = this.columnNames();
        String[] dataTypes = this.dataTypes();
        for (int i = 0; i < 2; ++i) {
            Assertions.assertEquals((Object)columnNames[i], (Object)rmetadata.getColumnLabel(i + 1));
            Assertions.assertEquals((Object)dataTypes[i], (Object)rmetadata.getColumnTypeName(i + 1));
        }
        rs.close();
    }

    @Test
    public void testResultsWarnings() throws Exception {
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg2(), this.statement);
        rs.close();
    }

    @Test
    public void testClose() throws Exception {
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg2(), this.statement);
        rs.close();
        ((StatementImpl)Mockito.verify((Object)this.statement, (VerificationMode)Mockito.times((int)0))).close();
    }

    @Test
    public void testGetFetchSize() throws Exception {
        StatementImpl s = (StatementImpl)Mockito.mock(StatementImpl.class);
        Mockito.when((Object)s.getFetchSize()).thenReturn((Object)500);
        ConnectionImpl c = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Mockito.when((Object)s.getConnection()).thenReturn((Object)c);
        Properties p = new Properties();
        Mockito.when((Object)c.getConnectionProps()).thenReturn((Object)p);
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg2(), s);
        Assertions.assertEquals((int)500, (int)rs.getFetchSize());
        rs.setFetchSize(100);
        Assertions.assertEquals((int)100, (int)rs.getFetchSize());
        p.setProperty("disableResultSetFetchSize", Boolean.TRUE.toString());
        rs = new ResultSetImpl(this.exampleResultsMsg2(), s);
        Assertions.assertEquals((int)500, (int)rs.getFetchSize());
        rs.setFetchSize(100);
        Assertions.assertEquals((int)500, (int)rs.getFetchSize());
    }

    @Test
    public void testIsAfterLast1() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1003);
        Assertions.assertThrows(SQLException.class, () -> rs.last());
    }

    @Test
    public void testAfterLast1() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1003);
        Assertions.assertThrows(SQLException.class, () -> rs.afterLast());
    }

    @Test
    public void testIsBeforeFirst1() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1003);
        boolean actual = rs.isBeforeFirst();
        Assertions.assertEquals((Object)true, (Object)actual);
        rs.close();
    }

    @Test
    public void testIsBeforeFirst2() throws Exception {
        ResultSetImpl rs = this.helpGetNoResults(1003);
        boolean actual = rs.isBeforeFirst();
        Assertions.assertEquals((Object)false, (Object)actual);
        rs.close();
    }

    @Test
    public void testBeforeFirst1() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1003);
        rs.next();
        Assertions.assertThrows(SQLException.class, () -> rs.beforeFirst());
    }

    @Test
    public void testIsFirst1() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1003);
        rs.next();
        boolean actual = rs.isFirst();
        Assertions.assertEquals((Object)true, (Object)actual);
        rs.close();
    }

    @Test
    public void testIsFirst2() throws Exception {
        ResultSetImpl rs = this.helpGetNoResults(1003);
        rs.next();
        boolean actual = rs.isFirst();
        Assertions.assertEquals((Object)false, (Object)actual);
        rs.close();
    }

    @Test
    public void testFirst1() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1003);
        rs.next();
        Assertions.assertThrows(SQLException.class, () -> rs.first());
    }

    @Test
    public void testFirst2() throws Exception {
        ResultSetImpl rs = this.helpGetNoResults(1003);
        rs.next();
        Assertions.assertThrows(SQLException.class, () -> rs.first());
    }

    @Test
    public void testFindColumn() throws Exception {
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg2a(), this.statement);
        Assertions.assertEquals((int)1, (int)rs.findColumn("IntNum"));
        rs.close();
    }

    @Test
    public void testIsLast1() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1003);
        boolean actual = rs.isLast();
        Assertions.assertEquals((Object)false, (Object)actual);
    }

    @Test
    public void testIsLast2() throws Exception {
        ResultSetImpl rs = this.helpGetNoResults(1003);
        boolean actual = rs.isLast();
        Assertions.assertEquals((Object)false, (Object)actual);
    }

    @Test
    public void testLast1() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1003);
        Assertions.assertThrows(SQLException.class, () -> rs.last());
    }

    @Test
    public void testRelative1() throws Exception {
        ResultSetImpl rs = new ResultSetImpl(this.exampleResultsMsg2(), this.statement);
        rs.next();
        boolean actual = rs.relative(1);
        Assertions.assertEquals((Object)true, (Object)actual);
        Assertions.assertEquals((int)2, (int)rs.getRow());
        actual = rs.relative(-1);
        Assertions.assertEquals((Object)true, (Object)actual);
        Assertions.assertEquals((int)1, (int)rs.getRow());
        rs.close();
    }

    @Test
    public void testAbsolute1() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1003);
        Assertions.assertThrows(SQLException.class, () -> rs.absolute(1));
    }

    @Test
    public void testAfterLast1a() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1005);
        rs.afterLast();
        Assertions.assertEquals((int)0, (int)rs.getRow());
        rs.close();
    }

    @Test
    public void testIsAfterLast1a() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1005);
        rs.last();
        boolean actual = rs.isAfterLast();
        Assertions.assertEquals((Object)false, (Object)actual);
        rs.next();
        actual = rs.isAfterLast();
        Assertions.assertEquals((Object)true, (Object)actual);
        rs.close();
    }

    @Test
    public void testIsBeforeFirst1a() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1005);
        boolean actual = rs.isBeforeFirst();
        Assertions.assertEquals((Object)true, (Object)actual);
        rs.close();
    }

    @Test
    public void testBeforeFirst1a() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1005);
        rs.next();
        rs.next();
        rs.beforeFirst();
        Assertions.assertEquals((int)0, (int)rs.getRow());
        rs.close();
    }

    @Test
    public void testIsFirst1a() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1005);
        rs.next();
        boolean actual = rs.isFirst();
        Assertions.assertEquals((Object)true, (Object)actual);
        Assertions.assertEquals((int)1, (int)rs.getRow());
        rs.close();
    }

    @Test
    public void testFirst1a() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1005);
        boolean actual = rs.first();
        Assertions.assertEquals((Object)true, (Object)actual);
        Assertions.assertEquals((int)1, (int)rs.getRow());
        rs.afterLast();
        actual = rs.first();
        Assertions.assertEquals((Object)true, (Object)actual);
        Assertions.assertEquals((int)1, (int)rs.getRow());
        rs.absolute(3);
        actual = rs.first();
        Assertions.assertEquals((Object)true, (Object)actual);
        Assertions.assertEquals((int)1, (int)rs.getRow());
        rs.close();
    }

    @Test
    public void testIsLast1a() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1005);
        rs.last();
        boolean actual = rs.isLast();
        Assertions.assertEquals((Object)true, (Object)actual);
        Assertions.assertEquals((int)5, (int)rs.getRow());
        rs.close();
    }

    @Test
    public void testLast1a() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1005);
        boolean actual = rs.last();
        Assertions.assertEquals((Object)true, (Object)actual);
        Assertions.assertEquals((int)5, (int)rs.getRow());
        rs.close();
    }

    @Test
    public void testRelative1a() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1005);
        rs.next();
        boolean actual = rs.relative(1);
        Assertions.assertEquals((Object)true, (Object)actual);
        Assertions.assertEquals((int)2, (int)rs.getRow());
        actual = rs.relative(-1);
        Assertions.assertEquals((Object)true, (Object)actual);
        Assertions.assertEquals((int)1, (int)rs.getRow());
        rs.close();
    }

    @Test
    public void testRelative1b() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1005);
        rs.next();
        boolean actual = rs.relative(1);
        actual = rs.relative(-1);
        actual = rs.relative(-3);
        Assertions.assertEquals((Object)false, (Object)actual);
        Assertions.assertEquals((int)0, (int)rs.getRow());
        rs.beforeFirst();
        rs.next();
        actual = rs.relative(7);
        Assertions.assertEquals((Object)false, (Object)actual);
        Assertions.assertEquals((int)0, (int)rs.getRow());
        rs.close();
    }

    @Test
    public void testRelative1c() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1005);
        try {
            rs.relative(-2);
            Assertions.fail((String)"relative move from an invalid row should fail");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assertions.assertEquals((Object)true, (Object)rs.isBeforeFirst(), (String)" Should still be before the first row ");
        Assertions.assertEquals((int)0, (int)rs.getRow());
        try {
            rs.relative(2);
            Assertions.fail((String)"relative move from an invalid row should fail");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assertions.assertEquals((Object)true, (Object)rs.isBeforeFirst(), (String)" Should still be before the first row ");
        Assertions.assertEquals((int)0, (int)rs.getRow());
        rs.afterLast();
        try {
            rs.relative(2);
            Assertions.fail((String)"relative move from an invalid row should fail");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assertions.assertEquals((Object)true, (Object)rs.isAfterLast(), (String)" Should still be after the last row. ");
        Assertions.assertEquals((int)0, (int)rs.getRow());
        try {
            rs.relative(-2);
            Assertions.fail((String)"relative move from an invalid row should fail");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assertions.assertEquals((Object)true, (Object)rs.isAfterLast(), (String)" Should still be after the last row. ");
        Assertions.assertEquals((int)0, (int)rs.getRow());
        rs.close();
    }

    @Test
    public void testAbsolute1a() throws Exception {
        ResultSetImpl rs = this.helpGetResultSetImpl(1005);
        boolean actual = rs.absolute(1);
        Assertions.assertEquals((Object)true, (Object)actual);
        Assertions.assertEquals((int)1, (int)rs.getRow());
        actual = rs.absolute(12);
        Assertions.assertEquals((Object)false, (Object)actual);
        Assertions.assertEquals((int)0, (int)rs.getRow());
        rs.afterLast();
        actual = rs.absolute(-1);
        Assertions.assertEquals((Object)true, (Object)actual);
        Assertions.assertEquals((int)5, (int)rs.getRow());
        actual = rs.absolute(-2);
        Assertions.assertEquals((Object)true, (Object)actual);
        Assertions.assertEquals((int)4, (int)rs.getRow());
        rs.close();
    }

    @Test
    public void testAbsolute2a() throws Exception {
        ResultSetImpl rs = this.helpGetNoResults(1005);
        Assertions.assertEquals((Object)false, (Object)rs.absolute(1));
        Assertions.assertEquals((int)0, (int)rs.getRow());
        rs.afterLast();
        Assertions.assertEquals((Object)false, (Object)rs.absolute(-1));
        Assertions.assertEquals((int)0, (int)rs.getRow());
        rs.close();
    }

    @Test
    public void testMoreResults() throws Exception {
        int fetchSize = 5;
        int batchLength = 4;
        int totalLength = 10;
        ResultSetImpl rs = TestAllResultsImpl.helpTestBatching(this.statement, fetchSize, batchLength, totalLength);
        Assertions.assertTrue((boolean)rs.absolute(6));
        Assertions.assertTrue((boolean)rs.absolute(-1));
        Assertions.assertFalse((boolean)rs.next());
        for (int i = 0; i < totalLength; ++i) {
            Assertions.assertTrue((boolean)rs.previous());
        }
    }

    @Test
    public void testResultsMessageException() throws Exception {
        ResultsMessage resultsMsg = this.exampleMessage(TestAllResultsImpl.exampleResults1(1), new String[]{"IntNum"}, new String[]{"integer"});
        resultsMsg.setFinalRow(-1);
        ResultsMessage next = new ResultsMessage();
        next.setException(new Throwable());
        ResultsFuture rf = new ResultsFuture();
        rf.getResultsReceiver().receiveResults((Object)next);
        Mockito.when((Object)this.statement.getDQP().processCursorRequest(0L, 2, 0)).thenReturn((Object)rf);
        ResultSetImpl cs = new ResultSetImpl(resultsMsg, this.statement, null, 2);
        Assertions.assertThrows(TeiidSQLException.class, () -> cs.next());
        Assertions.assertThrows(TeiidSQLException.class, () -> cs.next());
    }

    static ResultSetImpl helpTestBatching(StatementImpl statement, int fetchSize, int batchLength, int totalLength) throws TeiidProcessingException, SQLException {
        return TestAllResultsImpl.helpTestBatching(statement, fetchSize, batchLength, totalLength, false);
    }

    static ResultSetImpl helpTestBatching(StatementImpl statement, int fetchSize, int batchLength, int totalLength, boolean partial) throws TeiidProcessingException, SQLException {
        DQP dqp = statement.getDQP();
        if (dqp == null) {
            dqp = (DQP)Mockito.mock(DQP.class);
            Mockito.when((Object)statement.getDQP()).thenReturn((Object)dqp);
        }
        Mockito.when((Object)statement.getFetchSize()).thenReturn((Object)fetchSize);
        Mockito.when((Object)dqp.processCursorRequest(ArgumentMatchers.eq((long)0L), ArgumentMatchers.anyInt(), ArgumentMatchers.eq((int)fetchSize))).thenAnswer(invocation -> {
            ResultsFuture nextBatch = new ResultsFuture();
            int begin = Math.min(totalLength, (Integer)invocation.getArguments()[1]);
            if (partial && begin == fetchSize + 1) {
                begin -= 5;
            }
            int length = Math.min(fetchSize, Math.min(totalLength - begin + 1, batchLength));
            nextBatch.getResultsReceiver().receiveResults((Object)TestAllResultsImpl.exampleResultsMsg4(begin, length, begin + length - 1 >= totalLength));
            return nextBatch;
        });
        int initial = Math.min(fetchSize, batchLength);
        ResultsMessage msg = TestAllResultsImpl.exampleResultsMsg4(1, initial, initial == totalLength);
        return new ResultSetImpl(msg, statement, (ResultSetMetaData)new ResultSetMetaDataImpl(new MetadataProvider(DeferredMetadataProvider.loadPartialMetadata((String[])msg.getColumnNames(), (String[])msg.getDataTypes())), null), 0);
    }

    static List<Object>[] exampleResults1(int length) {
        return TestAllResultsImpl.exampleResults1(length, 1);
    }

    static List<Object>[] exampleResults1(int length, int begin) {
        List[] results = new List[length];
        for (int i = 0; i < results.length; ++i) {
            results[i] = new ArrayList(1);
            results[i].add(begin + i);
        }
        return results;
    }

    private List[] exampleResults2() {
        List[] results = new List[5];
        for (int i = 0; i < results.length; ++i) {
            results[i] = new ArrayList(2);
            results[i].add(i);
            results[i].add(new String("a" + i));
        }
        return results;
    }

    private String[] columnNames() {
        String[] names = new String[]{new String("IntNum"), new String("StringNum")};
        return names;
    }

    private String[] dataTypes() {
        String[] types = new String[]{"integer", "string"};
        return types;
    }

    private ResultSetImpl helpGetResultSetImpl(int type) throws SQLException {
        ResultsMessage rsMsg = this.exampleResultsMsg2();
        this.statement = TestResultSet.createMockStatement(type);
        ResultSetImpl rs = new ResultSetImpl(rsMsg, this.statement);
        return rs;
    }

    private ResultSetImpl helpGetNoResults(int type) throws SQLException {
        ResultsMessage rsMsg = this.exampleResultsMsg3();
        this.statement = TestResultSet.createMockStatement(type);
        ResultSetImpl rs = new ResultSetImpl(rsMsg, this.statement);
        return rs;
    }

    private ResultsMessage exampleResultsMsg1() {
        return this.exampleMessage(TestAllResultsImpl.exampleResults1(5), new String[]{"IntNum"}, new String[]{"integer"});
    }

    private ResultsMessage exampleMessage(List<Object>[] results, String[] columnNames, String[] datatypes) {
        RequestMessage request = new RequestMessage();
        request.setExecutionId(0L);
        ResultsMessage resultsMsg = new ResultsMessage();
        resultsMsg.setResults((List[])results);
        resultsMsg.setColumnNames(columnNames);
        resultsMsg.setDataTypes(datatypes);
        resultsMsg.setFinalRow(results.length);
        resultsMsg.setLastRow(results.length);
        resultsMsg.setFirstRow(1);
        return resultsMsg;
    }

    private ResultsMessage exampleResultsMsg2() {
        return this.exampleMessage(this.exampleResults2(), new String[]{"IntNum", "StringNum"}, new String[]{"integer", "string"});
    }

    private ResultsMessage exampleResultsMsg2a() {
        ResultsMessage resultsMsg = this.exampleResultsMsg2();
        List[] results = this.exampleResults2();
        resultsMsg.setDataTypes(this.dataTypes());
        resultsMsg.setColumnNames(this.columnNames());
        resultsMsg.setResults(results);
        resultsMsg.setFinalRow(results.length);
        resultsMsg.setLastRow(results.length);
        resultsMsg.setFirstRow(1);
        return resultsMsg;
    }

    private ResultsMessage exampleResultsMsg3() {
        return this.exampleMessage(new List[0], new String[]{"IntNum", "StringNum"}, new String[]{"integer", "string"});
    }

    static ResultsMessage exampleResultsMsg4(int begin, int length, boolean lastBatch) {
        RequestMessage request = new RequestMessage();
        request.setExecutionId(0L);
        ResultsMessage resultsMsg = new ResultsMessage();
        List[] results = TestAllResultsImpl.exampleResults1(length, begin);
        resultsMsg.setResults(results);
        resultsMsg.setColumnNames(new String[]{"IntKey"});
        resultsMsg.setDataTypes(new String[]{"integer"});
        resultsMsg.setFirstRow(begin);
        if (lastBatch) {
            resultsMsg.setFinalRow(begin + results.length - 1);
        }
        resultsMsg.setLastRow(begin + results.length - 1);
        return resultsMsg;
    }

    @Test
    public void testNotCallingNext() throws SQLException {
        ResultSetImpl cs = new ResultSetImpl(this.exampleResultsMsg2a(), this.statement);
        try {
            cs.getObject(1);
            Assertions.fail((String)"Exception expected");
        }
        catch (SQLException e) {
            Assertions.assertEquals((Object)"The cursor is not on a valid row.", (Object)e.getMessage());
        }
    }

    @Test
    public void testDateType() throws SQLException {
        RequestMessage request = new RequestMessage();
        request.setExecutionId(0L);
        ResultsMessage resultsMsg = new ResultsMessage();
        resultsMsg.setResults(new List[]{Arrays.asList(new Timestamp(0L))});
        resultsMsg.setColumnNames(new String[]{"TS"});
        resultsMsg.setDataTypes(new String[]{"timestamp"});
        resultsMsg.setFirstRow(1);
        resultsMsg.setFinalRow(1);
        resultsMsg.setLastRow(1);
        ResultSetImpl rs = new ResultSetImpl(resultsMsg, this.statement);
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((Object)new Timestamp(3600000L), (Object)rs.getObject(1));
        Assertions.assertEquals((Object)new Timestamp(0L), (Object)rs.getTimestamp(1, Calendar.getInstance(TimeZone.getTimeZone("GMT-05:00"))));
    }

    @Test
    public void testWasNull() throws SQLException {
        ResultsMessage message = this.exampleMessage(new List[]{Arrays.asList(new String[]{null}), Arrays.asList("1")}, new String[]{"string"}, new String[]{"string"});
        ResultSetImpl rs = new ResultSetImpl(message, this.statement);
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((Object)Boolean.FALSE, (Object)rs.getBoolean(1));
        Assertions.assertTrue((boolean)rs.wasNull());
        Assertions.assertEquals((int)0, (int)rs.getShort(1));
        Assertions.assertTrue((boolean)rs.wasNull());
        Assertions.assertEquals((int)0, (int)rs.getInt(1));
        Assertions.assertTrue((boolean)rs.wasNull());
        Assertions.assertEquals((long)0L, (long)rs.getLong(1));
        Assertions.assertTrue((boolean)rs.wasNull());
        Assertions.assertEquals((float)0.0f, (float)rs.getFloat(1), (float)0.0f);
        Assertions.assertTrue((boolean)rs.wasNull());
        Assertions.assertEquals((double)0.0, (double)rs.getDouble(1), (double)0.0);
        Assertions.assertTrue((boolean)rs.wasNull());
        Assertions.assertNull((Object)rs.getString(1));
        Assertions.assertTrue((boolean)rs.wasNull());
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((int)1, (int)rs.getShort(1));
        Assertions.assertFalse((boolean)rs.wasNull());
        Assertions.assertFalse((boolean)rs.next());
    }

    @Test
    public void testGetters() throws SQLException {
        TimeZone.setDefault(TimeZone.getTimeZone("GMT-05:00"));
        ResultsMessage message = this.exampleMessage(new List[]{Arrays.asList(1, TimestampUtil.createTime((int)0, (int)0, (int)0), TimestampUtil.createDate((int)1, (int)1, (int)1), TimestampUtil.createTimestamp((int)1, (int)1, (int)1, (int)1, (int)1, (int)1, (int)1), "<root/>")}, new String[]{"int", "time", "date", "timestamp", "sqlxml"}, new String[]{"integer", "time", "date", "timestamp", "string"});
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("GMT-06:00"));
        ResultSetImpl rs = new ResultSetImpl(message, this.statement);
        Assertions.assertTrue((boolean)rs.next());
        Assertions.assertEquals((Object)Boolean.TRUE, (Object)rs.getBoolean(1));
        Assertions.assertEquals((int)1, (int)rs.getShort(1));
        Assertions.assertEquals((int)1, (int)rs.getInt(1));
        Assertions.assertEquals((long)1L, (long)rs.getLong(1));
        Assertions.assertEquals((float)1.0f, (float)rs.getFloat(1), (float)0.0f);
        Assertions.assertEquals((double)1.0, (double)rs.getDouble(1), (double)0.0);
        Assertions.assertEquals((Object)"1", (Object)rs.getString(1));
        Assertions.assertEquals((Object)1, (Object)rs.getObject(1));
        Assertions.assertEquals((Object)TimestampUtil.createTime((int)0, (int)0, (int)0), (Object)rs.getTime(2));
        Assertions.assertEquals((Object)TimestampUtil.createDate((int)1, (int)1, (int)1), (Object)rs.getDate(3));
        Assertions.assertEquals((Object)TimestampUtil.createTimestamp((int)1, (int)1, (int)1, (int)1, (int)1, (int)1, (int)1), (Object)rs.getTimestamp(4));
        Assertions.assertEquals((Object)"<root/>", (Object)rs.getSQLXML(5).getString());
        try {
            rs.getSQLXML(1);
        }
        catch (SQLException e) {
            Assertions.assertEquals((Object)"Unable to transform the column value 1 to a SQLXML.", (Object)e.getMessage());
        }
        Assertions.assertFalse((boolean)rs.next());
        TimestampWithTimezone.resetCalendar(null);
    }
}

