/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.jdbc;

import com.kubling.teiid.jdbc.BatchResults;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBatchResults {
    private static List<?>[] createBatch(int begin, int end) {
        List[] results = new List[end - begin + 1];
        for (int i = 0; i < end - begin + 1; ++i) {
            results[i] = new ArrayList();
            results[i].add(i + begin);
        }
        return results;
    }

    private List<?>[] createEmptyBatch() {
        return new List[0];
    }

    @Test
    public void testGetCurrentRow1() throws Exception {
        BatchResults batchResults = this.getBatchResults(this.createEmptyBatch(), true);
        Assertions.assertNull((Object)batchResults.getCurrentRow());
        batchResults.next();
        Assertions.assertNull((Object)batchResults.getCurrentRow());
    }

    @Test
    public void testGetCurrentRow2() throws Exception {
        BatchResults batchResults = this.getBatchResults(TestBatchResults.createBatch(1, 10), false);
        Assertions.assertNull((Object)batchResults.getCurrentRow());
        batchResults.next();
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        expectedResult.add(1);
        Assertions.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
    }

    @Test
    public void testHasNext1() throws Exception {
        BatchResults batchResults = this.getBatchResults(this.createEmptyBatch(), true);
        Assertions.assertFalse((boolean)batchResults.hasNext());
    }

    @Test
    public void testHasNext2() throws Exception {
        BatchResults batchResults = this.getBatchResults(TestBatchResults.createBatch(1, 1), false);
        Assertions.assertTrue((boolean)batchResults.hasNext());
    }

    @Test
    public void testHasNext3() throws Exception {
        BatchResults batchResults = this.getBatchResults(TestBatchResults.createBatch(1, 10), false);
        Assertions.assertTrue((boolean)batchResults.hasNext());
    }

    @Test
    public void testNext1() throws Exception {
        BatchResults batchResults = this.getBatchResults(this.createEmptyBatch(), true);
        Assertions.assertFalse((boolean)batchResults.next());
    }

    @Test
    public void testNext2() throws Exception {
        BatchResults batchResults = this.getBatchResults(TestBatchResults.createBatch(1, 1), true);
        Assertions.assertTrue((boolean)batchResults.next());
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        expectedResult.add(1);
        Assertions.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
        Assertions.assertFalse((boolean)batchResults.next());
    }

    @Test
    public void testNext3() throws Exception {
        BatchResults batchResults = this.getBatchResults(TestBatchResults.createBatch(1, 1), false);
        Assertions.assertTrue((boolean)batchResults.next());
        Assertions.assertTrue((boolean)batchResults.next());
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        expectedResult.add(2);
        Assertions.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
    }

    @Test
    public void testNext4() throws Exception {
        ArrayList<Integer> expectedResult;
        int i;
        BatchResults batchResults = this.getBatchResults(TestBatchResults.createBatch(1, 10), false);
        for (i = 0; i < 10; ++i) {
            Assertions.assertTrue((boolean)batchResults.next());
            expectedResult = new ArrayList<Integer>();
            expectedResult.add(i + 1);
            Assertions.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
        }
        while (batchResults.next()) {
            expectedResult = new ArrayList();
            expectedResult.add(i++ + 1);
            Assertions.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
        }
        Assertions.assertFalse((boolean)batchResults.next());
    }

    @Test
    public void testHasPrevious1() throws Exception {
        BatchResults batchResults = this.getBatchResults(this.createEmptyBatch(), false);
        Assertions.assertFalse((boolean)batchResults.hasPrevious());
    }

    @Test
    public void testHasPrevious2() throws Exception {
        BatchResults batchResults = this.getBatchResults(TestBatchResults.createBatch(1, 1), true);
        Assertions.assertFalse((boolean)batchResults.hasPrevious());
        batchResults.next();
        Assertions.assertFalse((boolean)batchResults.hasPrevious());
        batchResults.next();
        Assertions.assertTrue((boolean)batchResults.hasPrevious());
    }

    @Test
    public void testPrevious1() throws Exception {
        BatchResults batchResults = this.getBatchResults(this.createEmptyBatch(), false);
        Assertions.assertFalse((boolean)batchResults.previous());
    }

    @Test
    public void testPrevious2() throws Exception {
        BatchResults batchResults = this.getBatchResults(TestBatchResults.createBatch(1, 1), true);
        Assertions.assertTrue((boolean)batchResults.next());
        Assertions.assertFalse((boolean)batchResults.previous());
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        expectedResult.add(1);
        while (batchResults.next()) {
        }
        Assertions.assertTrue((boolean)batchResults.previous());
        Assertions.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
    }

    @Test
    public void testPrevious3() throws Exception {
        BatchResults batchResults = this.getBatchResults(TestBatchResults.createBatch(1, 1), false);
        Assertions.assertFalse((boolean)batchResults.previous());
        Assertions.assertTrue((boolean)batchResults.next());
        Assertions.assertFalse((boolean)batchResults.previous());
        while (batchResults.next()) {
        }
        Assertions.assertTrue((boolean)batchResults.previous());
        while (batchResults.previous()) {
        }
        batchResults.next();
        batchResults.next();
        batchResults.next();
        batchResults.previous();
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        expectedResult.add(2);
        Assertions.assertEquals(expectedResult, (Object)batchResults.getCurrentRow());
    }

    @Test
    public void testPrevious4() throws Exception {
        int i;
        BatchResults batchResults = this.getBatchResults(TestBatchResults.createBatch(1, 10), false);
        for (i = 0; i <= 10; ++i) {
            Assertions.assertTrue((boolean)batchResults.next());
        }
        for (i = 10; i > 0; --i) {
            batchResults.previous();
            ArrayList<Integer> expectedResult = new ArrayList<Integer>();
            expectedResult.add(i);
            Assertions.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
        }
    }

    @Test
    public void testAbsolute1() throws Exception {
        BatchResults batchResults = this.getBatchResults(this.createEmptyBatch(), true);
        Assertions.assertFalse((boolean)batchResults.absolute(0));
        Assertions.assertFalse((boolean)batchResults.absolute(1));
    }

    @Test
    public void testAbsolute2() throws Exception {
        BatchResults batchResults = this.getBatchResults(TestBatchResults.createBatch(1, 1), false);
        Assertions.assertFalse((boolean)batchResults.absolute(0));
        Assertions.assertTrue((boolean)batchResults.absolute(1));
        Assertions.assertTrue((boolean)batchResults.absolute(1));
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        expectedResult.add(1);
        Assertions.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
    }

    @Test
    public void testAbsolute3() throws Exception {
        BatchResults batchResults = this.getBatchResults(TestBatchResults.createBatch(1, 10), false);
        batchResults.setBatchFetcher((BatchResults.BatchFetcher)new MockBatchFetcher(200));
        Assertions.assertFalse((boolean)batchResults.absolute(0));
        Assertions.assertTrue((boolean)batchResults.absolute(11));
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        expectedResult.add(11);
        Assertions.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
        Assertions.assertTrue((boolean)batchResults.absolute(1));
        expectedResult = new ArrayList();
        expectedResult.add(1);
        Assertions.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
        Assertions.assertTrue((boolean)batchResults.absolute(100));
        expectedResult = new ArrayList();
        expectedResult.add(100);
        Assertions.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
    }

    @Test
    public void testAbsolute4() throws Exception {
        BatchResults batchResults = this.getBatchResults(TestBatchResults.createBatch(1, 1), false);
        Assertions.assertTrue((boolean)batchResults.absolute(10));
        Assertions.assertTrue((boolean)batchResults.absolute(2));
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        expectedResult.add(2);
        Assertions.assertEquals((Object)batchResults.getCurrentRow(), expectedResult);
    }

    @Test
    public void testAbsolute5() throws Exception {
        BatchResults batchResults = this.getBatchResults(TestBatchResults.createBatch(1, 1), false);
        Assertions.assertTrue((boolean)batchResults.absolute(-1));
        ArrayList<Integer> expectedResult = new ArrayList<Integer>();
        expectedResult.add(50);
        Assertions.assertEquals(expectedResult, (Object)batchResults.getCurrentRow());
        Assertions.assertFalse((boolean)batchResults.absolute(-100));
    }

    @Test
    public void testAbsoluteWithLastRow() throws Exception {
        BatchResults.Batch batch = new BatchResults.Batch((List[])TestBatchResults.createBatch(1, 10), 1, 10);
        batch.setLastRow(50);
        MockBatchFetcher mbf = new MockBatchFetcher();
        mbf.setUseLastRow(true);
        BatchResults batchResults = new BatchResults((BatchResults.BatchFetcher)mbf, batch, 3);
        Assertions.assertTrue((boolean)batchResults.absolute(41));
        Assertions.assertEquals(Arrays.asList(41), (Object)batchResults.getCurrentRow());
        Assertions.assertEquals(Arrays.asList(41), mbf.batchCalls);
    }

    @Test
    public void testCurrentRowNumber() throws Exception {
        BatchResults batchResults = this.getBatchResults(TestBatchResults.createBatch(1, 1), true);
        Assertions.assertEquals((int)0, (int)batchResults.getCurrentRowNumber());
        batchResults.next();
        Assertions.assertEquals((int)1, (int)batchResults.getCurrentRowNumber());
        batchResults.next();
        Assertions.assertEquals((int)2, (int)batchResults.getCurrentRowNumber());
        Assertions.assertFalse((boolean)batchResults.next());
        Assertions.assertEquals((int)2, (int)batchResults.getCurrentRowNumber());
    }

    @Test
    public void testSetException() throws Exception {
        BatchResults batchResults = this.getBatchResults(TestBatchResults.createBatch(1, 1), false);
        MockBatchFetcher batchFetcher = new MockBatchFetcher();
        batchResults.setBatchFetcher((BatchResults.BatchFetcher)batchFetcher);
        batchFetcher.throwException();
        batchResults.next();
        Assertions.assertThrows(SQLException.class, () -> batchResults.hasNext());
    }

    BatchResults getBatchResults(List<?>[] batch, boolean isLast) {
        BatchResults.Batch batch2 = new BatchResults.Batch((List[])batch, 1, batch.length);
        if (isLast) {
            batch2.setLastRow(batch.length);
        }
        BatchResults results = new BatchResults(null, batch2, 3);
        if (!isLast) {
            results.setBatchFetcher((BatchResults.BatchFetcher)new MockBatchFetcher());
        }
        return results;
    }

    @Test
    public void testBatching() throws Exception {
        int i;
        BatchResults batchResults = this.getBatchResults(TestBatchResults.createBatch(1, 10), false);
        MockBatchFetcher batchFetcher = new MockBatchFetcher(60);
        batchResults.setBatchFetcher((BatchResults.BatchFetcher)batchFetcher);
        for (i = 0; i < 45; ++i) {
            Assertions.assertTrue((boolean)batchResults.next());
        }
        for (i = 0; i < 44; ++i) {
            Assertions.assertTrue((boolean)batchResults.previous());
            Assertions.assertEquals((Object)(44 - i), batchResults.getCurrentRow().get(0));
        }
        this.checkResults(new int[]{11, 21, 31, 41, 20, 10}, batchFetcher.batchCalls);
        Assertions.assertTrue((boolean)batchResults.absolute(50));
        Assertions.assertEquals((Object)50, batchResults.getCurrentRow().get(0));
    }

    private void checkResults(int[] expectedCalls, List<Integer> batchCalls) {
        Assertions.assertEquals((int)expectedCalls.length, (int)batchCalls.size());
        for (int i = 0; i < batchCalls.size(); ++i) {
            int range = batchCalls.get(i);
            int expected = expectedCalls[i];
            Assertions.assertEquals((int)expected, (int)range, (String)("On call " + i + " expected different begin"));
        }
    }

    static class MockBatchFetcher
    implements BatchResults.BatchFetcher {
        private int totalRows;
        private boolean throwException;
        private boolean useLastRow;
        List<Integer> batchCalls = new ArrayList<Integer>();

        public MockBatchFetcher() {
            this(50);
        }

        public MockBatchFetcher(int totalRows) {
            this.totalRows = totalRows;
        }

        public void setUseLastRow(boolean useLastRow) {
            this.useLastRow = useLastRow;
        }

        public BatchResults.Batch requestBatch(int beginRow) throws SQLException {
            this.batchCalls.add(beginRow);
            if (this.throwException) {
                throw new SQLException();
            }
            int endRow = beginRow + 9;
            if (beginRow % 10 == 0) {
                endRow = beginRow - 9;
            }
            if (beginRow > this.totalRows) {
                beginRow = this.totalRows + 1;
                endRow = this.totalRows;
            } else if (beginRow > endRow) {
                if (endRow < 1) {
                    endRow = 1;
                }
                int i = beginRow;
                beginRow = endRow;
                endRow = i;
            }
            boolean last = false;
            if (endRow >= this.totalRows) {
                endRow = this.totalRows;
                last = true;
            }
            BatchResults.Batch batch = new BatchResults.Batch((List[])TestBatchResults.createBatch(beginRow, endRow), beginRow, endRow);
            if (last || this.useLastRow) {
                batch.setLastRow(this.totalRows);
            }
            return batch;
        }

        public void throwException() {
            this.throwException = true;
        }
    }
}

