/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.jdbc;

import com.kubling.teiid.client.RequestMessage;
import com.kubling.teiid.client.ResultsMessage;
import com.kubling.teiid.client.metadata.ParameterInfo;
import com.kubling.teiid.client.security.LogonResult;
import com.kubling.teiid.jdbc.CallableStatementImpl;
import com.kubling.teiid.jdbc.ConnectionImpl;
import com.kubling.teiid.jdbc.ResultSetImpl;
import com.kubling.teiid.net.ServerConnection;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestCallableStatement {
    @Test
    public void testWasNull() throws Exception {
        ResultSetImpl rs;
        HashMap<Integer, Integer> params;
        CallableStatementImpl mmcs = this.getCallableStatement();
        mmcs.outParamIndexMap = params = new HashMap<Integer, Integer>();
        params.put(1, 1);
        params.put(2, 2);
        mmcs.resultSet = rs = (ResultSetImpl)Mockito.mock(ResultSetImpl.class);
        Mockito.when((Object)rs.getOutputParamValue(1)).thenReturn(null);
        Mockito.when((Object)rs.getOutputParamValue(2)).thenReturn((Object)Boolean.TRUE);
        mmcs.getBoolean(1);
        Assertions.assertTrue((boolean)mmcs.wasNull());
        Assertions.assertTrue((boolean)mmcs.getBoolean(2));
        Assertions.assertFalse((boolean)mmcs.wasNull());
    }

    @Test
    public void testGetOutputParameter() throws Exception {
        CallableStatementImpl mmcs = this.getCallableStatement();
        RequestMessage request = new RequestMessage();
        request.setExecutionId(1L);
        ResultsMessage resultsMsg = new ResultsMessage();
        List[] results = new List[]{Arrays.asList(null, null, null), Arrays.asList(null, 1, 2)};
        resultsMsg.setResults(results);
        resultsMsg.setColumnNames(new String[]{"IntNum", "Out1", "Out2"});
        resultsMsg.setDataTypes(new String[]{"integer", "integer", "integer"});
        resultsMsg.setFinalRow(results.length);
        resultsMsg.setLastRow(results.length);
        resultsMsg.setFirstRow(1);
        resultsMsg.setParameters(Arrays.asList(new ParameterInfo(5, 1), new ParameterInfo(2, 1), new ParameterInfo(2, 1)));
        mmcs.createResultSet(resultsMsg);
        Assertions.assertEquals((int)1, (int)mmcs.getInt(1));
        Assertions.assertEquals((int)2, (int)mmcs.getInt(2));
        Assertions.assertEquals((int)1, (int)mmcs.getInt("Out1"));
        Assertions.assertEquals((int)2, (int)mmcs.getInt("Out2"));
    }

    @Test
    public void testUnknownIndex() throws Exception {
        CallableStatementImpl mmcs = this.getCallableStatement();
        mmcs.outParamIndexMap = new HashMap();
        try {
            mmcs.getBoolean(0);
            Assertions.fail((String)"expected exception");
        }
        catch (SQLException e) {
            Assertions.assertEquals((Object)"Parameter 0 was not found.", (Object)e.getMessage());
        }
    }

    @Test
    public void testSetLobs() throws Exception {
        CallableStatementImpl mmcs = this.getCallableStatement();
        mmcs.paramsByName = new TreeMap();
        mmcs.paramsByName.put("foo", 2);
        mmcs.paramsByName.put("bar", 4);
        mmcs.setBlob(1, (InputStream)Mockito.mock(InputStream.class));
        mmcs.setBlob("foo", (InputStream)Mockito.mock(InputStream.class));
        mmcs.setNClob(3, (Reader)Mockito.mock(Reader.class));
        mmcs.setBlob("bar", (InputStream)Mockito.mock(InputStream.class), 1L);
        mmcs.setClob(5, (Reader)Mockito.mock(Reader.class));
        List params = mmcs.getParameterValues();
        Assertions.assertTrue((boolean)(params.get(0) instanceof Blob));
        Assertions.assertTrue((boolean)(params.get(1) instanceof Blob));
        Assertions.assertTrue((boolean)(params.get(2) instanceof Clob));
        Assertions.assertTrue((boolean)(params.get(3) instanceof Blob));
        Assertions.assertTrue((boolean)(params.get(4) instanceof Clob));
    }

    private CallableStatementImpl getCallableStatement() throws SQLException {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ServerConnection sc = (ServerConnection)Mockito.mock(ServerConnection.class);
        Mockito.when((Object)sc.getLogonResult()).thenReturn((Object)new LogonResult());
        Mockito.when((Object)conn.getServerConnection()).thenReturn((Object)sc);
        CallableStatementImpl mmcs = new CallableStatementImpl(conn, "{?=call x(?)}", 1003, 1007);
        return mmcs;
    }
}

