/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.jdbc;

import com.kubling.teiid.jdbc.JDBCURL;
import java.net.URLEncoder;
import java.util.Properties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestJDBCURL {
    @Test
    public final void testCredentials() throws Exception {
        String credentials = URLEncoder.encode("defaultToLogon,(system=BQT1 SQL Server 2000 Simple Cap,user=xyz,password=xyz)", "UTF-8");
        JDBCURL url = new JDBCURL("jdbc:teiid:QT_sqls2kds@mm://slwxp136:43100;credentials=" + credentials);
        Properties p = url.getProperties();
        Assertions.assertEquals((Object)"defaultToLogon,(system=BQT1 SQL Server 2000 Simple Cap,user=xyz,password=xyz)", (Object)p.getProperty("credentials"));
    }

    @Test
    public void testJDBCURLWithProperties() {
        String URL2 = "jdbc:teiid:bqt@mm://localhost:12345;version=1;user=%25xyz;password=***;logLevel=1;configFile=testdata/bqt/dqp_stmt_e2e.xmi;disableLocalTxn=true;autoFailover=false";
        Properties expectedProperties = new Properties();
        expectedProperties.setProperty("version", "1");
        expectedProperties.setProperty("user", "%xyz");
        expectedProperties.setProperty("password", "***");
        expectedProperties.setProperty("logLevel", "1");
        expectedProperties.setProperty("configFile", "testdata/bqt/dqp_stmt_e2e.xmi");
        expectedProperties.setProperty("disableLocalTxn", "true");
        expectedProperties.setProperty("autoFailover", "false");
        JDBCURL url = new JDBCURL(URL2);
        Assertions.assertEquals((Object)"bqt", (Object)url.getVDBName());
        Assertions.assertEquals((Object)"mm://localhost:12345", (Object)url.getConnectionURL());
        Assertions.assertEquals((Object)expectedProperties, (Object)url.getProperties());
        Assertions.assertTrue((boolean)url.getJDBCURL().contains("user=%25xyz"));
    }

    @Test
    public void testJDBCURLWithoutProperties() {
        String URL2 = "jdbc:teiid:bqt@mm://localhost:12345";
        JDBCURL url = new JDBCURL(URL2);
        Assertions.assertEquals((Object)"bqt", (Object)url.getVDBName());
        Assertions.assertEquals((Object)"mm://localhost:12345", (Object)url.getConnectionURL());
        Assertions.assertEquals((Object)new Properties(), (Object)url.getProperties());
    }

    @Test
    public void testCaseConversion() {
        String URL2 = "jdbc:teiid:bqt@mm://localhost:12345;VERSION=1;user=xyz;password=***;configFile=testdata/bqt/dqp_stmt_e2e.xmi";
        Properties expectedProperties = new Properties();
        expectedProperties.setProperty("version", "1");
        expectedProperties.setProperty("user", "xyz");
        expectedProperties.setProperty("password", "***");
        expectedProperties.setProperty("configFile", "testdata/bqt/dqp_stmt_e2e.xmi");
        JDBCURL url = new JDBCURL(URL2);
        Assertions.assertEquals((Object)"bqt", (Object)url.getVDBName());
        Assertions.assertEquals((Object)"mm://localhost:12345", (Object)url.getConnectionURL());
        Assertions.assertEquals((Object)expectedProperties, (Object)url.getProperties());
    }

    @Test
    public void testWithExtraSemicolons() {
        String URL2 = "jdbc:teiid:bqt@mm://localhost:12345;version=1;user=xyz;password=***;logLevel=1;;;configFile=testdata/bqt/dqp_stmt_e2e.xmi;;";
        Properties expectedProperties = new Properties();
        expectedProperties.setProperty("version", "1");
        expectedProperties.setProperty("user", "xyz");
        expectedProperties.setProperty("password", "***");
        expectedProperties.setProperty("logLevel", "1");
        expectedProperties.setProperty("configFile", "testdata/bqt/dqp_stmt_e2e.xmi");
        JDBCURL url = new JDBCURL(URL2);
        Assertions.assertEquals((Object)"bqt", (Object)url.getVDBName());
        Assertions.assertEquals((Object)"mm://localhost:12345", (Object)url.getConnectionURL());
        Assertions.assertEquals((Object)expectedProperties, (Object)url.getProperties());
    }

    @Test
    public void testWithWhitespace() {
        String URL2 = "jdbc:teiid:bqt@mm://localhost:12345; version =1;user= xyz ;password=***; logLevel = 1 ; configFile=testdata/bqt/dqp_stmt_e2e.xmi ;";
        Properties expectedProperties = new Properties();
        expectedProperties.setProperty("version", "1");
        expectedProperties.setProperty("user", "xyz");
        expectedProperties.setProperty("password", "***");
        expectedProperties.setProperty("logLevel", "1");
        expectedProperties.setProperty("configFile", "testdata/bqt/dqp_stmt_e2e.xmi");
        JDBCURL url = new JDBCURL(URL2);
        Assertions.assertEquals((Object)"bqt", (Object)url.getVDBName());
        Assertions.assertEquals((Object)"mm://localhost:12345", (Object)url.getConnectionURL());
        Assertions.assertEquals((Object)expectedProperties, (Object)url.getProperties());
    }

    @Test
    public void testNoPropertyValue() {
        String URL2 = "jdbc:teiid:bqt@mm://localhost:12345;version=1;user=xyz;password=***;logLevel=;configFile=";
        Properties expectedProperties = new Properties();
        expectedProperties.setProperty("version", "1");
        expectedProperties.setProperty("user", "xyz");
        expectedProperties.setProperty("password", "***");
        expectedProperties.setProperty("logLevel", "");
        expectedProperties.setProperty("configFile", "");
        JDBCURL url = new JDBCURL(URL2);
        Assertions.assertEquals((Object)"bqt", (Object)url.getVDBName());
        Assertions.assertEquals((Object)"mm://localhost:12345", (Object)url.getConnectionURL());
        Assertions.assertEquals((Object)expectedProperties, (Object)url.getProperties());
    }

    @Test
    public void testInvalidProtocol() {
        String URL2 = "jdbc:monkeymatrix:bqt@mm://localhost:12345;version=1;user=xyz;password=***;logLevel=1";
        try {
            new JDBCURL(URL2);
            Assertions.fail((String)"Illegal argument should have failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNoVDBName() {
        String URL2 = "jdbc:teiid:@mm://localhost:12345;version=1;user=xyz;password=***;logLevel=1";
        try {
            new JDBCURL(URL2);
            Assertions.fail((String)"Illegal argument should have failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNoAtSignInURL() {
        String URL2 = "jdbc:teiid:bqt!mm://localhost:12345;version=1;user=xyz;password=***;logLevel=1";
        try {
            new JDBCURL(URL2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMoreThanOneAtSign() {
        String URL2 = "jdbc:teiid:bqt@mm://localhost:12345;version=1;user=xy@;password=***;logLevel=1";
        try {
            new JDBCURL(URL2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNoEqualsInProperty() {
        String URL2 = "jdbc:teiid:bqt@mm://localhost:12345;version=1;user=xyz;password***;logLevel=1";
        try {
            new JDBCURL(URL2);
            Assertions.fail((String)"Illegal argument should have failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMoreThanOneEqualsInProperty() {
        String URL2 = "jdbc:teiid:bqt@mm://localhost:12345;version=1;user=xyz;password==***;logLevel=1";
        try {
            new JDBCURL(URL2);
            Assertions.fail((String)"Illegal argument should have failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        URL2 = "jdbc:teiid:bqt@mm://localhost:12345;version=1;user=xyz;password=***=;logLevel=1";
        try {
            new JDBCURL(URL2);
            Assertions.fail((String)"Illegal argument should have failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        URL2 = "jdbc:teiid:bqt@mm://localhost:12345;version=1;user=xyz;=password=***;logLevel=1";
        try {
            new JDBCURL(URL2);
            Assertions.fail((String)"Illegal argument should have failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNoKeyInProperty() {
        String URL2 = "jdbc:teiid:bqt@mm://localhost:12345;version=1;user=xyz;=***;logLevel=1";
        try {
            new JDBCURL(URL2);
            Assertions.fail((String)"Illegal argument should have failed.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testConstructor() {
        JDBCURL url = new JDBCURL("myVDB", "mm://myhost:12345", null);
        Assertions.assertEquals((Object)"jdbc:teiid:myVDB@mm://myhost:12345", (Object)url.getJDBCURL());
        Properties props = new Properties();
        props.setProperty("user", "myuser");
        props.setProperty("password", "mypassword");
        props.put("ClieNTtOKeN", (Object)1);
        url = new JDBCURL("myVDB", "mm://myhost:12345", props);
        Assertions.assertEquals((Object)"jdbc:teiid:myVDB@mm://myhost:12345;password=mypassword;user=myuser", (Object)url.getJDBCURL());
    }

    @Test
    public void testConstructor_Exception() {
        try {
            new JDBCURL(null, "myhost", null);
            Assertions.fail((String)"Should have failed.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            new JDBCURL("  ", "myhost", null);
            Assertions.fail((String)"Should have failed.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            new JDBCURL("myVDB", "  ", null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testNormalize() {
        Properties props = new Properties();
        props.setProperty("UsEr", "myuser");
        props.setProperty("pAssWOrD", "mypassword");
        props.put("ClieNTtOKeN", (Object)1);
        JDBCURL.normalizeProperties((Properties)props);
        Assertions.assertEquals((Object)"myuser", (Object)props.getProperty("user"));
        Assertions.assertEquals((Object)"mypassword", (Object)props.getProperty("password"));
    }

    @Test
    public final void testEncodedPropertyProperties() throws Exception {
        String password = "=@#^&*()+!%$^%@#_-)_~{}||\\`':;,./<>?password has = & %";
        Properties props = new Properties();
        props.setProperty("UsEr", "foo");
        props.setProperty("PASswoRd", password);
        JDBCURL.normalizeProperties((Properties)props);
        Assertions.assertEquals((Object)password, (Object)props.getProperty("password"));
        Assertions.assertEquals((Object)"foo", (Object)props.getProperty("user"));
    }

    @Test
    public final void testEncodedPropertyInURL() throws Exception {
        String password = "=@#^&*()+!%$^%@#_-)_~{}||\\`':;,./<>?password has = & %";
        String encPassword = URLEncoder.encode(password, "UTF-8");
        JDBCURL url = new JDBCURL("jdbc:teiid:QT_sqls2kds@mm://slwxp136:43100;PASswoRd=" + encPassword);
        Properties p = url.getProperties();
        Assertions.assertEquals((Object)password, (Object)p.getProperty("password"));
    }

    @Test
    public void testGetServerURL_NoProperties() {
        String result = new JDBCURL("jdbc:teiid:designtimecatalog@mm://slwxp172:44401;user=ddifranco;password=mm").getConnectionURL();
        Assertions.assertEquals((Object)"mm://slwxp172:44401", (Object)result);
    }

    @Test
    public void testGetServerURL_Properties() {
        String result = new JDBCURL("jdbc:teiid:designtimecatalog@mm://slwxp172:44401;user=ddifranco;password=mm").getConnectionURL();
        Assertions.assertEquals((Object)"mm://slwxp172:44401", (Object)result);
    }

    @Test
    public void testGetServerURL_PasswordProperties() throws Exception {
        String result = null;
        String srcURL = "jdbc:teiid:designtimecatalog@mm://slwxp172:44401;user=ddifranco;password=";
        String password = null;
        String tgtURL = "mm://slwxp172:44401";
        for (char ch = ' '; ch <= '~'; ch = (char)((char)(ch + 1))) {
            if (ch == 59 || ch == 61 || ch == 37) continue;
            password = ch + "mm";
            result = new JDBCURL(srcURL + URLEncoder.encode(password, "UTF-8")).getConnectionURL();
            Assertions.assertEquals((Object)tgtURL, (Object)result, (String)("Failed to obtain correct ServerURL when using password " + password));
        }
    }

    @Test
    public void testGetServerURL_2Servers() {
        String result = new JDBCURL("jdbc:teiid:designtimecatalog@mm://slwxp172:44401,slabc123:12345;user=ddifranco;password=mm").getConnectionURL();
        Assertions.assertEquals((Object)"mm://slwxp172:44401,slabc123:12345", (Object)result);
    }

    @Test
    public void testBuildEmbeedURL() {
        JDBCURL url = new JDBCURL("vdb", "/home/foo/deploy.properties", new Properties());
        Assertions.assertEquals((Object)"jdbc:teiid:vdb@/home/foo/deploy.properties", (Object)url.getJDBCURL());
        Properties p = new Properties();
        p.setProperty("user", "test");
        p.setProperty("password", "pass");
        p.setProperty("autoFailover", "true");
        p.setProperty("any", "thing");
        url = new JDBCURL("vdb", "/home/foo/deploy.properties", p);
        Assertions.assertTrue((boolean)url.getJDBCURL().startsWith("jdbc:teiid:vdb@/home/foo/deploy.properties;"));
        Assertions.assertTrue((url.getJDBCURL().indexOf("any=thing") != -1 ? 1 : 0) != 0);
        Assertions.assertTrue((url.getJDBCURL().indexOf("password=pass") != -1 ? 1 : 0) != 0);
        Assertions.assertTrue((url.getJDBCURL().indexOf("autoFailover=true") != -1 ? 1 : 0) != 0);
    }

    @Test
    public void testUnicodeName() {
        String result = new JDBCURL("jdbc:teiid:%E4%BD%A0%E5%A5%BD").getVDBName();
        Assertions.assertEquals((Object)"\u4f60\u597d", (Object)result);
        result = new JDBCURL("jdbc:teiid:\u4f60\u597d").getVDBName();
        Assertions.assertEquals((Object)"\u4f60\u597d", (Object)result);
    }

    @Test
    public void testEncoding() {
        JDBCURL url = new JDBCURL("jdbc:teiid:a%40b@mm://%50;%55=a");
        Assertions.assertEquals((Object)"a@b", (Object)url.getVDBName());
        Assertions.assertEquals((Object)"mm://P", (Object)url.getConnectionURL());
        Assertions.assertEquals((Object)"U", (Object)url.getProperties().entrySet().iterator().next().getKey());
    }
}

