/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.jdbc;

import com.kubling.teiid.client.DQP;
import com.kubling.teiid.client.RequestMessage;
import com.kubling.teiid.client.ResultsMessage;
import com.kubling.teiid.client.security.LogonResult;
import com.kubling.teiid.client.util.ResultsFuture;
import com.kubling.teiid.core.TeiidException;
import com.kubling.teiid.jdbc.ConnectionImpl;
import com.kubling.teiid.jdbc.PreparedStatementImpl;
import com.kubling.teiid.net.ServerConnection;
import java.sql.BatchUpdateException;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestPreparedStatement {
    @Test
    public void testBatchedUpdateExecution() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        Mockito.when((Object)conn.getConnectionProps()).thenReturn((Object)new Properties());
        DQP dqp = (DQP)Mockito.mock(DQP.class);
        ServerConnection serverConn = (ServerConnection)Mockito.mock(ServerConnection.class);
        LogonResult logonResult = (LogonResult)Mockito.mock(LogonResult.class);
        Mockito.when((Object)conn.getServerConnection()).thenReturn((Object)serverConn);
        Mockito.when((Object)serverConn.getLogonResult()).thenReturn((Object)logonResult);
        Mockito.when((Object)logonResult.getTimeZone()).thenReturn((Object)TimeZone.getDefault());
        ResultsFuture results = new ResultsFuture();
        int[] count = new int[1];
        ResultsMessage rm = new ResultsMessage();
        Mockito.when((Object)dqp.executeRequest(ArgumentMatchers.anyLong(), (RequestMessage)ArgumentMatchers.any())).thenAnswer(invocation -> {
            RequestMessage requestMessage = (RequestMessage)invocation.getArguments()[1];
            count[0] = count[0] + requestMessage.getParameterValues().size();
            if (count[0] == 100000) {
                rm.setException((Throwable)new TeiidException());
                rm.setResults(new List[]{Arrays.asList(-3)});
            } else {
                Object[] vals = new List[requestMessage.getParameterValues().size()];
                Arrays.fill(vals, Arrays.asList(0));
                rm.setResults(Arrays.asList(vals));
            }
            return results;
        });
        rm.setUpdateResult(true);
        results.getResultsReceiver().receiveResults((Object)rm);
        Mockito.when((Object)conn.getDQP()).thenReturn((Object)dqp);
        String sqlCommand = "delete from table where col=?";
        TestableMMPreparedStatement statement = (TestableMMPreparedStatement)this.getMMPreparedStatement(conn, sqlCommand);
        ArrayList<ArrayList<Object>> expectedParameterValues = new ArrayList<ArrayList<Object>>(3);
        expectedParameterValues.add(new ArrayList<Object>(Arrays.asList(1)));
        statement.setInt(1, 1);
        statement.addBatch();
        expectedParameterValues.add(new ArrayList<Object>(Arrays.asList(2)));
        statement.setInt(1, 2);
        statement.addBatch();
        expectedParameterValues.add(new ArrayList<Object>(Arrays.asList(3)));
        statement.setInt(1, 3);
        statement.addBatch();
        Assertions.assertTrue((boolean)Arrays.equals(new int[]{0, 0, 0}, statement.executeBatch()));
        Assertions.assertEquals((Object)sqlCommand, (Object)statement.requestMessage.getCommandString());
        Assertions.assertEquals(expectedParameterValues, (Object)statement.requestMessage.getParameterValues());
        Assertions.assertTrue((boolean)statement.requestMessage.isBatchedUpdate());
        Assertions.assertFalse((boolean)statement.requestMessage.isCallableStatement());
        Assertions.assertTrue((boolean)statement.requestMessage.isPreparedStatement());
        count[0] = 0;
        for (int i = 0; i < 100000; ++i) {
            statement.setInt(1, 1);
            statement.addBatch();
        }
        try {
            statement.executeBatch();
            Assertions.fail();
        }
        catch (BatchUpdateException e) {
            Assertions.assertEquals((int)100000, (int)count[0]);
            Assertions.assertEquals((int)95309, (int)e.getUpdateCounts().length);
            Assertions.assertEquals((int)-3, (int)e.getUpdateCounts()[95308]);
        }
    }

    @Test
    public void testClearBatch() throws Exception {
        PreparedStatementImpl statement = this.getMMPreparedStatement("delete from table where col=?");
        statement.setInt(1, Integer.valueOf(1).intValue());
        statement.addBatch();
        statement.setInt(1, Integer.valueOf(2).intValue());
        statement.addBatch();
        Assertions.assertTrue((statement.getParameterValuesList().size() > 0 ? 1 : 0) != 0);
        statement.clearBatch();
        Assertions.assertTrue((statement.getParameterValuesList().size() == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testClearBatchAddBatch() throws Exception {
        PreparedStatementImpl statement = this.getMMPreparedStatement("delete from table where col=?");
        statement.setInt(1, Integer.valueOf(1).intValue());
        statement.addBatch();
        statement.setInt(1, Integer.valueOf(2).intValue());
        statement.addBatch();
        Assertions.assertTrue((statement.getParameterValuesList().size() > 0 ? 1 : 0) != 0);
        statement.clearBatch();
        Assertions.assertTrue((statement.getParameterValuesList().size() == 0 ? 1 : 0) != 0);
        ArrayList<ArrayList<Object>> expectedParameterValues = new ArrayList<ArrayList<Object>>(1);
        expectedParameterValues.add(new ArrayList<Object>(Arrays.asList(5)));
        statement.setInt(1, Integer.valueOf(5).intValue());
        statement.addBatch();
        Assertions.assertEquals(expectedParameterValues, (Object)statement.getParameterValuesList());
    }

    @Test
    public void testAddBatch() throws Exception {
        PreparedStatementImpl statement = this.getMMPreparedStatement("delete from table where col=?");
        ArrayList<ArrayList<Integer>> expectedParameterValues = new ArrayList<ArrayList<Integer>>(1);
        expectedParameterValues.add(new ArrayList<Integer>(Arrays.asList(1)));
        statement.setInt(1, Integer.valueOf(1).intValue());
        statement.addBatch();
        Assertions.assertEquals(expectedParameterValues, (Object)statement.getParameterValuesList());
        expectedParameterValues.add(new ArrayList<Integer>(Arrays.asList(3)));
        expectedParameterValues.add(new ArrayList<Integer>(Arrays.asList(5)));
        statement.setInt(1, Integer.valueOf(3).intValue());
        statement.addBatch();
        statement.setInt(1, Integer.valueOf(5).intValue());
        statement.addBatch();
        Assertions.assertEquals(expectedParameterValues, (Object)statement.getParameterValuesList());
        Assertions.assertEquals(Arrays.asList(5), (Object)statement.getParameterValues());
    }

    @Test
    public void testSetBlob() throws Exception {
        PreparedStatementImpl stmt = this.getMMPreparedStatement("delete from table where col=?");
        stmt.setBlob(1, (Blob)null);
    }

    @Test
    public void testShowParameterMetadata() throws Exception {
        PreparedStatementImpl stmt = this.getMMPreparedStatement("show plan");
        Assertions.assertEquals((int)0, (int)stmt.getParameterMetaData().getParameterCount());
    }

    @Test
    public void testAddBatchNoParameterValues() throws Exception {
        PreparedStatementImpl statement = this.getMMPreparedStatement("delete from table where col=?");
        ArrayList<ArrayList<Object>> expectedParameterValues = new ArrayList<ArrayList<Object>>(1);
        expectedParameterValues.add(new ArrayList(Collections.emptyList()));
        statement.addBatch();
        expectedParameterValues.add(new ArrayList<Object>(Arrays.asList(1)));
        statement.setInt(1, Integer.valueOf(1).intValue());
        statement.addBatch();
        Assertions.assertEquals(expectedParameterValues, (Object)statement.getParameterValuesList());
    }

    protected PreparedStatementImpl getMMPreparedStatement(String sql) throws SQLException {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ServerConnection serverConn = (ServerConnection)Mockito.mock(ServerConnection.class);
        LogonResult logonResult = (LogonResult)Mockito.mock(LogonResult.class);
        Mockito.when((Object)conn.getServerConnection()).thenReturn((Object)serverConn);
        Mockito.when((Object)serverConn.getLogonResult()).thenReturn((Object)logonResult);
        Mockito.when((Object)logonResult.getTimeZone()).thenReturn((Object)TimeZone.getDefault());
        return this.getMMPreparedStatement(conn, sql);
    }

    protected PreparedStatementImpl getMMPreparedStatement(ConnectionImpl conn, String sql) throws SQLException {
        TestableMMPreparedStatement statement = new TestableMMPreparedStatement(this, conn, sql, 1003, 1007);
        Assertions.assertTrue((statement.getParameterValuesList().size() == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((statement.getParameterValues().size() == 0 ? 1 : 0) != 0);
        return statement;
    }

    class TestableMMPreparedStatement
    extends PreparedStatementImpl {
        public RequestMessage requestMessage;

        protected RequestMessage createRequestMessage(String[] commands, boolean isBatchedCommand, RequestMessage.ResultsMode resultsMode) {
            this.requestMessage = super.createRequestMessage(commands, isBatchedCommand, resultsMode);
            return this.requestMessage;
        }

        public TestableMMPreparedStatement(TestPreparedStatement this$0, ConnectionImpl connection, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            super(connection, sql, resultSetType, resultSetConcurrency);
        }
    }
}

