/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.jdbc;

import com.kubling.teiid.client.ProcedureErrorInstructionException;
import com.kubling.teiid.core.BundleUtil;
import com.kubling.teiid.core.TeiidException;
import com.kubling.teiid.core.TeiidProcessingException;
import com.kubling.teiid.core.TeiidRuntimeException;
import com.kubling.teiid.jdbc.TeiidSQLException;
import com.kubling.teiid.net.CommunicationException;
import com.kubling.teiid.net.ConnectionException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.sql.SQLException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSQLException {
    @Test
    public void testMMSQLException() {
        TeiidSQLException e = new TeiidSQLException();
        String sqlState = e.getSQLState();
        Throwable cause = e.getCause();
        int errorCode = e.getErrorCode();
        Throwable nestedException = e.getCause();
        SQLException nextException = e.getNextException();
        Assertions.assertTrue((sqlState == null ? 1 : 0) != 0, (String)("Expected MMSQLException.getSQLState() to return <null> but got \"" + sqlState + "\" instead."));
        Assertions.assertTrue((cause == null ? 1 : 0) != 0, (String)("Expected MMSQLException.getCause() to return <null> but got [" + (cause != null ? cause.getClass().getName() : "<unknown>") + "] instead."));
        Assertions.assertTrue((errorCode == 0 ? 1 : 0) != 0, (String)("Expected MMSQLException.getErrorCode() to return [0] but got [" + errorCode + "] instead."));
        Assertions.assertTrue((nestedException == null ? 1 : 0) != 0, (String)("Expected MMSQLException.getNestedException() to return <null> but got [" + (nestedException != null ? nestedException.getClass().getName() : "<unknown>") + "] instead."));
        Assertions.assertTrue((nextException == null ? 1 : 0) != 0, (String)("Expected MMSQLException.getNextException() to return <null> but got a SQLException with message \"" + (nextException != null ? nextException.getMessage() : "") + "\" instead."));
    }

    @Test
    public void testCreateThrowable_01() {
        this.testCreateThrowable(new CommunicationException("A test MM Communication Exception"), "08S01");
        this.testCreateThrowable(new ConnectException("A test connection attempt exception"), "08001");
        this.testCreateThrowable((Throwable)new ConnectionException("A test MM Connection Exception"), "08001");
        this.testCreateThrowable(new IOException("A test Generic java.io.IOException"), "08S01");
        this.testCreateThrowable(new MalformedURLException("A test java.net.MalformedURLException"), "08001");
        this.testCreateThrowable((Throwable)new TeiidException("A test Generic MM Core Exception"), "38000");
        this.testCreateThrowable((Throwable)new TeiidException("A test MM Exception"), "38000");
        this.testCreateThrowable((Throwable)new TeiidProcessingException("A test Generic MM Query Processing Exception"), "50000");
        this.testCreateThrowable((Throwable)new TeiidRuntimeException("A test MM Runtime Exception"), "38000");
        this.testCreateThrowable(new TeiidSQLException("A test Generic MM SQL Exception"), "38000");
        this.testCreateThrowable(new NoRouteToHostException("A test java.net.NoRouteToHostException"), "08001");
        this.testCreateThrowable(new NullPointerException("A test NPE"), "38000");
        this.testCreateThrowable((Throwable)new ProcedureErrorInstructionException("A test SQL Procedure Error exception"), "50001");
        this.testCreateThrowable(new SocketTimeoutException("A test socket timeout exception"), "08S01");
        this.testCreateThrowable(new UnknownHostException("A test connection attempt exception"), "08001");
    }

    private TeiidSQLException testCreateThrowable(Throwable ecause, String esqlState) {
        TeiidSQLException e = TeiidSQLException.create((Throwable)ecause);
        if (ecause.getClass() == TeiidSQLException.class) {
            ecause = null;
        }
        String sqlState = e.getSQLState();
        Throwable cause = e.getCause();
        int errorCode = e.getErrorCode();
        Throwable nestedException = e.getCause();
        SQLException nextException = e.getNextException();
        Assertions.assertEquals((Object)esqlState, (Object)sqlState);
        Assertions.assertEquals((Object)ecause, (Object)cause);
        Assertions.assertEquals((int)0, (int)errorCode);
        Assertions.assertEquals((Object)nestedException, (Object)ecause);
        Assertions.assertNull((Object)nextException);
        return e;
    }

    @Test
    public void testCreate() {
        TeiidSQLException exception = TeiidSQLException.create((Throwable)new Exception());
        Assertions.assertEquals((Object)exception.getMessage(), (Object)Exception.class.getName());
        Assertions.assertNotNull((Object)exception.getSQLState());
        Assertions.assertEquals((Object)exception.getSQLState(), (Object)"38000");
        Assertions.assertEquals((Object)((Object)exception), (Object)((Object)TeiidSQLException.create((Throwable)exception)));
    }

    @Test
    public void testCreateFromSQLException() {
        SQLException sqlexception = new SQLException("foo", "21");
        SQLException nested = new SQLException("bar");
        sqlexception.setNextException(nested);
        String message = "top level message";
        TeiidSQLException exception = TeiidSQLException.create((Throwable)sqlexception, (String)message);
        exception.printStackTrace();
        Assertions.assertEquals((Object)sqlexception, (Object)exception.getCause());
        Assertions.assertEquals((Object)exception.getMessage(), (Object)message);
        Assertions.assertEquals((Object)exception.getSQLState(), (Object)sqlexception.getSQLState());
    }

    @Test
    public void testCodeAsVendorCode() {
        TeiidException sqlexception = new TeiidException((BundleUtil.Event)Event.TEIID21, "foo");
        String message = "top level message";
        TeiidSQLException exception = TeiidSQLException.create((Throwable)sqlexception, (String)message);
        Assertions.assertEquals((Object)sqlexception.getCode(), (Object)exception.getTeiidCode());
        Assertions.assertEquals((int)21, (int)exception.getErrorCode());
    }

    public static enum Event implements BundleUtil.Event
    {
        TEIID21;

    }
}

