/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.jdbc;

import com.kubling.teiid.jdbc.JDBCURL;
import com.kubling.teiid.jdbc.TeiidDriver;
import java.sql.SQLException;
import java.util.Properties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSocketProfile {
    public String localhost = "localhost";

    @Test
    public void testAcceptsURL1() throws Exception {
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Socket, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:jvdb@mm://localhost:1234"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Socket, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:jvdb@mm://localhost:1234"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Socket, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:vdb@mm://localhost:1234;version=x"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Socket, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:vdb@mm://localhost:1234"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Socket, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:vdb@mm://localhost:1234,localhost2:12342,localhost3:12343"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Socket, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:vdb@mm://localhost:1234;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Socket, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:vdb@mm://localhost:1234,localhost2:12342,localhost3:12343;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Socket, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:vdb@mms://localhost:1234;logLevel=1;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log"));
        Assertions.assertNull((Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:@mm://localhost:1234;logLevel=2;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Socket, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:vdb@mm://localhost:1234;logLevel=2;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log;autoCommitTxn=OFF;paritalResultsMode=true"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Socket, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:jvdb@mms://localhost:1234"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Socket, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:vdb@mm://localhost:1234;version=x"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Socket, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:vdb@mm://localhost:1234,localhost2:12342,localhost3:12343"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Socket, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:vdb@mms://localhost:1234,localhost2:12342,localhost3:12343;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Socket, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:vdb@mms://localhost:1234;logLevel=2;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log;autoCommitTxn=OFF;paritalResultsMode=true"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Socket, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:vdb@mm://127.0.0.1:1234;logLevel=2"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Socket, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:vdb@mms://127.0.0.1:1234"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Socket, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:vdb@mm://127.0.0.1:1234,localhost.mydomain.com:63636;logLevel=2"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Socket, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:vdb@mm://my-host.mydomain.com:53535,127.0.0.1:1234"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Socket, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:vdb@mm://123.123.123.123:53535,127.0.0.1:1234"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Socket, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:jvdb@localhost:1234"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Socket, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:jvdb@c:/dqp.properties;version=1"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Socket, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:jvdb@/foo/dqp.properties;version=1"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Socket, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:jvdb@../foo/dqp.properties;version=1"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Socket, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:jvdb@mm://localhost:port"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Socket, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:vdb@localhost:port;version=x"));
        Assertions.assertNull((Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:@localhost:1234"));
        Assertions.assertNull((Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:@localhost:1234,localhost2:12342,localhost3:12343"));
        Assertions.assertNull((Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:@localhost:1234;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log"));
        Assertions.assertNull((Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:@localhost:1234,localhost2:12342,localhost3:12343;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log"));
        Assertions.assertNull((Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:@localhost:1234;logLevel=1;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log"));
        Assertions.assertNull((Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:@localhost:1234;logLevel=2;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log"));
        Assertions.assertNull((Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:@localhost:1234;logLevel=2;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log;autoCommitTxn=OFF;paritalResultsMode=true"));
        Assertions.assertNull((Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:@localhost:1234;stickyConnections=false;socketsPerVM=4"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Socket, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:vdb@mm://my_host.mydomain.com:53535,127.0.0.1:1234"));
    }

    @Test
    public void testAcceptsURL2() throws Exception {
        Assertions.assertTrue((!TeiidDriver.getInstance().acceptsURL("jdbc:matamatrix:test") ? 1 : 0) != 0);
        Assertions.assertTrue((!TeiidDriver.getInstance().acceptsURL("metamatrix:test") ? 1 : 0) != 0);
        Assertions.assertTrue((!TeiidDriver.getInstance().acceptsURL("jdbc&matamatrix:test") ? 1 : 0) != 0);
        Assertions.assertTrue((!TeiidDriver.getInstance().acceptsURL("jdbc;metamatrix:test") ? 1 : 0) != 0);
    }

    @Test
    public void testParseURL() throws SQLException {
        Properties p = new Properties();
        TeiidDriver.parseURL((String)"jdbc:teiid:BQT@mm://slwxp157:1234", (Properties)p);
        Assertions.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        Assertions.assertTrue((boolean)p.getProperty("serverURL").equals("mm://slwxp157:1234"));
        Assertions.assertEquals((int)3, (int)p.size());
    }

    @Test
    public void testParseURL2() throws SQLException {
        Properties p = new Properties();
        TeiidDriver.parseURL((String)"jdbc:teiid:BQT@mms://slwxp157:1234;version=3", (Properties)p);
        Assertions.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        Assertions.assertTrue((boolean)p.getProperty("VirtualDatabaseVersion").equals("3"));
        Assertions.assertTrue((boolean)p.getProperty("serverURL").equals("mms://slwxp157:1234"));
        Assertions.assertTrue((boolean)p.getProperty("version").equals("3"));
        Assertions.assertTrue((boolean)p.getProperty("ApplicationName").equals("JDBC"));
        Assertions.assertEquals((int)5, (int)p.size());
    }

    @Test
    public void testParseURL3() throws SQLException {
        Properties p = new Properties();
        TeiidDriver.parseURL((String)"jdbc:teiid:BQT@mm://slwxp157:1234,slntmm01:43401,sluxmm09:43302;version=4;autoCommitTxn=ON;partialResultsMode=YES;ApplicationName=Client", (Properties)p);
        Assertions.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        Assertions.assertTrue((boolean)p.getProperty("VirtualDatabaseVersion").equals("4"));
        Assertions.assertTrue((boolean)p.getProperty("autoCommitTxn").equals("ON"));
        Assertions.assertTrue((boolean)p.getProperty("partialResultsMode").equals("YES"));
        Assertions.assertTrue((boolean)p.getProperty("serverURL").equals("mm://slwxp157:1234,slntmm01:43401,sluxmm09:43302"));
        Assertions.assertTrue((boolean)p.getProperty("version").equals("4"));
        Assertions.assertTrue((boolean)p.getProperty("ApplicationName").equals("Client"));
        Assertions.assertEquals((int)7, (int)p.size());
    }

    @Test
    public void testIPV6() throws SQLException {
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Socket, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:vdb@mm://[::1]:53535,127.0.0.1:1234"));
        Assertions.assertEquals((Object)JDBCURL.ConnectionType.Socket, (Object)JDBCURL.acceptsUrl((String)"jdbc:teiid:vdb@mm://[3ffe:ffff:0100:f101::1]:53535,127.0.0.1:1234"));
        Properties p = new Properties();
        TeiidDriver.parseURL((String)"jdbc:teiid:BQT@mms://[3ffe:ffff:0100:f101::1]:1234;version=3", (Properties)p);
        Assertions.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        Assertions.assertTrue((boolean)p.getProperty("VirtualDatabaseVersion").equals("3"));
        Assertions.assertTrue((boolean)p.getProperty("serverURL").equals("mms://[3ffe:ffff:0100:f101::1]:1234"));
        Assertions.assertTrue((boolean)p.getProperty("version").equals("3"));
    }

    @Test
    public void testIPV6MultipleHosts() throws SQLException {
        Properties p = new Properties();
        TeiidDriver.parseURL((String)"jdbc:teiid:BQT@mms://[3ffe:ffff:0100:f101::1]:1234,[::1]:31000,127.0.0.1:2134;version=3", (Properties)p);
        Assertions.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        Assertions.assertTrue((boolean)p.getProperty("VirtualDatabaseVersion").equals("3"));
        Assertions.assertTrue((boolean)p.getProperty("serverURL").equals("mms://[3ffe:ffff:0100:f101::1]:1234,[::1]:31000,127.0.0.1:2134"));
        Assertions.assertTrue((boolean)p.getProperty("version").equals("3"));
    }
}

