/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.jdbc;

import com.kubling.teiid.jdbc.TeiidDriver;
import java.sql.DriverPropertyInfo;
import java.util.Properties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestTeiidDriver {
    TeiidDriver drv = new TeiidDriver();
    public String localhost = "localhost";

    @Test
    public void testAccepts() throws Exception {
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://localhost:12345"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://localhost:12345;user=foo;password=bar"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@/foo/blah/deploy.properties"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://localhost:12345"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://localhost:12345;user=foo;password=bar"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@/foo/blah/deploy.properties"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:8294601c-9fe9-4244-9499-4a012c5e1476_vdb"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:8294601c-9fe9-4244-9499-4a012c5e1476_vdb@mm://localhost:12345"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:test_vdb@mm://local-host:12345"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:test_vdb@mm://local_host:12345"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:test_vdb.1@mm://local_host:12345"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:test_vdb.10@mm://local_host:12345"));
    }

    @Test
    public void testAcceptsURL1() throws Exception {
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:jvdb@mm://localhost:1234"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://localhost:1234;version=x"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://localhost:1234"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://localhost:1234,localhost2:12342,localhost3:12343"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://localhost:1234;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://localhost:1234,localhost2:12342,localhost3:12343;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mms://localhost:1234;logLevel=1;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log"));
        Assertions.assertTrue((!this.drv.acceptsURL("jdbc:teiid:@mm://localhost:1234;logLevel=2;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log") ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://localhost:1234;logLevel=2;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log;autoCommitTxn=OFF;paritalResultsMode=true"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:jvdb@mms://localhost:1234"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://localhost:1234;version=x"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://localhost:1234,localhost2:12342,localhost3:12343"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mms://localhost:1234,localhost2:12342,localhost3:12343;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mms://localhost:1234;logLevel=2;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log;autoCommitTxn=OFF;paritalResultsMode=true"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://127.0.0.1:1234;logLevel=2"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mms://127.0.0.1:1234"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://127.0.0.1:1234,localhost.mydomain.com:63636;logLevel=2"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://my-host.mydomain.com:53535,127.0.0.1:1234"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://123.123.123.123:53535,127.0.0.1:1234"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:jvdb@c:/dqp.properties;version=1"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:jvdb@/foo/dqp.properties;version=1"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:jvdb@../foo/dqp.properties;version=1"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:jvdb@mm://localhost:port"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@localhost:port;version=x"));
        Assertions.assertTrue((!this.drv.acceptsURL("jdbc:teiid:@localhost:1234") ? 1 : 0) != 0);
        Assertions.assertTrue((!this.drv.acceptsURL("jdbc:teiid:@localhost:1234,localhost2:12342,localhost3:12343") ? 1 : 0) != 0);
        Assertions.assertTrue((!this.drv.acceptsURL("jdbc:teiid:@localhost:1234;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log") ? 1 : 0) != 0);
        Assertions.assertTrue((!this.drv.acceptsURL("jdbc:teiid:@localhost:1234,localhost2:12342,localhost3:12343;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log") ? 1 : 0) != 0);
        Assertions.assertTrue((!this.drv.acceptsURL("jdbc:teiid:@localhost:1234;logLevel=1;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log") ? 1 : 0) != 0);
        Assertions.assertTrue((!this.drv.acceptsURL("jdbc:teiid:@localhost:1234;logLevel=2;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log") ? 1 : 0) != 0);
        Assertions.assertTrue((!this.drv.acceptsURL("jdbc:teiid:@localhost:1234;logLevel=2;logFile=D:\\metamatrix\\work\\DQP\\log\\jdbcLogFile.log;autoCommitTxn=OFF;paritalResultsMode=true") ? 1 : 0) != 0);
        Assertions.assertTrue((!this.drv.acceptsURL("jdbc:teiid:@localhost:1234;stickyConnections=false;socketsPerVM=4") ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://my_host.mydomain.com:53535,127.0.0.1:1234"));
        Assertions.assertTrue((boolean)this.drv.acceptsURL("jdbc:teiid:vdb@mm://localhost:1234;version=x;useJDBC4ColumnNameAndLabelSemantics=false"));
    }

    @Test
    public void testAcceptsURL2() throws Exception {
        Assertions.assertTrue((!this.drv.acceptsURL("jdbc:matamatrix:test") ? 1 : 0) != 0);
        Assertions.assertTrue((!this.drv.acceptsURL("metamatrix:test") ? 1 : 0) != 0);
        Assertions.assertTrue((!this.drv.acceptsURL("jdbc&matamatrix:test") ? 1 : 0) != 0);
        Assertions.assertTrue((!this.drv.acceptsURL("jdbc;metamatrix:test") ? 1 : 0) != 0);
    }

    @Test
    public void testParseURL() throws Exception {
        Properties p = new Properties();
        TeiidDriver.parseURL((String)"jdbc:teiid:BQT@mm://slwxp157:1234", (Properties)p);
        Assertions.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        Assertions.assertTrue((boolean)p.getProperty("serverURL").equals("mm://slwxp157:1234"));
        Assertions.assertEquals((int)3, (int)p.size());
    }

    @Test
    public void testParseURL2() throws Exception {
        Properties p = new Properties();
        TeiidDriver.parseURL((String)"jdbc:teiid:BQT@mms://slwxp157:1234;version=3", (Properties)p);
        Assertions.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        Assertions.assertTrue((boolean)p.getProperty("VirtualDatabaseVersion").equals("3"));
        Assertions.assertTrue((boolean)p.getProperty("serverURL").equals("mms://slwxp157:1234"));
        Assertions.assertTrue((boolean)p.getProperty("version").equals("3"));
        Assertions.assertTrue((boolean)p.getProperty("ApplicationName").equals("JDBC"));
        Assertions.assertEquals((int)5, (int)p.size());
    }

    @Test
    public void testParseURL3() throws Exception {
        Properties p = new Properties();
        TeiidDriver.parseURL((String)"jdbc:teiid:BQT@mm://slwxp157:1234,slntmm01:43401,sluxmm09:43302;version=4;autoCommitTxn=ON;partialResultsMode=YES;ApplicationName=Client", (Properties)p);
        Assertions.assertTrue((boolean)p.getProperty("VirtualDatabaseName").equals("BQT"));
        Assertions.assertTrue((boolean)p.getProperty("VirtualDatabaseVersion").equals("4"));
        Assertions.assertTrue((boolean)p.getProperty("autoCommitTxn").equals("ON"));
        Assertions.assertTrue((boolean)p.getProperty("partialResultsMode").equals("YES"));
        Assertions.assertTrue((boolean)p.getProperty("serverURL").equals("mm://slwxp157:1234,slntmm01:43401,sluxmm09:43302"));
        Assertions.assertTrue((boolean)p.getProperty("version").equals("4"));
        Assertions.assertTrue((boolean)p.getProperty("ApplicationName").equals("Client"));
        Assertions.assertEquals((int)7, (int)p.size());
    }

    @Test
    public void testGetPropertyInfo1() throws Exception {
        DriverPropertyInfo[] info = this.drv.getPropertyInfo("jdbc:teiid:vdb@mm://localhost:12345;applicationName=x", null);
        Assertions.assertEquals((int)29, (int)info.length);
        Assertions.assertEquals((Object)false, (Object)info[1].required);
        Assertions.assertEquals((Object)"ApplicationName", (Object)info[1].name);
        Assertions.assertEquals((Object)"x", (Object)info[1].value);
        for (DriverPropertyInfo dpi : info) {
            Assertions.assertTrue((!dpi.description.startsWith("<Missing message") ? 1 : 0) != 0, (String)dpi.name);
        }
    }
}

