/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.jdbc;

import com.kubling.teiid.client.security.InvalidSessionException;
import com.kubling.teiid.client.xa.XidImpl;
import com.kubling.teiid.jdbc.ConnectionImpl;
import com.kubling.teiid.jdbc.StatementImpl;
import com.kubling.teiid.jdbc.TestConnection;
import com.kubling.teiid.jdbc.XAConnectionImpl;
import com.kubling.teiid.net.ServerConnection;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestXAConnection {
    @Test
    public void testConnectionClose() throws Exception {
        ConnectionImpl mmConn = TestConnection.getMMConnection();
        XAConnectionImpl xaConn = new XAConnectionImpl(mmConn);
        Connection conn = xaConn.getConnection();
        StatementImpl stmt = (StatementImpl)conn.createStatement();
        conn.setAutoCommit(false);
        conn.close();
        ServerConnection sc = xaConn.getConnectionImpl().getServerConnection();
        Assertions.assertTrue((boolean)stmt.isClosed());
        Assertions.assertTrue((boolean)conn.getAutoCommit());
        conn = xaConn.getConnection();
        stmt = (StatementImpl)conn.createStatement();
        XAResource resource = xaConn.getXAResource();
        resource.start((Xid)new XidImpl(1, new byte[0], new byte[0]), 0);
        conn.close();
        Assertions.assertTrue((boolean)stmt.isClosed());
        Assertions.assertTrue((boolean)conn.getAutoCommit());
    }

    @Test
    public void testNotification() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        ((ConnectionImpl)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException((Throwable)new InvalidSessionException())}).when((Object)conn)).commit();
        XAConnectionImpl xaConn = new XAConnectionImpl(conn);
        ConnectionEventListener cel = (ConnectionEventListener)Mockito.mock(ConnectionEventListener.class);
        xaConn.addConnectionEventListener(cel);
        Connection c = xaConn.getConnection();
        try {
            c.commit();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        ((ConnectionEventListener)Mockito.verify((Object)cel)).connectionErrorOccurred((ConnectionEvent)Mockito.any());
    }

    @Test
    public void testStartFailure() throws Exception {
        ConnectionImpl conn = (ConnectionImpl)Mockito.mock(ConnectionImpl.class);
        XidImpl xid = new XidImpl();
        ((ConnectionImpl)Mockito.doThrow((Throwable[])new Throwable[]{new SQLException((Throwable)new InvalidSessionException())}).when((Object)conn)).startTransaction(xid, 0, 100);
        XAConnectionImpl xaConn = new XAConnectionImpl(conn);
        xaConn.setTransactionTimeout(100);
        Assertions.assertThrows(XAException.class, () -> xaConn.start((Xid)xid, 0));
    }
}

