/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.net.socket;

import com.kubling.teiid.client.security.ILogon;
import com.kubling.teiid.client.security.InvalidSessionException;
import com.kubling.teiid.client.security.LogonException;
import com.kubling.teiid.client.security.LogonResult;
import com.kubling.teiid.client.security.SessionToken;
import com.kubling.teiid.client.util.ResultsFuture;
import com.kubling.teiid.client.util.ResultsReceiver;
import com.kubling.teiid.core.TeiidComponentException;
import com.kubling.teiid.core.crypto.NullCryptor;
import com.kubling.teiid.net.CommunicationException;
import com.kubling.teiid.net.ConnectionException;
import com.kubling.teiid.net.HostInfo;
import com.kubling.teiid.net.ServerConnection;
import com.kubling.teiid.net.TeiidURL;
import com.kubling.teiid.net.socket.Message;
import com.kubling.teiid.net.socket.SingleInstanceCommunicationException;
import com.kubling.teiid.net.socket.SocketServerConnection;
import com.kubling.teiid.net.socket.SocketServerInstance;
import com.kubling.teiid.net.socket.SocketServerInstanceFactory;
import com.kubling.teiid.net.socket.UrlServerDiscovery;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Properties;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestSocketServerConnection {
    @Test
    public void testSocketServerConnection_PropertiesClientHost() throws Throwable {
        Properties p = new Properties();
        SocketServerConnection.updateConnectionProperties((Properties)p, (InetAddress)InetAddress.getLocalHost(), (boolean)true, null);
        Assertions.assertTrue((boolean)p.containsKey("clientHostName"));
        Assertions.assertTrue((boolean)p.containsKey("clientIpAddress"));
    }

    @Test
    public void testLogonFailsWithMultipleHosts() throws Exception {
        Properties p = new Properties();
        SocketServerInstanceFactory instanceFactory = (SocketServerInstanceFactory)Mockito.mock(SocketServerInstanceFactory.class);
        Mockito.when((Object)instanceFactory.getServerInstance((HostInfo)Mockito.any())).thenThrow(new Throwable[]{new SingleInstanceCommunicationException()});
        UrlServerDiscovery discovery = new UrlServerDiscovery(new TeiidURL("mm://host1:1,host2:2"));
        try {
            new SocketServerConnection(instanceFactory, false, discovery, p);
            Assertions.fail((String)"exception expected");
        }
        catch (CommunicationException e) {
            Assertions.assertEquals((Object)"TEIID20021 No valid host available. Attempted connections to: [host1:1, host2:2]", (Object)e.getMessage());
        }
    }

    @Test
    public void testLogon() throws Exception {
        SocketServerConnection connection = this.createConnection(null);
        Assertions.assertEquals((Object)String.valueOf(1), (Object)connection.getLogonResult().getSessionID());
    }

    @Test
    public void testChangeUser() throws Exception {
        Properties p = new Properties();
        SocketServerConnection connection = this.createConnection(null, p);
        Assertions.assertEquals((Object)"fooUser", (Object)connection.getLogonResult().getUserName());
        p.setProperty("user", "newUser");
        connection.authenticate();
        Assertions.assertEquals((Object)"newUser", (Object)connection.getLogonResult().getUserName());
    }

    @Test
    public void testRetry() throws Exception {
        SocketServerConnection connection = this.createConnection(new SingleInstanceCommunicationException());
        connection.setFailOver(true);
        connection.setFailOverPingInterval(50);
        ILogon logon = (ILogon)connection.getService(ILogon.class);
        Thread.sleep(70L);
        logon.ping();
    }

    @Test
    public void testImmediateFail() throws Exception {
        SocketServerConnection connection = this.createConnection(new CommunicationException());
        ILogon logon = (ILogon)connection.getService(ILogon.class);
        Assertions.assertThrows(CommunicationException.class, () -> logon.ping());
    }

    @Test
    public void testImmediateFail1() throws Exception {
        SocketServerConnection connection = this.createConnection(new CommunicationException());
        connection.setFailOver(true);
        ILogon logon = (ILogon)connection.getService(ILogon.class);
        Assertions.assertThrows(CommunicationException.class, () -> logon.ping());
    }

    private SocketServerConnection createConnection(Throwable throwException) throws CommunicationException, ConnectionException {
        return this.createConnection(throwException, new Properties());
    }

    private SocketServerConnection createConnection(Throwable throwException, Properties p) throws CommunicationException, ConnectionException {
        return this.createConnection(throwException, new HostInfo("0.0.0.2", 1), p);
    }

    private SocketServerConnection createConnection(final Throwable t, final HostInfo hostInfo, Properties p) throws CommunicationException, ConnectionException {
        UrlServerDiscovery discovery = new UrlServerDiscovery(new TeiidURL(hostInfo.getHostName(), hostInfo.getPortNumber(), false));
        SocketServerInstanceFactory instanceFactory = new SocketServerInstanceFactory(){
            FakeILogon logon;
            {
                this.logon = new FakeILogon(t);
            }

            public SocketServerInstance getServerInstance(HostInfo info) throws CommunicationException, IOException {
                SocketServerInstance instance = (SocketServerInstance)Mockito.mock(SocketServerInstance.class);
                Mockito.when((Object)instance.getCryptor()).thenReturn((Object)new NullCryptor());
                Mockito.when((Object)instance.getHostInfo()).thenReturn((Object)hostInfo);
                Mockito.when((Object)((ILogon)instance.getService(ILogon.class))).thenReturn((Object)this.logon);
                Mockito.when((Object)instance.getServerVersion()).thenReturn((Object)"07.03");
                if (t != null) {
                    try {
                        ((SocketServerInstance)Mockito.doAnswer((Answer)new Answer<Void>(){

                            public Void answer(InvocationOnMock invocation) throws Throwable {
                                if (logon.t == null) {
                                    return null;
                                }
                                throw logon.t;
                            }
                        }).when((Object)instance)).send((Message)Mockito.any(), (ResultsReceiver)Mockito.any(), (Serializable)Mockito.any());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                Mockito.when((Object)instance.isOpen()).thenReturn((Object)true);
                return instance;
            }

            public String resolveHostname(InetAddress addr) {
                return null;
            }
        };
        SocketServerConnection connection = new SocketServerConnection(instanceFactory, false, discovery, p);
        return connection;
    }

    @Test
    public void testIsSameInstance() throws Exception {
        SocketServerConnection conn = this.createConnection(null, new HostInfo("0.0.0.0", 1), new Properties());
        SocketServerConnection conn1 = this.createConnection(null, new HostInfo("0.0.0.1", 1), new Properties());
        Assertions.assertFalse((boolean)conn.isSameInstance((ServerConnection)conn1));
        Assertions.assertTrue((boolean)conn.isSameInstance((ServerConnection)conn));
    }

    private static final class FakeILogon
    implements ILogon {
        Throwable t;

        public FakeILogon(Throwable t) {
            this.t = t;
        }

        public void assertIdentity(SessionToken sessionId) throws InvalidSessionException, TeiidComponentException {
        }

        public ResultsFuture<?> logoff() throws InvalidSessionException {
            return null;
        }

        public LogonResult logon(Properties connectionProperties) throws LogonException, TeiidComponentException {
            return new LogonResult(new SessionToken(1L, connectionProperties.getProperty("user", "fooUser")), "foo", "fake");
        }

        public ResultsFuture<?> ping() throws TeiidComponentException, CommunicationException {
            if (this.t != null) {
                if (this.t instanceof CommunicationException) {
                    CommunicationException ce = (CommunicationException)this.t;
                    this.t = null;
                    throw ce;
                }
                TeiidComponentException e = new TeiidComponentException(this.t);
                this.t = null;
                throw e;
            }
            return ResultsFuture.NULL_FUTURE;
        }

        public ResultsFuture<?> ping(Collection<String> sessions) throws TeiidComponentException, CommunicationException {
            return this.ping();
        }

        public LogonResult neogitiateGssLogin(Properties connectionProperties, byte[] serviceToken, boolean createSession) throws LogonException {
            return null;
        }
    }
}

