/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.net.socket;

import com.kubling.teiid.client.security.ILogon;
import com.kubling.teiid.client.util.ResultsFuture;
import com.kubling.teiid.net.CommunicationException;
import com.kubling.teiid.net.HostInfo;
import com.kubling.teiid.net.socket.Handshake;
import com.kubling.teiid.net.socket.ObjectChannel;
import com.kubling.teiid.net.socket.ObjectChannelFactory;
import com.kubling.teiid.net.socket.SingleInstanceCommunicationException;
import com.kubling.teiid.net.socket.SocketServerInstanceImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSocketServerInstanceImpl {
    @Test
    public void testHandshakeTimeout() throws Exception {
        Object[] exs = new SocketTimeoutException[1];
        Arrays.fill(exs, new SocketTimeoutException());
        FakeObjectChannel channel = new FakeObjectChannel(Arrays.asList(exs));
        try {
            this.createInstance(channel);
            Assertions.fail((String)"Exception expected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private SocketServerInstanceImpl createInstance(ObjectChannelFactory channelFactory) throws CommunicationException, IOException {
        HostInfo info = new HostInfo("0.0.0.0", 1);
        info.getInetAddress();
        SocketServerInstanceImpl ssii = new SocketServerInstanceImpl(info, 1L, 1);
        ssii.connect(channelFactory);
        return ssii;
    }

    @Test
    public void testSuccessfulHandshake() throws Exception {
        FakeObjectChannel channel = new FakeObjectChannel(Arrays.asList(new Handshake(), new SocketTimeoutException()));
        SocketServerInstanceImpl instance = this.createInstance(channel);
        ILogon logon = (ILogon)instance.getService(ILogon.class);
        try {
            logon.logon(new Properties());
            Assertions.fail((String)"Exception expected");
        }
        catch (SingleInstanceCommunicationException e) {
            Assertions.assertTrue((boolean)(e.getCause() instanceof TimeoutException));
        }
    }

    private static class FakeObjectChannel
    implements ObjectChannel,
    ObjectChannelFactory {
        List<Object> msgs = new ArrayList<Object>();
        List<? extends Object> readMsgs;
        int readCount;

        public FakeObjectChannel(List<? extends Object> readMsgs) {
            this.readMsgs = readMsgs;
        }

        public void close() {
        }

        public boolean isOpen() {
            return true;
        }

        public Future<?> write(Object msg) {
            this.msgs.add(msg);
            ResultsFuture result = new ResultsFuture();
            result.getResultsReceiver().receiveResults(null);
            return result;
        }

        public Object read() throws IOException, ClassNotFoundException {
            Object msg;
            if (this.readCount >= this.readMsgs.size()) {
                return "";
            }
            if ((msg = this.readMsgs.get(this.readCount++)) instanceof IOException) {
                if (msg instanceof SocketTimeoutException) {
                    try {
                        Thread.sleep(5L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                throw (IOException)msg;
            }
            return msg;
        }

        public SocketAddress getRemoteAddress() {
            return null;
        }

        public ObjectChannel createObjectChannel(HostInfo info) throws CommunicationException, IOException {
            return this;
        }

        public int getSoTimeout() {
            return 1;
        }

        public InetAddress getLocalAddress() {
            return null;
        }
    }
}

