/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.netty.handler.codec.serialization;

import com.kubling.teiid.core.types.ClobImpl;
import com.kubling.teiid.core.types.InputStreamFactory;
import com.kubling.teiid.core.util.AccessibleBufferedInputStream;
import com.kubling.teiid.core.util.Assertion;
import com.kubling.teiid.core.util.ReaderInputStream;
import com.kubling.teiid.netty.handler.codec.serialization.ObjectDecoderInputStream;
import com.kubling.teiid.netty.handler.codec.serialization.ObjectEncoderOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestObjectDecoderInputStream {
    @Test
    public void testTimeoutException() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectEncoderOutputStream oeos = new ObjectEncoderOutputStream(new DataOutputStream(baos), 512);
        List<Integer> obj = Arrays.asList(1, 2, 3);
        oeos.writeObject(obj);
        oeos.close();
        final ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        InputStream is = new InputStream(this){
            int count;

            @Override
            public int read() throws IOException {
                if (this.count++ % 2 == 0) {
                    throw new SocketTimeoutException();
                }
                return bais.read();
            }
        };
        ObjectDecoderInputStream odis = new ObjectDecoderInputStream(new AccessibleBufferedInputStream(is, 1024), Thread.currentThread().getContextClassLoader(), 1024);
        Object result = null;
        do {
            try {
                result = odis.readObject();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        } while (result == null);
        Assertions.assertEquals(obj, (Object)result);
    }

    @Test
    public void testReplaceObject() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectEncoderOutputStream out = new ObjectEncoderOutputStream(new DataOutputStream(baos), 512);
        ClobImpl clob = new ClobImpl(new InputStreamFactory(this){

            public InputStream getInputStream() throws IOException {
                return new ReaderInputStream((Reader)new StringReader("Clob contents"), Charset.forName("UTF-8"));
            }
        }, -1L);
        out.writeObject((Object)clob);
        ObjectDecoderInputStream in = new ObjectDecoderInputStream(new AccessibleBufferedInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()), 1024), Thread.currentThread().getContextClassLoader(), 1024);
        Object result = in.readObject();
        Assertion.assertTrue((boolean)(result instanceof ClobImpl));
    }
}

