/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.client;

import com.kubling.teiid.client.BatchSerializer;
import com.kubling.teiid.client.ResizingArrayList;
import com.kubling.teiid.core.types.ArrayImpl;
import com.kubling.teiid.core.types.BinaryType;
import com.kubling.teiid.core.types.ClobImpl;
import com.kubling.teiid.core.types.ClobType;
import com.kubling.teiid.core.types.GeographyType;
import com.kubling.teiid.core.types.GeometryType;
import com.kubling.teiid.core.types.JsonType;
import com.kubling.teiid.core.util.TimestampWithTimezone;
import com.kubling.teiid.query.unittest.TimestampUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Clob;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBatchSerializer {
    private static final String[] sampleBatchTypes = new String[]{"bigdecimal", "biginteger", "boolean", "byte", "char", "date", "double", "float", "integer", "long", "short", "string", "time", "timestamp", "object", "varbinary"};

    private static List<List<Object>> helpTestSerialization(String[] types, List<?>[] batch, byte version) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(byteStream);
        List<List<?>> batchList = Arrays.asList(batch);
        BatchSerializer.writeBatch((ObjectOutput)out, (String[])types, batchList, (byte)version);
        out.flush();
        byte[] bytes = byteStream.toByteArray();
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytes);
        ObjectInputStream in = new ObjectInputStream(bytesIn);
        List newBatch = BatchSerializer.readBatch((ObjectInput)in, (String[])types);
        out.close();
        in.close();
        Assertions.assertEquals(batchList, (Object)newBatch);
        return newBatch;
    }

    private static String sampleString(int length) {
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)i;
        }
        return new String(chars);
    }

    private static List<?>[] sampleBatchWithNulls(int rows) {
        List[] batch = new List[rows];
        for (int i = 0; i < rows; ++i) {
            Date d = new Date();
            int mod = i % 16;
            Object[] objectArray = new Object[16];
            objectArray[0] = mod == 0 ? null : new BigDecimal("" + i);
            Object object = objectArray[1] = mod == 1 ? null : new BigInteger(Integer.toString(i));
            objectArray[2] = mod == 2 ? null : (i % 2 == 0 ? Boolean.FALSE : Boolean.TRUE);
            objectArray[3] = mod == 3 ? null : Byte.valueOf((byte)i);
            objectArray[4] = mod == 4 ? null : Character.valueOf((char)i);
            objectArray[5] = mod == 5 ? null : TimestampWithTimezone.createDate((Date)d);
            objectArray[6] = mod == 6 ? null : Double.valueOf(i);
            objectArray[7] = mod == 7 ? null : Float.valueOf(i);
            objectArray[8] = mod == 8 ? null : Integer.valueOf(i);
            objectArray[9] = mod == 9 ? null : Long.valueOf(i);
            objectArray[10] = mod == 10 ? null : Short.valueOf((short)i);
            objectArray[11] = mod == 11 ? null : TestBatchSerializer.sampleString(i);
            objectArray[12] = mod == 12 ? null : TimestampWithTimezone.createTime((Date)d);
            objectArray[13] = mod == 13 ? null : TimestampWithTimezone.createTimestamp((Date)d);
            objectArray[14] = mod == 14 ? null : TimestampWithTimezone.createTimestamp((Date)d);
            objectArray[15] = mod == 15 ? null : new BinaryType(new byte[]{(byte)i});
            Object[] data = objectArray;
            batch[i] = Arrays.asList(data);
        }
        return batch;
    }

    @Test
    public void testSerializeBasicTypes() throws Exception {
        TestBatchSerializer.helpTestSerialization(sampleBatchTypes, TestBatchSerializer.sampleBatchWithNulls(1), (byte)5);
        TestBatchSerializer.helpTestSerialization(sampleBatchTypes, TestBatchSerializer.sampleBatchWithNulls(8), (byte)5);
        TestBatchSerializer.helpTestSerialization(sampleBatchTypes, TestBatchSerializer.sampleBatchWithNulls(17), (byte)5);
        TestBatchSerializer.helpTestSerialization(sampleBatchTypes, TestBatchSerializer.sampleBatchWithNulls(120), (byte)5);
        TestBatchSerializer.helpTestSerialization(sampleBatchTypes, TestBatchSerializer.sampleBatchWithNulls(833), (byte)5);
        TestBatchSerializer.helpTestSerialization(sampleBatchTypes, TestBatchSerializer.sampleBatchWithNulls(4096), (byte)5);
    }

    @Test
    public void testSerializeLargeStrings() throws Exception {
        List<Object> row = Arrays.asList(TestBatchSerializer.sampleString(66666));
        TestBatchSerializer.helpTestSerialization(new String[]{"string"}, new List[]{row}, (byte)5);
    }

    @Test
    public void testSerializeNoData() throws Exception {
        TestBatchSerializer.helpTestSerialization(sampleBatchTypes, new List[0], (byte)5);
    }

    @Test
    public void testSerializeDatatypeMismatch() throws Exception {
        try {
            TestBatchSerializer.helpTestSerialization(new String[]{"double"}, new List[]{List.of("Hello!")}, (byte)5);
        }
        catch (RuntimeException e) {
            Assertions.assertEquals((Object)"TEIID20001 The modeled datatype double for column 0 doesn't match the runtime type \"java.lang.String\". Please ensure that the column's modeled datatype matches the expected data.", (Object)e.getMessage());
        }
    }

    @Test
    public void testOutOfRangeDate() {
        Assertions.assertThrows(IOException.class, () -> TestBatchSerializer.helpTestSerialization(new String[]{"date"}, new List[]{List.of(TimestampUtil.createDate((int)-2, (int)0, (int)1))}, (byte)1));
    }

    @Test
    public void testStringArray() throws IOException, ClassNotFoundException {
        TestBatchSerializer.helpTestSerialization(new String[]{"long", "string[]"}, new List[]{Arrays.asList(1L, new ArrayImpl(new Object[]{new String[]{"Silly String", "Silly String"}}))}, (byte)5);
    }

    @Test
    public void testGeometry() throws IOException, ClassNotFoundException {
        GeometryType geometryType = new GeometryType(new byte[0]);
        geometryType.setReferenceStreamId(null);
        geometryType.setSrid(10000);
        Object val = TestBatchSerializer.helpTestSerialization(new String[]{"geometry"}, new List[]{List.of(geometryType)}, (byte)4).getFirst().getFirst();
        Assertions.assertInstanceOf(GeometryType.class, (Object)val);
        Assertions.assertEquals((int)10000, (int)((GeometryType)val).getSrid());
        TestBatchSerializer.helpTestSerialization(new String[]{"geometry"}, new List[]{List.of(geometryType)}, (byte)0);
        val = TestBatchSerializer.helpTestSerialization(new String[]{"geometry"}, new List[]{List.of(geometryType)}, (byte)1).getFirst().getFirst();
        Assertions.assertFalse((boolean)(val instanceof GeometryType));
        val = TestBatchSerializer.helpTestSerialization(new String[]{"object"}, new List[]{List.of(geometryType)}, (byte)1).getFirst().getFirst();
        Assertions.assertFalse((boolean)(val instanceof GeometryType));
    }

    @Test
    public void testGeography() throws IOException, ClassNotFoundException {
        GeometryType geometryType = new GeometryType(new byte[0]);
        geometryType.setReferenceStreamId(null);
        geometryType.setSrid(4326);
        Object val = TestBatchSerializer.helpTestSerialization(new String[]{"geography"}, new List[]{List.of(geometryType)}, (byte)5).getFirst().getFirst();
        Assertions.assertInstanceOf(GeographyType.class, (Object)val);
        Assertions.assertEquals((int)4326, (int)((GeographyType)val).getSrid());
        TestBatchSerializer.helpTestSerialization(new String[]{"geography"}, new List[]{List.of(geometryType)}, (byte)0);
        val = TestBatchSerializer.helpTestSerialization(new String[]{"geography"}, new List[]{List.of(geometryType)}, (byte)1).getFirst().getFirst();
        Assertions.assertFalse((boolean)(val instanceof GeographyType));
        val = TestBatchSerializer.helpTestSerialization(new String[]{"object"}, new List[]{List.of(geometryType)}, (byte)1).getFirst().getFirst();
        Assertions.assertFalse((boolean)(val instanceof GeographyType));
    }

    @Test
    public void testJson() throws IOException, ClassNotFoundException {
        JsonType json = new JsonType((Clob)new ClobImpl("5"));
        json.setReferenceStreamId(null);
        Object val = TestBatchSerializer.helpTestSerialization(new String[]{"json"}, new List[]{List.of(json)}, (byte)5).getFirst().getFirst();
        Assertions.assertInstanceOf(JsonType.class, (Object)val);
        TestBatchSerializer.helpTestSerialization(new String[]{"json"}, new List[]{List.of(json)}, (byte)0);
        val = TestBatchSerializer.helpTestSerialization(new String[]{"json"}, new ResizingArrayList[]{new ResizingArrayList(List.of(json))}, (byte)1).getFirst().getFirst();
        Assertions.assertInstanceOf(ClobType.class, (Object)val);
        val = TestBatchSerializer.helpTestSerialization(new String[]{"object"}, new List[]{List.of(json)}, (byte)1).getFirst().getFirst();
        Assertions.assertInstanceOf(ClobType.class, (Object)val);
    }
}

