/*
 * Decompiled with CFR 0.152.
 */
package com.kubling.teiid.client.util;

import com.kubling.teiid.client.SourceWarning;
import com.kubling.teiid.client.util.ExceptionHolder;
import com.kubling.teiid.core.TeiidException;
import com.kubling.teiid.core.TeiidProcessingException;
import com.kubling.teiid.core.TeiidRuntimeException;
import com.kubling.teiid.core.util.ReflectionHelper;
import com.kubling.teiid.core.util.UnitTestUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestExceptionHolder {
    @Test
    public void testDeserializationUnknownException() throws Exception {
        URLClassLoader cl = new URLClassLoader(new URL[]{UnitTestUtil.getTestDataFile((String)"test.jar").toURI().toURL()});
        Object obj = ReflectionHelper.create((String)"test.Test", null, (ClassLoader)cl);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(new ExceptionHolder((Throwable)((Object)new BadException(obj))));
        oos.flush();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        ExceptionHolder holder = (ExceptionHolder)ois.readObject();
        Assertions.assertTrue((boolean)(holder.getException() instanceof BadException));
        Assertions.assertEquals((Object)"Remote com.kubling.teiid.client.util.TestExceptionHolder$BadException: null", (Object)holder.getException().getMessage());
    }

    @Test
    public void testDeserializationUnknownChildException() throws Exception {
        URLClassLoader cl = new URLClassLoader(new URL[]{UnitTestUtil.getTestDataFile((String)"test.jar").toURI().toURL()});
        Exception obj = (Exception)ReflectionHelper.create((String)"test.UnknownException", null, (ClassLoader)cl);
        obj.initCause(new SQLException("something bad happended"));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(new ExceptionHolder((Throwable)((Object)new BadException2(obj, "I have foreign exception embedded in me"))));
        oos.flush();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        ExceptionHolder holder = (ExceptionHolder)ois.readObject();
        Throwable e = holder.getException();
        Assertions.assertTrue((boolean)(e instanceof BadException2));
        Assertions.assertEquals((Object)e.getMessage(), (Object)"Remote com.kubling.teiid.client.util.TestExceptionHolder$BadException2: I have foreign exception embedded in me");
        e = e.getCause();
        Assertions.assertTrue((boolean)(e instanceof TeiidRuntimeException));
        e = e.getCause();
        Assertions.assertTrue((boolean)(e instanceof SQLException));
        Assertions.assertEquals((Object)"Remote java.sql.SQLException: something bad happended", (Object)e.getMessage());
    }

    @Test
    public void testSQLExceptionChain() throws Exception {
        SQLException se;
        URLClassLoader cl = new URLClassLoader(new URL[]{UnitTestUtil.getTestDataFile((String)"test.jar").toURI().toURL()});
        Exception obj = (Exception)ReflectionHelper.create((String)"test.UnknownException", null, (ClassLoader)cl);
        SQLException next = se = new SQLException("something bad happened", obj);
        for (int i = 0; i < 10; ++i) {
            SQLException se1 = new SQLException("something else bad happened", obj);
            next.setNextException(se1);
            next = se1;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CustomStream oos = new CustomStream(baos);
        oos.writeObject(new ExceptionHolder((Throwable)se, false));
        oos.flush();
        Assertions.assertEquals((int)22, (int)oos.count.get());
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        ExceptionHolder holder = (ExceptionHolder)ois.readObject();
        Throwable e = holder.getException();
        Assertions.assertTrue((boolean)(e instanceof SQLException));
        Assertions.assertEquals((Object)"Remote java.sql.SQLException: something bad happened", (Object)e.getMessage());
        Assertions.assertTrue((boolean)(e.getCause() instanceof TeiidRuntimeException));
        e = ((SQLException)e).getNextException();
        Assertions.assertTrue((boolean)(e instanceof SQLException));
        Assertions.assertEquals((Object)"Remote java.sql.SQLException: something else bad happened", (Object)e.getMessage());
        int count = 0;
        while ((e = ((SQLException)e).getNextException()) != null) {
            ++count;
        }
        Assertions.assertEquals((int)9, (int)count);
    }

    @Test
    public void testDeserializationUnknownChildException2() throws Exception {
        URLClassLoader cl = new URLClassLoader(new URL[]{UnitTestUtil.getTestDataFile((String)"test.jar").toURI().toURL()});
        ArrayList<String> args = new ArrayList<String>();
        args.add("Unknown Exception");
        Exception obj = (Exception)ReflectionHelper.create((String)"test.UnknownException", args, (ClassLoader)cl);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(new ExceptionHolder((Throwable)obj));
        oos.flush();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        ExceptionHolder holder = (ExceptionHolder)ois.readObject();
        Throwable e = holder.getException();
        Assertions.assertTrue((boolean)(e instanceof TeiidRuntimeException));
        Assertions.assertEquals((Object)"Remote test.UnknownException: Unknown Exception", (Object)e.getMessage());
    }

    @Test
    public void testDeserializationNotSerializable() throws Exception {
        TeiidException ex = new TeiidException(){
            NotSerializable ns = new NotSerializable();
        };
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(new ExceptionHolder((Throwable)ex));
        oos.flush();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        ExceptionHolder holder = (ExceptionHolder)ois.readObject();
        Throwable e = holder.getException();
        Assertions.assertTrue((boolean)(e instanceof TeiidException));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSourceWarning() throws Exception {
        URLClassLoader cl = new URLClassLoader(new URL[]{UnitTestUtil.getTestDataFile((String)"test.jar").toURI().toURL()});
        ArrayList<String> args = new ArrayList<String>();
        args.add("Unknown Exception");
        Exception obj = (Exception)ReflectionHelper.create((String)"test.UnknownException", args, (ClassLoader)cl);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(new ExceptionHolder((Throwable)new SourceWarning("x", "y", (Throwable)obj, true)));
        oos.flush();
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
        ExceptionHolder holder = (ExceptionHolder)ois.readObject();
        SourceWarning sw = (SourceWarning)holder.getException();
        Assertions.assertEquals((Object)sw.getConnectorBindingName(), (Object)"y");
        Assertions.assertEquals((Object)sw.getModelName(), (Object)"x");
        Assertions.assertTrue((boolean)sw.isPartialResultsError());
        try {
            ois = new ObjectInputStream(new FileInputStream(UnitTestUtil.getTestDataFile((String)"old-exceptionholder.ser")));
            holder = (ExceptionHolder)ois.readObject();
            Assertions.assertTrue((boolean)(holder.getException() instanceof TeiidException));
        }
        finally {
            ois.close();
        }
    }

    public static class BadException
    extends TeiidProcessingException {
        private Object obj;

        public BadException(String msg) {
            super(msg);
        }

        public BadException(Object obj) {
            this.obj = obj;
        }
    }

    public static class BadException2
    extends TeiidProcessingException {
        public BadException2(String msg) {
            super(msg);
        }

        public BadException2(Throwable e, String msg) {
            super(e, msg);
        }
    }

    private static final class CustomStream
    extends ObjectOutputStream {
        final AtomicInteger count = new AtomicInteger();

        private CustomStream(OutputStream out) throws IOException {
            super(out);
            this.enableReplaceObject(true);
        }

        @Override
        protected Object replaceObject(Object obj) throws IOException {
            if (obj instanceof ExceptionHolder) {
                this.count.incrementAndGet();
            }
            return super.replaceObject(obj);
        }
    }

    private static class NotSerializable {
        private NotSerializable() {
        }
    }
}

